/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui.tree;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.util.StaticStrings;
import org.greenstone.gatherer.util.Utility;

public class DragTreeCellRenderer
    extends DefaultTreeCellRenderer
{
    private Color selection_background;
    private Color selection_foreground;

    public DragTreeCellRenderer() {
	super();
	// Have to wait until this image is loaded
	selection_background = getBackgroundSelectionColor();
	selection_foreground = getTextSelectionColor();
    }

    public void gainFocus() {
	setBackgroundSelectionColor(selection_background);
	setTextSelectionColor(selection_foreground);
    }

    /** Configures the renderer based on the passed in components. */
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus)
    {
	// Rendering FileNodes
	if (value instanceof FileNode) {
	    FileNode node = (FileNode) value;
	    String node_text = node.toString();

	    // Add file sizes if necessary
	    if (Configuration.get("general.show_file_size", Configuration.COLLECTION_SPECIFIC) && node.getFile() != null && !node.getAllowsChildren()) {
		node_text = node_text + StaticStrings.SPACE_CHARACTER + StaticStrings.LBRACKET_CHARACTER + Utility.formatFileLength(node.getFile().length()) + StaticStrings.RBRACKET_CHARACTER;
	    }

	    return (JLabel) super.getTreeCellRendererComponent(tree, node_text, sel, expanded, leaf, row, hasFocus);
	}

	// Use default renderer for anything else
	return (JLabel) super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public void loseFocus() {
	setBackgroundSelectionColor(Color.lightGray);
	setTextSelectionColor(Color.black);
    }
}
