/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Katherine Don, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import org.w3c.dom.Element;
import org.greenstone.gatherer.util.StaticStrings;

/** A DOMProxyListModel thatholds options for indexoptions. For example, levels and stem options */
public class IndexOptionList
    extends DOMProxyListModel {

    /** A reference to ourselves so our inner methods have access. */
    private DOMProxyListModel options_model = null;

    public IndexOptionList(Element options) {
	super(options, StaticStrings.INDEXOPTION_ELEMENT, new IndexOption());

	options_model = this;
    }

    public void addOption(String name) {
	if (getOption(name) == null) {
	    add(new IndexOption(name));
	}
    }


    public IndexOption getOption(String name) {
	int options_model_size = options_model.getSize();
	for(int i = 0; i < options_model_size; i++) {
	    IndexOption option = (IndexOption) options_model.getElementAt(i);
	    if(option.getName().equals(name)) {
		return option;
	    }
	}
	return null;
    }

    public void removeOption(String name) {
	IndexOption option_elem = null;
	if ((option_elem = getOption(name)) != null) {
	    options_model.remove(option_elem);
	}
    }


}
	    
