/**********************************************************************
 *
 * infodbclass.cpp -- 
 * Copyright (C) 1999-2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "infodbclass.h"


// constructors
infodbclass::infodbclass () {
}


void infodbclass::setinfo (const text_t &key, const text_t &value)
{
  text_tarray &tarr = info[key];
  tarr.erase(tarr.begin(), tarr.end());
  tarr.push_back(value);
}


void infodbclass::setintinfo (const text_t &key, int value)
{
  setinfo (key, value);
}


void infodbclass::setcinfo (const text_t &key, unsigned short c)
{
  text_t t;
  t.push_back (c);
  setinfo (key, t);
}


text_t *infodbclass::getinfo (const text_t &key)
{
  iterator here = info.find (key);
  if (here == info.end()) return NULL;

  if ((*here).second.empty()) return NULL;
  
  return &((*here).second[0]);
}


text_t *infodbclass::getinfo (const text_t &key, const text_t& slang)
{
  text_tarray *t = getmultinfo(key, slang);
  if (t == NULL || t->empty()) return NULL;
  return &((*t)[0]);
}


int infodbclass::getintinfo (const text_t &key)
{
  text_t *t = getinfo (key);
  if (t == NULL) return 0;
  return t->getint();
}


int infodbclass::getintinfo (const text_t &key, const text_t& slang)
{
  text_tarray *t = getmultinfo(key, slang);
  if (t == NULL || t->empty()) return 0;
  return (*t)[0].getint();
}


text_t &infodbclass::operator[] (const text_t &key)
{
  text_tarray &tarr = info[key];
  if (tarr.empty()) {
    text_t e;
    tarr.push_back(e);
  }
  return tarr[0];
}


void infodbclass::addinfo (const text_t &key, const text_t &value)
{
  text_tarray &tarr = info[key];
  tarr.push_back (value);
}


void infodbclass::addintinfo (const text_t &key, int value)
{
  addinfo (key, value);
}


void infodbclass::addcinfo (const text_t &key, unsigned short c)
{
  text_t t;
  t.push_back(c);
  addinfo (key, t);
}


text_tarray *infodbclass::getmultinfo (const text_t &key)
{
  iterator here = info.find (key);
  if (here == info.end()) return NULL;

  return &((*here).second);
}


text_tarray *infodbclass::getmultinfo (const text_t &key, const text_t& slang)
{
  iterator here = info.end();
  if (slang.empty()) {
    here = info.find (key);
  }
  else {
    here = info.find (key+":"+slang);
    if (here == info.end()) {
      here = info.find (key);
    }
  }
  if (here == info.end()) return NULL;

  return &((*here).second);
}
