/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.PropertyConfigurator;
import org.greenstone.server.BaseServer;
import org.greenstone.server.Server2Control;
import org.greenstone.server.Server2Property;
import org.greenstone.util.PortFinder;
import org.greenstone.util.RunMake;
import org.greenstone.util.ScriptReadWrite;

public class Server2
extends BaseServer {
    private static final int WAITING_TIME = 10;
    private static final String URL_PENDING = "URL_pending";
    protected String libraryURL;
    protected String property_prefix;
    protected String gsdlos_gsdlarch;

    public Server2(String gsdl2_home, String gsdlos_arch, String lang, String configfile, int quitPort, String mode) {
        super(gsdl2_home, lang, configfile, "etc" + File.separator + "logs-gsi");
        String url;
        ArrayList<String> fileLines;
        ScriptReadWrite scriptReadWrite;
        this.gsdlos_gsdlarch = gsdlos_arch;
        this.property_prefix = mode;
        if (!this.property_prefix.equals("") && !this.property_prefix.endsWith(".")) {
            this.property_prefix = this.property_prefix + ".";
        }
        Property = new Server2Property(this.property_prefix);
        String frame_title = dictionary.get("ServerControl.Frame_Title");
        this.server_control_ = new Server2Control(this, frame_title);
        START_CMD = "web-start";
        RESTART_CMD = "web-restart";
        CONFIGURE_CMD = "configure-web \"" + configfile + "\"";
        STOP_CMD = "web-stop";
        if (quitPort != -1) {
            if (PortFinder.isAssignablePortNumber(quitPort)) {
                try {
                    new QuitListener(quitPort).start();
                }
                catch (Exception e) {
                    this.recordError("Exception constructing the QuitListener thread.");
                }
            } else {
                this.recordError("QuitPort provided is not within acceptable range: (1024 - 65535]");
                quitPort = -1;
            }
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            String hosts = inetAddress.getHostName();
            scriptReadWrite = new ScriptReadWrite();
            fileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
            scriptReadWrite.replaceOrAddLine(fileLines, "hosts", hosts, true);
            scriptReadWrite.writeOutFile(config_properties_file, fileLines);
        }
        catch (UnknownHostException hosts) {
            // empty catch block
        }
        if (config_properties.getProperty(BaseServer.Property.AUTOSTART, "").equals("0") && config_properties.getProperty(url = this.property_prefix + "url") == null) {
            config_properties.setProperty(url, URL_PENDING);
            scriptReadWrite = new ScriptReadWrite();
            fileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
            scriptReadWrite.replaceOrAddLine(fileLines, url, URL_PENDING, true);
            scriptReadWrite.writeOutFile(config_properties_file, fileLines);
        }
        this.autoStart();
    }

    @Override
    protected void initLogger() {
        String libjavaFolder = this.gsdl_home + File.separator + "lib" + File.separator + "java" + File.separator;
        File propsFile = new File(libjavaFolder + "log4j.properties");
        if (!propsFile.exists()) {
            try {
                FileInputStream infile = new FileInputStream(new File(libjavaFolder + "log4j.properties.in"));
                if (infile != null) {
                    Properties logProps = new Properties();
                    logProps.load(infile);
                    infile.close();
                    logProps.setProperty("gsdl2.home", this.gsdl_home);
                    FileOutputStream outfile = new FileOutputStream(propsFile);
                    if (outfile != null) {
                        logProps.store(outfile, "Customised log4j.properties file");
                        outfile.close();
                    } else {
                        System.err.println("Could not store properties file " + propsFile + " for Server2.");
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Exception occurred when custom-configuring the logger for Server2.\n" + e);
            }
        }
        if (propsFile.exists()) {
            PropertyConfigurator.configure((String)propsFile.getAbsolutePath());
        } else {
            System.err.println("Could not create properties file " + propsFile + " for Server2.");
        }
    }

    @Override
    protected int runTarget(String cmd) {
        RunMake runMake = new RunMake();
        runMake.setTargetCmd(cmd);
        runMake.run();
        return runMake.getTargetState();
    }

    @Override
    public String getBrowserURL() {
        return this.libraryURL;
    }

    @Override
    public void reload() {
        String host = "localhost";
        String port = "80";
        String httpprefix = "/greenstone";
        String suffix = "/cgi-bin/library.cgi";
        try {
            File gsdlsite_cfg = new File(this.gsdl_home + File.separator + "cgi-bin" + File.separator + this.gsdlos_gsdlarch + File.separator + "gsdlsite.cfg");
            FileInputStream fin = new FileInputStream(gsdlsite_cfg);
            Properties gsdlProperties = new Properties();
            if (fin != null) {
                gsdlProperties.load(fin);
                String gwcgi = gsdlProperties.getProperty("gwcgi");
                if (gwcgi != null) {
                    suffix = gwcgi;
                } else {
                    httpprefix = gsdlProperties.getProperty("httpprefix", httpprefix);
                    suffix = httpprefix + suffix;
                }
                fin.close();
            } else {
                this.recordError("Could not open gsdlsite_cfg for reading, using default library prefix.");
            }
            port = config_properties.getProperty("portnumber", port);
            String addressResolutionMethod = config_properties.getProperty("address_resolution_method");
            int address_resolution_method = addressResolutionMethod == null ? 2 : Integer.parseInt(addressResolutionMethod);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger_.error((Object)e);
                logger_.info((Object)("Defaulting host IP to " + host));
                address_resolution_method = 2;
                inetAddress = null;
            }
            switch (address_resolution_method) {
                case 0: {
                    host = inetAddress.getHostName();
                    break;
                }
                case 1: {
                    host = inetAddress.getHostAddress();
                    break;
                }
                case 2: {
                    host = "localhost";
                    break;
                }
                case 3: {
                    host = "127.0.0.1";
                    break;
                }
                default: {
                    host = "localhost";
                    break;
                }
            }
        }
        catch (Exception e) {
            this.recordError("Exception trying to load properties from gsdlsite_cfg. Using default library prefix.", e);
            suffix = httpprefix + suffix;
        }
        this.libraryURL = "http://" + host + ":" + port + suffix;
    }

    @Override
    public boolean reloadConfigProperties(boolean port_has_changed) {
        super.reloadConfigProperties(port_has_changed);
        String port = config_properties.getProperty("portnumber", "80");
        String keepport = config_properties.getProperty("keepport", "0");
        int portDefault = 8282;
        try {
            int portNum = Integer.parseInt(port);
            boolean verbose = true;
            if (port_has_changed && !PortFinder.isPortAvailable(portNum, verbose)) {
                if (keepport.equals("1")) {
                    this.server_control_.errorMessage(dictionary.get("ServerSettings.SettingsUnchangedPortOccupied", new String[]{port}));
                    String errorMsg = "Unable to run the Greenstone server on port " + port + ". It appears to already be in use.";
                    System.err.println("\n******************");
                    logger_.error((Object)errorMsg);
                    System.err.println("If you wish to try another port, go to File > Settings of the Greenstone Server interface and either change the port number or untick the \"Do Not Modify Port\" option there. Then press the \"Enter Library\" button.");
                    System.err.println("******************\n");
                    return false;
                }
                PortFinder portFinder = new PortFinder(portDefault, 101);
                portNum = portFinder.findPortInRange(!verbose);
                if (portNum == -1) {
                    System.err.println("No free port found. Going to try on " + portDefault + " anyway.");
                    port = Integer.toString(portDefault);
                } else {
                    port = Integer.toString(portNum);
                }
                config_properties.setProperty("portnumber", port);
                ScriptReadWrite scriptReadWrite = new ScriptReadWrite();
                ArrayList<String> fileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
                scriptReadWrite.replaceOrAddLine(fileLines, "portnumber", port, false);
                scriptReadWrite.writeOutFile(config_properties_file, fileLines);
                this.configure_required_ = true;
                System.err.println("Running server on port " + port + ".");
            }
        }
        catch (Exception e) {
            this.recordError("Exception in Server2.reload(): " + e.getMessage());
            port = Integer.toString(portDefault);
        }
        return true;
    }

    @Override
    protected void preStop() {
        ScriptReadWrite scriptReadWrite = new ScriptReadWrite();
        ArrayList<String> fileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
        boolean done = false;
        for (int i = fileLines.size() - 1; i >= 0 && !done; --i) {
            String line = fileLines.get(i).trim();
            if (!line.startsWith(this.property_prefix + "url=")) continue;
            fileLines.remove(i);
            done = true;
        }
        scriptReadWrite.writeOutFile(config_properties_file, fileLines);
    }

    @Override
    protected void postStart() {
        URL libURL = null;
        try {
            libURL = new URL(this.libraryURL);
        }
        catch (Exception e) {
            this.recordError("Unable to convert library URL string into a valid URL, Server2.java." + e);
        }
        if (libURL != null && !this.libraryURL.equals(URL_PENDING)) {
            boolean ready = false;
            for (int i = 0; i < 10 && !ready; ++i) {
                try {
                    libURL.openConnection();
                    ready = true;
                    this.recordSuccess("Try connecting to server on url: '" + this.libraryURL + "'");
                    continue;
                }
                catch (IOException bad_url_connection) {
                    this.recordSuccess("NOT YET CONNECTED. Waiting to try again...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        ready = true;
                        this.recordError("Unexpected: got an InterruptedException in sleeping thread, Server2.java." + ie);
                    }
                    continue;
                }
                catch (Exception e) {
                    ready = true;
                    this.recordError("Got an Exception while waiting for the connection to become live, Server2.java." + e);
                }
            }
        }
        String port = config_properties.getProperty("portnumber");
        ScriptReadWrite scriptReadWrite = new ScriptReadWrite();
        ArrayList<String> fileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
        scriptReadWrite.replaceOrAddLine(fileLines, this.property_prefix + "url", this.libraryURL, true);
        scriptReadWrite.replaceOrAddLine(fileLines, "portnumber", port, false);
        scriptReadWrite.writeOutFile(config_properties_file, fileLines);
    }

    public static void main(String[] args) {
        String gsdl2_home;
        File gsdl2_dir;
        if (args.length < 2 || args.length > 6) {
            System.err.println("Usage: java org.greenstone.server.Server2 <gsdl2-home-dir> <GSDLOS_GSDLARCH> [lang] [--mode=\"gli\"] [--config=configfile] [--quitport=portNum]");
            System.exit(1);
        }
        if (!(gsdl2_dir = new File(gsdl2_home = args[0])).isDirectory()) {
            System.err.println("gsdl-home-dir directory does not exist!");
            System.exit(1);
        }
        String gsdlos_arch = args[1];
        for (int i = 2; i < args.length; ++i) {
            int j;
            int lastIndex = args[i].lastIndexOf("--");
            if (lastIndex <= 0) continue;
            StringTokenizer tokenizer = new StringTokenizer(args[i]);
            String[] tokens = new String[tokenizer.countTokens() + i];
            for (j = 0; j < i; ++j) {
                tokens[j] = args[j];
            }
            while (tokenizer.hasMoreTokens()) {
                tokens[j] = tokenizer.nextToken();
                ++j;
            }
            args = null;
            args = tokens;
        }
        File defaultConfigFile = new File(gsdl2_dir, "llssite.cfg");
        String configfile = defaultConfigFile.getAbsolutePath();
        int port = -1;
        String mode = "";
        String lang = "en";
        int index = 2;
        if (args.length > index && !args[index].startsWith("--")) {
            lang = args[index];
            ++index;
        }
        while (args.length > index) {
            if (args[index].startsWith("--config=")) {
                configfile = args[index].substring(args[index].indexOf(61) + 1);
                gsdl2_dir = null;
                defaultConfigFile = null;
            } else if (args[index].startsWith("--quitport=")) {
                String quitport = args[index].substring(args[index].indexOf(61) + 1);
                try {
                    port = Integer.parseInt(quitport);
                }
                catch (Exception e) {
                    System.err.println("Port must be numeric. Continuing without it.");
                }
            } else if (args[index].startsWith("--mode=")) {
                mode = args[index].substring(args[index].indexOf(61) + 1);
            } else if (!args[index].startsWith("--")) {
                configfile = configfile + " " + args[index];
            }
            ++index;
        }
        configfile = configfile.trim();
        new Server2(gsdl2_home, gsdlos_arch, lang, configfile, port, mode);
    }

    private class QuitListener
    extends Thread {
        int quitPort = -1;
        ServerSocket serverSocket = null;

        public QuitListener(int quitport) throws Exception {
            this.quitPort = quitport;
            this.serverSocket = new ServerSocket(this.quitPort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket connection = null;
            try {
                connection = this.serverSocket.accept();
                boolean stop = false;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (line.equals("QUIT")) {
                            stop = true;
                            reader.close();
                            reader = null;
                            this.serverSocket.close();
                            this.serverSocket = null;
                            break;
                        }
                        if (line.equals("RECONFIGURE")) {
                            Server2.this.server_control_.displayMessage(BaseServer.dictionary.get("ServerControl.Configuring"));
                            Server2.this.reconfigRequired();
                            continue;
                        }
                        if (!line.equals("RESTART")) continue;
                        String url = Server2.this.property_prefix + "url";
                        if (BaseServer.config_properties.getProperty(BaseServer.Property.AUTOSTART, "").equals("0") && BaseServer.config_properties.getProperty(url) == null) {
                            BaseServer.config_properties.setProperty(url, Server2.URL_PENDING);
                            ScriptReadWrite scriptReadWrite = new ScriptReadWrite();
                            ArrayList<String> fileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
                            scriptReadWrite.replaceOrAddLine(fileLines, url, Server2.URL_PENDING, true);
                            scriptReadWrite.writeOutFile(BaseServer.config_properties_file, fileLines);
                        }
                        Server2.this.autoStart();
                    }
                }
                catch (Exception e) {
                    Server2.this.recordError("Exception in QuitListener thread.");
                }
                finally {
                    if (stop) {
                        Server2.this.stop();
                        System.exit(0);
                    }
                }
            }
            catch (IOException ioe) {
                Server2.this.recordError("Server2.QuitListener: Unable to make the connection with the client socket." + ioe);
            }
        }
    }
}

