/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.greenstone.LuceneWrapper4.GS2Analyzer;
import org.greenstone.LuceneWrapper4.GSLuceneUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GS2LuceneIndexer {
    protected static boolean debug = false;

    protected static void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 1;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (stringArray[i].startsWith("-")) {
                if (stringArray[i].equals("-removeold")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-verbosity")) {
                    if (++i >= n2 || (n = Integer.parseInt(stringArray[i])) < 5) continue;
                    debug = true;
                    continue;
                }
                if (stringArray[i].equals("-debug")) {
                    debug = true;
                    continue;
                }
                System.err.println("Unrecognised option: " + stringArray[i]);
                continue;
            }
            vector.add(stringArray[i]);
        }
        if (vector.size() != 3) {
            System.err.println("Usage: java GS2LuceneIndexer [-removeold|-verbosity [num]] doc-tag-level building_dir index");
            return;
        }
        String string = (String)vector.get(0);
        String string2 = (String)vector.get(1);
        String string3 = (String)vector.get(2);
        String string4 = string2 + File.separator + "text";
        File file = new File(string4);
        File file2 = new File(string2);
        if (!file.exists()) {
            System.err.println("Couldn't find import directory: " + string4);
            return;
        }
        File file3 = new File(file2.getPath() + File.separator + string3 + File.separator);
        file3.mkdir();
        Indexer indexer = new Indexer(string, file3, bl);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer(1024);
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string5);
                stringBuffer.append(" ");
                GS2LuceneIndexer.debug("Got line " + string5);
                if (string5.endsWith("</Delete>")) {
                    indexer.delete(stringBuffer.toString());
                    stringBuffer = new StringBuffer(1024);
                    continue;
                }
                if (!string5.startsWith("</Doc>")) continue;
                indexer.index(stringBuffer.toString());
                stringBuffer = new StringBuffer(1024);
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Error: unable to read from stdin");
            iOException.printStackTrace();
        }
        indexer.finish();
    }

    public static class Indexer
    extends DefaultHandler {
        IndexWriter writer_ = null;
        Analyzer analyzer_ = null;
        SAXParser sax_parser_ = null;
        String doc_tag_level_ = null;
        Stack stack_ = null;
        String path_ = "";
        Document current_doc_ = null;
        String current_node_ = "";
        String current_doc_oid_ = "";
        String indexable_current_node_ = "";
        boolean tokenize = true;
        String current_contents_ = "";
        String mode_ = "";
        protected String file_id_ = null;

        public Indexer(String string, File file, boolean bl) {
            this.doc_tag_level_ = string;
            try {
                this.stack_ = new Stack();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                this.sax_parser_ = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = this.sax_parser_.getXMLReader();
                xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                this.analyzer_ = new GS2Analyzer();
                this.writer_ = GSLuceneUtil.getIndexWriter(file.getPath(), this.analyzer_, bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void index(String string, File file) {
            this.mode_ = "add";
            this.file_id_ = string;
            this.path_ = "";
            String string2 = file.getPath();
            string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar));
            try {
                this.sax_parser_.parse(new InputSource(new FileInputStream(file)), (DefaultHandler)this);
            }
            catch (Exception exception) {
                this.println("parse error:");
                exception.printStackTrace();
            }
        }

        public void index(String string) {
            this.mode_ = "add";
            this.file_id_ = "<xml doc on stdin>";
            this.path_ = "";
            try {
                this.sax_parser_.parse(new InputSource(new StringReader(string)), (DefaultHandler)this);
            }
            catch (Exception exception) {
                this.println("parse error:");
                exception.printStackTrace();
            }
        }

        public void delete(String string) {
            this.mode_ = "delete";
            this.file_id_ = "<delete doc>";
            this.path_ = "";
            try {
                this.sax_parser_.parse(new InputSource(new StringReader(string)), (DefaultHandler)this);
            }
            catch (Exception exception) {
                this.println("parse error:");
                exception.printStackTrace();
            }
        }

        public void finish() {
            try {
                this.writer_.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void print(String string) {
            System.err.print(string);
        }

        protected void println(String string) {
            System.err.println(string);
        }

        @Override
        public void startDocument() throws SAXException {
            this.println("Starting to process " + this.file_id_ + " ...");
            this.print("[");
        }

        @Override
        public void endDocument() throws SAXException {
            this.println("]");
            this.println("... processing finished.");
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.path_ = this.appendPathLink(this.path_, string3, attributes);
            if (string3.equals(this.doc_tag_level_)) {
                this.mode_ = attributes.getValue("gs2:mode");
                this.pushOnStack();
                this.current_node_ = string3;
                this.current_doc_oid_ = attributes.getValue("gs2:docOID");
                this.print(" " + string3 + ": " + this.current_doc_oid_ + " (" + this.mode_ + ")");
                this.current_doc_.add(new Field("docOID", this.current_doc_oid_, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
            if (Indexer.isIndexable(attributes)) {
                this.indexable_current_node_ = string3;
                this.tokenize = Indexer.isTokenized(attributes);
            } else {
                this.indexable_current_node_ = "";
            }
        }

        public static boolean isTokenized(Attributes attributes) {
            boolean bl = true;
            String string = attributes.getValue("tokenize");
            if (string != null && string.equals("0")) {
                bl = false;
            }
            return bl;
        }

        public static boolean isIndexable(Attributes attributes) {
            boolean bl = false;
            String string = attributes.getValue("index");
            if (string != null && string.equals("1")) {
                bl = true;
            }
            return bl;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.mode_.equals("delete")) {
                try {
                    this.deleteDocument(this.current_doc_oid_);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (this.mode_.equals("add") || this.mode_.equals("update")) {
                if (string3.equals(this.indexable_current_node_)) {
                    if (this.tokenize) {
                        this.current_doc_.add(new Field(string3, this.current_contents_, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES));
                    } else {
                        this.current_doc_.add(new Field(string3, this.current_contents_, Field.Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
                    }
                    this.current_contents_ = "";
                }
                if (string3.equals(this.doc_tag_level_)) {
                    try {
                        this.writer_.updateDocument(new Term("docOID", this.current_doc_oid_), this.current_doc_, this.analyzer_);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    this.popOffStack();
                }
                this.path_ = this.removePathLink(this.path_);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            String string = new String(cArray, n, n2).trim();
            if (string.length() > 0) {
                this.current_contents_ = this.current_contents_ + string;
            }
        }

        protected String appendPathLink(String string, String string2, Attributes attributes) {
            string = string + "/" + string2;
            if (attributes.getLength() > 0) {
                String string3 = attributes.getValue("gs2:docOID");
                if (string3 != null) {
                    string = string + "[@gs2:docOID='" + string3 + "']";
                } else {
                    string3 = attributes.getValue("gs3:id");
                    if (string3 != null) {
                        string = string + "[@gs3:id='" + string3 + "']";
                    }
                }
            }
            return string;
        }

        protected String removePathLink(String string) {
            int n = string.lastIndexOf(47);
            string = n == -1 ? "" : string.substring(0, n);
            return string;
        }

        protected void pushOnStack() {
            if (this.current_doc_ != null) {
                MyDocument myDocument = new MyDocument();
                myDocument.doc = this.current_doc_;
                myDocument.contents = this.current_contents_;
                myDocument.tagname = this.current_node_;
                this.stack_.push(myDocument);
            }
            this.current_doc_ = new Document();
            this.current_contents_ = "";
            this.current_node_ = "";
        }

        protected void popOffStack() {
            if (!this.stack_.empty()) {
                MyDocument myDocument = (MyDocument)this.stack_.pop();
                this.current_doc_ = myDocument.doc;
                this.current_contents_ = myDocument.contents;
                this.current_node_ = myDocument.tagname;
            } else {
                this.current_doc_ = new Document();
                this.current_contents_ = "";
                this.current_node_ = "";
            }
        }

        protected void deleteDocument(String string) throws IOException {
            GS2LuceneIndexer.debug("GS2LuceneDelete.deleteDocument(" + string + ")");
            GS2LuceneIndexer.debug("- Initial number of documents in index: " + this.writer_.numDocs());
            this.writer_.deleteDocuments(new Term("docOID", string));
            GS2LuceneIndexer.debug("- Final number of documents in index: " + this.writer_.numDocs());
        }

        private class MyDocument {
            public Document doc = null;
            public String contents = null;
            public String tagname = "";

            private MyDocument() {
            }
        }
    }
}

