/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import jdbm.RecordManager;
import jdbm.helper.FastIterator;
import jdbm.helper.IterationException;
import jdbm.htree.HashBucket;
import jdbm.htree.HashNode;

final class HashDirectory
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    static final int MAX_CHILDREN = 256;
    static final int BIT_SIZE = 8;
    static final int MAX_DEPTH = 3;
    private long[] _children;
    private byte _depth;
    private transient RecordManager _recman;
    private transient long _recid;

    public HashDirectory() {
    }

    HashDirectory(byte by) {
        this._depth = by;
        this._children = new long[256];
    }

    void setPersistenceContext(RecordManager recordManager, long l) {
        this._recman = recordManager;
        this._recid = l;
    }

    long getRecid() {
        return this._recid;
    }

    boolean isEmpty() {
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] == 0L) continue;
            return false;
        }
        return true;
    }

    Object get(Object object) throws IOException {
        int n = this.hashCode(object);
        long l = this._children[n];
        if (l == 0L) {
            return null;
        }
        HashNode hashNode = (HashNode)this._recman.fetch(l);
        if (hashNode instanceof HashDirectory) {
            HashDirectory hashDirectory = (HashDirectory)hashNode;
            hashDirectory.setPersistenceContext(this._recman, l);
            return hashDirectory.get(object);
        }
        HashBucket hashBucket = (HashBucket)hashNode;
        return hashBucket.getValue(object);
    }

    Object put(Object object, Object object2) throws IOException {
        if (object2 == null) {
            return this.remove(object);
        }
        int n = this.hashCode(object);
        long l = this._children[n];
        if (l == 0L) {
            long l2;
            HashBucket hashBucket = new HashBucket(this._depth + 1);
            Object object3 = hashBucket.addElement(object, object2);
            this._children[n] = l2 = this._recman.insert(hashBucket);
            this._recman.update(this._recid, this);
            return object3;
        }
        HashNode hashNode = (HashNode)this._recman.fetch(l);
        if (hashNode instanceof HashDirectory) {
            HashDirectory hashDirectory = (HashDirectory)hashNode;
            hashDirectory.setPersistenceContext(this._recman, l);
            return hashDirectory.put(object, object2);
        }
        HashBucket hashBucket = (HashBucket)hashNode;
        if (hashBucket.hasRoom()) {
            Object object4 = hashBucket.addElement(object, object2);
            this._recman.update(l, hashBucket);
            return object4;
        }
        if (this._depth == 3) {
            throw new RuntimeException("Cannot create deeper directory. Depth=" + this._depth);
        }
        HashDirectory hashDirectory = new HashDirectory((byte)(this._depth + 1));
        long l3 = this._recman.insert(hashDirectory);
        hashDirectory.setPersistenceContext(this._recman, l3);
        this._children[n] = l3;
        this._recman.update(this._recid, this);
        this._recman.delete(l);
        ArrayList arrayList = hashBucket.getKeys();
        ArrayList arrayList2 = hashBucket.getValues();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            hashDirectory.put(arrayList.get(i), arrayList2.get(i));
        }
        return hashDirectory.put(object, object2);
    }

    Object remove(Object object) throws IOException {
        int n = this.hashCode(object);
        long l = this._children[n];
        if (l == 0L) {
            return null;
        }
        HashNode hashNode = (HashNode)this._recman.fetch(l);
        if (hashNode instanceof HashDirectory) {
            HashDirectory hashDirectory = (HashDirectory)hashNode;
            hashDirectory.setPersistenceContext(this._recman, l);
            Object object2 = hashDirectory.remove(object);
            if (object2 != null && hashDirectory.isEmpty()) {
                this._recman.delete(l);
                this._children[n] = 0L;
                this._recman.update(this._recid, this);
            }
            return object2;
        }
        HashBucket hashBucket = (HashBucket)hashNode;
        Object object3 = hashBucket.removeElement(object);
        if (object3 != null) {
            if (hashBucket.getElementCount() >= 1) {
                this._recman.update(l, hashBucket);
            } else {
                this._recman.delete(l);
                this._children[n] = 0L;
                this._recman.update(this._recid, this);
            }
        }
        return object3;
    }

    private int hashCode(Object object) {
        int n = this.hashMask();
        int n2 = object.hashCode();
        n2 &= n;
        n2 >>>= (3 - this._depth) * 8;
        return n2 %= 256;
    }

    int hashMask() {
        int n = 255;
        int n2 = n << (3 - this._depth) * 8;
        return n2;
    }

    FastIterator keys() throws IOException {
        return new HDIterator(true);
    }

    FastIterator values() throws IOException {
        return new HDIterator(false);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this._depth);
        objectOutput.writeObject(this._children);
    }

    @Override
    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._depth = objectInput.readByte();
        this._children = (long[])objectInput.readObject();
    }

    public class HDIterator
    extends FastIterator {
        private boolean _iterateKeys;
        private ArrayList _dirStack = new ArrayList();
        private ArrayList _childStack = new ArrayList();
        private HashDirectory _dir;
        private int _child;
        private Iterator _iter;

        HDIterator(boolean bl) throws IOException {
            this._dir = HashDirectory.this;
            this._child = -1;
            this._iterateKeys = bl;
            this.prepareNext();
        }

        @Override
        public Object next() {
            Object var1_1 = null;
            if (this._iter != null && this._iter.hasNext()) {
                var1_1 = this._iter.next();
            } else {
                try {
                    this.prepareNext();
                }
                catch (IOException iOException) {
                    throw new IterationException(iOException);
                }
                if (this._iter != null && this._iter.hasNext()) {
                    return this.next();
                }
            }
            return var1_1;
        }

        private void prepareNext() throws IOException {
            long l = 0L;
            do {
                ++this._child;
                if (this._child >= 256) {
                    if (this._dirStack.isEmpty()) {
                        return;
                    }
                    this._dir = (HashDirectory)this._dirStack.remove(this._dirStack.size() - 1);
                    this._child = (Integer)this._childStack.remove(this._childStack.size() - 1);
                    continue;
                }
                l = this._dir._children[this._child];
            } while (l == 0L);
            if (l == 0L) {
                throw new Error("child_recid cannot be 0");
            }
            HashNode hashNode = (HashNode)HashDirectory.this._recman.fetch(l);
            if (hashNode instanceof HashDirectory) {
                this._dirStack.add(this._dir);
                this._childStack.add(new Integer(this._child));
                this._dir = (HashDirectory)hashNode;
                this._child = -1;
                this._dir.setPersistenceContext(HashDirectory.this._recman, l);
                this.prepareNext();
            } else {
                HashBucket hashBucket = (HashBucket)hashNode;
                this._iter = this._iterateKeys ? hashBucket.getKeys().iterator() : hashBucket.getValues().iterator();
            }
        }
    }
}

