/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import jdbm.htree.HashNode;

final class HashBucket
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private ArrayList _keys;
    private ArrayList _values;

    public HashBucket() {
    }

    public HashBucket(int n) {
        if (n > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + n);
        }
        this._depth = n;
        this._keys = new ArrayList(8);
        this._values = new ArrayList(8);
    }

    public int getElementCount() {
        return this._keys.size();
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this._keys.size() < 8;
    }

    public Object addElement(Object object, Object object2) {
        int n = this._keys.indexOf(object);
        if (n != -1) {
            Object e = this._values.get(n);
            this._values.set(n, object2);
            return e;
        }
        this._keys.add(object);
        this._values.add(object2);
        return null;
    }

    public Object removeElement(Object object) {
        int n = this._keys.indexOf(object);
        if (n != -1) {
            Object e = this._values.get(n);
            this._keys.remove(n);
            this._values.remove(n);
            return e;
        }
        return null;
    }

    public Object getValue(Object object) {
        int n = this._keys.indexOf(object);
        if (n != -1) {
            return this._values.get(n);
        }
        return null;
    }

    ArrayList getKeys() {
        return this._keys;
    }

    ArrayList getValues() {
        return this._values;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        objectOutput.writeInt(this._depth);
        int n2 = this._keys.size();
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeObject(this._keys.get(n));
        }
        for (n = 0; n < n2; ++n) {
            objectOutput.writeObject(this._values.get(n));
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        this._depth = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = Math.max(n2, 8);
        this._keys = new ArrayList(n3);
        this._values = new ArrayList(n3);
        for (n = 0; n < n2; ++n) {
            this._keys.add(objectInput.readObject());
        }
        for (n = 0; n < n2; ++n) {
            this._values.add(objectInput.readObject());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HashBucket {depth=");
        stringBuffer.append(this._depth);
        stringBuffer.append(", keys=");
        stringBuffer.append(this._keys);
        stringBuffer.append(", values=");
        stringBuffer.append(this._values);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

