/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.util.HTMLStringTokenizer;
import org.greenstone.gatherer.util.SafeProcess;

public class Utility {
    public static final String CONFIG_FILE = "etc" + File.separator + "collect.cfg";
    public static final String CONFIG_GS3_FILE = "etc" + File.separator + "collectionConfig.xml";
    public static final String COLLECT_CFG = "collect.cfg";
    public static final String COLLECT_BAK = "collect.bak";
    public static final String COLLECTION_CONFIG_XML = "collectionConfig.xml";
    public static final String COLLECTION_CONFIG_BAK = "collectionConfig.bak";
    public static final String GROUP_CONFIG_XML = "groupConfig.xml";
    public static final String GS3MODE_ARGUMENT = "-gs3mode";
    public static final String BUILD_CFG = "build.cfg";
    public static final String BUILD_CONFIG_XML = "buildConfig.xml";
    public static final String PERL_EXECUTABLE_UNIX = "perl";
    public static final String PERL_EXECUTABLE_WINDOWS = "Perl.exe";
    public static final String NEWLINE;
    public static int IMPORT_MODE;
    public static int FILES_MODE;
    public static final String BYTE_SUFFIX = " b";
    public static final long GIGABYTE = 1024000000L;
    public static final String GIGABYTE_SUFFIX = " Gb";
    public static final long KILOBYTE = 1024L;
    public static final String KILOBYTE_SUFFIX = " kb";
    public static final long MEGABYTE = 1024000L;
    public static final String MEGABYTE_SUFFIX = " Mb";
    private static final String APPLICATION_DATA_FOLDER = "Application Data";
    private static final String UNIX_GLI_CONFIG_FOLDER = ".gli";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String WIN_GLI_CONFIG_FOLDER;
    public static final String LOG_DIR;
    private static HashMap plugin_map;

    public static String debugUnicodeString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            string2 = n >= 20 && n <= 126 || n == 9 || n == 10 || n == 13 ? string2 + string.charAt(i) : string2 + "x{" + String.format("%04x", n) + "}";
        }
        return string2;
    }

    public static String stringToHex(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            string2 = n <= 127 ? string2 + string.charAt(i) : string2 + "\\x{" + String.format("%04x", n) + "}";
        }
        return string2;
    }

    public static String getWindowsShortFileName(String string) throws Exception {
        if (!Utility.isWindows()) {
            return string;
        }
        return Utility.getMSDOSName(string);
    }

    public static String getMSDOSName(String string) throws IOException, InterruptedException {
        String string2 = Utility.getAbsolutePath(string);
        SafeProcess safeProcess = new SafeProcess("cmd /c for %I in (\"" + string2 + "\") do @echo %~fsI");
        int n = safeProcess.runProcess();
        if (n != 0) {
            return null;
        }
        String string3 = safeProcess.getStdOutput();
        if (string3 == null) {
            return null;
        }
        return string3.replaceAll("\\r\\n", "");
    }

    public static String getAbsolutePath(String string) throws IOException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (!file.exists()) {
            file = new File(string2);
        }
        string2 = file.getCanonicalPath();
        if (file.isDirectory() && !string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string2;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        System.err.println("\n@@@@ stacktrace:");
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Throwable().getStackTrace()) {
            System.err.println("   " + stackTraceElement);
        }
    }

    public static void printCaller() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        if (stackTraceElementArray.length > 3) {
            StackTraceElement stackTraceElement2 = stackTraceElementArray[3];
            System.err.println("\n@@@ Function " + stackTraceElement + " called by:\n    " + stackTraceElement2 + " at 1 ancestors back\n");
        } else {
            StackTraceElement stackTraceElement3 = stackTraceElementArray[stackTraceElementArray.length - 1];
            System.err.println("\n@@@ Don't have callers beyond requestor function " + stackTraceElement + "\n");
        }
    }

    public static void printCaller(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        if (stackTraceElementArray.length > n + 3) {
            StackTraceElement stackTraceElement2 = stackTraceElementArray[n + 3];
            System.err.println("\n@@@ Function " + stackTraceElement + " called by:\n    " + stackTraceElement2 + " at " + n + " ancestors back\n");
        } else {
            StackTraceElement stackTraceElement3 = stackTraceElementArray[stackTraceElementArray.length - 1];
            System.err.println("\n@@@ Don't have " + n + " ancestor callers. Function " + stackTraceElement + " called by:\n    " + stackTraceElement3 + " at max " + (stackTraceElementArray.length - 1) + " ancestors back\n");
        }
    }

    public static String readUTF8File(File file) {
        return Utility.readFile(file, "UTF-8");
    }

    public static String readFile(File file) {
        return Utility.readFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String string) {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            bufferedReader = string == null ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            try {
                System.err.println("*** Could not read in file: " + file.toString());
                System.err.println("*** Exception occurred: " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                SafeProcess.closeResource(bufferedReader);
                throw throwable;
            }
            SafeProcess.closeResource(bufferedReader);
        }
        SafeProcess.closeResource(bufferedReader);
        return stringBuffer.toString();
    }

    public static void writeFile(File file, String string) {
        Utility.writeFile(file, string, null);
    }

    public static void writeUTF8File(File file, String string) {
        Utility.writeFile(file, string, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = string2 == null ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, false))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), string2));
            bufferedWriter.write(string);
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (IOException iOException) {
            try {
                System.err.println("*** Could not write file: " + file.getName());
                System.err.println("Exception occurred: " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                SafeProcess.closeResource(bufferedWriter);
                throw throwable;
            }
            SafeProcess.closeResource(bufferedWriter);
        }
        SafeProcess.closeResource(bufferedWriter);
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        return Utility.deleteInternal(file);
    }

    public static boolean delete(String string) {
        return Utility.delete(new File(string));
    }

    private static boolean deleteInternal(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (Utility.deleteInternal(fileArray[i])) continue;
                System.err.println("Error: Could not delete folder " + file);
                return false;
            }
        }
        if (!file.delete()) {
            System.err.println("Error: Could not delete file " + file);
            return false;
        }
        return true;
    }

    public static final String formatFileLength(long l) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        float f = 0.0f;
        String string = null;
        if (l >= 1024000000L) {
            f = (float)l / 1.024E9f;
            string = GIGABYTE_SUFFIX;
        } else if (l >= 1024000L) {
            f = (float)l / 1024000.0f;
            string = MEGABYTE_SUFFIX;
        } else if (l >= 1024L) {
            f = (float)l / 1024.0f;
            string = KILOBYTE_SUFFIX;
        } else {
            return l + BYTE_SUFFIX;
        }
        String string2 = Float.toString(f);
        char[] cArray = string2.toCharArray();
        for (n = 0; cArray != null && n < cArray.length && cArray[n] != '.'; ++n) {
            stringBuffer.append(cArray[n]);
        }
        if (n < cArray.length) {
            stringBuffer.append(cArray[n]);
            ++n;
            for (int i = 0; i < 2 && n < cArray.length; ++i, ++n) {
                stringBuffer.append(cArray[n]);
            }
            while (n < cArray.length && cArray[n] != 'E') {
                ++n;
            }
            while (n < cArray.length) {
                stringBuffer.append(cArray[n]);
                ++n;
            }
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String formatHTMLWidth(String string, int n) {
        String string2;
        if (string == null) {
            return "Error";
        }
        HTMLStringTokenizer hTMLStringTokenizer = new HTMLStringTokenizer(string);
        int n2 = 0;
        int n3 = n / 2;
        Stack<String> stack = new Stack<String>();
        String string3 = "";
        while (hTMLStringTokenizer.hasMoreTokens()) {
            string2 = hTMLStringTokenizer.nextToken();
            while (string2 != null) {
                if (hTMLStringTokenizer.isTag()) {
                    string2 = null;
                    continue;
                }
                if (n2 + 1 + string2.length() > n && string2.length() > n3) {
                    if (n == n2) {
                        stack.push(string3);
                        string3 = string2;
                        n2 = string2.length();
                        continue;
                    }
                    String string4 = string2.substring(0, n - 1 - n2);
                    string2 = string2.substring(string4.length());
                    string3 = n2 == 0 ? string3 + string4 : string3 + " " + string4;
                    stack.push(string3);
                    string3 = "";
                    n2 = 0;
                    continue;
                }
                if (n2 + 1 + string2.length() > n) {
                    stack.push(string3);
                    string3 = string2;
                    n2 = string2.length();
                    string2 = null;
                    continue;
                }
                if (n2 == 0) {
                    string3 = string3 + string2;
                    n2 = string2.length();
                } else if (string2.equals(".") || string2.equals(",") || string2.equals("!") || string2.equals("?")) {
                    string3 = string3 + string2;
                    ++n2;
                } else {
                    string3 = string3 + " " + string2;
                    n2 = n2 + 1 + string2.length();
                }
                string2 = null;
            }
        }
        string2 = string3;
        while (!stack.empty()) {
            string2 = (String)stack.pop() + "<BR>" + string2;
        }
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '<') {
                bl = true;
                continue;
            }
            if (string2.charAt(i) == '>') {
                bl = false;
                continue;
            }
            if (string2.charAt(i) != ' ' || bl) continue;
            String string5 = string2.substring(0, i);
            String string6 = string2.substring(i + 1);
            string2 = string5 + "&nbsp;" + string6;
        }
        string2 = "<HTML>" + string2 + "</HTML>";
        return string2;
    }

    public static String getDateString() {
        Calendar calendar = Calendar.getInstance();
        String string = null;
        switch (calendar.get(7)) {
            case 2: {
                string = "Dates.Mon";
                break;
            }
            case 3: {
                string = "Dates.Tue";
                break;
            }
            case 4: {
                string = "Dates.Wed";
                break;
            }
            case 5: {
                string = "Dates.Thu";
                break;
            }
            case 6: {
                string = "Dates.Fri";
                break;
            }
            case 7: {
                string = "Dates.Sat";
                break;
            }
            case 1: {
                string = "Dates.Sun";
                break;
            }
            default: {
                string = "";
            }
        }
        String string2 = null;
        switch (calendar.get(2)) {
            case 0: {
                string2 = "Dates.Jan";
                break;
            }
            case 1: {
                string2 = "Dates.Feb";
                break;
            }
            case 2: {
                string2 = "Dates.Mar";
                break;
            }
            case 3: {
                string2 = "Dates.Apr";
                break;
            }
            case 4: {
                string2 = "Dates.May";
                break;
            }
            case 5: {
                string2 = "Dates.Jun";
                break;
            }
            case 6: {
                string2 = "Dates.Jul";
                break;
            }
            case 7: {
                string2 = "Dates.Aug";
                break;
            }
            case 8: {
                string2 = "Dates.Sep";
                break;
            }
            case 9: {
                string2 = "Dates.Oct";
                break;
            }
            case 10: {
                string2 = "Dates.Nov";
                break;
            }
            case 11: {
                string2 = "Dates.Dec";
                break;
            }
            default: {
                string2 = "";
            }
        }
        int n = calendar.get(5);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        int n5 = calendar.get(1);
        return Dictionary.get(string) + " " + Dictionary.get(string2) + " " + n + " " + n5 + " " + Utility.pad(String.valueOf(n2), 2, '0', true) + ":" + Utility.pad(String.valueOf(n3), 2, '0', true) + ":" + Utility.pad(String.valueOf(n4), 2, '0', true);
    }

    public static String getMachineName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "Unknown Machine";
        }
    }

    public static String getSitesDir(String string) {
        return string + "sites" + File.separator;
    }

    public static String getOSdirName() {
        if (Utility.isWindows()) {
            return "windows";
        }
        if (Utility.isMac()) {
            return "darwin";
        }
        return "linux";
    }

    public static boolean isMac() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("os.name", "");
        return string.startsWith("Mac OS");
    }

    public static boolean isWindows() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("os.name", "");
        return string.startsWith("Windows");
    }

    public static boolean isWindows9x() {
        Properties properties = System.getProperties();
        String string = properties.getProperty("os.name", "");
        return string.startsWith("Windows") && string.indexOf("9") != -1;
    }

    private static String pad(String string, int n, char c, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            if (bl) {
                stringBuffer.insert(0, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static File getCacheDir() {
        return new File(Utility.getGLIUserFolder(), "cache");
    }

    public static String getLogDir(String string) {
        if (string != null) {
            return string + LOG_DIR;
        }
        return Utility.getGLIUserFolder().getAbsolutePath() + File.separator + LOG_DIR;
    }

    public static File getGLIUserFolder() {
        if (Utility.isWindows()) {
            return new File(System.getProperty(USER_HOME_PROPERTY) + File.separator + APPLICATION_DATA_FOLDER + File.separator + WIN_GLI_CONFIG_FOLDER + File.separator);
        }
        return new File(System.getProperty(USER_HOME_PROPERTY) + File.separator + UNIX_GLI_CONFIG_FOLDER + File.separator);
    }

    private static void setUpPluginNameMap() {
        plugin_map = new HashMap();
        plugin_map.put("GAPlug", "GreenstoneXMLPlugin");
        plugin_map.put("RecPlug", "DirectoryPlugin");
        plugin_map.put("ArcPlug", "ArchivesInfPlugin");
        plugin_map.put("TEXTPlug", "TextPlugin");
        plugin_map.put("XMLPlug", "ReadXMLFile");
        plugin_map.put("EMAILPlug", "EmailPlugin");
        plugin_map.put("SRCPlug", "SourceCodePlugin");
        plugin_map.put("NULPlug", "NulPlugin");
        plugin_map.put("W3ImgPlug", "HTMLImagePlugin");
        plugin_map.put("PagedImgPlug", "PagedImagePlugin");
        plugin_map.put("METSPlug", "GreenstoneMETSPlugin");
        plugin_map.put("DBPlug", "DatabasePlugin");
        plugin_map.put("PPTPlug", "PowerPointPlugin");
        plugin_map.put("PSPlug", "PostScriptPlugin");
    }

    public static String ensureNewPluginName(String string) {
        String string2;
        if (string.endsWith("Plugin")) {
            return string;
        }
        if (plugin_map == null) {
            Utility.setUpPluginNameMap();
        }
        if ((string2 = (String)plugin_map.get(string)) != null) {
            return string2;
        }
        string2 = string.replaceAll("Plug", "Plugin");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updatePropertyConfigFile(String string, String string2, String string3) {
        BufferedWriter bufferedWriter;
        BufferedReader bufferedReader;
        String string4;
        block11: {
            File file = new File(string);
            string4 = "";
            if (!file.exists()) {
                System.err.println("*** Unable to update property " + string2 + " in file " + string + " to\n" + string3 + ". File does not (yet) exist.\n");
                return string4;
            }
            bufferedReader = null;
            bufferedWriter = null;
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = null;
            if (string3 != null) {
                string5 = string2 + "\t" + string3 + "\n";
            }
            boolean bl = false;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                String string6 = "";
                while ((string6 = bufferedReader.readLine()) != null) {
                    if ((string6 = string6.trim()).startsWith(string2)) {
                        bl = true;
                        string4 = string6;
                        string4 = string4.substring(string2.length());
                        string4 = string4.trim();
                        if (string3 == null) continue;
                        if (string6.equals(string5)) {
                            bufferedReader.close();
                            bufferedReader = null;
                            break;
                        }
                        stringBuffer.append(string5);
                        continue;
                    }
                    stringBuffer.append(string6);
                    stringBuffer.append("\n");
                }
                if (bufferedReader == null) break block11;
                bufferedReader.close();
                bufferedReader = null;
                if (!bl && string3 != null) {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, true), "UTF-8"));
                    bufferedWriter.write(string5, 0, string5.length());
                } else {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, false), "UTF-8"));
                    bufferedWriter.write(stringBuffer.toString(), 0, stringBuffer.length());
                }
                bufferedWriter.close();
                bufferedWriter = null;
            }
            catch (IOException iOException) {
                try {
                    System.err.println("*** Could not update file: " + string);
                    System.err.println("with the " + string2 + " property set to " + string3);
                    System.err.println("Exception occurred: " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    SafeProcess.closeResource(bufferedReader);
                    SafeProcess.closeResource(bufferedWriter);
                    throw throwable;
                }
                SafeProcess.closeResource(bufferedReader);
                SafeProcess.closeResource(bufferedWriter);
            }
        }
        SafeProcess.closeResource(bufferedReader);
        SafeProcess.closeResource(bufferedWriter);
        return string4;
    }

    static {
        IMPORT_MODE = 0;
        FILES_MODE = 1;
        double d = Double.parseDouble(System.getProperty("java.specification.version"));
        NEWLINE = d >= 1.7 ? System.getProperty("line.separator") : (Utility.isWindows() ? "\r\n" : "\n");
        WIN_GLI_CONFIG_FOLDER = "Greenstone" + File.separator + "GLI";
        LOG_DIR = "log" + File.separator;
        plugin_map = null;
    }
}

