/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.shell;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.metadata.DocXMLFileManager;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.shell.GShellProgressMonitor;
import org.greenstone.gatherer.util.SafeProcess;

public class GShell
extends Thread
implements SafeProcess.ExceptionHandler {
    private boolean cancel = false;
    private BufferedOutputStream buffered_output_stream = null;
    private final CopyOnWriteArrayList<GShellListener> listeners;
    private int status = -1;
    private int msg_type = -1;
    private int type = -1;
    private GShellListener caller = null;
    private GShellProgressMonitor progress = null;
    private String[] args = null;
    private String commandOutput = null;
    private SafeProcess prcs = null;
    public static final int BUILD = 0;
    public static final int IMPORT = 1;
    public static final int NEW = 2;
    public static final int EXPORTAS = 3;
    public static final int CDIMAGE = 4;
    public static final int CONVERT = 5;
    public static final int EXPLODE = 6;
    public static final int SRCREPLACE = 7;
    public static final int SCHEDULE = 8;
    public static final int DELETE = 9;
    public static final int ERROR = 0;
    public static final int OK = 1;
    public static final int CANCELLED = 2;
    public static String GSHELL_BUILD = "gshell_build";
    public static String GSHELL_IMPORT = "gshell_import";
    public static String GSHELL_NEW = "gshell_new";
    public static String GSHELL_EXPORTAS = "gshell_exportas";
    public static String GSHELL_CDIMAGE = "gshell_cdimage";
    public static String GSHELL_CONVERT = "gshell_convert";
    public static String GSHELL_EXPLODE = "gshell_explode";
    public static String GSHELL_SRCREPLACE = "gshell_srcreplace";
    public static String GSHELL_SCHEDULE = "gshell_schedule";
    public static String GSHELL_FEDORA_COLDELETE = "gshell_fedora_col_delete";

    public GShell(String[] stringArray, int n, int n2, GShellListener gShellListener, GShellProgressMonitor gShellProgressMonitor, String string) {
        super(string);
        this.args = stringArray;
        this.msg_type = n2;
        this.type = n;
        this.caller = gShellListener;
        this.progress = gShellProgressMonitor;
        this.status = 0;
        this.setPriority(1);
        this.listeners = new CopyOnWriteArrayList();
        if (gShellListener != null) {
            this.listeners.add(gShellListener);
        }
    }

    public void addGShellListener(GShellListener gShellListener) {
        this.listeners.add(gShellListener);
    }

    protected StringBuffer get_stream_char(InputStreamReader inputStreamReader, StringBuffer stringBuffer, BufferedOutputStream bufferedOutputStream) throws IOException {
        int n = inputStreamReader.read();
        if (n == 10 || n == 13) {
            if (stringBuffer.length() > 0) {
                String string = stringBuffer.toString();
                this.fireMessage(this.type, this.typeAsString(this.type) + "> " + string, this.status, bufferedOutputStream);
                stringBuffer = new StringBuffer();
            }
        } else {
            stringBuffer.append((char)n);
        }
        return stringBuffer;
    }

    public String getCommandOutput() {
        return this.commandOutput;
    }

    public void resetCommandOutput() {
        this.commandOutput = null;
    }

    private void runRemote(String[] stringArray, BufferedOutputStream bufferedOutputStream) {
        if (this.hasSignalledStop()) {
            return;
        }
        try {
            String string;
            int n = stringArray[0].lastIndexOf(File.separator);
            String string2 = n != -1 ? stringArray[0].substring(n + 1) : stringArray[0];
            System.err.println("Script name: " + string2);
            String string3 = stringArray[stringArray.length - 1];
            System.err.println("Collection name: " + string3);
            String string4 = "";
            for (int i = 1; i < stringArray.length - 1; ++i) {
                if (stringArray[i].equals("-collectdir") || stringArray[i].equals("-importdir") || stringArray[i].equals("-builddir") || stringArray[i].equals("-site")) {
                    ++i;
                    continue;
                }
                if (!stringArray[i].startsWith("-")) continue;
                string4 = string4 + "&" + stringArray[i].substring(1) + "=";
                if (i + 1 >= stringArray.length - 1 || stringArray[i + 1].startsWith("-")) continue;
                string4 = string4 + URLEncoder.encode(stringArray[i + 1], "UTF-8");
                ++i;
            }
            System.err.println("Script args: " + string4);
            this.buffered_output_stream = bufferedOutputStream;
            this.commandOutput = string = Gatherer.remoteGreenstoneServer.runScript(string3, string2, string4, this);
            this.status = string.equals("") ? 2 : 1;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            this.status = 0;
        }
    }

    private void old_runLocal(String[] stringArray, BufferedOutputStream bufferedOutputStream) {
        try {
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + " ";
            }
            this.fireMessage(this.type, Dictionary.get("GShell.Command") + ": " + string, this.status, null);
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            process = runtime.exec(stringArray);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream(), "UTF-8");
            InputStreamReader inputStreamReader2 = new InputStreamReader(process.getInputStream(), "UTF-8");
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (SafeProcess.processRunning(process) && !this.hasSignalledStop()) {
                if (inputStreamReader != null && inputStreamReader.ready()) {
                    stringBuffer = this.get_stream_char(inputStreamReader, stringBuffer, bufferedOutputStream);
                    continue;
                }
                if (inputStreamReader2.ready()) {
                    stringBuffer2 = this.get_stream_char(inputStreamReader2, stringBuffer2, bufferedOutputStream);
                    continue;
                }
                try {
                    GShell.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (!this.hasSignalledStop()) {
                String string2;
                while (inputStreamReader.ready()) {
                    stringBuffer = this.get_stream_char(inputStreamReader, stringBuffer, bufferedOutputStream);
                }
                while (inputStreamReader2.ready()) {
                    stringBuffer2 = this.get_stream_char(inputStreamReader2, stringBuffer2, bufferedOutputStream);
                }
                if (stringBuffer.length() > 0) {
                    string2 = stringBuffer.toString();
                    this.fireMessage(this.type, this.typeAsString(this.type) + "> " + string2, this.status, bufferedOutputStream);
                    string2 = null;
                }
                if (stringBuffer2.length() > 0) {
                    string2 = stringBuffer2.toString();
                    this.fireMessage(this.type, this.typeAsString(this.type) + "> " + string2, this.status, null);
                    string2 = null;
                }
            } else {
                DebugStream.println("We've been asked to stop.");
            }
            if (!this.hasSignalledStop()) {
                process.waitFor();
                if (process.exitValue() == 0) {
                    this.status = 1;
                    this.fireMessage(this.type, this.typeAsString(this.type) + "> " + Dictionary.get("GShell.Success"), this.status, null);
                } else {
                    this.status = 0;
                    this.fireMessage(this.type, this.typeAsString(this.type) + "> " + Dictionary.get("GShell.Failure"), this.status, null);
                }
                inputStreamReader.close();
                inputStreamReader2.close();
            } else {
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
                process.destroy();
                this.status = 2;
            }
        }
        catch (Exception exception) {
            DebugStream.println("Exception in GShell.runLocal() - unexpected");
            DebugStream.printStackTrace(exception);
            this.status = 0;
        }
    }

    private void runLocal(String[] stringArray, BufferedOutputStream bufferedOutputStream) {
        if (this.hasSignalledStop()) {
            return;
        }
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + " ";
        }
        this.fireMessage(this.type, Dictionary.get("GShell.Command") + ": " + string, this.status, null);
        this.prcs = new SafeProcess(stringArray);
        SynchronizedLineByLineHandler synchronizedLineByLineHandler = new SynchronizedLineByLineHandler(1);
        SynchronizedLineByLineHandler synchronizedLineByLineHandler2 = new SynchronizedLineByLineHandler(0);
        this.prcs.setExceptionHandler(this);
        int n = this.prcs.runProcess(synchronizedLineByLineHandler, synchronizedLineByLineHandler2);
        if (n == 0) {
            this.status = 1;
            this.fireMessage(this.type, this.typeAsString(this.type) + "> " + Dictionary.get("GShell.Success"), this.status, null);
        } else {
            this.status = 0;
            this.fireMessage(this.type, this.typeAsString(this.type) + "> " + Dictionary.get("GShell.Failure"), this.status, null);
        }
        this.prcs = null;
    }

    public void cancel() {
        if (this.prcs != null) {
            SafeProcess.log("********** HAS SIGNALLED STOP. INTERRUPTING THE GSHELL/SAFEPROCESS THREAD");
            this.prcs.cancelRunningProcess();
            this.prcs = null;
        }
        this.setStatus(2);
    }

    @Override
    public void run() {
        String string = this.args[this.args.length - 1];
        String string2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        if ((this.type == 1 || this.type == 0 || this.type == 8) && (string2 = this.type == 1 ? Gatherer.c_man.getCollection().import_options.getValue("out") : (this.type == 0 ? Gatherer.c_man.getCollection().build_options.getValue("out") : Gatherer.c_man.getCollection().schedule_options.getValue("out"))) != null && string2.length() > 0) {
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2), true));
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
        this.fireProcessBegun(this.type, this.status);
        if (Gatherer.isGsdlRemote) {
            this.runRemote(this.args, bufferedOutputStream);
        } else {
            this.runLocal(this.args, bufferedOutputStream);
        }
        if (this.status == 1) {
            File file;
            if (this.type == 2) {
                if (Gatherer.isGsdlRemote) {
                    Gatherer.remoteGreenstoneServer.downloadCollection(string);
                }
            } else if (this.type == 1) {
                if (Gatherer.isGsdlRemote) {
                    if (this.progress != null) {
                        this.progress.messageOnProgressBar("Downloading archive data from server");
                    }
                    Gatherer.remoteGreenstoneServer.downloadCollectionArchives(string);
                    if (this.progress != null) {
                        this.progress.messageOnProgressBar("");
                    }
                }
                this.fireMessage(this.type, this.typeAsString(this.type) + "> " + Dictionary.get("GShell.Parsing_Metadata_Start"), this.status, null);
                DocXMLFileManager.clearDocXMLFiles();
                if (Configuration.fedora_info != null && Configuration.fedora_info.isActive()) {
                    file = new File(CollectionManager.getLoadedCollectionExportDirectoryPath());
                    DocXMLFileManager.loadDocXMLFiles(file, "docmets.xml");
                } else {
                    file = new File(CollectionManager.getLoadedCollectionArchivesDirectoryPath());
                    DocXMLFileManager.loadDocXMLFiles(file, "doc.xml");
                }
                this.fireMessage(this.type, this.typeAsString(this.type) + "> " + Dictionary.get("GShell.Parsing_Metadata_Complete"), this.status, null);
            } else if (this.type == 0) {
                if (Gatherer.isGsdlRemote && !Configuration.fedora_info.isActive()) {
                    if (this.progress != null) {
                        this.progress.messageOnProgressBar("Downloading index data from server");
                    }
                    if (!Gatherer.GS3) {
                        file = new File(CollectionManager.getLoadedCollectionIndexDirectoryPath(), "build.cfg");
                        Gatherer.remoteGreenstoneServer.downloadCollectionFile(string, file);
                    } else {
                        file = new File(CollectionManager.getLoadedCollectionIndexDirectoryPath(), "buildConfig.xml");
                        Gatherer.remoteGreenstoneServer.downloadCollectionFile(string, file);
                    }
                    if (this.progress != null) {
                        this.progress.messageOnProgressBar("");
                    }
                }
            } else if (this.type == 4 && Gatherer.isGsdlRemote) {
                if (this.progress != null) {
                    this.progress.messageOnProgressBar("Downloading CD-ROM data from server");
                }
                if (this.progress != null) {
                    this.progress.messageOnProgressBar("");
                }
            }
        }
        this.fireProcessComplete(this.type, this.status);
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.close();
                bufferedOutputStream = null;
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
    }

    public synchronized void fireMessage(String string) {
        this.fireMessage(this.type, this.typeAsString(this.type) + "> " + string, this.status, this.buffered_output_stream);
    }

    public void fireMessage(int n, String string, int n2, BufferedOutputStream bufferedOutputStream) {
        GShellEvent gShellEvent = new GShellEvent(this, 0, n, string, n2);
        ArrayList<GShellEvent> arrayList = new ArrayList<GShellEvent>();
        arrayList.add(gShellEvent);
        if (this.progress != null) {
            this.progress.process(arrayList);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            GShellEvent gShellEvent2 = (GShellEvent)arrayList.get(i);
            if (gShellEvent2.isVetoed()) continue;
            for (GShellListener gShellListener : this.listeners) {
                gShellListener.message(gShellEvent2);
            }
        }
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.write(string.getBytes(), 0, string.length());
            }
            catch (Exception exception) {
                DebugStream.println("Exception in GShell.fireMessage() - unexpected");
                DebugStream.printStackTrace(exception);
            }
        }
        arrayList = null;
        gShellEvent = null;
    }

    protected void fireProcessBegun(int n, int n2) {
        if (this.progress != null) {
            this.progress.start();
        }
        GShellEvent gShellEvent = new GShellEvent(this, 0, n, "", n2);
        for (GShellListener gShellListener : this.listeners) {
            gShellListener.processBegun(gShellEvent);
        }
    }

    protected void fireProcessComplete(final int n, final int n2) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("GShell.fireProcessComplete()", true, new Runnable(){

            @Override
            public void run() {
                Object object;
                if (GShell.this.progress != null && n2 != 2) {
                    GShell.this.progress.stop();
                }
                if (n2 == 2 && Configuration.getMode() <= 2) {
                    object = new GShellEvent(GShell.this, 0, n, Dictionary.get("GShell.Build.BuildCancelled"), n2);
                    for (Object object2 : GShell.this.listeners) {
                        object2.message((GShellEvent)object);
                    }
                }
                object = "";
                if (n2 == 0 && n == 2) {
                    object = GShell.this.args[GShell.this.args.length - 1];
                }
                GShellEvent gShellEvent = new GShellEvent(GShell.this, 0, n, (String)object, n2);
                for (GShellListener gShellListener : GShell.this.listeners) {
                    gShellListener.processComplete(gShellEvent);
                }
            }
        });
    }

    public synchronized boolean hasSignalledStop() {
        boolean bl = false;
        if (this.progress != null) {
            bl = this.progress.hasSignalledStop();
        }
        if (bl) {
            this.status = 2;
        }
        return bl;
    }

    public String typeAsString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "buildcol.pl";
                break;
            }
            case 1: {
                string = "import.pl";
                break;
            }
            case 2: {
                string = "mkcol.pl";
                break;
            }
            case 3: {
                string = "export.pl";
                break;
            }
            case 4: {
                string = "exportcol.pl";
                break;
            }
            case 5: {
                string = "convert_coll_from_gs2.pl";
                break;
            }
            case 6: {
                string = "explode_metadata_database.pl";
                break;
            }
            case 7: {
                string = "replace_srcdoc_with_html.pl";
                break;
            }
            case 8: {
                string = "schedule.pl";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void gotException(Exception exception) {
        if (exception instanceof InterruptedException) {
            DebugStream.println("We've been asked to stop.");
            SafeProcess.log("@@@ Interruption to SafeProcess run by GShell.runLocal()");
            this.setStatus(2);
        } else {
            DebugStream.println("Exception in GShell.runLocal() - unexpected");
            DebugStream.printStackTrace(exception);
            this.setStatus(0);
        }
    }

    public synchronized void setStatus(int n) {
        this.status = n;
    }

    protected class SynchronizedLineByLineHandler
    extends SafeProcess.LineByLineHandler {
        public SynchronizedLineByLineHandler(int n) {
            super(n);
        }

        @Override
        public void gotException(Exception exception) {
            String string = "Got exception when processing the perl process' " + SafeProcess.streamToString(this.source) + " stream.";
            DebugStream.println(string);
            DebugStream.printStackTrace(exception);
            SafeProcess.log("*** " + string, exception);
            GShell.this.setStatus(0);
        }

        private void log(String string) {
            DebugStream.println(string);
            System.err.println("@@@@@ " + string);
        }

        @Override
        public void gotLine(String string) {
            GShell.this.fireMessage(string);
        }
    }
}

