/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.metadata.MetadataChangedListener;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataXMLFile;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;

public class MetadataXMLFileManager {
    private static ArrayList metadata_xml_files = new ArrayList();
    private static ArrayList metadata_changed_listeners = new ArrayList();
    private static ArrayList modified_metadata_xml_files = new ArrayList();
    private static MetadataXMLFileComparator metadataXMLFileComparator = new MetadataXMLFileComparator();

    public static void addMetadata(CollectionTreeNode collectionTreeNode, ArrayList arrayList) {
        MetadataXMLFileManager.addMetadata(new CollectionTreeNode[]{collectionTreeNode}, arrayList);
    }

    public static void addMetadata(CollectionTreeNode[] collectionTreeNodeArray, MetadataValue metadataValue) {
        ArrayList<MetadataValue> arrayList = new ArrayList<MetadataValue>();
        arrayList.add(metadataValue);
        MetadataXMLFileManager.addMetadata(collectionTreeNodeArray, arrayList);
    }

    public static void addMetadata(CollectionTreeNode[] collectionTreeNodeArray, ArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return;
        }
        for (int i = 0; i < collectionTreeNodeArray.length; ++i) {
            MetadataXMLFile metadataXMLFile;
            File file = collectionTreeNodeArray[i].getFile();
            DebugStream.println("Adding metadata to " + file.getAbsolutePath() + " - hex: " + Utility.debugUnicodeString(file.getAbsolutePath()));
            boolean bl = false;
            File file2 = file.isDirectory() ? file : file.getParentFile();
            String string = file2.getAbsolutePath();
            for (int j = 0; j < metadata_xml_files.size(); ++j) {
                metadataXMLFile = (MetadataXMLFile)metadata_xml_files.get(j);
                if (!string.equals(metadataXMLFile.getParentFile().getAbsolutePath())) continue;
                bl = true;
                metadataXMLFile.addMetadata(collectionTreeNodeArray[i], arrayList);
                if (modified_metadata_xml_files.contains(metadataXMLFile)) continue;
                modified_metadata_xml_files.add(metadataXMLFile);
            }
            if (bl) continue;
            File file3 = new File(file2, "metadata.xml");
            XMLTools.writeXMLFile(file3, XMLTools.parseXMLFile("xml/metadata.xml", true));
            metadataXMLFile = MetadataXMLFileManager.loadMetadataXMLFile(file3, true);
            metadataXMLFile.addMetadata(collectionTreeNodeArray[i], arrayList);
            if (modified_metadata_xml_files.contains(metadataXMLFile)) continue;
            modified_metadata_xml_files.add(metadataXMLFile);
        }
        MetadataXMLFileManager.fireMetadataChangedEvent(collectionTreeNodeArray);
    }

    public static void addMetadataChangedListener(MetadataChangedListener metadataChangedListener) {
        metadata_changed_listeners.add(metadataChangedListener);
    }

    public static void clearMetadataXMLFiles() {
        metadata_xml_files.clear();
    }

    private static void fireMetadataChangedEvent(CollectionTreeNode[] collectionTreeNodeArray) {
        for (int i = 0; i < metadata_changed_listeners.size(); ++i) {
            ((MetadataChangedListener)metadata_changed_listeners.get(i)).metadataChanged(collectionTreeNodeArray);
        }
    }

    public static ArrayList getMetadataAssignedDirectlyToExternalFile(File file) {
        Serializable serializable;
        File file2;
        DebugStream.println("Getting metadata assigned directly to external file " + file + "...");
        ArrayList<MetadataXMLFile> arrayList = new ArrayList<MetadataXMLFile>();
        File file3 = file2 = file.isDirectory() ? file : file.getParentFile();
        while (file2 != null) {
            serializable = new File(file2, "metadata.xml");
            if (((File)serializable).exists() && !((File)serializable).isDirectory()) {
                arrayList.add(0, new MetadataXMLFile(((File)serializable).getAbsolutePath()));
            }
            file2 = file2.getParentFile();
        }
        serializable = MetadataXMLFileManager.getMetadataAssignedToFile(file, arrayList, false);
        for (int i = ((ArrayList)serializable).size() - 1; i >= 0; --i) {
            if (!((MetadataValue)((ArrayList)serializable).get(i)).isInheritedMetadata()) continue;
            ((ArrayList)serializable).remove(i);
        }
        return serializable;
    }

    public static ArrayList getMetadataAssignedDirectlyToFile(File file) {
        return MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file, false);
    }

    public static ArrayList getMetadataAssignedDirectlyToFile(File file, boolean bl) {
        ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedToFile(file, bl);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!((MetadataValue)arrayList.get(i)).isInheritedMetadata()) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public static ArrayList getMetadataAssignedToFile(File file) {
        return MetadataXMLFileManager.getMetadataAssignedToFile(file, false);
    }

    public static ArrayList getMetadataAssignedToFile(File file, boolean bl) {
        ArrayList<MetadataXMLFile> arrayList = new ArrayList<MetadataXMLFile>();
        String string = (file.isDirectory() ? file : file.getParentFile()).getAbsolutePath() + File.separator;
        for (int i = 0; i < metadata_xml_files.size(); ++i) {
            MetadataXMLFile metadataXMLFile = (MetadataXMLFile)metadata_xml_files.get(i);
            if (!string.startsWith(metadataXMLFile.getParentFile().getAbsolutePath() + File.separator)) continue;
            arrayList.add(metadataXMLFile);
        }
        Collections.sort(arrayList, metadataXMLFileComparator);
        return MetadataXMLFileManager.getMetadataAssignedToFile(file, arrayList, bl);
    }

    static ArrayList getMetadataAssignedToFile(File file, ArrayList arrayList, boolean bl) {
        ArrayList<MetadataValue> arrayList2 = new ArrayList<MetadataValue>();
        for (int i = 0; i < arrayList.size(); ++i) {
            MetadataXMLFile metadataXMLFile = (MetadataXMLFile)arrayList.get(i);
            DebugStream.println("Applicable metadata.xml file: " + metadataXMLFile);
            ArrayList arrayList3 = metadataXMLFile.getMetadataAssignedToFile(file, bl);
            for (int j = 0; j < arrayList3.size(); ++j) {
                MetadataValue metadataValue = (MetadataValue)arrayList3.get(j);
                if (!metadataValue.isAccumulatingMetadata()) {
                    for (int k = arrayList2.size() - 1; k >= 0; --k) {
                        if (!((MetadataValue)arrayList2.get(k)).getMetadataElement().equals(metadataValue.getMetadataElement())) continue;
                        arrayList2.remove(k);
                    }
                }
                arrayList2.add(metadataValue);
            }
        }
        return arrayList2;
    }

    public static void loadMetadataXMLFiles(File file, boolean bl) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                MetadataXMLFileManager.loadMetadataXMLFiles(file2, bl);
                continue;
            }
            if (!file2.getName().equals("metadata.xml")) continue;
            MetadataXMLFileManager.loadMetadataXMLFile(file2, bl);
        }
    }

    private static MetadataXMLFile loadMetadataXMLFile(File file, boolean bl) {
        MetadataXMLFile metadataXMLFile = new MetadataXMLFile(file.getAbsolutePath());
        if (metadata_xml_files.contains(metadataXMLFile)) {
            return (MetadataXMLFile)metadata_xml_files.get(metadata_xml_files.indexOf(metadataXMLFile));
        }
        if (bl) {
            metadataXMLFile.skimFile();
        }
        metadata_xml_files.add(metadataXMLFile);
        return metadataXMLFile;
    }

    public static void removeMetadata(CollectionTreeNode collectionTreeNode, ArrayList arrayList) {
        MetadataXMLFileManager.removeMetadata(new CollectionTreeNode[]{collectionTreeNode}, arrayList);
    }

    public static void removeMetadata(CollectionTreeNode[] collectionTreeNodeArray, MetadataValue metadataValue) {
        ArrayList<MetadataValue> arrayList = new ArrayList<MetadataValue>();
        arrayList.add(metadataValue);
        MetadataXMLFileManager.removeMetadata(collectionTreeNodeArray, arrayList);
    }

    public static void removeMetadata(CollectionTreeNode[] collectionTreeNodeArray, ArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return;
        }
        for (int i = 0; i < collectionTreeNodeArray.length; ++i) {
            File file = collectionTreeNodeArray[i].getFile();
            DebugStream.println("Removing metadata from " + file.getAbsolutePath());
            File file2 = file.isDirectory() ? file : file.getParentFile();
            String string = file2.getAbsolutePath();
            for (int j = 0; j < metadata_xml_files.size(); ++j) {
                MetadataXMLFile metadataXMLFile = (MetadataXMLFile)metadata_xml_files.get(j);
                if (!string.startsWith(metadataXMLFile.getParentFile().getAbsolutePath())) continue;
                metadataXMLFile.removeMetadata(collectionTreeNodeArray[i], arrayList);
                if (modified_metadata_xml_files.contains(metadataXMLFile)) continue;
                modified_metadata_xml_files.add(metadataXMLFile);
            }
        }
        MetadataXMLFileManager.fireMetadataChangedEvent(collectionTreeNodeArray);
    }

    public static void removeMetadataChangedListener(MetadataChangedListener metadataChangedListener) {
        metadata_changed_listeners.remove(metadataChangedListener);
    }

    public static void replaceMetadata(CollectionTreeNode[] collectionTreeNodeArray, MetadataValue metadataValue, MetadataValue metadataValue2) {
        for (int i = 0; i < collectionTreeNodeArray.length; ++i) {
            File file = collectionTreeNodeArray[i].getFile();
            DebugStream.println("Replacing metadata in " + file.getAbsolutePath());
            File file2 = file.isDirectory() ? file : file.getParentFile();
            String string = file2.getAbsolutePath();
            for (int j = 0; j < metadata_xml_files.size(); ++j) {
                MetadataXMLFile metadataXMLFile = (MetadataXMLFile)metadata_xml_files.get(j);
                if (!string.equals(metadataXMLFile.getParentFile().getAbsolutePath())) continue;
                metadataXMLFile.replaceMetadata(collectionTreeNodeArray[i], metadataValue, metadataValue2);
                if (modified_metadata_xml_files.contains(metadataXMLFile)) continue;
                modified_metadata_xml_files.add(metadataXMLFile);
            }
        }
        MetadataXMLFileManager.fireMetadataChangedEvent(collectionTreeNodeArray);
    }

    public static void saveMetadataXMLFiles() {
        MetadataXMLFile.saveLoadedFile();
        if (Gatherer.isGsdlRemote) {
            if (modified_metadata_xml_files.isEmpty()) {
                DebugStream.println("No modified metadata.xml files to upload.");
                return;
            }
            Gatherer.remoteGreenstoneServer.uploadCollectionFiles(CollectionManager.getLoadedCollectionName(), modified_metadata_xml_files.toArray(new File[0]));
            modified_metadata_xml_files.clear();
        }
    }

    public static void unloadMetadataXMLFile(File file) {
        DebugStream.println("Unloading metadata.xml file " + file);
        for (int i = 0; i < metadata_xml_files.size(); ++i) {
            MetadataXMLFile metadataXMLFile = (MetadataXMLFile)metadata_xml_files.get(i);
            if (!file.getAbsolutePath().equals(metadataXMLFile.getAbsolutePath())) continue;
            metadata_xml_files.remove(i);
            break;
        }
    }

    public static void clearAllMetadataInCollection() {
        for (int i = 0; i < metadata_xml_files.size(); ++i) {
            MetadataXMLFile metadataXMLFile = (MetadataXMLFile)metadata_xml_files.get(i);
            metadataXMLFile.clearAllMetadataInFile();
            if (!modified_metadata_xml_files.contains(metadataXMLFile)) {
                modified_metadata_xml_files.add(metadataXMLFile);
            }
            MetadataXMLFileManager.saveMetadataXMLFiles();
        }
    }

    private static class MetadataXMLFileComparator
    implements Comparator {
        private MetadataXMLFileComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof MetadataXMLFile)) {
                return -1;
            }
            if (!(object2 instanceof MetadataXMLFile)) {
                return 1;
            }
            String string = ((MetadataXMLFile)object).getParentFile().getAbsolutePath();
            String string2 = ((MetadataXMLFile)object2).getParentFile().getAbsolutePath();
            if (string2.startsWith(string)) {
                return -1;
            }
            if (string.startsWith(string2)) {
                return 1;
            }
            return string.compareTo(string2);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof MetadataXMLFileComparator;
        }
    }
}

