/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataXMLFile
extends File {
    private static final String DESCRIPTION_ELEMENT = "Description";
    private static final String DIRECTORY_FILENAME = ".*";
    private static final String FILENAME_ELEMENT = "FileName";
    private static final String FILESET_ELEMENT = "FileSet";
    private static final String METADATA_ELEMENT = "Metadata";
    private static final String[] nonEscapingElements = new String[]{"FileName"};
    public static final String FILENAME_ENCODING_METADATA = "gs.filenameEncoding";
    private static File loaded_file = null;
    private static Document loaded_file_document = null;
    private static boolean loaded_file_changed = false;

    public MetadataXMLFile(String string) {
        super(string);
    }

    public void clearAllMetadataInFile() {
        Node node;
        if (loaded_file != this) {
            MetadataXMLFile.saveLoadedFile();
            node = XMLTools.parseXMLFile(this);
            if (node == null) {
                System.err.println("Error: Could not parse metadata.xml file " + this.getAbsolutePath());
                return;
            }
            loaded_file = this;
            loaded_file_document = node;
        }
        node = loaded_file_document.getDocumentElement();
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
        loaded_file_changed = true;
    }

    public void addMetadata(CollectionTreeNode collectionTreeNode, ArrayList arrayList) {
        Object object;
        Object object2;
        Element element;
        String string;
        Object object3;
        if (loaded_file != this) {
            MetadataXMLFile.saveLoadedFile();
            object3 = XMLTools.parseXMLFile(this);
            if (object3 == null) {
                System.err.println("Error: Could not parse metadata.xml file " + this.getAbsolutePath());
                return;
            }
            loaded_file = this;
            loaded_file_document = object3;
        }
        object3 = FilenameEncoding.fileToURLEncoding(this.getParentFile());
        String string2 = collectionTreeNode.getURLEncodedFilePath();
        if ((string2 = string2.substring(((String)object3).length())).startsWith(FilenameEncoding.URL_FILE_SEPARATOR)) {
            string2 = string2.substring(FilenameEncoding.URL_FILE_SEPARATOR.length());
        }
        if (string2.equals("")) {
            string = DIRECTORY_FILENAME;
        } else {
            string2 = string2.replace("&", "%26");
            string = MetadataTools.getRegularExpressionThatMatchesFilePath(string2);
        }
        Element element2 = null;
        NodeList nodeList = loaded_file_document.getElementsByTagName(FILESET_ELEMENT);
        block0: for (int i = 0; i < nodeList.getLength(); ++i) {
            element = (Element)nodeList.item(i);
            object2 = element.getElementsByTagName(FILENAME_ELEMENT);
            for (int j = 0; j < object2.getLength(); ++j) {
                object = (Element)object2.item(j);
                String string3 = XMLTools.getElementTextValue((Element)object);
                if (!string3.equals(string)) continue;
                element2 = element;
                continue block0;
            }
        }
        if (element2 == null) {
            DebugStream.println("Creating new FileSet element for file since none exists..." + string);
            element2 = loaded_file_document.createElement(FILESET_ELEMENT);
            Element element3 = loaded_file_document.createElement(FILENAME_ELEMENT);
            element3.appendChild(loaded_file_document.createTextNode(string));
            element2.appendChild(element3);
            element = loaded_file_document.createElement(DESCRIPTION_ELEMENT);
            element2.appendChild(element);
            if (string.equals(DIRECTORY_FILENAME)) {
                loaded_file_document.getDocumentElement().insertBefore(element2, loaded_file_document.getDocumentElement().getFirstChild());
            } else {
                loaded_file_document.getDocumentElement().appendChild(element2);
            }
        }
        Element element4 = (Element)element2.getElementsByTagName(DESCRIPTION_ELEMENT).item(0);
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (MetadataValue)arrayList.get(i);
            String string4 = ((MetadataValue)object2).getMetadataElement().getFullName();
            object = XMLTools.removeInvalidCharacters(((MetadataValue)object2).getFullValue());
            object = ((String)object).replaceAll("\\[", "&#091;");
            object = ((String)object).replaceAll("\\]", "&#093;");
            if (string4.equals(FILENAME_ENCODING_METADATA)) {
                object = this.processFilenameEncoding(string, collectionTreeNode, (String)object, false);
            }
            boolean bl = false;
            NodeList nodeList2 = element4.getElementsByTagName(METADATA_ELEMENT);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element5 = (Element)nodeList2.item(j);
                String string5 = element5.getAttribute("name");
                if (!string5.equals(string4)) continue;
                if (!((MetadataValue)object2).isAccumulatingMetadata()) {
                    XMLTools.setNodeText(element5, (String)object);
                    bl = true;
                    break;
                }
                String string6 = XMLTools.getElementTextValue(element5);
                if (!string6.equals(object)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Element element6 = loaded_file_document.createElement(METADATA_ELEMENT);
            element6.setAttribute("name", ((MetadataValue)object2).getMetadataElement().getFullName());
            element6.setAttribute("mode", ((MetadataValue)object2).isAccumulatingMetadata() ? "accumulate" : "override");
            element6.appendChild(loaded_file_document.createTextNode((String)object));
            if (((MetadataValue)object2).isAccumulatingMetadata()) {
                element4.appendChild(element6);
                continue;
            }
            element4.insertBefore(element6, element4.getFirstChild());
        }
        loaded_file_changed = true;
    }

    public ArrayList getMetadataAssignedToFile(File file, boolean bl) {
        Object object;
        if (loaded_file != this) {
            MetadataXMLFile.saveLoadedFile();
            object = XMLTools.parseXMLFile(this);
            if (object == null) {
                System.err.println("Error: Could not parse metadata.xml file " + this.getAbsolutePath());
                return new ArrayList();
            }
            loaded_file = this;
            loaded_file_document = object;
        }
        object = FilenameEncoding.fileToURLEncoding(file);
        File file2 = this.getParentFile();
        String string = FilenameEncoding.fileToURLEncoding(file2);
        if (((String)(object = ((String)object).substring(string.length()))).startsWith(FilenameEncoding.URL_FILE_SEPARATOR)) {
            object = ((String)object).substring(FilenameEncoding.URL_FILE_SEPARATOR.length());
        }
        object = ((String)object).replace("&", "%26");
        ArrayList<MetadataValue> arrayList = new ArrayList<MetadataValue>();
        NodeList nodeList = loaded_file_document.getElementsByTagName(FILESET_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object2;
            Element element = (Element)nodeList.item(i);
            boolean bl2 = false;
            boolean bl3 = true;
            File file3 = null;
            NodeList nodeList2 = element.getElementsByTagName(FILENAME_ELEMENT);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                object2 = XMLTools.getElementTextValue(element2);
                bl3 = true;
                if (((String)object2).indexOf("*") != -1 && !((String)object2).equals(DIRECTORY_FILENAME)) {
                    bl3 = false;
                }
                if (((String)object).matches((String)object2)) {
                    bl2 = true;
                    if (((String)object).equals("") || !((String)object2).equals(DIRECTORY_FILENAME)) break;
                    file3 = file2;
                    break;
                }
                if (!((String)object).startsWith((String)object2 + FilenameEncoding.URL_FILE_SEPARATOR)) continue;
                bl2 = true;
                file3 = new File(file2, (String)object2);
                break;
            }
            if (!bl2) continue;
            NodeList nodeList3 = element.getElementsByTagName(METADATA_ELEMENT);
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Object object3;
                String string2;
                object2 = (Element)nodeList3.item(j);
                Object object4 = object2.getAttribute("name");
                if (bl && !((String)object4).equals(FILENAME_ENCODING_METADATA) || (string2 = MetadataTools.getMetadataSetNamespace((String)object4)).equals("hidden")) continue;
                MetadataSet metadataSet = MetadataSetManager.getMetadataSet(string2);
                if (metadataSet == null) {
                    object3 = MetadataSetManager.mapUnloadedMetadataElement((String)object4);
                    if (object3 == null || ((String)object3).equals("")) continue;
                    object4 = object3;
                    string2 = MetadataTools.getMetadataSetNamespace((String)object4);
                    metadataSet = MetadataSetManager.getMetadataSet(string2);
                }
                object3 = MetadataTools.getMetadataElementWithName((String)object4);
                String string3 = MetadataTools.getMetadataElementName((String)object4);
                if (object3 == null) {
                    object3 = metadataSet.addMetadataElementForThisSession(string3);
                }
                String string4 = XMLTools.getElementTextValue((Element)object2);
                string4 = string4.replaceAll("&#091;", "[");
                MetadataValueTreeNode metadataValueTreeNode = ((MetadataElement)object3).getMetadataValueTreeNode(string4 = string4.replaceAll("&#093;", "]"));
                if (metadataValueTreeNode == null) {
                    DebugStream.println("Note: No value tree node for metadata value \"" + string4 + "\"");
                    ((MetadataElement)object3).addMetadataValue(string4);
                    metadataValueTreeNode = ((MetadataElement)object3).getMetadataValueTreeNode(string4);
                }
                MetadataValue metadataValue = new MetadataValue((MetadataElement)object3, metadataValueTreeNode);
                metadataValue.inheritsMetadataFromFolder(file3);
                metadataValue.setIsOneFileOnlyMetadata(bl3);
                if (object2.getAttribute("mode").equals("accumulate")) {
                    metadataValue.setIsAccumulatingMetadata(true);
                }
                arrayList.add(metadataValue);
            }
        }
        return arrayList;
    }

    public void removeMetadata(CollectionTreeNode collectionTreeNode, ArrayList arrayList) {
        Object object;
        Object object2;
        Object object3;
        int n;
        String string;
        Object object4;
        if (loaded_file != this) {
            MetadataXMLFile.saveLoadedFile();
            object4 = XMLTools.parseXMLFile(this);
            if (object4 == null) {
                System.err.println("Error: Could not parse metadata.xml file " + this.getAbsolutePath());
                return;
            }
            loaded_file = this;
            loaded_file_document = object4;
        }
        object4 = FilenameEncoding.fileToURLEncoding(this.getParentFile());
        String string2 = collectionTreeNode.getURLEncodedFilePath();
        if ((string2 = string2.substring(((String)object4).length())).startsWith(FilenameEncoding.URL_FILE_SEPARATOR)) {
            string2 = string2.substring(FilenameEncoding.URL_FILE_SEPARATOR.length());
        }
        if (string2.equals("")) {
            string = DIRECTORY_FILENAME;
        } else {
            string2 = string2.replace("&", "%26");
            string = MetadataTools.getRegularExpressionThatMatchesFilePath(string2);
        }
        Object object5 = null;
        NodeList nodeList = loaded_file_document.getElementsByTagName(FILESET_ELEMENT);
        block0: for (n = 0; n < nodeList.getLength(); ++n) {
            object3 = (Element)nodeList.item(n);
            object2 = object3.getElementsByTagName(FILENAME_ELEMENT);
            for (int i = 0; i < object2.getLength(); ++i) {
                object = (Element)object2.item(i);
                String string3 = XMLTools.getElementTextValue((Element)object);
                if (!string3.equals(string)) continue;
                object5 = object3;
                continue block0;
            }
        }
        if (object5 == null) {
            DebugStream.println("Note: No appropriate FileSet element found when removing metadata from " + this);
            return;
        }
        block2: for (n = 0; n < arrayList.size(); ++n) {
            object3 = (MetadataValue)arrayList.get(n);
            object2 = XMLTools.removeInvalidCharacters(((MetadataValue)object3).getFullValue());
            object2 = ((String)object2).replaceAll("\\[", "&#091;");
            object2 = ((String)object2).replaceAll("\\]", "&#093;");
            String string4 = ((MetadataValue)object3).getMetadataElement().getFullName();
            object = object5.getElementsByTagName(METADATA_ELEMENT);
            for (int i = 0; i < object.getLength(); ++i) {
                String string5;
                Element element = (Element)object.item(i);
                String string6 = element.getAttribute("name");
                if (!string6.equals(string4) || !(string5 = XMLTools.getElementTextValue(element)).equals(object2)) continue;
                element.getParentNode().removeChild(element);
                if (string6.equals(FILENAME_ENCODING_METADATA)) {
                    object2 = this.processFilenameEncoding(string, collectionTreeNode, "", true);
                }
                if (object.getLength() != 0) continue block2;
                object5.getParentNode().removeChild((Node)object5);
                continue block2;
            }
        }
        loaded_file_changed = true;
    }

    public void replaceMetadata(CollectionTreeNode collectionTreeNode, MetadataValue metadataValue, MetadataValue metadataValue2) {
        String string;
        Object object;
        if (loaded_file != this) {
            MetadataXMLFile.saveLoadedFile();
            object = XMLTools.parseXMLFile(this);
            if (object == null) {
                System.err.println("Error: Could not parse metadata.xml file " + this.getAbsolutePath());
                return;
            }
            loaded_file = this;
            loaded_file_document = object;
        }
        object = FilenameEncoding.fileToURLEncoding(this.getParentFile());
        String string2 = collectionTreeNode.getURLEncodedFilePath();
        if ((string2 = string2.substring(((String)object).length())).startsWith(FilenameEncoding.URL_FILE_SEPARATOR)) {
            string2 = string2.substring(FilenameEncoding.URL_FILE_SEPARATOR.length());
        }
        if (string2.equals("")) {
            string = DIRECTORY_FILENAME;
        } else {
            string2 = string2.replace("&", "%26");
            string = MetadataTools.getRegularExpressionThatMatchesFilePath(string2);
        }
        String string3 = XMLTools.removeInvalidCharacters(metadataValue.getFullValue());
        String string4 = XMLTools.removeInvalidCharacters(metadataValue2.getFullValue());
        string3 = string3.replaceAll("\\[", "&#091;");
        string3 = string3.replaceAll("\\]", "&#093;");
        string4 = string4.replaceAll("\\[", "&#091;");
        string4 = string4.replaceAll("\\]", "&#093;");
        NodeList nodeList = loaded_file_document.getElementsByTagName(FILESET_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string5;
            Element element;
            int n;
            Element element2 = (Element)nodeList.item(i);
            boolean bl = false;
            NodeList nodeList2 = element2.getElementsByTagName(FILENAME_ELEMENT);
            for (n = 0; n < nodeList2.getLength(); ++n) {
                element = (Element)nodeList2.item(n);
                string5 = XMLTools.getElementTextValue(element);
                if (!string5.equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n = 0;
            element = null;
            string5 = metadataValue.getMetadataElement().getFullName();
            NodeList nodeList3 = element2.getElementsByTagName(METADATA_ELEMENT);
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                Element element3 = (Element)nodeList3.item(j);
                String string6 = element3.getAttribute("name");
                if (!string6.equals(string5)) continue;
                String string7 = XMLTools.getElementTextValue(element3);
                if (string7.equals(string4)) {
                    n = 1;
                }
                if (!string7.equals(string3)) continue;
                element = element3;
            }
            if (n != 0) {
                if (element != null) {
                    element.getParentNode().removeChild(element);
                    continue;
                }
                System.err.println("ERROR MetadataXMLFile: metadata_element_to_edit is null");
                continue;
            }
            if (element == null) continue;
            if (string5.equals(FILENAME_ENCODING_METADATA)) {
                string4 = this.processFilenameEncoding(string, collectionTreeNode, string4, false);
            }
            XMLTools.setElementTextValue(element, string4);
        }
        loaded_file_changed = true;
    }

    public static void saveLoadedFile() {
        if (loaded_file != null && loaded_file_changed) {
            XMLTools.writeXMLFile(loaded_file, loaded_file_document, nonEscapingElements);
            loaded_file_changed = false;
        }
    }

    public void skimFile() {
        boolean bl = false;
        DebugStream.println("Skimming metadata.xml file " + this + "...");
        Document document = XMLTools.parseXMLFile(this);
        if (document == null) {
            System.err.println("Error: Could not parse metadata.xml file " + this.getAbsolutePath());
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = document.getElementsByTagName(METADATA_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            String string;
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute("name");
            String string3 = MetadataTools.getMetadataSetNamespace(string2);
            if (string3.equals("hidden")) continue;
            MetadataSet metadataSet = MetadataSetManager.getMetadataSet(string3);
            if (metadataSet == null) {
                string = MetadataSetManager.mapUnloadedMetadataElement(string2);
                if (string == null || string.equals("")) continue;
                object = (Attr)hashMap.get(string);
                if (object == null) {
                    object = document.createAttribute("name");
                    object.setValue(string);
                    hashMap.put(string, object);
                }
                element.removeAttribute("name");
                element.setAttributeNode((Attr)object.cloneNode(false));
                bl = true;
                string2 = string;
                string3 = MetadataTools.getMetadataSetNamespace(string2);
                metadataSet = MetadataSetManager.getMetadataSet(string3);
            }
            if ((object = metadataSet.getMetadataElementWithName(string = MetadataTools.getMetadataElementName(string2))) == null) {
                object = metadataSet.addMetadataElementForThisSession(string);
            }
            String string4 = XMLTools.getElementTextValue(element);
            string4 = string4.replaceAll("&#091;", "[");
            string4 = string4.replaceAll("&#093;", "]");
            ((MetadataElement)object).addMetadataValue(string4);
        }
        if (bl) {
            XMLTools.writeXMLFile(this, document);
        }
    }

    public String processFilenameEncoding(String string, CollectionTreeNode collectionTreeNode, String string2, boolean bl) {
        if (!FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            return string2;
        }
        if (bl) {
            string2 = FilenameEncoding.getInheritedFilenameEncoding(collectionTreeNode.getURLEncodedFilePath(), collectionTreeNode.getFile());
        } else if (!string2.equals("")) {
            string2 = FilenameEncoding.canonicalEncodingName(string2);
        }
        collectionTreeNode.reencodeDisplayName(string2);
        String string3 = collectionTreeNode.getURLEncodedFilePath();
        if (bl) {
            FilenameEncoding.map.remove(string3);
        } else {
            FilenameEncoding.map.put(string3, string2);
        }
        FilenameEncoding.setRefreshRequired(true);
        return string2;
    }
}

