/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GComboBox;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataTools;

public class MetadataImportMappingPrompt
implements ActionListener {
    public static final int ADD_BUTTON_PRESSED = 0;
    public static final int MERGE_BUTTON_PRESSED = 1;
    public static final int IGNORE_BUTTON_PRESSED = 2;
    private static final Dimension DIALOG_SIZE = new Dimension(640, 180);
    private int result;
    private String metadata_element_name_full = null;
    private GComboBox metadata_sets_combobox = null;
    private GComboBox metadata_elements_combobox = null;
    private JButton add_button = null;
    private JButton merge_button = null;
    private JButton ignore_button = null;
    private JDialog on_screen = null;

    public MetadataImportMappingPrompt(String string) {
        this.metadata_element_name_full = string;
        ModalDialog modalDialog = new ModalDialog(Gatherer.g_man);
        modalDialog.setComponentOrientation(Dictionary.getOrientation());
        ((Dialog)modalDialog).setModal(true);
        modalDialog.setSize(DIALOG_SIZE);
        modalDialog.setJMenuBar(new SimpleMenuBar("importingpreviouslyassignedmetadata"));
        modalDialog.setTitle(Dictionary.get("MIMP.Title"));
        ArrayList arrayList = MetadataSetManager.getMetadataSets();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!((MetadataSet)arrayList.get(i)).getNamespace().equals("ex")) continue;
            arrayList.remove(i);
        }
        this.add_button = new GLIButton(Dictionary.get("MIMP.Add"), Dictionary.get("MIMP.Add_Tooltip"));
        this.add_button.addActionListener(this);
        this.merge_button = new GLIButton(Dictionary.get("MIMP.Merge"), Dictionary.get("MIMP.Merge_Tooltip"));
        this.merge_button.addActionListener(this);
        this.merge_button.setEnabled(true);
        this.ignore_button = new GLIButton(Dictionary.get("MIMP.Ignore"), Dictionary.get("MIMP.Ignore_Tooltip"));
        this.ignore_button.addActionListener(this);
        this.ignore_button.setEnabled(true);
        this.metadata_elements_combobox = new GComboBox();
        this.metadata_sets_combobox = new GComboBox(arrayList);
        this.metadata_sets_combobox.addActionListener(new MetadataSetListSelectionListener());
        this.metadata_sets_combobox.setSelectedIndex(0);
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setLayout(new GridLayout(3, 1));
        JLabel jLabel = new JLabel(Dictionary.get("MIMP.Source_Element"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add(jLabel);
        jLabel = new JLabel(Dictionary.get("MIMP.Target_Set"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add(jLabel);
        jLabel = new JLabel(Dictionary.get("MIMP.Target_Element"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new GridLayout(3, 1));
        jLabel = new JLabel(string);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add(jLabel);
        jPanel2.add(this.metadata_sets_combobox);
        jPanel2.add(this.metadata_elements_combobox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel3.setLayout(new GridLayout(1, 3));
        jPanel3.add(this.add_button);
        jPanel3.add(this.merge_button);
        jPanel3.add(this.ignore_button);
        JPanel jPanel4 = (JPanel)modalDialog.getContentPane();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel4.add((Component)jPanel, "Before");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        TestingPreparation.setNamesRecursively(modalDialog, "MetadataImportMappingPrompt");
        Dimension dimension = Configuration.screen_size;
        modalDialog.setLocation((dimension.width - MetadataImportMappingPrompt.DIALOG_SIZE.width) / 2, (dimension.height - MetadataImportMappingPrompt.DIALOG_SIZE.height) / 2);
        this.on_screen = modalDialog;
        this.on_screen.setVisible(true);
        this.on_screen.dispose();
        this.on_screen = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.add_button) {
            this.result = 0;
        }
        if (object == this.merge_button) {
            this.result = 1;
        }
        if (object == this.ignore_button) {
            this.result = 2;
        }
        this.on_screen.setVisible(false);
    }

    public MetadataElement getSelectedMetadataElement() {
        return (MetadataElement)this.metadata_elements_combobox.getSelectedItem();
    }

    public MetadataSet getSelectedMetadataSet() {
        return (MetadataSet)this.metadata_sets_combobox.getSelectedItem();
    }

    public int getResult() {
        return this.result;
    }

    private class MetadataSetListSelectionListener
    implements ActionListener {
        private MetadataSetListSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            String string = MetadataTools.getMetadataElementName(MetadataImportMappingPrompt.this.metadata_element_name_full);
            MetadataSet metadataSet = (MetadataSet)MetadataImportMappingPrompt.this.metadata_sets_combobox.getSelectedItem();
            ArrayList arrayList = metadataSet.getMetadataSetElements();
            MetadataImportMappingPrompt.this.metadata_elements_combobox.removeAllItems();
            for (int i = 0; i < arrayList.size(); ++i) {
                MetadataElement metadataElement = (MetadataElement)arrayList.get(i);
                MetadataImportMappingPrompt.this.metadata_elements_combobox.addItem(metadataElement);
                if (!metadataElement.getName().equals(string)) continue;
                MetadataImportMappingPrompt.this.metadata_elements_combobox.setSelectedIndex(i);
                bl = false;
            }
            MetadataImportMappingPrompt.this.add_button.setEnabled(bl);
            if (arrayList.size() == 0) {
                MetadataImportMappingPrompt.this.merge_button.setEnabled(false);
            }
        }
    }
}

