/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.greenstone.gatherer.Dictionary;

public class EmailField
extends JTextField
implements DocumentListener {
    public static final Pattern EMAIL_PATTERN = Pattern.compile("([^()\\-<> @,;:\"][^()<> @,;:\"]*|\"[^()<>@,;:\"]+\")@([A-Za-z](-*[A-Za-z0-9])*(\\.[A-Za-z](-*[A-Za-z0-9])*)*)");
    private boolean invalid = false;
    private Color background;
    private Color invalid_background;

    public EmailField(Color color) {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.invalid_background = color;
    }

    public EmailField(String string, Color color) {
        super(string);
        this.invalid_background = color;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateEmail();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateEmail();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateEmail();
    }

    private void validateEmail() {
        Matcher matcher = EMAIL_PATTERN.matcher(this.getText());
        if (matcher.matches()) {
            if (this.invalid) {
                this.setBackground(this.background);
                this.invalid = false;
            }
        } else {
            this.background = this.getBackground();
            this.setBackground(this.invalid_background);
            this.invalid = true;
        }
        matcher = null;
    }
}

