/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.greenstone3;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.ArrayTools;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletConfiguration {
    public static String ADD_COMMAND = "?a=s&sa=a&st=collection&sn=";
    public static String DEACTIVATE_COMMAND = "?a=s&sa=d&st=collection&sn=";
    private String gsdl3_web_path = "";
    private String gsdl3_writableweb_path = "";
    private ArrayList sites = null;
    private HashMap site_to_servlet_list_map = null;
    private HashMap servlet_to_site_map = null;

    public ServletConfiguration(String string, String string2) {
        String string3;
        Object object;
        int n;
        Object object2;
        Object object3;
        File file;
        this.gsdl3_web_path = string;
        this.gsdl3_writableweb_path = string2;
        if (Gatherer.isGsdlRemote && Gatherer.remoteGreenstoneServer.downloadWebXMLFile().equals("")) {
            System.err.println("ServletConfiguration Error: Could not download web.xml.");
            System.exit(0);
        }
        if (!(file = Gatherer.isGsdlRemote ? new File(string2 + "web.xml") : new File(string2 + "WEB-INF" + File.separator + "web.xml")).exists()) {
            DebugStream.println("Error: no web.xml found at " + file.toString());
            return;
        }
        this.sites = new ArrayList();
        if (Gatherer.isGsdlRemote) {
            object3 = Gatherer.remoteGreenstoneServer.getSiteNames();
            if (((String)object3).equals("")) {
                System.err.println("ServletConfiguration Error: Could not get names of the sites.");
                System.exit(0);
            }
            object2 = ((String)object3).split("-----");
            for (n = 0; n < ((Object[])object2).length; ++n) {
                if (((String)object2[n]).trim().equals("")) continue;
                this.sites.add(((String)object2[n]).trim());
            }
        } else {
            object3 = new File(Utility.getSitesDir(string));
            object2 = ((File)object3).listFiles();
            ArrayTools.sort((File[])object2);
            for (n = 0; object2 != null && n < ((Object[])object2).length; ++n) {
                File file2;
                if (((File)object2[n]).getName().equals("modelsite") || !(file2 = new File((File)object2[n], "siteConfig.xml")).exists()) continue;
                this.sites.add(((File)object2[n]).getName());
            }
        }
        this.site_to_servlet_list_map = new HashMap();
        this.servlet_to_site_map = new HashMap();
        System.err.println("parsing xml file " + file.getAbsolutePath());
        object3 = XMLTools.parseXMLFile(file.getAbsolutePath(), false);
        object2 = object3.getElementsByTagName("servlet-mapping");
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < object2.getLength(); ++i) {
            Element element = (Element)object2.item(i);
            object = XMLTools.getValue(XMLTools.getNodeFromNamed(element, "servlet-name"));
            string3 = XMLTools.getValue(XMLTools.getNodeFromNamed(element, "url-pattern"));
            hashMap.put(object, string3);
        }
        NodeList nodeList = object3.getElementsByTagName("servlet");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string4;
            object = (Element)nodeList.item(i);
            string3 = XMLTools.getValue(XMLTools.getNodeFromNamed((Node)object, "servlet-class"));
            if (!string3.equals("org.greenstone.gsdl3.LibraryServlet")) continue;
            String string5 = XMLTools.getValue(XMLTools.getNodeFromNamed((Node)object, "servlet-name"));
            String string6 = XMLTools.getValue(XMLTools.getNodeFromNamed((Node)object, "description"));
            String string7 = this.getServletSite((Element)object);
            if (string7 == null) continue;
            ArrayList<String> arrayList = (ArrayList<String>)this.site_to_servlet_list_map.get(string7);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            if ((string4 = (String)hashMap.get(string5)) == null) continue;
            if (string4.endsWith("/*")) {
                string4 = string4.substring(0, string4.length() - 2);
            }
            arrayList.add(string4);
            this.site_to_servlet_list_map.put(string7, arrayList);
            this.servlet_to_site_map.put(string4, string7);
        }
        object3 = null;
        hashMap = null;
    }

    public ArrayList getSites() {
        return this.sites;
    }

    public ArrayList getServletsForSite(String string) {
        return (ArrayList)this.site_to_servlet_list_map.get(string);
    }

    public String getServletPath(String string) {
        ArrayList arrayList = (ArrayList)this.site_to_servlet_list_map.get(string);
        if (arrayList == null) {
            return null;
        }
        return (String)arrayList.get(0);
    }

    public String getSiteForServlet(String string) {
        return (String)this.servlet_to_site_map.get(string);
    }

    private String getServletSite(Element element) {
        NodeList nodeList = element.getElementsByTagName("init-param");
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        String string = null;
        for (int i = 0; i < nodeList.getLength() && string == null; ++i) {
            String string2 = XMLTools.getValue(XMLTools.getNodeFromNamed(nodeList.item(i), "param-name"));
            if (!string2.equals("site_name")) continue;
            string = XMLTools.getValue(XMLTools.getNodeFromNamed(nodeList.item(i), "param-value"));
        }
        return string;
    }
}

