/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.greenstone;

import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentContainer;
import org.greenstone.gatherer.cdm.Plugin;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Plugins {
    private static ArrayList core_greenstone_plugins_list = null;
    private static String collection_name = null;
    private static ArrayList collection_specific_plugins_list = new ArrayList();

    public static Plugin getPlugin(String string, boolean bl) {
        Plugin plugin;
        int n;
        Plugin plugin2 = null;
        boolean bl2 = false;
        for (n = 0; n < collection_specific_plugins_list.size(); ++n) {
            plugin = (Plugin)collection_specific_plugins_list.get(n);
            if (!plugin.getName().equals(string)) continue;
            plugin2 = plugin;
            bl2 = true;
            break;
        }
        if (plugin2 == null) {
            for (n = 0; n < core_greenstone_plugins_list.size(); ++n) {
                plugin = (Plugin)core_greenstone_plugins_list.get(n);
                if (!plugin.getName().equals(string)) continue;
                plugin2 = plugin;
                break;
            }
        }
        if (plugin2 != null && bl) {
            if (!plugin2.hasLoadedOptions()) {
                Plugins.loadPluginInfo(plugin2, bl2);
            } else {
                DebugStream.println("Already loaded arguments for " + string + "!");
            }
        }
        return plugin2;
    }

    public static ArrayList getPluginsList() {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        arrayList.addAll(collection_specific_plugins_list);
        for (int i = 0; i < core_greenstone_plugins_list.size(); ++i) {
            Plugin plugin = (Plugin)core_greenstone_plugins_list.get(i);
            boolean bl = false;
            for (int j = 0; j < collection_specific_plugins_list.size(); ++j) {
                Plugin plugin2 = (Plugin)collection_specific_plugins_list.get(j);
                if (!plugin.getName().equals(plugin2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(plugin);
        }
        return arrayList;
    }

    private static void loadPluginInfo(Plugin plugin, boolean bl) {
        DebugStream.println("Loading arguments for " + plugin.getName() + "...");
        try {
            String string = null;
            if (Gatherer.isGsdlRemote) {
                String string2 = "&plugin=" + plugin;
                if (bl) {
                    string2 = string2 + "&collection=" + collection_name;
                }
                string = Gatherer.remoteGreenstoneServer.getScriptOptions("pluginfo.pl", string2);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(Configuration.perl_path);
                arrayList.add("-S");
                arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "pluginfo.pl");
                arrayList.add("-gs_version");
                if (Gatherer.GS3) {
                    arrayList.add("3");
                } else {
                    arrayList.add("2");
                }
                if (bl) {
                    arrayList.add("-collection");
                    arrayList.add(collection_name);
                    if (Gatherer.GS3) {
                        arrayList.add("-site");
                        arrayList.add(Configuration.site_name);
                    }
                }
                arrayList.add("-xml");
                arrayList.add("-language");
                arrayList.add(Configuration.getLanguage());
                arrayList.add(plugin.getName());
                SafeProcess safeProcess = new SafeProcess(arrayList.toArray(new String[0]));
                safeProcess.setSplitStdErrorNewLines(true);
                int n = safeProcess.runProcess();
                if (n != 0) {
                    throw new Exception("*** Error running pluginfo.pl loadPlugInfo, process exited with: " + n);
                }
                string = safeProcess.getStdError();
                string = XMLTools.readXMLStream(string).toString();
            }
            if (string == null || string.length() == 0) {
                plugin.setHasLoadedOptions(false);
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.PlugInManager.PlugIn_XML_Parse_Failed", plugin.getName()), Dictionary.get("General.Error"), 0);
                return;
            }
            plugin.setHasLoadedOptions(true);
            Plugins.parsePluginInfoXML(plugin, string);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public static void loadPluginsList(String string) {
        DebugStream.println("In loadPluginsList()...");
        if (string != null) {
            collection_name = string;
            collection_specific_plugins_list = new ArrayList();
        }
        try {
            String string2 = null;
            if (Gatherer.isGsdlRemote) {
                String string3;
                String string4 = "&listall";
                if (collection_name != null) {
                    string4 = string4 + "&collection=" + collection_name;
                }
                string2 = string3 = Gatherer.remoteGreenstoneServer.getScriptOptions("pluginfo.pl", string4);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(Configuration.perl_path);
                arrayList.add("-S");
                arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "pluginfo.pl");
                arrayList.add("-gs_version");
                if (Gatherer.GS3) {
                    arrayList.add("3");
                } else {
                    arrayList.add("2");
                }
                if (collection_name != null) {
                    arrayList.add("-collection");
                    arrayList.add(collection_name);
                    if (Gatherer.GS3) {
                        arrayList.add("-site");
                        arrayList.add(Configuration.site_name);
                    }
                }
                arrayList.add("-listall");
                arrayList.add("-xml");
                SafeProcess safeProcess = new SafeProcess(arrayList.toArray(new String[0]));
                safeProcess.setSplitStdErrorNewLines(true);
                int n = safeProcess.runProcess();
                if (n != 0) {
                    throw new Exception("*** Error running pluginfo.pl loadPluginsList, process exited with: " + n);
                }
                string2 = safeProcess.getStdError();
                string2 = XMLTools.readXMLStream(string2).toString();
            }
            if (string2 == null || string2.length() == 0) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.PluginManager.Plugin_List_XML_Parse_Failed"), Dictionary.get("General.Error"), 0);
                return;
            }
            if (collection_name != null) {
                collection_specific_plugins_list = Plugins.parsePluginsListXML(string2);
            } else {
                core_greenstone_plugins_list = Plugins.parsePluginsListXML(string2);
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private static void parsePluginInfoXML(Plugin plugin, String string) {
        Document document = XMLTools.parseXML(new StringReader(string));
        if (document == null) {
            plugin.setHasLoadedOptions(false);
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.PlugInManager.PlugIn_XML_Parse_Failed", plugin.getName()), Dictionary.get("General.Error"), 0);
            return;
        }
        plugin.setHasLoadedOptions(true);
        Plugins.parsePluginInfoXMLNode(plugin, document.getDocumentElement());
    }

    private static void parsePluginInfoXMLNode(Plugin plugin, Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            String string = node2.getNodeName();
            if (string.equalsIgnoreCase("Name")) {
                plugin.setName(XMLTools.getValue(node2));
                continue;
            }
            if (string.equals("Desc")) {
                plugin.setDescription(XMLTools.getValue(node2));
                continue;
            }
            if (string.equals("Abstract")) {
                plugin.setIsAbstract(XMLTools.getValue(node2).equalsIgnoreCase("yes"));
                continue;
            }
            if (string.equalsIgnoreCase("Explodes")) {
                plugin.setDoesExplodeMetadataDatabases(XMLTools.getValue(node2).equalsIgnoreCase("yes"));
                continue;
            }
            if (string.equalsIgnoreCase("SourceReplaceable")) {
                plugin.setDoesReplaceSrcDocsWithHtml(XMLTools.getValue(node2).equalsIgnoreCase("yes"));
                continue;
            }
            if (string.equalsIgnoreCase("Processes")) {
                plugin.setDefaultProcessExpression(XMLTools.getValue(node2));
                continue;
            }
            if (string.equalsIgnoreCase("Blocks")) {
                plugin.setDefaultBlockExpression(XMLTools.getValue(node2));
                continue;
            }
            if (string.equalsIgnoreCase("Arguments")) {
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (!object.getNodeName().equalsIgnoreCase("Option")) continue;
                    Argument argument = new Argument();
                    argument.parseXML((Element)object);
                    plugin.addArgument(argument);
                }
                continue;
            }
            if (!string.equalsIgnoreCase("PlugInfo")) continue;
            object = new Plugin();
            Plugins.parsePluginInfoXMLNode((Plugin)object, node2);
            plugin.setSuper((ArgumentContainer)object);
        }
    }

    private static ArrayList parsePluginsListXML(String string) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        Document document = XMLTools.parseXML(new StringReader(string));
        Element element = document.getDocumentElement();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string2 = node.getNodeName();
            if (!string2.equals("PlugInfo")) continue;
            Plugin plugin = new Plugin();
            Plugins.parsePluginInfoXMLNode(plugin, node);
            arrayList.add(plugin);
        }
        return arrayList;
    }
}

