/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.io.File;
import javax.swing.table.AbstractTableModel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.FileAssociationDialog;
import org.greenstone.gatherer.gui.PreviewCommandDialog;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.StaticStrings;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FileAssociationManager
extends AbstractTableModel {
    public static final String FILENAME_ARG = "%1";
    private static final String ESCAPE = "\\\\";
    private static final String ESCAPED_ESCAPE = "\\\\\\\\";
    private static final String SPACE = " ";
    private static final String ESCAPED_SPACE = "\\\\ ";
    private Element associations_element = Configuration.getFileAssociations();
    private File data_file;

    public FileAssociationManager() {
        if (this.associations_element != null) {
            NodeList nodeList = this.associations_element.getElementsByTagName("Entry");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string = XMLTools.getValue(element);
                if (string.length() == 0) {
                    if (Utility.isWindows()) {
                        if (Utility.isWindows9x()) {
                            XMLTools.setValue(element, "command.com /c start \"%1\"");
                        } else {
                            XMLTools.setValue(element, "cmd.exe /c start \"\" \"%1\"");
                        }
                    } else if (Utility.isMac()) {
                        XMLTools.setValue(element, "open %1");
                    } else if (StaticStrings.LINUX_OPEN_COMMAND != null && !StaticStrings.LINUX_OPEN_COMMAND.equals("")) {
                        XMLTools.setValue(element, StaticStrings.LINUX_OPEN_COMMAND);
                    } else if (StaticStrings.LINUX_OPEN_COMMAND == null) {
                        String[] stringArray;
                        for (String string2 : stringArray = new String[]{"xdg-open", "kde-open", "gnome-open"}) {
                            Gatherer.ProgramInstalledTest programInstalledTest = new Gatherer.ProgramInstalledTest(string2);
                            if (programInstalledTest.found()) {
                                System.err.println("*********** Linux file open command " + programInstalledTest + " was found to be installed.");
                                StaticStrings.LINUX_OPEN_COMMAND = string2 + " %1";
                                XMLTools.setValue(element, StaticStrings.LINUX_OPEN_COMMAND);
                                break;
                            }
                            System.err.println("*********** Linux file open command " + programInstalledTest + " was not installed.");
                        }
                        if (StaticStrings.LINUX_OPEN_COMMAND == null) {
                            StaticStrings.LINUX_OPEN_COMMAND = "";
                        }
                    }
                }
                string = null;
                element = null;
            }
            nodeList = null;
        } else {
            DebugStream.println("Didn't parse anything. About to crash.");
        }
    }

    public void edit() {
        FileAssociationDialog fileAssociationDialog = new FileAssociationDialog(this);
        TestingPreparation.setNamesRecursively(fileAssociationDialog);
        fileAssociationDialog.display(null);
        fileAssociationDialog = null;
    }

    public String getBrowserCommand(String string) {
        String[] stringArray;
        DebugStream.println("Get browser command: " + string);
        String string2 = Configuration.getPreviewCommand();
        if (string2 != null && string2.length() > 0) {
            string2 = string2.replaceAll(FILENAME_ARG, string);
            DebugStream.println("Result = " + string2);
            return string2;
        }
        string2 = null;
        if (Utility.isWindows()) {
            string2 = Utility.isWindows9x() ? "command.com /c start \"%1\"" : "cmd.exe /c start \"\" \"%1\"";
        } else if (Utility.isMac()) {
            string2 = "open %1";
        } else {
            stringArray = new String[]{"mozilla", "netscape", "firefox"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!SafeProcess.isAvailable(stringArray[i])) continue;
                string2 = stringArray[i] + " %1";
                break;
            }
        }
        if (string2 == null) {
            stringArray = new PreviewCommandDialog();
            string2 = stringArray.display();
            stringArray.dispose();
            stringArray = null;
        }
        if (string2 != null && !string2.equals("")) {
            Configuration.setPreviewCommand(string2);
            string2 = string2.replaceAll(FILENAME_ARG, string);
            DebugStream.println("Result = " + string2);
            return string2;
        }
        DebugStream.println("Result = null");
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        String string;
        switch (n) {
            case 0: {
                string = Dictionary.get("FileAssociationDialog.Table.Extension");
                break;
            }
            default: {
                string = Dictionary.get("FileAssociationDialog.Table.Command");
            }
        }
        return string;
    }

    public String[] getCommand(File file) {
        String string = null;
        String[] stringArray = null;
        if (file.isFile()) {
            String[] stringArray2;
            String string2 = file.getAbsolutePath();
            String string3 = string2.substring(string2.lastIndexOf(".") + 1);
            Element element = this.getCommand(string3);
            if (element != null) {
                string = XMLTools.getValue(element);
            }
            if (string == null || string.length() == 0) {
                if (Utility.isWindows()) {
                    string = Utility.isWindows9x() ? "command.com /c start \"%1\"" : "cmd.exe /c start \"\" \"%1\"";
                } else if (Utility.isMac()) {
                    string = "open %1";
                }
                if (string == null || string.length() == 0) {
                    stringArray2 = new FileAssociationDialog(this);
                    string = stringArray2.display(string3);
                    stringArray2 = null;
                }
                if (string != null && !string.equals("")) {
                    if (element == null) {
                        element = this.associations_element.getOwnerDocument().createElement("Entry");
                        element.setAttribute("extension", string3);
                        this.associations_element.appendChild(element);
                    }
                    XMLTools.setValue(element, string);
                }
            }
            if (string != null && !string.equals("")) {
                stringArray = string.split(SPACE);
                string2 = string2.replaceAll(ESCAPE, ESCAPED_ESCAPE);
                if (Utility.isWindows() && string2.indexOf(SPACE) != -1 && string.indexOf("start") != -1) {
                    int n;
                    stringArray2 = stringArray;
                    int n2 = 0;
                    for (n = 0; n < stringArray.length; ++n) {
                        if (stringArray[n].indexOf("start") == -1) continue;
                        n2 = n;
                    }
                    stringArray = new String[n2 + 1];
                    for (n = 0; n < n2; ++n) {
                        stringArray[n] = stringArray2[n];
                    }
                    stringArray[n2] = stringArray2[n2];
                    for (n = n2 + 1; n < stringArray2.length; ++n) {
                        stringArray[n2] = stringArray[n2] + SPACE + stringArray2[n];
                    }
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].replaceAll(FILENAME_ARG, string2);
                }
            }
            element = null;
            string3 = null;
            string2 = null;
        }
        return stringArray;
    }

    public Element getCommand(String string) {
        NodeList nodeList = this.associations_element.getElementsByTagName("Entry");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute("extension");
            if (!string2.equalsIgnoreCase(string)) continue;
            nodeList = null;
            string2 = null;
            return element;
        }
        nodeList = null;
        return null;
    }

    public String getCommandString(String string) {
        Element element = this.getCommand(string);
        if (element != null) {
            return XMLTools.getValue(element);
        }
        return "";
    }

    public String getExtension(int n) {
        NodeList nodeList = this.associations_element.getElementsByTagName("Entry");
        if (0 <= n && n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            return element.getAttribute("extension");
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.getExtension(n);
        switch (n2) {
            case 0: {
                return string;
            }
        }
        return this.getCommandString(string);
    }

    public void save() {
    }

    public void setCommand(String string, String string2) {
        DebugStream.println("Set Launch: " + string + " with " + string2);
        Element element = this.getCommand(string);
        if (element == null && string2 != null) {
            element = this.associations_element.getOwnerDocument().createElement("Entry");
            element.setAttribute("extension", string);
            this.associations_element.appendChild(element);
        }
        if (string2 != null) {
            XMLTools.setValue(element, string2);
        } else {
            this.associations_element.removeChild(element);
        }
        element = null;
        this.fireTableDataChanged();
    }

    public int size() {
        NodeList nodeList = this.associations_element.getElementsByTagName("Entry");
        return nodeList.getLength();
    }
}

