/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.greenstone.gatherer.feedback.ActionRecorderDialog;
import org.greenstone.gatherer.feedback.Base64;

public class ScreenShot {
    private BufferedImage img;
    private static final Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private Rectangle mRect = new Rectangle(dim);
    private int iw;
    private int ih;
    private BufferedImage bi;
    private Robot mRobot;

    public ScreenShot() {
        try {
            this.mRobot = new Robot();
            this.iw = (int)(dim.getWidth() - 60.0);
            this.ih = (int)(dim.getHeight() * 0.75) - 50;
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public BufferedImage getImageIcon(Rectangle rectangle) {
        int n;
        BufferedImage bufferedImage = null;
        this.img = this.mRobot.createScreenCapture(rectangle);
        boolean bl = false;
        int n2 = rectangle.width;
        if (n2 >= this.iw) {
            n2 = this.iw - 50;
            bl = true;
        }
        if ((n = rectangle.height) >= this.ih) {
            n = this.ih - 50;
            bl = true;
        }
        Graphics graphics = null;
        if (bl) {
            bufferedImage = new BufferedImage(n2, n, 1);
            graphics = bufferedImage.createGraphics();
            graphics.drawImage(this.img.getScaledInstance(n2, n, 4), 0, 0, null);
        } else {
            bufferedImage = this.img;
        }
        if (graphics != null) {
            graphics.dispose();
        }
        ActionRecorderDialog.setSavefinish(true);
        return bufferedImage;
    }

    public String getImage(Rectangle rectangle) {
        String string = null;
        BufferedImage bufferedImage = null;
        try {
            int n;
            this.img = this.mRobot.createScreenCapture(rectangle);
            boolean bl = false;
            int n2 = rectangle.width;
            if (n2 >= this.iw) {
                n2 = this.iw - 50;
                bl = true;
            }
            if ((n = rectangle.height) >= this.ih) {
                n = this.ih - 50;
                bl = true;
            }
            Graphics2D graphics2D = null;
            if (bl) {
                bufferedImage = new BufferedImage(n2, n, 1);
                graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(this.img.getScaledInstance(n2, n, 4), 0, 0, null);
            } else {
                bufferedImage = this.img;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "gif", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            string = Base64.encodeBytes(byArray);
            byArray = null;
            if (graphics2D != null) {
                graphics2D.dispose();
            }
            bufferedImage = null;
            this.img = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ActionRecorderDialog.setSavefinish(true);
        return string;
    }

    public BufferedImage getBuffImage() {
        return this.bi;
    }

    public BufferedImage captureScreen() {
        this.img = this.mRobot.createScreenCapture(this.mRect);
        this.bi = new BufferedImage(this.iw, this.ih, 1);
        Graphics2D graphics2D = this.bi.createGraphics();
        graphics2D.drawImage(this.img.getScaledInstance(this.iw, this.ih, 4), 0, 0, null);
        graphics2D.dispose();
        graphics2D = null;
        return this.bi;
    }

    public int getWidth() {
        return this.iw;
    }

    public int getHeight() {
        return this.ih;
    }
}

