/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SaveToXML {
    private FileOutputStream fos;
    private TransformerHandler hd;
    private AttributesImpl atts;
    private static ResourceBundle messages;

    public SaveToXML(ResourceBundle resourceBundle) {
        messages = resourceBundle;
    }

    public void saveImage(String string, String string2, String string3, String string4) {
        try {
            this.hd.startElement("", "", "Title", this.atts);
            this.hd.characters(string2.toCharArray(), 0, string2.length());
            this.hd.endElement("", "", "Title");
            this.hd.startElement("", "", "Size", this.atts);
            this.hd.startElement("", "", "Width", this.atts);
            this.hd.characters(string3.toCharArray(), 0, string3.length());
            this.hd.endElement("", "", "Width");
            this.hd.startElement("", "", "Height", this.atts);
            this.hd.characters(string4.toCharArray(), 0, string4.length());
            this.hd.endElement("", "", "Height");
            this.hd.endElement("", "", "Size");
            this.hd.startElement("", "", "View", this.atts);
            this.hd.characters(string.toCharArray(), 0, string.length());
            this.hd.endElement("", "", "View");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void open(String string, String string2) {
        try {
            File file = new File(string);
            this.fos = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(this.fos);
            StreamResult streamResult = new StreamResult(printWriter);
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.hd = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = this.hd.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            this.hd.setResult(streamResult);
            this.atts = new AttributesImpl();
            this.hd.startDocument();
            this.hd.startElement("", "", string2, this.atts);
        }
        catch (IOException iOException) {
            System.err.println("Unable to write to file");
            System.exit(-1);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println("Error in: TransformerConfigurationException");
        }
        catch (SAXException sAXException) {
            System.err.println("Error in: (SAXException");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
    }

    public void close(String string) {
        try {
            this.hd.endElement("", "", string);
            this.hd.endDocument();
            this.fos.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to write to file");
            System.exit(-1);
        }
        catch (SAXException sAXException) {
            System.err.println("Error in: (SAXException");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
    }

    public void startContent(int n) {
        try {
            switch (n) {
                case 0: {
                    this.hd.startElement("", "", "COMPONENT", this.atts);
                    break;
                }
                case 1: {
                    this.hd.startElement("", "", "Type", this.atts);
                    break;
                }
                case 2: {
                    this.hd.startElement("", "", "Title", this.atts);
                    break;
                }
                case 3: {
                    this.hd.startElement("", "", "Content", this.atts);
                    break;
                }
                case 4: {
                    this.hd.startElement("", "", "Selected", this.atts);
                    break;
                }
                case 5: {
                    this.hd.startElement("", "", "Visible", this.atts);
                    break;
                }
                case 6: {
                    this.hd.startElement("", "", "Image", this.atts);
                    break;
                }
                case 7: {
                    this.hd.startElement("", "", "Date", this.atts);
                    break;
                }
                case 8: {
                    this.hd.startElement("", "", "Command", this.atts);
                    break;
                }
                case 9: {
                    this.hd.startElement("", "", "COMPONENTS", this.atts);
                    break;
                }
                case 10: {
                    this.hd.startElement("", "", "LOG", this.atts);
                    break;
                }
                case 11: {
                    this.hd.startElement("", "", "Icon", this.atts);
                    break;
                }
                case 12: {
                    this.hd.startElement("", "", "ToolTipText", this.atts);
                    break;
                }
                case 13: {
                    this.hd.startElement("", "", "Comment", this.atts);
                }
            }
        }
        catch (SAXException sAXException) {
            System.err.println("Error in: (SAXException");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
    }

    public void saveContent(String string) {
        try {
            if (string == null) {
                string = "\t";
            }
            this.hd.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            System.err.println("Error in: (SAXException");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
    }

    public void closeContent(int n) {
        try {
            switch (n) {
                case 0: {
                    this.hd.endElement("", "", "COMPONENT");
                    break;
                }
                case 1: {
                    this.hd.endElement("", "", "Type");
                    break;
                }
                case 2: {
                    this.hd.endElement("", "", "Title");
                    break;
                }
                case 3: {
                    this.hd.endElement("", "", "Content");
                    break;
                }
                case 4: {
                    this.hd.endElement("", "", "Selected");
                    break;
                }
                case 5: {
                    this.hd.endElement("", "", "Visible");
                    break;
                }
                case 6: {
                    this.hd.endElement("", "", "Image");
                    break;
                }
                case 7: {
                    this.hd.endElement("", "", "Date");
                    break;
                }
                case 8: {
                    this.hd.endElement("", "", "Command");
                    break;
                }
                case 9: {
                    this.hd.endElement("", "", "COMPONENTS");
                    break;
                }
                case 10: {
                    this.hd.endElement("", "", "LOG");
                    break;
                }
                case 11: {
                    this.hd.endElement("", "", "Icon");
                    break;
                }
                case 12: {
                    this.hd.endElement("", "", "ToolTipText");
                    break;
                }
                case 13: {
                    this.hd.endElement("", "", "Comment");
                }
            }
        }
        catch (SAXException sAXException) {
            System.err.println("Error in: (SAXException");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
    }

    public void saveFeedback(String[] stringArray, String[] stringArray2) {
        try {
            String string = "xmlfeedback/";
            FileOutputStream fileOutputStream = new FileOutputStream(string + "feedback" + stringArray[0] + ".xml");
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            StreamResult streamResult = new StreamResult(printWriter);
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            this.hd = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = this.hd.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            this.hd.setResult(streamResult);
            this.hd.startDocument();
            this.atts = new AttributesImpl();
            this.hd.startElement("", "", "BUGS", this.atts);
            this.hd.startElement("", "", "IDCode", this.atts);
            this.hd.characters(stringArray[0].toCharArray(), 0, stringArray[0].length());
            this.hd.endElement("", "", "IDCode");
            this.hd.startElement("", "", "LastViewedWindow", this.atts);
            this.hd.characters(stringArray[1].toCharArray(), 0, stringArray[1].length());
            this.hd.endElement("", "", "LastViewedWindow");
            this.hd.startElement("", "", "Optionals", this.atts);
            this.hd.startElement("", "", "Type", this.atts);
            this.hd.characters(stringArray[3].toCharArray(), 0, stringArray[3].length());
            this.hd.endElement("", "", "Type");
            this.hd.startElement("", "", "Urgency", this.atts);
            this.hd.characters(stringArray[4].toCharArray(), 0, stringArray[4].length());
            this.hd.endElement("", "", "Urgency");
            this.hd.endElement("", "", "Optionals");
            this.hd.startElement("", "", "User", this.atts);
            this.hd.startElement("", "", "Name", this.atts);
            this.hd.characters(stringArray[5].toCharArray(), 0, stringArray[5].length());
            this.hd.endElement("", "", "Name");
            this.hd.startElement("", "", "HomeDirectory", this.atts);
            this.hd.characters(stringArray[6].toCharArray(), 0, stringArray[6].length());
            this.hd.endElement("", "", "HomeDirectory");
            this.hd.startElement("", "", "WorkingDirectory", this.atts);
            this.hd.characters(stringArray[7].toCharArray(), 0, stringArray[7].length());
            this.hd.endElement("", "", "WorkingDirectory");
            this.hd.startElement("", "", "SMTP", this.atts);
            this.hd.characters(stringArray[19].toCharArray(), 0, stringArray[19].length());
            this.hd.endElement("", "", "SMTP");
            this.hd.startElement("", "", "Email", this.atts);
            this.hd.characters(stringArray[20].toCharArray(), 0, stringArray[20].length());
            this.hd.endElement("", "", "Email");
            this.hd.endElement("", "", "User");
            this.hd.startElement("", "", "OpenFormTime", this.atts);
            this.hd.characters(stringArray[8].toCharArray(), 0, stringArray[8].length());
            this.hd.endElement("", "", "OpenFormTime");
            this.hd.startElement("", "", "SendFormTime", this.atts);
            this.hd.characters(stringArray[9].toCharArray(), 0, stringArray[9].length());
            this.hd.endElement("", "", "SendFormTime");
            this.hd.startElement("", "", "OperatingSystem", this.atts);
            this.hd.characters(stringArray[10].toCharArray(), 0, stringArray[10].length());
            this.hd.endElement("", "", "OperatingSystem");
            this.hd.startElement("", "", "Java", this.atts);
            this.hd.startElement("", "", "JavaInformation", this.atts);
            this.hd.characters(stringArray[11].toCharArray(), 0, stringArray[11].length());
            this.hd.endElement("", "", "JavaInformation");
            this.hd.startElement("", "", "TotalMemory", this.atts);
            this.hd.characters(stringArray[21].toCharArray(), 0, stringArray[21].length());
            this.hd.endElement("", "", "TotalMemory");
            this.hd.startElement("", "", "MaxMemory", this.atts);
            this.hd.characters(stringArray[22].toCharArray(), 0, stringArray[22].length());
            this.hd.endElement("", "", "MaxMemory");
            this.hd.startElement("", "", "FreeMemory", this.atts);
            this.hd.characters(stringArray[23].toCharArray(), 0, stringArray[23].length());
            this.hd.endElement("", "", "FreeMemory");
            this.hd.startElement("", "", "DefaultLocale", this.atts);
            this.hd.characters(stringArray[12].toCharArray(), 0, stringArray[12].length());
            this.hd.endElement("", "", "DefaultLocale");
            this.hd.endElement("", "", "Java");
            this.hd.startElement("", "", "Browser", this.atts);
            this.hd.characters(stringArray[13].toCharArray(), 0, stringArray[13].length());
            this.hd.endElement("", "", "Browser");
            this.hd.startElement("", "", "LocalHostName", this.atts);
            this.hd.characters(stringArray[14].toCharArray(), 0, stringArray[14].length());
            this.hd.endElement("", "", "LocalHostName");
            this.hd.startElement("", "", "LocalHostAddress", this.atts);
            this.hd.characters(stringArray[15].toCharArray(), 0, stringArray[15].length());
            this.hd.endElement("", "", "LocalHostAddress");
            this.hd.startElement("", "", "ScreenResolution", this.atts);
            this.hd.characters(stringArray[16].toCharArray(), 0, stringArray[16].length());
            this.hd.endElement("", "", "ScreenResolution");
            if (stringArray2 != null) {
                this.hd.startElement("", "", "Sequences", this.atts);
                for (int i = 0; i < stringArray2.length; i += 10) {
                    this.hd.startElement("", "", "Sequence", this.atts);
                    this.hd.startElement("", "", "Title", this.atts);
                    this.hd.characters(stringArray2[i].toCharArray(), 0, stringArray2[i].length());
                    this.hd.endElement("", "", "Title");
                    this.hd.startElement("", "", "Details", this.atts);
                    this.hd.characters(stringArray2[i + 9].toCharArray(), 0, stringArray2[i + 9].length());
                    this.hd.endElement("", "", "Details");
                    this.hd.startElement("", "", "ImageDescription", this.atts);
                    this.hd.startElement("", "", "ScreenShot", this.atts);
                    this.hd.startElement("", "", "Image", this.atts);
                    this.saveImage(stringArray2[i + 1], stringArray2[i + 2], stringArray2[i + 7], stringArray2[i + 8]);
                    this.hd.endElement("", "", "Image");
                    this.hd.endElement("", "", "ScreenShot");
                    this.hd.startElement("", "", "ErrorLineAndScreenShot", this.atts);
                    this.hd.startElement("", "", "Image", this.atts);
                    this.saveImage(stringArray2[i + 3], stringArray2[i + 4], stringArray2[i + 7], stringArray2[i + 8]);
                    this.hd.endElement("", "", "Image");
                    this.hd.endElement("", "", "ErrorLineAndScreenShot");
                    this.hd.startElement("", "", "ErrorLineForScreenShot", this.atts);
                    this.hd.startElement("", "", "Image", this.atts);
                    this.saveImage(stringArray2[i + 5], stringArray2[i + 6], stringArray2[i + 7], stringArray2[i + 8]);
                    this.hd.endElement("", "", "Image");
                    this.hd.endElement("", "", "ErrorLineForScreenShot");
                    this.hd.endElement("", "", "ImageDescription");
                    this.hd.endElement("", "", "Sequence");
                }
                this.hd.endElement("", "", "Sequences");
            }
            this.hd.endElement("", "", "BUGS");
            this.hd.endDocument();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to write to file");
            System.exit(-1);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println("Error in: TransformerConfigurationException");
        }
        catch (SAXException sAXException) {
            System.err.println("Error in: (SAXException");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
    }
}

