/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.download;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class URLConnectionManager
implements HostnameVerifier,
X509TrustManager {
    private static final URLConnectionManager allTrustingSSLTrustManager = new URLConnectionManager();
    private static final TrustManager[] trustAllCerts = new TrustManager[]{allTrustingSSLTrustManager};
    private static final HostnameVerifier restoreDefaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private static final SSLSocketFactory restoreDefaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();

    public static void setNoCheckCertificates(boolean bl) throws Exception {
        if (bl) {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(allTrustingSSLTrustManager);
        } else {
            HttpsURLConnection.setDefaultSSLSocketFactory(restoreDefaultSSLSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(restoreDefaultHostnameVerifier);
        }
    }

    public static URLConnection getConnection(String string, Proxy proxy) throws Exception {
        URL uRL = new URL(string);
        if (proxy == null) {
            return uRL.openConnection();
        }
        return uRL.openConnection(proxy);
    }

    public static URLConnection getConnection(String string, Proxy proxy, boolean bl) throws Exception {
        URL uRL = new URL(string);
        if (string.startsWith("https:") && bl) {
            URLConnectionManager.setNoCheckCertificates(bl);
        } else {
            URLConnectionManager.setNoCheckCertificates(false);
        }
        if (proxy == null) {
            return uRL.openConnection();
        }
        return uRL.openConnection(proxy);
    }

    public static URLConnection getConnection(String string, String string2, String string3, boolean bl) throws Exception {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string2, Integer.parseInt(string3)));
        return URLConnectionManager.getConnection(string, proxy, bl);
    }

    public static URLConnection getConnection(String string, String string2, int n, boolean bl) throws Exception {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string2, n));
        return URLConnectionManager.getConnection(string, proxy, bl);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
    }

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        return true;
    }
}

