/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.download.Download;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.SafeProcess;

public class ServerInfoDialog
extends JDialog {
    private static Dimension SIZE = new Dimension(500, 300);
    private String url;
    private String mode;
    private JPanel info_list_pane;
    private JTextArea info_text_area;
    private JScrollPane info_scroll_pane;
    private JDialog info_dialog;
    private Download download;
    private Properties proxy_urls;

    public ServerInfoDialog(String string, Properties properties, String string2, Download download) {
        this.url = string;
        this.mode = string2;
        this.download = download;
        this.proxy_urls = properties;
        this.info_dialog = this;
        this.setSize(SIZE);
        GLIButton gLIButton = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
        gLIButton.setEnabled(true);
        gLIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerInfoDialog.this.info_dialog.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(gLIButton);
        this.info_list_pane = new JPanel();
        this.info_list_pane.setLayout(new BoxLayout(this.info_list_pane, 1));
        this.info_list_pane.setBorder(BorderFactory.createEtchedBorder());
        this.info_text_area = new JTextArea();
        this.info_list_pane.add(this.info_text_area);
        this.info_text_area.setEditable(false);
        this.getServerInfo();
        this.info_scroll_pane = new JScrollPane(this.info_list_pane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)this.info_scroll_pane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "South");
        Container container = this.getContentPane();
        container.add(jPanel3);
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - ServerInfoDialog.SIZE.width) / 2, (dimension.height - ServerInfoDialog.SIZE.height) / 2);
        TestingPreparation.setIndividualSubcomponentNames(this, this.info_text_area);
        this.setVisible(true);
    }

    private void getServerInfo() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Configuration.perl_path);
        arrayList.add("-S");
        arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "downloadfrom.pl");
        arrayList.add("-info");
        arrayList.add("-download_mode");
        arrayList.add(this.mode);
        ArrayList arrayList2 = this.download.getArguments(true, false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (Argument)arrayList2.get(i);
            if (!((Argument)object).isAssigned()) continue;
            arrayList.add("-" + ((Argument)object).getName());
            if (((Argument)object).getType() == 1) continue;
            arrayList.add(((Argument)object).getValue());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        DebugStream.println("Getting server info: " + arrayList);
        try {
            object = null;
            if (this.proxy_urls.size() != 0) {
                String[] stringArray2 = new String[4 + this.proxy_urls.size()];
                stringArray2[0] = "GSDLHOME=" + Configuration.gsdl_path;
                stringArray2[1] = "GSDLOS=" + Gatherer.client_operating_system;
                stringArray2[2] = "GSWGETRC=" + System.getenv("GSWGETRC");
                stringArray2[3] = "PATH=" + System.getenv("PATH");
                int n = 4;
                String string = this.proxy_urls.getProperty("HTTP");
                if (string != null) {
                    stringArray2[n] = "http_proxy=" + string;
                    ++n;
                }
                if ((string = this.proxy_urls.getProperty("HTTPS")) != null) {
                    stringArray2[n] = "https_proxy=" + string;
                    ++n;
                }
                if ((string = this.proxy_urls.getProperty("FTP")) != null) {
                    stringArray2[n] = "ftp_proxy=" + string;
                    ++n;
                }
                object = new SafeProcess(stringArray, stringArray2, null);
            } else {
                object = new SafeProcess(stringArray);
            }
            int n = ((SafeProcess)object).runProcess(null, new ProcErrStreamLineByLineHandler());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class ProcErrStreamLineByLineHandler
    extends SafeProcess.LineByLineHandler {
        public ProcErrStreamLineByLineHandler() {
            super(0);
        }

        @Override
        public void gotLine(final String string) {
            if (!string.trim().equals("<<Finished>>")) {
                Gatherer.invokeInEDT_replacesProceedInCurrThread("ServerInfoDialog.ProcErrStreamLineByLineHandler.gotLine()", false, new Runnable(){

                    @Override
                    public void run() {
                        if (!string.trim().equals("")) {
                            ServerInfoDialog.this.info_text_area.append(string + "\n");
                        }
                    }
                });
            }
        }

        @Override
        public void gotException(Exception exception) {
            exception.printStackTrace();
        }
    }
}

