/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.download.DownloadJob;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.AppendLineOnlyFileDocument;

public class DownloadProgressBar
extends JPanel
implements ActionListener {
    private boolean simple = false;
    private Dimension bar_size = new Dimension(520, 25);
    private Dimension MINIMUM_BUTTON_SIZE = new Dimension(100, 25);
    private Dimension PROGRESS_BAR_SIZE = new Dimension(580, 75);
    private int current_action;
    private int err_count;
    private int file_count;
    private int total_count;
    private int warning_count;
    private JLabel current_status;
    private JLabel main_status;
    private JLabel results_status;
    private JPanel center_pane;
    private JPanel inner_pane;
    private JProgressBar progress;
    private long file_size;
    private long total_size;
    private String current_url;
    private String initial_url;
    private DownloadJob owner;
    public JButton stop_start_button;
    public JButton log_button;
    public JButton close_button;
    private static final Dimension DIALOG_SIZE = new Dimension(640, 480);

    public DownloadProgressBar(DownloadJob downloadJob, String string, boolean bl) {
        this.owner = downloadJob;
        this.current_url = null;
        this.err_count = 0;
        this.initial_url = string;
        this.file_count = 0;
        this.file_size = 0L;
        this.simple = bl;
        this.total_count = 0;
        this.total_size = 0L;
        this.warning_count = 0;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.current_action = 3;
        this.inner_pane = new JPanel(new BorderLayout());
        this.inner_pane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.center_pane = new JPanel(new GridLayout(3, 1));
        this.main_status = new JLabel();
        this.current_status = new JLabel();
        this.results_status = new JLabel();
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        this.progress.setMinimum(0);
        this.progress.setMaximum(0);
        this.progress.setEnabled(false);
        this.progress.setString(Dictionary.get("Mirroring.DownloadJob.Waiting"));
        this.inner_pane.add((Component)this.progress, "Center");
        this.center_pane.add(this.main_status);
        this.center_pane.add(this.current_status);
        this.center_pane.add(this.results_status);
        JPanel jPanel = new JPanel();
        this.stop_start_button = new GLIButton(Dictionary.get("Mirroring.DownloadJob.Stop"), Dictionary.get("Mirroring.DownloadJob.Stop_Tooltip"));
        this.stop_start_button.addActionListener(this);
        this.stop_start_button.addActionListener(downloadJob);
        this.stop_start_button.setMinimumSize(this.MINIMUM_BUTTON_SIZE);
        this.stop_start_button.setMnemonic(80);
        this.stop_start_button.setEnabled(true);
        this.log_button = new GLIButton(Dictionary.get("Mirroring.DownloadJob.Log"), Dictionary.get("Mirroring.DownloadJob.Log_Tooltip"));
        this.log_button.addActionListener(downloadJob);
        this.log_button.addActionListener(this);
        this.log_button.setEnabled(false);
        this.log_button.setMinimumSize(this.MINIMUM_BUTTON_SIZE);
        this.log_button.setMnemonic(76);
        this.close_button = new GLIButton(Dictionary.get("Mirroring.DownloadJob.Close"), Dictionary.get("Mirroring.DownloadJob.Close_Tooltip"));
        this.close_button.addActionListener(downloadJob);
        this.close_button.addActionListener(this);
        this.close_button.setMinimumSize(this.MINIMUM_BUTTON_SIZE);
        this.close_button.setMnemonic(67);
        this.close_button.setEnabled(true);
        this.inner_pane.add((Component)this.center_pane, "North");
        jPanel.setLayout(new GridLayout(3, 1));
        jPanel.add(this.stop_start_button);
        jPanel.add(this.log_button);
        jPanel.add(this.close_button);
        this.add((Component)this.inner_pane, "Center");
        this.add((Component)jPanel, "East");
        this.refresh();
        TestingPreparation.setIndividualSubcomponentNames(this, this.current_status, this.main_status, this.results_status);
    }

    public void enableCancelJob(final boolean bl) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("DownloadProgressBar.enableCancelJob() - stop-start and close buttons", true, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JButton jButton = DownloadProgressBar.this.stop_start_button;
                synchronized (jButton) {
                    DownloadProgressBar.this.stop_start_button.setEnabled(bl);
                }
                jButton = DownloadProgressBar.this.close_button;
                synchronized (jButton) {
                    DownloadProgressBar.this.close_button.setEnabled(bl);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.stop_start_button) {
            if (this.current_action == 2) {
                this.current_action = 3;
                this.stop_start_button.setText(Dictionary.get("Mirroring.DownloadJob.Stopped"));
                this.stop_start_button.setToolTipText(Dictionary.get("Mirroring.DownloadJob.Stopped_Tooltip"));
                this.progress.setString(Dictionary.get("Mirroring.DownloadJob.Download_Stopped"));
                this.progress.setIndeterminate(false);
                this.stop_start_button.setEnabled(false);
            }
        } else if (object == this.close_button) {
            if (this.current_action == 2) {
                this.current_action = 3;
                this.progress.setString(Dictionary.get("Mirroring.DownloadJob.Download_Stopped"));
                this.progress.setIndeterminate(false);
            }
        } else if (object == this.log_button) {
            LogDialog logDialog = new LogDialog(this.owner.getLogDocument());
            logDialog.setVisible(true);
            logDialog = null;
        }
        this.refresh();
    }

    public synchronized void addDownload(String string) {
        this.current_url = string;
        this.file_size = 0L;
        this.refresh();
    }

    public synchronized void downloadComplete() {
        this.current_url = null;
        ++this.file_count;
        if (this.total_count < this.file_count + this.err_count + this.warning_count) {
            this.total_count = this.file_count + this.err_count + this.warning_count;
        }
        this.progress.setValue(this.progress.getMaximum());
        this.refresh();
    }

    public synchronized void downloadFailed() {
        ++this.err_count;
        if (this.total_count < this.file_count + this.err_count + this.warning_count) {
            this.total_count = this.file_count + this.err_count + this.warning_count;
        }
        this.refresh();
    }

    public synchronized void downloadWarning() {
        ++this.warning_count;
        if (this.total_count < this.file_count + this.err_count + this.warning_count) {
            this.total_count = this.file_count + this.err_count + this.warning_count;
        }
        this.refresh();
    }

    public synchronized void setTotalDownload(int n) {
        this.total_count = n;
        this.refresh();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.PROGRESS_BAR_SIZE;
    }

    public synchronized void increaseFileCount() {
        ++this.file_count;
        this.refresh();
    }

    public synchronized void increaseFileCount(int n) {
        this.file_count += n;
        this.refresh();
    }

    public synchronized void resetFileCount() {
        this.file_count = 0;
        this.refresh();
    }

    public synchronized void mirrorBegun(boolean bl, final boolean bl2) {
        if (bl) {
            this.file_count = 0;
            this.file_size = 0L;
            this.total_count = 0;
            this.total_size = 0L;
            this.err_count = 0;
            this.warning_count = 0;
        }
        this.current_action = 2;
        Gatherer.invokeInEDT_replacesProceedInCurrThread("DownloadProgressBar.mirrorBegun()", true, new Runnable(){

            @Override
            public void run() {
                DownloadProgressBar.this.stop_start_button.setEnabled(true);
                DownloadProgressBar.this.log_button.setEnabled(true);
                if (bl2) {
                    DownloadProgressBar.this.progress.setIndeterminate(true);
                    DownloadProgressBar.this.progress.setString(Dictionary.get("Mirroring.DownloadJob.Download_Progress"));
                }
            }
        });
    }

    public synchronized void mirrorComplete() {
        this.current_action = 0;
        this.current_url = null;
        Gatherer.invokeInEDT_replacesProceedInCurrThread("DownloadProgressBar.mirrorComplete()", true, new Runnable(){

            @Override
            public void run() {
                if (DownloadProgressBar.this.simple) {
                    DownloadProgressBar.this.progress.setIndeterminate(false);
                }
                DownloadProgressBar.this.progress.setValue(DownloadProgressBar.this.progress.getMaximum());
                DownloadProgressBar.this.progress.setString(Dictionary.get("Mirroring.DownloadJob.Download_Complete"));
                DownloadProgressBar.this.current_status.setText(Dictionary.get("Mirroring.DownloadJob.Download_Complete"));
                DownloadProgressBar.this.stop_start_button.setEnabled(false);
                DownloadProgressBar.this.updateUI();
            }
        });
    }

    public synchronized void updateProgress(long l, long l2) {
        this.file_size += l;
        if (!this.progress.isIndeterminate()) {
            if (l == 0L) {
                this.inner_pane.remove(this.progress);
                this.progress = null;
                this.progress = l2 == 0L ? new JProgressBar(0, 100) : new JProgressBar(0, Long.valueOf(l2).intValue());
                this.progress.setEnabled(true);
                this.inner_pane.add((Component)this.progress, "Center");
                this.inner_pane.updateUI();
            } else if (l2 != 0L) {
                this.progress.setValue(Long.valueOf(this.file_size).intValue());
                int n = Double.valueOf(this.progress.getPercentComplete() * 100.0).intValue();
                this.progress.setString(n + "%");
                this.progress.setStringPainted(true);
            } else {
                this.progress.setString(this.file_size + " b");
                this.progress.setStringPainted(true);
            }
        }
        this.refresh();
    }

    private void refresh() {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("DownloadProgressBar.refresh()", true, new Runnable(){

            @Override
            public void run() {
                String[] stringArray;
                String[] stringArray2 = new String[]{DownloadProgressBar.this.initial_url.toString()};
                DownloadProgressBar.this.main_status.setText(Dictionary.get("Mirroring.DownloadJob.Downloading", stringArray2));
                if (DownloadProgressBar.this.current_url != null) {
                    stringArray = new String[]{DownloadProgressBar.this.current_url};
                    DownloadProgressBar.this.current_status.setText(Dictionary.get("Mirroring.DownloadJob.Downloading", stringArray));
                } else if (DownloadProgressBar.this.current_action == 3 || DownloadProgressBar.this.current_action == 1) {
                    DownloadProgressBar.this.current_status.setText(Dictionary.get("Mirroring.DownloadJob.Waiting_User"));
                } else {
                    DownloadProgressBar.this.current_status.setText(Dictionary.get("Mirroring.DownloadJob.Download_Complete"));
                }
                stringArray = new String[]{DownloadProgressBar.this.file_count + "", DownloadProgressBar.this.total_count + "", DownloadProgressBar.this.warning_count + "", DownloadProgressBar.this.err_count + ""};
                DownloadProgressBar.this.results_status.setText(Dictionary.get("Mirroring.DownloadJob.Status", stringArray));
                DownloadProgressBar.this.updateUI();
            }
        });
    }

    private class LogDialog
    extends JDialog {
        public LogDialog(AppendLineOnlyFileDocument appendLineOnlyFileDocument) {
            super((Frame)Gatherer.g_man, Dictionary.get("Mirroring.DownloadJob.Log_Title"));
            this.setSize(DIALOG_SIZE);
            JPanel jPanel = (JPanel)this.getContentPane();
            JTextArea jTextArea = new JTextArea(appendLineOnlyFileDocument);
            GLIButton gLIButton = new GLIButton(Dictionary.get("General.Close"));
            gLIButton.addActionListener(new CloseActionListener());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JScrollPane(jTextArea), "Center");
            jPanel.add((Component)gLIButton, "South");
        }

        private class CloseActionListener
        implements ActionListener {
            private CloseActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LogDialog.this.dispose();
            }
        }
    }
}

