/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.io.File;
import javax.swing.ImageIcon;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.collection.FullCollectionTreeNode;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.util.JarTools;

public class CollectionTreeNode
extends FullCollectionTreeNode {
    public static final ImageIcon GREEN_FILE_ICON = JarTools.getImage("greenfile.gif", true);
    private boolean is_explodable = false;
    private boolean is_srcreplaceable = false;

    public CollectionTreeNode(File file) {
        super(file);
        this.is_explodable = CollectionDesignManager.plugin_manager.isFileExplodable(file);
        this.is_srcreplaceable = CollectionDesignManager.plugin_manager.isFileSrcReplaceable(file);
    }

    @Override
    public FileNode addChildNode(File file) {
        CollectionTreeNode collectionTreeNode = new CollectionTreeNode(file);
        collectionTreeNode.setModel(this.model);
        collectionTreeNode.setParent(this);
        return collectionTreeNode;
    }

    public boolean isExplodable() {
        return this.is_explodable;
    }

    public boolean isSrcReplaceable() {
        return this.is_srcreplaceable;
    }

    @Override
    protected String calcDisplayString() {
        if (this.file.getName().equals("metadata.xml")) {
            return super.calcDisplayString();
        }
        if (!FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            return super.calcDisplayString();
        }
        String string = null;
        String string2 = this.getURLEncodedFilePath();
        String string3 = FilenameEncoding.findFilenameEncoding(this.file, string2, false);
        if (!string3.equals(this.getFilenameEncoding())) {
            string = this.reencodeDisplayName(string3);
        }
        if (string == null) {
            string = FilenameEncoding.DEBUGGING ? this.getURLEncodedFileName() : super.calcDisplayString();
        }
        return string;
    }

    public String reencodeDisplayName(String string) {
        if (!FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            return this.displayFileName;
        }
        this.filenameEncoding = string;
        if (this.filenameEncoding.equals("")) {
            this.displayFileName = super.calcDisplayString();
            return this.displayFileName;
        }
        try {
            this.displayFileName = new String(this.file.getName().getBytes(), this.filenameEncoding);
        }
        catch (Exception exception) {
            this.filenameEncoding = string;
            this.displayFileName = FilenameEncoding.DEBUGGING ? this.getURLEncodedFileName() : super.calcDisplayString();
        }
        return this.displayFileName;
    }

    @Override
    public void refreshDescendantEncodings() {
        if (!FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED || this.child_nodes == null) {
            return;
        }
        for (int i = 0; i < this.child_nodes.size(); ++i) {
            CollectionTreeNode collectionTreeNode = (CollectionTreeNode)this.child_nodes.get(i);
            String string = collectionTreeNode.getURLEncodedFilePath();
            String string2 = FilenameEncoding.findFilenameEncoding(collectionTreeNode.getFile(), string, false);
            if (collectionTreeNode.getFilenameEncoding().equals(string2)) continue;
            collectionTreeNode.reencodeDisplayName(string2);
        }
    }

    @Override
    public void resetDescendantEncodings() {
        if (FilenameEncoding.MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            CollectionTreeNode.resetDescendantEncodings(this.file, this.getURLEncodedFilePath());
        }
    }

    private static void resetDescendantEncodings(File file, String string) {
        FilenameEncoding.map.remove(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                string = FilenameEncoding.fileToURLEncoding(fileArray[i]);
                CollectionTreeNode.resetDescendantEncodings(fileArray[i], string);
            }
        }
    }
}

