/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.Index;
import org.greenstone.gatherer.cdm.IndexOption;
import org.greenstone.gatherer.cdm.LanguageListCellRenderer;
import org.greenstone.gatherer.cdm.SearchMeta;
import org.greenstone.gatherer.cdm.SubcollectionIndex;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.util.Utility;

public class TranslationView {
    private Control controls;
    private static final Dimension COMPONENT_SIZE = new Dimension(225, 25);
    private static final int LANGUAGE_WIDTH = 75;

    public TranslationView() {
        DebugStream.println("TranslationView: Initialized.");
    }

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new TranslationControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    private CollectionMeta newCollOrSearchMeta(String string, String string2, String string3) {
        return this.newCollOrSearchMeta(string, string2, string3, false);
    }

    private CollectionMeta newCollOrSearchMeta(String string, String string2, String string3, boolean bl) {
        CollectionMeta collectionMeta = string2 != null ? new SearchMeta(string, string2, string3, bl) : new CollectionMeta(string, string3, bl);
        return collectionMeta;
    }

    private TreeSet getLanguages() {
        TreeSet treeSet = CollectionDesignManager.collectionmeta_manager.getLanguages();
        treeSet.addAll(CollectionDesignManager.searchmeta_manager.getLanguages());
        return treeSet;
    }

    private Object[] getFeaturesList() {
        ArrayList arrayList;
        ArrayList arrayList2;
        int n;
        ArrayList<BobTheMagicalComparableWrapper> arrayList3 = new ArrayList<BobTheMagicalComparableWrapper>();
        ArrayList arrayList4 = CollectionDesignManager.collectionmeta_manager.getMetadata();
        for (int i = 0; i < arrayList4.size(); ++i) {
            BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper;
            CollectionMeta collectionMeta = (CollectionMeta)arrayList4.get(i);
            if (collectionMeta.isSpecial() || arrayList3.contains(bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(collectionMeta.getName(), null))) continue;
            arrayList3.add(bobTheMagicalComparableWrapper);
        }
        ArrayList arrayList5 = CollectionDesignManager.index_manager.getIndexes();
        int n2 = arrayList5.size();
        for (int i = 0; i < n2; ++i) {
            BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(arrayList5.get(i), "index");
            if (arrayList3.contains(bobTheMagicalComparableWrapper)) continue;
            arrayList3.add(bobTheMagicalComparableWrapper);
        }
        ArrayList arrayList6 = CollectionDesignManager.index_manager.getLevels();
        if (arrayList6 != null) {
            int n3 = arrayList6.size();
            for (n = 0; n < arrayList6.size(); ++n) {
                BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(arrayList6.get(n), "level");
                if (arrayList3.contains(bobTheMagicalComparableWrapper)) continue;
                arrayList3.add(bobTheMagicalComparableWrapper);
            }
        }
        if ((arrayList2 = CollectionDesignManager.index_manager.getSortFields()) != null) {
            n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(arrayList2.get(i), "sort");
                if (arrayList3.contains(bobTheMagicalComparableWrapper)) continue;
                arrayList3.add(bobTheMagicalComparableWrapper);
            }
        }
        if ((arrayList = CollectionDesignManager.index_manager.getFacets()) != null) {
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(arrayList.get(i), "facet");
                if (arrayList3.contains(bobTheMagicalComparableWrapper)) continue;
                arrayList3.add(bobTheMagicalComparableWrapper);
            }
        }
        ArrayList arrayList7 = CollectionDesignManager.subcollectionindex_manager.getSubcollectionIndexes();
        int n5 = arrayList7.size();
        for (int i = 0; i < n5; ++i) {
            BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(arrayList7.get(i), "partition");
            if (arrayList3.contains(bobTheMagicalComparableWrapper)) continue;
            arrayList3.add(bobTheMagicalComparableWrapper);
        }
        ArrayList arrayList8 = CollectionDesignManager.language_manager.getLanguages();
        int n6 = arrayList8.size();
        for (int i = 0; i < n6; ++i) {
            BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = new BobTheMagicalComparableWrapper(arrayList8.get(i), "language");
            if (arrayList3.contains(bobTheMagicalComparableWrapper)) continue;
            arrayList3.add(bobTheMagicalComparableWrapper);
        }
        return arrayList3.toArray();
    }

    private class TranslationControl
    extends JPanel
    implements Control {
        private boolean ignore_event = false;
        private FragmentTableModel fragment_table_model;
        private JButton add_button;
        private JButton remove_button;
        private JButton replace_button;
        private JComboBox language_combobox;
        private JList features_list;
        private JTable fragment_table;
        private JTextArea default_area;
        private JTextArea translation_area;

        TranslationControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.fragment_table_model = new FragmentTableModel("", "", new TreeSet(), new ArrayList());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Translation", "translatetext");
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.TranslationManager.Affected_Features"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            Object[] objectArray = TranslationView.this.getFeaturesList();
            this.features_list = new JList<Object>(objectArray);
            this.features_list.setSelectionMode(0);
            if (objectArray != null && objectArray.length > 0) {
                this.features_list.setSelectedIndex(0);
            }
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.TranslationManager.Assigned_Fragments"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            this.fragment_table = new JTable(this.fragment_table_model);
            this.fragment_table.setComponentOrientation(Dictionary.getOrientation());
            this.fragment_table.setAutoResizeMode(3);
            this.fragment_table.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.fragment_table.setColumnSelectionAllowed(false);
            this.fragment_table.setDefaultRenderer(Object.class, new FragmentTableRenderer());
            this.fragment_table.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.fragment_table);
            jScrollPane.getViewport().setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            jScrollPane.setOpaque(true);
            JPanel jPanel5 = new JPanel();
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel6 = new JPanel();
            jPanel6.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel3 = new JLabel(Dictionary.get("CDM.TranslationManager.Language"));
            jLabel3.setComponentOrientation(Dictionary.getOrientation());
            this.language_combobox = new JComboBox<Object>(CollectionDesignManager.language_manager.getLanguageCodes().toArray());
            this.language_combobox.setOpaque(!Utility.isMac());
            this.language_combobox.setPreferredSize(COMPONENT_SIZE);
            this.language_combobox.setRenderer(new LanguageListCellRenderer());
            this.language_combobox.setToolTipText(Dictionary.get("CDM.TranslationManager.Language_Tooltip"));
            this.language_combobox.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel8 = new JPanel();
            jPanel8.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel4 = new JLabel(Dictionary.get("CDM.TranslationManager.Default_Text"));
            jLabel4.setComponentOrientation(Dictionary.getOrientation());
            this.default_area = new JTextArea();
            this.default_area.setComponentOrientation(Dictionary.getOrientation());
            this.default_area.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.default_area.setEditable(false);
            this.default_area.setLineWrap(true);
            this.default_area.setWrapStyleWord(true);
            JPanel jPanel9 = new JPanel();
            jPanel9.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel5 = new JLabel(Dictionary.get("CDM.TranslationManager.Translation"));
            jLabel5.setComponentOrientation(Dictionary.getOrientation());
            this.translation_area = new JTextArea();
            this.translation_area.setComponentOrientation(Dictionary.getOrientation());
            this.translation_area.setBackground(Configuration.getColor("coloring.disabled", false));
            this.translation_area.setEnabled(false);
            this.translation_area.setLineWrap(true);
            this.translation_area.setWrapStyleWord(true);
            this.translation_area.setToolTipText(Dictionary.get("CDM.TranslationManager.Translation_Tooltip"));
            JPanel jPanel10 = new JPanel();
            jPanel10.setComponentOrientation(Dictionary.getOrientation());
            this.add_button = new GLIButton(Dictionary.get("CDM.TranslationManager.Add"), Dictionary.get("CDM.TranslationManager.Add_Tooltip"));
            this.add_button.setEnabled(false);
            this.replace_button = new GLIButton(Dictionary.get("CDM.TranslationManager.Replace"), Dictionary.get("CDM.TranslationManager.Replace_Tooltip"));
            this.replace_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get("CDM.TranslationManager.Remove"), Dictionary.get("CDM.TranslationManager.Remove_Tooltip"));
            this.remove_button.setEnabled(false);
            this.add_button.addActionListener(new AddListener());
            this.remove_button.addActionListener(new RemoveListener());
            this.replace_button.addActionListener(new ReplaceListener());
            this.language_combobox.addActionListener(new LanguageActionListener());
            this.translation_area.getDocument().addDocumentListener(new TranslationDocumentListener());
            this.features_list.addListSelectionListener(new FeaturesListSelectionListener());
            this.fragment_table.getSelectionModel().addListSelectionListener(new FragmentListSelectionListener());
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jLabel, "North");
            jPanel3.add((Component)new JScrollPane(this.features_list), "Center");
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jLabel2, "North");
            jPanel4.add((Component)jScrollPane, "Center");
            jPanel2.setLayout(new GridLayout(2, 1, 0, 5));
            jPanel2.add(jPanel3);
            jPanel2.add(jPanel4);
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add((Component)jLabel4, "North");
            jPanel8.add((Component)new JScrollPane(this.default_area), "Center");
            jPanel9.setLayout(new BorderLayout());
            jPanel9.add((Component)jLabel5, "North");
            jPanel9.add((Component)new JScrollPane(this.translation_area), "Center");
            jPanel6.setLayout(new GridLayout(1, 2, 5, 0));
            jPanel6.add(jPanel8);
            jPanel6.add(jPanel9);
            jPanel7.setLayout(new BorderLayout(5, 0));
            jPanel7.add((Component)jLabel3, "Before");
            jPanel7.add((Component)this.language_combobox, "Center");
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)jPanel7, "North");
            jPanel5.add((Component)jPanel6, "Center");
            jPanel.setLayout(new GridLayout(2, 1, 0, 5));
            jPanel.add(jPanel2);
            jPanel.add(jPanel5);
            jPanel10.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            jPanel10.setLayout(new GridLayout(1, 3));
            jPanel10.add(this.add_button);
            jPanel10.add(this.replace_button);
            jPanel10.add(this.remove_button);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel10, "South");
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            if (this.features_list != null) {
                Object e = this.features_list.getSelectedValue();
                this.features_list.setListData(TranslationView.this.getFeaturesList());
                if (e != null) {
                    this.features_list.setSelectedValue(e, true);
                }
            }
        }

        @Override
        public void loseFocus() {
        }

        private class TranslationDocumentListener
        implements DocumentListener {
            private TranslationDocumentListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                String string = TranslationControl.this.translation_area.getText();
                String string2 = (String)TranslationControl.this.language_combobox.getSelectedItem();
                CollectionMeta collectionMeta = TranslationControl.this.fragment_table_model.getMetadata(string2);
                TranslationControl.this.add_button.setEnabled(string.length() > 0 && (collectionMeta.isDummy() || TranslationControl.this.fragment_table_model.getMetadataIndexByLanguage(string2) == -1));
                string2 = null;
                if (TranslationControl.this.fragment_table.getSelectedRowCount() > 0) {
                    TranslationControl.this.replace_button.setEnabled(!collectionMeta.isDummy() && !string.equals(TranslationControl.this.fragment_table.getValueAt(TranslationControl.this.fragment_table.getSelectedRow(), 1)));
                } else {
                    TranslationControl.this.replace_button.setEnabled(false);
                }
                string = null;
            }
        }

        private class LanguageActionListener
        implements ActionListener {
            private LanguageActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TranslationControl.this.ignore_event && TranslationControl.this.features_list.getSelectedIndex() > -1) {
                    TranslationControl.this.ignore_event = true;
                    String string = TranslationControl.this.language_combobox.getSelectedItem().toString();
                    int n = TranslationControl.this.fragment_table_model.getMetadataIndexByLanguage(string);
                    if (n != -1) {
                        CollectionMeta collectionMeta = TranslationControl.this.fragment_table_model.getMetadata(n);
                        TranslationControl.this.fragment_table.setRowSelectionInterval(n, n);
                        TranslationControl.this.translation_area.setText(collectionMeta.getValue(true));
                    } else {
                        TranslationControl.this.fragment_table.clearSelection();
                        TranslationControl.this.translation_area.setText("");
                    }
                    TranslationControl.this.translation_area.setEnabled(true);
                    TranslationControl.this.translation_area.setBackground(Configuration.getColor("coloring.editable_background", false));
                    TranslationControl.this.ignore_event = false;
                }
            }
        }

        private class FragmentTableRenderer
        extends DefaultTableCellRenderer {
            private FragmentTableRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (bl) {
                    jComponent.setBackground(Configuration.getColor("coloring.workspace_heading_background", false));
                } else {
                    jComponent.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
                }
                return jComponent;
            }
        }

        private class FragmentTableModel
        extends AbstractTableModel {
            private ArrayList metadata;
            private String feature_name;
            private String feature_type;
            private TreeSet languages;

            FragmentTableModel(String string, String string2, TreeSet treeSet, ArrayList arrayList) {
                this.feature_name = string;
                this.feature_type = string2;
                this.languages = treeSet;
                this.metadata = arrayList;
            }

            @Override
            public int getRowCount() {
                return this.languages.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return Dictionary.get("CDM.TranslationManager.Language_Column");
                }
                if (n == 1) {
                    return Dictionary.get("CDM.TranslationManager.Fragment_Column");
                }
                return "";
            }

            public CollectionMeta getMetadata(int n) {
                int n2;
                String string = null;
                Iterator iterator = this.languages.iterator();
                for (n2 = 0; n2 != n && iterator.hasNext(); ++n2) {
                    iterator.next();
                }
                if (n2 == n) {
                    string = (String)iterator.next();
                    return this.getMetadata(string);
                }
                iterator = null;
                return null;
            }

            public CollectionMeta getMetadata(String string) {
                for (int i = 0; i < this.metadata.size(); ++i) {
                    CollectionMeta collectionMeta = (CollectionMeta)this.metadata.get(i);
                    if (!collectionMeta.getLanguage().equals(string)) continue;
                    return collectionMeta;
                }
                return TranslationView.this.newCollOrSearchMeta(this.feature_name, this.feature_type, string, true);
            }

            public int getMetadataIndexByLanguage(String string) {
                Iterator iterator = this.languages.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string.equals(string2)) {
                        return n;
                    }
                    ++n;
                }
                return -1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (0 <= n && n < this.languages.size()) {
                    int n3;
                    Iterator iterator = this.languages.iterator();
                    for (n3 = 0; n3 != n && iterator.hasNext(); ++n3) {
                        iterator.next();
                    }
                    if (n3 == n) {
                        String string = (String)iterator.next();
                        if (n2 == 0) {
                            return CollectionDesignManager.language_manager.getLanguageName(string);
                        }
                        CollectionMeta collectionMeta = this.getMetadata(string);
                        return collectionMeta.getValue(true);
                    }
                    iterator = null;
                }
                return "#Error";
            }

            public void remove(CollectionMeta collectionMeta) {
                this.metadata.remove(collectionMeta);
            }

            public void setData(String string, String string2, TreeSet treeSet, ArrayList arrayList) {
                this.feature_name = string;
                this.feature_type = string2;
                this.languages = treeSet;
                this.metadata = arrayList;
                this.fireTableDataChanged();
            }

            public int size() {
                return this.metadata.size();
            }
        }

        private class FragmentListSelectionListener
        implements ListSelectionListener {
            private FragmentListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && !TranslationControl.this.ignore_event) {
                    TranslationControl.this.ignore_event = true;
                    int n = -1;
                    n = TranslationControl.this.fragment_table.getSelectedRow();
                    if (n != -1) {
                        CollectionMeta collectionMeta = TranslationControl.this.fragment_table_model.getMetadata(n);
                        if (collectionMeta != null) {
                            String string = collectionMeta.getLanguage();
                            for (int i = 0; i < TranslationControl.this.language_combobox.getItemCount(); ++i) {
                                if (!TranslationControl.this.language_combobox.getItemAt(i).toString().equals(string)) continue;
                                TranslationControl.this.language_combobox.setSelectedIndex(i);
                            }
                            TranslationControl.this.translation_area.setText(collectionMeta.getValue(true));
                            TranslationControl.this.remove_button.setEnabled(!collectionMeta.isDummy());
                        } else {
                            TranslationControl.this.remove_button.setEnabled(false);
                        }
                    } else {
                        TranslationControl.this.translation_area.setText("");
                        TranslationControl.this.remove_button.setEnabled(false);
                    }
                    TranslationControl.this.ignore_event = false;
                }
            }
        }

        private class FeaturesListSelectionListener
        implements ListSelectionListener {
            private FeaturesListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && !TranslationControl.this.ignore_event) {
                    if (!TranslationControl.this.features_list.isSelectionEmpty()) {
                        CollectionMeta collectionMeta;
                        BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = (BobTheMagicalComparableWrapper)TranslationControl.this.features_list.getSelectedValue();
                        TranslationControl.this.fragment_table.clearSelection();
                        if (bobTheMagicalComparableWrapper.getType() != null) {
                            collectionMeta = CollectionDesignManager.searchmeta_manager.getMetadatum(bobTheMagicalComparableWrapper.getName(), bobTheMagicalComparableWrapper.getType());
                            TranslationControl.this.fragment_table_model.setData(bobTheMagicalComparableWrapper.getName(), bobTheMagicalComparableWrapper.getType(), TranslationView.this.getLanguages(), CollectionDesignManager.searchmeta_manager.getMetadata(bobTheMagicalComparableWrapper.getName()));
                        } else {
                            collectionMeta = CollectionDesignManager.collectionmeta_manager.getMetadatum(bobTheMagicalComparableWrapper.getName());
                            TranslationControl.this.fragment_table_model.setData(bobTheMagicalComparableWrapper.getName(), bobTheMagicalComparableWrapper.getType(), TranslationView.this.getLanguages(), CollectionDesignManager.collectionmeta_manager.getMetadata(bobTheMagicalComparableWrapper.getName()));
                        }
                        if (collectionMeta != null) {
                            TranslationControl.this.default_area.setText(collectionMeta.getValue(true));
                        }
                        bobTheMagicalComparableWrapper = null;
                        String string = (String)TranslationControl.this.language_combobox.getSelectedItem();
                        int n = TranslationControl.this.fragment_table_model.getMetadataIndexByLanguage(string);
                        if (n != -1) {
                            CollectionMeta collectionMeta2 = TranslationControl.this.fragment_table_model.getMetadata(n);
                            TranslationControl.this.fragment_table.setRowSelectionInterval(n, n);
                            if (collectionMeta2 != null) {
                                TranslationControl.this.translation_area.setText(collectionMeta2.getValue(true));
                            } else {
                                TranslationControl.this.translation_area.setText("");
                            }
                            collectionMeta2 = null;
                        } else {
                            TranslationControl.this.translation_area.setText("");
                        }
                        TranslationControl.this.translation_area.setEnabled(true);
                        TranslationControl.this.translation_area.setBackground(Configuration.getColor("coloring.editable_background", false));
                    } else {
                        TranslationControl.this.default_area.setText("");
                        TranslationControl.this.fragment_table.clearSelection();
                        TranslationControl.this.fragment_table_model.setData("", "", new TreeSet(), new ArrayList());
                        TranslationControl.this.translation_area.setText("");
                        TranslationControl.this.translation_area.setText("");
                        TranslationControl.this.translation_area.setEnabled(false);
                        TranslationControl.this.translation_area.setBackground(Configuration.getColor("coloring.disabled", false));
                    }
                }
            }
        }

        private class ReplaceListener
        implements ActionListener {
            private ReplaceListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TranslationControl.this.ignore_event = true;
                int n = -1;
                n = TranslationControl.this.fragment_table.getSelectedRow();
                if (n != -1) {
                    String string = TranslationControl.this.translation_area.getText();
                    CollectionMeta collectionMeta = TranslationControl.this.fragment_table_model.getMetadata(n);
                    collectionMeta.setValue(string);
                    TranslationControl.this.fragment_table_model.fireTableRowsUpdated(n, n);
                    collectionMeta = null;
                    TranslationControl.this.remove_button.setEnabled(true);
                }
                TranslationControl.this.add_button.setEnabled(false);
                TranslationControl.this.replace_button.setEnabled(false);
                TranslationControl.this.ignore_event = false;
            }
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TranslationControl.this.ignore_event = true;
                int n = -1;
                n = TranslationControl.this.fragment_table.getSelectedRow();
                if (n != -1) {
                    CollectionMeta collectionMeta = TranslationControl.this.fragment_table_model.getMetadata(n);
                    if (collectionMeta instanceof SearchMeta) {
                        CollectionDesignManager.searchmeta_manager.removeMetadata(collectionMeta);
                    } else {
                        CollectionDesignManager.collectionmeta_manager.removeMetadata(collectionMeta);
                    }
                    TranslationControl.this.fragment_table_model.remove(collectionMeta);
                    TranslationControl.this.add_button.setEnabled(true);
                }
                TranslationControl.this.replace_button.setEnabled(false);
                TranslationControl.this.remove_button.setEnabled(false);
                TranslationControl.this.ignore_event = false;
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TranslationControl.this.ignore_event = true;
                String string = TranslationControl.this.translation_area.getText();
                if (string.length() > 0) {
                    ArrayList arrayList;
                    BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = (BobTheMagicalComparableWrapper)TranslationControl.this.features_list.getSelectedValue();
                    String string2 = (String)TranslationControl.this.language_combobox.getSelectedItem();
                    CollectionMeta collectionMeta = TranslationView.this.newCollOrSearchMeta(bobTheMagicalComparableWrapper.getName(), bobTheMagicalComparableWrapper.getType(), string2);
                    collectionMeta.setValue(string);
                    TranslationControl.this.fragment_table.clearSelection();
                    if (collectionMeta instanceof SearchMeta) {
                        System.err.println("adding meta to search" + collectionMeta);
                        CollectionDesignManager.searchmeta_manager.addMetadatum(collectionMeta);
                        arrayList = CollectionDesignManager.searchmeta_manager.getMetadata(bobTheMagicalComparableWrapper.getName(), bobTheMagicalComparableWrapper.getType());
                        System.err.println("metadata = " + arrayList);
                    } else {
                        System.err.println("adding meta to general");
                        CollectionDesignManager.collectionmeta_manager.addMetadatum(collectionMeta);
                        arrayList = CollectionDesignManager.collectionmeta_manager.getMetadata(bobTheMagicalComparableWrapper.getName());
                    }
                    System.err.println("new langues = " + TranslationView.this.getLanguages());
                    TranslationControl.this.fragment_table_model.setData(bobTheMagicalComparableWrapper.getName(), bobTheMagicalComparableWrapper.getType(), TranslationView.this.getLanguages(), arrayList);
                    int n = TranslationControl.this.fragment_table_model.getMetadataIndexByLanguage(string2);
                    System.err.println("I want to select the row " + n + " out of " + arrayList.size());
                    TranslationControl.this.fragment_table.setRowSelectionInterval(n, n);
                    collectionMeta = null;
                    string2 = null;
                    bobTheMagicalComparableWrapper = null;
                    string = null;
                    TranslationControl.this.remove_button.setEnabled(true);
                }
                TranslationControl.this.add_button.setEnabled(false);
                TranslationControl.this.replace_button.setEnabled(false);
                TranslationControl.this.ignore_event = false;
            }
        }
    }

    private class BobTheMagicalComparableWrapper
    implements Comparable {
        private Object content;
        private String text;
        private String type;

        BobTheMagicalComparableWrapper(Object object, String string) {
            this.content = object;
            if (string != null) {
                this.type = Gatherer.GS3 ? string : "search";
            }
        }

        public int compareTo(Object object) {
            if (object == null) {
                object = "";
            }
            if (this.text == null) {
                this.toString();
            }
            return this.text.compareTo(object.toString());
        }

        public boolean equals(Object object) {
            BobTheMagicalComparableWrapper bobTheMagicalComparableWrapper = (BobTheMagicalComparableWrapper)object;
            return object != null && this.content.toString().equals(bobTheMagicalComparableWrapper.getContent().toString()) && (this.type == null && bobTheMagicalComparableWrapper.getType() == null || this.type.equals(bobTheMagicalComparableWrapper.getType()));
        }

        public Object getContent() {
            return this.content;
        }

        public String getName() {
            if (this.content instanceof IndexOption) {
                return ((IndexOption)this.content).getName();
            }
            if (this.content instanceof Index) {
                return ((Index)this.content).getID();
            }
            if (this.content instanceof SubcollectionIndex) {
                return ((SubcollectionIndex)this.content).getID();
            }
            return this.content.toString();
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            if (this.text == null) {
                String string = this.content.toString();
                this.text = this.type != null ? Dictionary.get("CDM.SearchMetadataManager.Type_" + this.type) + ": " + string : Dictionary.get("CDM.TranslationManager.Type_general") + ": " + string;
            }
            return this.text;
        }
    }
}

