/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.BaseIndexManager;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.Index;
import org.greenstone.gatherer.cdm.IndexOption;
import org.greenstone.gatherer.cdm.MGIndex;
import org.greenstone.gatherer.cdm.SearchMeta;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchIndexManager
extends BaseIndexManager {
    private static final Dimension FIELD_SIZE = new Dimension(200, 30);
    private static final String ALLFIELDS = "allfields";

    public SearchIndexManager(Element element, String string) {
        super(element, string, "Index", "DefaultIndex", string.equals("mg") ? new MGIndex() : new Index());
        this.controls_title_key = "CDM.IndexManager.Indexes";
        this.new_button_tooltip_key = "CDM.IndexManager.New_Button_Tooltip";
        this.edit_button_tooltip_key = "CDM.IndexManager.Edit_Button_Tooltip";
        this.remove_button_tooltip_key = "CDM.IndexManager.Remove_Button_Tooltip";
        this.default_indicator_key = "CDM.IndexManager.Default_Index_Indicator";
        this.nip_new_index_key = "CDM.IndexManager.New_Index";
        this.nip_edit_index_key = "CDM.IndexManager.Edit_Index";
        this.nip_source_label_key = "CDM.IndexManager.Source";
        this.nip_source_tooltip_key = "CDM.IndexManager.Source_Tooltip";
        this.nip_custom_label_key = "CDM.IndexManager.Custom";
        this.nip_custom_tooltip_key = "CDM.IndexManager.Custom_Tooltip";
        this.nip_add_index_button_key = "CDM.IndexManager.Add_Index";
        this.nip_add_index_tooltip_key = "CDM.IndexManager.Add_Index_Tooltip";
        this.nip_replace_index_button_key = "CDM.IndexManager.Replace_Index";
        this.nip_replace_index_tooltip_key = "CDM.IndexManager.Replace_Index_Tooltip";
        this.nip_add_all_index_button_key = "CDM.IndexManager.AddAll";
        this.nip_add_all_index_tooltip_key = "CDM.IndexManager.AddAll_Tooltip";
    }

    @Override
    public void buildTypeChanged(String string) {
        if (this.build_type.equals(string)) {
            return;
        }
        if (!this.build_type.equals("mg") && !string.equals("mg")) {
            return;
        }
        boolean bl = true;
        if (string.equals("mg")) {
            bl = false;
        }
        if (bl) {
            this.changeToMGPPIndexes();
        } else {
            this.changeToMGIndexes();
        }
        this.build_type = string;
        Index index = (Index)this.getElementAt(0);
        this.setDefault(index);
        index = null;
    }

    private void changeToMGIndexes() {
        Index index;
        this.setClassType(new MGIndex());
        Element element = this.root;
        Element element2 = CollectionDesignManager.collect_config.getMGIndexes();
        element2.setAttribute("assigned", "true");
        NodeList nodeList = element2.getElementsByTagName("Index");
        this.setRoot(element2);
        if (nodeList.getLength() == 0 && (index = this.getIndex("text")) != null) {
            ArrayList arrayList = CollectionDesignManager.index_manager.getLevels();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                IndexOption indexOption = (IndexOption)arrayList.get(i);
                MGIndex mGIndex = new MGIndex(indexOption.getName(), index.getSources());
                String string = ((Index)mGIndex).getID();
                SearchMeta searchMeta = CollectionDesignManager.searchmeta_manager.getMetadatum(string, mGIndex.getType(), false);
                if (searchMeta == null) {
                    searchMeta = new SearchMeta(string, mGIndex.getType());
                    searchMeta.setAssigned(true);
                    searchMeta.setValue(string);
                } else {
                    searchMeta.setAssigned(true);
                }
                string = null;
                this.addIndex(mGIndex, searchMeta);
                mGIndex = null;
                indexOption = null;
            }
        }
        element.setAttribute("assigned", "false");
        element = null;
    }

    private void changeToMGPPIndexes() {
        this.setClassType(new Index());
        Element element = this.root;
        Element element2 = CollectionDesignManager.collect_config.getMGPPIndexes();
        element2.setAttribute("assigned", "true");
        NodeList nodeList = element2.getElementsByTagName("Index");
        if (nodeList.getLength() != 0) {
            this.setRoot(element2);
        } else {
            ArrayList arrayList;
            int n;
            ArrayList arrayList2 = new ArrayList();
            if (this.default_index != null) {
                ArrayList arrayList3 = this.default_index.getSources();
                arrayList2.addAll(arrayList3);
            }
            int n2 = this.getSize();
            for (n = 0; n < n2; ++n) {
                Index index = (Index)this.getElementAt(n);
                arrayList = index.getSources();
                arrayList.removeAll(arrayList2);
                arrayList2.addAll(arrayList);
                index = null;
            }
            this.setRoot(element2);
            n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                arrayList = arrayList2.get(i);
                String string = null;
                string = arrayList instanceof MetadataElement ? ((MetadataElement)((Object)arrayList)).getFullName() : ((Object)arrayList).toString();
                ArrayList arrayList4 = new ArrayList();
                arrayList4.add(arrayList);
                arrayList = null;
                Index index = new Index(arrayList4);
                string = index.getID();
                SearchMeta searchMeta = CollectionDesignManager.searchmeta_manager.getMetadatum(string, index.getType(), false);
                if (searchMeta == null) {
                    searchMeta = new SearchMeta(string, index.getType());
                    searchMeta.setAssigned(true);
                    searchMeta.setValue(string);
                } else {
                    searchMeta.setAssigned(true);
                }
                string = null;
                this.addIndex(index, searchMeta);
                searchMeta = null;
                index = null;
                arrayList4 = null;
                string = null;
            }
        }
        element.setAttribute("assigned", "false");
        element = null;
    }

    @Override
    public Control getControls() {
        if (this.controls == null) {
            this.controls = new SearchIndexControl();
        }
        return this.controls;
    }

    @Override
    public void setDefault(Index index) {
        if (index != null) {
            if (this.default_index == null) {
                Element element = this.root.getOwnerDocument().createElement("DefaultIndex");
                this.default_index = this.build_type.equals("mg") ? new MGIndex(element) : new Index(element);
                Node node = CollectionConfiguration.findInsertionPoint(element);
                if (node != null) {
                    this.root.getOwnerDocument().getDocumentElement().insertBefore(element, node);
                } else {
                    this.root.getOwnerDocument().getDocumentElement().appendChild(element);
                }
            } else if (this.build_type.equals("mg") && !(this.default_index instanceof MGIndex)) {
                this.default_index = new MGIndex(this.default_index.getElement());
            } else if (!this.build_type.equals("mg") && this.default_index instanceof MGIndex) {
                this.default_index = new Index(this.default_index.getElement());
            }
            this.default_index.setAssigned(true);
            this.default_index.setSources(index.getSources());
            if (this.build_type.equals("mg")) {
                ((MGIndex)this.default_index).setLevel(((MGIndex)index).getLevel());
            }
        } else if (this.default_index != null) {
            this.default_index.setAssigned(false);
        }
    }

    private class SearchIndexControl
    extends BaseIndexManager.IndexControl {
        public SearchIndexControl() {
            super(SearchIndexManager.this);
            TestingPreparation.setNamesRecursively(this);
        }

        @Override
        protected BaseIndexManager.IndexControl.NewIndexPrompt createNewIndexPrompt(String string, Index index) {
            return new NewSearchIndexPrompt(string, index);
        }

        protected class NewSearchIndexPrompt
        extends BaseIndexManager.IndexControl.NewIndexPrompt {
            private JCheckBox text_checkbox;
            private JComboBox level_combobox;
            private JCheckBox allfields_box;
            private JButton select_all_button;
            private JButton select_none_button;
            private boolean mgpp_enabled;
            private boolean editing;

            public NewSearchIndexPrompt(String string, Index index) {
                super(SearchIndexControl.this, string, index);
                this.mgpp_enabled = false;
                this.editing = false;
            }

            @Override
            protected void generateContents(String string, Index index) {
                Serializable serializable;
                this.mgpp_enabled = !string.equals("mg");
                super.generateContents(string, index);
                this.text_checkbox = new JCheckBox(Dictionary.get("CDM.IndexManager.Text_Source"));
                this.text_checkbox.setToolTipText(Dictionary.get("CDM.IndexManager.Text_Source_Tooltip"));
                this.text_checkbox.setComponentOrientation(Dictionary.getOrientation());
                this.text_checkbox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NewSearchIndexPrompt.this.validateAddOrReplaceButton();
                    }
                });
                this.button_pane.setLayout(new GridLayout(2, 2, 5, 0));
                this.select_all_button = new GLIButton(Dictionary.get("CDM.IndexManager.Select_All"), Dictionary.get("CDM.IndexManager.Select_All_Tooltip"));
                this.select_all_button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NewSearchIndexPrompt.this.text_checkbox.setSelected(true);
                        NewSearchIndexPrompt.this.source_list.setAllTicked();
                        NewSearchIndexPrompt.this.validateAddOrReplaceButton();
                    }
                });
                this.select_none_button = new GLIButton(Dictionary.get("CDM.IndexManager.Select_None"), Dictionary.get("CDM.IndexManager.Select_None_Tooltip"));
                this.select_none_button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NewSearchIndexPrompt.this.text_checkbox.setSelected(false);
                        NewSearchIndexPrompt.this.source_list.clearTicked();
                        NewSearchIndexPrompt.this.validateAddOrReplaceButton();
                    }
                });
                this.button_pane.add(this.select_all_button);
                this.button_pane.add(this.select_none_button);
                this.button_pane.add(this.add_or_replace_button);
                this.button_pane.add(this.cancel_button);
                this.details_pane.add((Component)this.text_checkbox, "North");
                if (this.mgpp_enabled) {
                    this.allfields_box = new JCheckBox(Dictionary.get("CDM.IndexManager.Allfields_Index"));
                    this.allfields_box.addItemListener(new AllFieldsBoxListener());
                    this.allfields_box.setComponentOrientation(Dictionary.getOrientation());
                    this.extra_pane.add(this.allfields_box);
                } else {
                    serializable = new JLabel(Dictionary.get("CDM.IndexManager.Level"));
                    ((Component)serializable).setComponentOrientation(Dictionary.getOrientation());
                    this.level_combobox = new JComboBox();
                    this.level_combobox.setOpaque(false);
                    this.level_combobox.setPreferredSize(FIELD_SIZE);
                    this.level_combobox.addItem("document");
                    this.level_combobox.addItem("section");
                    this.level_combobox.addItem("paragraph");
                    this.level_combobox.setEditable(false);
                    this.level_combobox.setToolTipText(Dictionary.get("CDM.IndexManager.Level_Tooltip"));
                    this.level_combobox.setComponentOrientation(Dictionary.getOrientation());
                    this.level_combobox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            NewSearchIndexPrompt.this.validateAddOrReplaceButton();
                        }
                    });
                    JPanel jPanel = new JPanel();
                    jPanel.setComponentOrientation(Dictionary.getOrientation());
                    jPanel.setLayout(new BorderLayout());
                    jPanel.add((Component)serializable, "Before");
                    jPanel.add((Component)this.level_combobox, "Center");
                    this.extra_pane.add(jPanel);
                }
                if (index != null) {
                    serializable = index.getSources();
                    if (this.mgpp_enabled && ((ArrayList)serializable).get(0).equals(SearchIndexManager.ALLFIELDS)) {
                        this.allfields_box.setSelected(true);
                        this.source_list.setEnabled(false);
                        this.custom_field.setEnabled(false);
                    } else {
                        this.source_list.setTickedObjects(((ArrayList)serializable).toArray());
                        this.source_list.setEnabled(true);
                        if (((ArrayList)serializable).contains("text")) {
                            this.text_checkbox.setSelected(true);
                        }
                    }
                    if (!this.mgpp_enabled && index instanceof MGIndex) {
                        this.level_combobox.setSelectedIndex(((MGIndex)index).getLevel());
                    }
                }
                TestingPreparation.setIndividualSubcomponentNames(this, this.text_checkbox, this.allfields_box);
            }

            @Override
            protected String getCustomItemsFromSources(ArrayList arrayList) {
                ArrayList arrayList2 = this.source_list.getAll();
                String string = "";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    if (arrayList2.contains(e) || e.equals("text") || e.equals(SearchIndexManager.ALLFIELDS)) continue;
                    string = string + e + ",";
                }
                return string;
            }

            protected void validateAddOrReplaceButtonOld() {
                Index index;
                ArrayList arrayList;
                if (this.mgpp_enabled && this.allfields_box.isSelected()) {
                    arrayList = new ArrayList();
                    arrayList.add(SearchIndexManager.ALLFIELDS);
                    index = new Index(arrayList);
                } else if (this.text_checkbox.isSelected() || !this.source_list.isNothingTicked()) {
                    arrayList = this.source_list.getTicked();
                    if (this.text_checkbox.isSelected()) {
                        arrayList.add(0, "text");
                    }
                    index = this.mgpp_enabled ? new Index(arrayList) : new MGIndex(this.level_combobox.getSelectedIndex(), arrayList);
                } else {
                    this.add_or_replace_button.setEnabled(false);
                    return;
                }
                arrayList = null;
                if (SearchIndexManager.this.index_model.contains(index)) {
                    this.add_or_replace_button.setEnabled(false);
                } else {
                    this.add_or_replace_button.setEnabled(true);
                }
            }

            @Override
            protected Index generateNewIndex() {
                Index index = null;
                String string = this.custom_field.getText();
                if (this.mgpp_enabled && this.allfields_box.isSelected()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(SearchIndexManager.ALLFIELDS);
                    index = new Index(arrayList);
                } else if (this.text_checkbox.isSelected() || !this.source_list.isNothingTicked() || !string.equals("")) {
                    ArrayList arrayList = this.source_list.getTicked();
                    if (this.text_checkbox.isSelected()) {
                        arrayList.add(0, "text");
                    }
                    this.addCustomItemsToSources(arrayList, string);
                    index = this.mgpp_enabled ? new Index(arrayList) : new MGIndex(this.level_combobox.getSelectedIndex(), arrayList);
                }
                return index;
            }

            private class AllFieldsBoxListener
            implements ItemListener {
                private AllFieldsBoxListener() {
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        NewSearchIndexPrompt.this.source_list.setEnabled(false);
                        NewSearchIndexPrompt.this.custom_field.setEnabled(false);
                        NewSearchIndexPrompt.this.text_checkbox.setEnabled(false);
                    } else if (itemEvent.getStateChange() == 2) {
                        NewSearchIndexPrompt.this.source_list.setEnabled(true);
                        NewSearchIndexPrompt.this.custom_field.setEnabled(true);
                        NewSearchIndexPrompt.this.text_checkbox.setEnabled(true);
                    }
                    NewSearchIndexPrompt.this.validateAddOrReplaceButton();
                }
            }
        }
    }
}

