/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectCfgReadWrite;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;

public class CollectionMeta
implements DOMProxyListEntry {
    public static final boolean TEXT = true;
    public static final boolean GREENSTONE = false;
    protected boolean dummy = false;
    protected Element element = null;
    protected String text = null;

    public CollectionMeta() {
    }

    public CollectionMeta(Element element) {
        this.element = element;
    }

    public CollectionMeta(String string) {
        this.element = CollectionConfiguration.createElement("CollectionMetadata");
        this.element.setAttribute("name", string);
        this.element.setAttribute("language", Configuration.getLanguage());
        this.element.setAttribute("assigned", "false");
    }

    public CollectionMeta(String string, String string2) {
        this.element = CollectionConfiguration.createElement("CollectionMetadata");
        this.element.setAttribute("name", string);
        this.element.setAttribute("language", string2);
        this.element.setAttribute("assigned", "false");
    }

    public CollectionMeta(String string, String string2, boolean bl) {
        this(string, string2);
        this.dummy = bl;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new CollectionMeta(element);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getLanguage() {
        return this.element.getAttribute("language");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getValue(boolean bl) {
        String string = XMLTools.getValue(this.element);
        if (bl) {
            return Codec.transform(string, "DOM_TO_TEXT");
        }
        return Codec.transform(string, "DOM_TO_GREENSTONE");
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && !this.element.getAttribute("assigned").equals("false");
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public boolean isSpecial() {
        return this.element != null && this.element.getAttribute("special").equals("true");
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
        this.text = null;
    }

    public void setValue(String string) {
        this.setValue(string, false);
    }

    public void setValue(String string, boolean bl) {
        String string2;
        String string3 = XMLTools.getValue(this.element);
        String string4 = "TEXT_TO_DOM";
        if (bl) {
            string4 = Gatherer.GS3 ? "TEXT_TO_DOM_PRESERVE_TAGS_GS3" : "TEXT_TO_DOM_PRESERVE_TAGS";
        }
        if (!string3.equals(string2 = Codec.transform(string, string4))) {
            XMLTools.setValue(this.element, string2);
            this.text = null;
            this.setAssigned(string != null && string.length() > 0);
        }
    }

    public String toString() {
        if (this.text == null) {
            this.text = CollectCfgReadWrite.toString(this.element);
            if (this.text.equals("")) {
                this.text = this.getName();
            }
        }
        return this.text;
    }
}

