/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.LanguageListCellRenderer;
import org.greenstone.gatherer.gui.GComboBox;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.util.Utility;

public class ArgumentControl
extends JPanel {
    protected static Dimension LABEL_SIZE = new Dimension(175, 25);
    protected static Dimension ROW_SIZE = new Dimension(400, 30);
    private Argument argument = null;
    private JCheckBox enabled = null;
    private JComponent value_control = null;

    public ArgumentControl(Argument argument, boolean bl, String string) {
        Serializable serializable;
        Object object;
        this.setComponentOrientation(Dictionary.getOrientation());
        this.argument = argument;
        String string2 = "<html>" + argument.getName() + ": " + argument.getDescription() + "</html>";
        string2 = Utility.formatHTMLWidth(string2, 80);
        this.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(ROW_SIZE);
        String string3 = argument.getDisplayName();
        if (string3.equals("")) {
            string3 = argument.getName();
        }
        if (argument.isRequired()) {
            object = new JLabel(string3);
            ((Component)object).setComponentOrientation(Dictionary.getOrientation());
            ((JComponent)object).setOpaque(false);
            ((JComponent)object).setPreferredSize(LABEL_SIZE);
            ((JComponent)object).setToolTipText(string2);
            this.add((Component)object, "Before");
        } else {
            this.enabled = new JCheckBox(string3);
            this.enabled.setComponentOrientation(Dictionary.getOrientation());
            this.enabled.setOpaque(false);
            this.enabled.setPreferredSize(LABEL_SIZE);
            this.enabled.setToolTipText(string2);
            this.add((Component)this.enabled, "Before");
        }
        object = string != null && !string.equals("") ? string : argument.getValue();
        if (object == null || ((String)object).equals("")) {
            object = argument.getDefaultValue();
        }
        if (object == null) {
            object = "";
        }
        switch (argument.getType()) {
            case 0: 
            case 10: {
                serializable = argument.getOptions();
                boolean bl2 = false;
                if (argument.getType() == 10) {
                    bl2 = true;
                }
                this.value_control = new GComboBox(serializable.toArray(), bl2, false);
                this.value_control.setComponentOrientation(Dictionary.getOrientation());
                boolean bl3 = ArgumentControl.selectValue((JComboBox)this.value_control, (String)object);
                if (!bl3 && argument.getType() == 10) {
                    ((JComboBox)this.value_control).addItem(object);
                    ((JComboBox)this.value_control).setSelectedItem(object);
                }
                ((JComboBox)this.value_control).addActionListener(new ToolTipUpdater());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                int n = 0;
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    DebugStream.println("ArgumentControl Error: " + exception);
                }
                if (n < argument.getMinimum()) {
                    n = argument.getMinimum();
                } else if (n > argument.getMaximum()) {
                    n = argument.getMaximum();
                }
                JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(n, argument.getMinimum(), argument.getMaximum(), 1));
                jSpinner.setComponentOrientation(Dictionary.getOrientation());
                this.value_control = jSpinner;
                break;
            }
            case 6: 
            case 7: {
                this.value_control = new JTextField((String)object);
                this.value_control.setComponentOrientation(Dictionary.getOrientation());
                break;
            }
            case 4: {
                this.value_control = new GComboBox(CollectionDesignManager.language_manager.getLanguageCodes().toArray(), false);
                this.value_control.setComponentOrientation(Dictionary.getOrientation());
                ((JComboBox)this.value_control).setRenderer(new LanguageListCellRenderer());
                String string4 = CollectionDesignManager.language_manager.getLanguageName((String)object);
                if (string4 == null) break;
                ((JComboBox)this.value_control).setSelectedItem(object);
                break;
            }
            case 5: {
                String string5;
                String string6;
                boolean bl3;
                this.value_control = new GComboBox(MetadataSetManager.getEveryMetadataSetElement(), false);
                this.value_control.setComponentOrientation(Dictionary.getOrientation());
                if (Configuration.getMode() > 1) {
                    ((JComboBox)this.value_control).setEditable(true);
                }
                if ((string6 = string) == null || string6.equals("")) {
                    string6 = argument.getValue();
                }
                if ((string6 == null || string6.equals("")) && (string5 = argument.getDefaultValue()) != null) {
                    if (MetadataTools.getMetadataSetNamespace(string5).equals("")) {
                        string5 = "ex." + string5;
                    }
                    string6 = string5;
                }
                if (string6 == null || string6.equals("") || (bl3 = ArgumentControl.selectValue((JComboBox)this.value_control, string6))) break;
                ((JComboBox)this.value_control).addItem(string6);
                ((JComboBox)this.value_control).setSelectedItem(string6);
                break;
            }
            case 8: {
                this.value_control = new JComboBox();
                this.value_control.setComponentOrientation(Dictionary.getOrientation());
                File file = new File(Gatherer.getGLIMetadataDirectoryPath() + "exp" + ".mds");
                MetadataSet metadataSet = new MetadataSet(file);
                Gatherer.c_man.importMetadataSet(metadataSet);
                ArrayList arrayList = MetadataSetManager.getMetadataSets();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    MetadataSet metadataSet2 = (MetadataSet)arrayList.get(i);
                    if (metadataSet2.getNamespace().equals("ex")) continue;
                    ((JComboBox)this.value_control).addItem(metadataSet2);
                }
                ArgumentControl.selectValue((JComboBox)this.value_control, (String)object);
            }
        }
        if (argument.isRequired() || argument.isAssigned() || bl) {
            if (this.enabled != null) {
                this.enabled.setSelected(true);
            }
            if (this.value_control != null) {
                this.value_control.setOpaque(true);
                this.value_control.setBackground(Color.white);
                this.value_control.setEnabled(true);
                if (this.value_control instanceof JSpinner && (serializable = ((JSpinner)this.value_control).getEditor()) instanceof JSpinner.DefaultEditor) {
                    JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)serializable;
                    JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
                    jFormattedTextField.setEditable(true);
                    jFormattedTextField.setBackground(Color.white);
                }
            }
        } else {
            if (this.enabled != null) {
                this.enabled.setSelected(false);
            }
            if (this.value_control != null) {
                this.value_control.setOpaque(true);
                this.value_control.setBackground(Color.lightGray);
                this.value_control.setEnabled(false);
                if (this.value_control instanceof JSpinner && (serializable = ((JSpinner)this.value_control).getEditor()) instanceof JSpinner.DefaultEditor) {
                    JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)serializable;
                    JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
                    jFormattedTextField.setEditable(false);
                    jFormattedTextField.setBackground(Color.lightGray);
                }
            }
        }
        if (this.value_control != null) {
            if (argument.getType() != 0 && argument.getType() != 10) {
                this.value_control.setToolTipText(string2);
            }
            this.add((Component)this.value_control, "Center");
            if (!argument.isRequired()) {
                this.enabled.addActionListener(new EnabledListener(this.value_control));
            }
        }
    }

    public Argument getArgument() {
        return this.argument;
    }

    public String getArgumentName() {
        return this.argument.getName();
    }

    public String getValue() {
        if (this.value_control == null) {
            return null;
        }
        if (this.value_control instanceof JSpinner) {
            return ((JSpinner)this.value_control).getValue().toString();
        }
        if (this.value_control instanceof JComboBox) {
            Object object = ((JComboBox)this.value_control).getSelectedItem();
            if (object != null) {
                if (this.argument.getType() == 8) {
                    return ((MetadataSet)object).getNamespace();
                }
                if (object instanceof Argument.ArgumentOption) {
                    return ((Argument.ArgumentOption)object).name;
                }
                if (object instanceof MetadataElement) {
                    return ((MetadataElement)object).getFullName();
                }
                return object.toString();
            }
            return null;
        }
        if (this.value_control instanceof JTextField) {
            return ((JTextField)this.value_control).getText();
        }
        return null;
    }

    public JComponent getValueControl() {
        return this.value_control;
    }

    @Override
    public boolean isEnabled() {
        if (this.enabled == null) {
            return true;
        }
        return this.enabled.isSelected();
    }

    @Override
    public String toString() {
        return this.argument.getName();
    }

    public boolean updateArgument() {
        if (this.argument.isRequired() || this.enabled.isSelected()) {
            this.argument.setAssigned(false);
            String string = null;
            switch (this.argument.getType()) {
                case 0: {
                    Argument.ArgumentOption argumentOption = (Argument.ArgumentOption)((JComboBox)this.value_control).getSelectedItem();
                    this.argument.setValue(argumentOption.name);
                    this.argument.setAssigned(true);
                    return true;
                }
                case 10: {
                    Object object = ((JComboBox)this.value_control).getSelectedItem();
                    if (object instanceof Argument.ArgumentOption) {
                        this.argument.setValue(((Argument.ArgumentOption)object).name);
                    } else {
                        String string2 = object.toString();
                        if (string2.length() > 0) {
                            this.argument.setValue(string2);
                        } else {
                            String[] stringArray = new String[]{this.argument.getName()};
                            if (this.argument.isRequired()) {
                                JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.Required_Argument", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                            } else {
                                JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.No_Value", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                                this.argument.setValue(null);
                            }
                            stringArray = null;
                            return false;
                        }
                    }
                    this.argument.setAssigned(true);
                    return true;
                }
                case 1: {
                    this.argument.setAssigned(true);
                    return true;
                }
                case 3: {
                    string = ((JSpinner)this.value_control).getValue().toString();
                    if (string.length() > 0) {
                        try {
                            int n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            String[] stringArray = new String[]{this.argument.getName(), string};
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.Bad_Integer", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                            stringArray = null;
                            return false;
                        }
                    } else {
                        String[] stringArray = new String[]{this.argument.getName()};
                        if (this.argument.isRequired()) {
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.Required_Argument", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                        } else {
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.No_Value", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                            this.argument.setValue(null);
                        }
                        stringArray = null;
                        return false;
                    }
                    this.argument.setValue(string);
                    this.argument.setAssigned(true);
                    return true;
                }
                case 4: {
                    String string3 = ((JComboBox)this.value_control).getSelectedItem().toString();
                    this.argument.setValue(string3);
                    this.argument.setAssigned(true);
                    return true;
                }
                case 5: {
                    String string4 = ((JComboBox)this.value_control).getSelectedItem().toString();
                    if (string4.length() <= 0) {
                        String[] stringArray = new String[]{this.argument.getName()};
                        if (this.argument.isRequired()) {
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.Required_Argument", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                        } else {
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.No_Value", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                            this.argument.setValue(null);
                        }
                        stringArray = null;
                        return false;
                    }
                    this.argument.setValue(string4);
                    this.argument.setAssigned(true);
                    return true;
                }
                case 6: 
                case 7: {
                    string = ((JTextField)this.value_control).getText();
                    if (string.length() <= 0) {
                        String[] stringArray = new String[]{this.argument.getName()};
                        if (this.argument.isRequired()) {
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.Required_Argument", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                        } else {
                            JOptionPane.showMessageDialog(this, Dictionary.get("CDM.ArgumentConfiguration.No_Value", stringArray), Dictionary.get("CDM.ArgumentConfiguration.Error_Title"), 0);
                            this.argument.setValue(null);
                        }
                        stringArray = null;
                        return false;
                    }
                    this.argument.setValue(string);
                    this.argument.setAssigned(true);
                    return true;
                }
            }
            return false;
        }
        this.argument.setAssigned(false);
        return true;
    }

    public boolean updateArgument(boolean bl) {
        String string;
        if (bl) {
            return this.updateArgument();
        }
        if (this.argument.getType() == 6 && (string = ((JTextField)this.value_control).getText()).length() > 0) {
            this.argument.setValue(string);
            this.argument.setAssigned(true);
        }
        return true;
    }

    public static boolean selectValue(JComboBox jComboBox, String string) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            Object e = jComboBox.getItemAt(i);
            if (e instanceof Argument.ArgumentOption) {
                Argument.ArgumentOption argumentOption = (Argument.ArgumentOption)e;
                if (!argumentOption.name.startsWith(string)) continue;
                jComboBox.setSelectedIndex(i);
                jComboBox.setToolTipText(argumentOption.getToolTip());
                return true;
            }
            if (e instanceof MetadataElement) {
                if (!((MetadataElement)e).getFullName().equals(string)) continue;
                jComboBox.setSelectedIndex(i);
                return true;
            }
            if (!e.toString().equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public void setEnabled() {
        this.enabled.setSelected(true);
    }

    public void setValue(String string) {
        ((JTextField)this.value_control).setText(string);
    }

    private class ToolTipUpdater
    implements ActionListener {
        private ToolTipUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object instanceof Argument.ArgumentOption) {
                Argument.ArgumentOption argumentOption = (Argument.ArgumentOption)object;
                if (argumentOption != null) {
                    jComboBox.setToolTipText(argumentOption.getToolTip());
                } else {
                    jComboBox.setToolTipText("");
                }
            }
        }
    }

    private class EnabledListener
    implements ActionListener {
        private JComponent target = null;

        public EnabledListener(JComponent jComponent) {
            this.target = jComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSpinner jSpinner;
            JComponent jComponent;
            if (this.target == null) {
                return;
            }
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                this.target.setBackground(Color.white);
                this.target.setEnabled(true);
            } else {
                this.target.setBackground(Color.lightGray);
                this.target.setEnabled(false);
            }
            if (this.target instanceof JSpinner && (jComponent = (jSpinner = (JSpinner)this.target).getEditor()) instanceof JSpinner.DefaultEditor) {
                JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
                JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
                jFormattedTextField.setEditable(jCheckBox.isSelected());
                if (jCheckBox.isSelected()) {
                    jFormattedTextField.setBackground(Color.white);
                } else {
                    jFormattedTextField.setBackground(Color.lightGray);
                }
            }
        }
    }
}

