/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;

public class GAuthenticator
extends Authenticator {
    public static Hashtable authentications = new Hashtable();
    private boolean authentication_cancelled = false;
    private JButton cancel_button = null;
    private JButton ok_button = null;
    private JDialog dialog = null;
    private JPasswordField password = null;
    private static final Dimension SIZE = new Dimension(470, 160);
    public static final int REGULAR = 0;
    public static final int DOWNLOAD = 1;
    private static int operationMode = 0;

    public static void setMode(int n) {
        operationMode = n;
    }

    protected PasswordAuthentication getPasswordAuthentication(String string, String string2) {
        Object object;
        Object object2;
        if (operationMode == 1 && (object2 = (String)authentications.get(object = this.getRequestingHost() + ":" + this.getRequestingPort())) != null) {
            if (string == null) {
                string = ((String)object2).substring(0, ((String)object2).indexOf("@"));
            }
            if (string2 == null) {
                string2 = ((String)object2).substring(((String)object2).indexOf("@") + 1);
            }
            operationMode = 0;
            return new PasswordAuthentication(string, string2.toCharArray());
        }
        this.dialog = new JDialog(Gatherer.g_man, Dictionary.get("GAuthenticator.Title"), true);
        this.dialog.setModal(true);
        this.dialog.setSize(SIZE);
        object = (JPanel)this.dialog.getContentPane();
        object2 = new JLabel(this.getMessageString());
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Dictionary.get("GAuthenticator.Username"));
        JTextField jTextField = new JTextField();
        jTextField.setToolTipText(Dictionary.get("GAuthenticator.Username_Tooltip"));
        if (string != null) {
            jTextField.setText(string);
        }
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel(Dictionary.get("GAuthenticator.Password"));
        this.password = new JPasswordField();
        this.password.setEchoChar('*');
        this.password.setToolTipText(Dictionary.get("GAuthenticator.Password_Tooltip"));
        if (string2 != null) {
            this.password.setText(string2);
        }
        JPanel jPanel3 = new JPanel();
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        this.cancel_button.addActionListener(new AuthenticationActionListener(true));
        this.ok_button.addActionListener(new AuthenticationActionListener(false));
        this.password.addActionListener(new AuthenticationActionListener(false));
        jTextField.addActionListener(new RequestFocusListener(this.password));
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(jLabel2);
        jPanel2.add(this.password);
        jPanel3.setLayout(new GridLayout(1, 2));
        jPanel3.add(this.ok_button);
        jPanel3.add(this.cancel_button);
        ((Container)object).setLayout(new GridLayout(4, 1, 0, 2));
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ((Container)object).add((Component)object2);
        ((Container)object).add(jPanel);
        ((Container)object).add(jPanel2);
        ((Container)object).add(jPanel3);
        TestingPreparation.setNamesRecursively(this.dialog);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((dimension.width - GAuthenticator.SIZE.width) / 2, (dimension.height - GAuthenticator.SIZE.height) / 2);
        this.dialog.setVisible(true);
        if (!this.authentication_cancelled) {
            authentications.put(this.getRequestingHost() + ":" + this.getRequestingPort(), jTextField.getText() + "@" + new String(this.password.getPassword()));
            return new PasswordAuthentication(jTextField.getText(), this.password.getPassword());
        }
        return null;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        return this.getPasswordAuthentication(null, null);
    }

    protected String getMessageString() {
        return this.getRequestingPrompt();
    }

    private class RequestFocusListener
    implements ActionListener {
        private Component target = null;

        public RequestFocusListener(Component component) {
            this.target = component;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.target.requestFocus();
        }
    }

    private class AuthenticationActionListener
    implements ActionListener {
        private boolean cancel_action = false;

        public AuthenticationActionListener(boolean bl) {
            this.cancel_action = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GAuthenticator.this.authentication_cancelled = this.cancel_action;
            GAuthenticator.this.dialog.dispose();
        }
    }
}

