/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.core.Receptionist;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GSXSLT;
import org.greenstone.gsdl3.util.GlobalProperties;
import org.greenstone.gsdl3.util.XMLConverter;
import org.greenstone.gsdl3.util.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class TransformingReceptionist
extends Receptionist {
    static Logger logger = Logger.getLogger((String)TransformingReceptionist.class.getName());
    static final String preprocess_xsl_filename = GlobalProperties.getGSDL3Home() + File.separatorChar + "ui" + File.separatorChar + "xslt" + File.separatorChar + "preProcess.xsl";
    protected HashMap xslt_map = new HashMap();
    protected XMLTransformer transformer = new XMLTransformer();
    protected TransformerFactory transformerFactory = null;
    protected DOMParser parser = null;

    public TransformingReceptionist() {
        try {
            this.transformerFactory = TransformerFactoryImpl.newInstance();
            this.converter = new XMLConverter();
            this.parser = new DOMParser();
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            this.parser.setErrorHandler((ErrorHandler)new XMLConverter.ParseErrorHandler());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean configure() {
        if (this.config_params == null) {
            logger.error((Object)" config variables must be set before calling configure");
            return false;
        }
        if (this.mr == null) {
            logger.error((Object)" message router must be set  before calling configure");
            return false;
        }
        File interface_config_file = new File(GSFile.interfaceConfigFile(GSFile.interfaceHome(GlobalProperties.getGSDL3Home(), (String)this.config_params.get("interface_name"))));
        if (!interface_config_file.exists()) {
            logger.error((Object)(" interface config file: " + interface_config_file.getPath() + " not found!"));
            return false;
        }
        Document config_doc = this.converter.getDOM(interface_config_file, "utf-8");
        if (config_doc == null) {
            logger.error((Object)(" could not parse interface config file: " + interface_config_file.getPath()));
            return false;
        }
        Element config_elem = config_doc.getDocumentElement();
        String base_interface = config_elem.getAttribute("baseInterface");
        this.setUpBaseInterface(base_interface);
        this.setUpInterfaceOptions(config_elem);
        Element action_list = (Element)GSXML.getChildByTagName(config_elem, "actionList");
        NodeList actions = action_list.getElementsByTagName("action");
        for (int i = 0; i < actions.getLength(); ++i) {
            Element action = (Element)actions.item(i);
            String class_name = action.getAttribute("class");
            String action_name = action.getAttribute("name");
            Action ac = null;
            try {
                ac = (Action)Class.forName("org.greenstone.gsdl3.action." + class_name).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)(" couldn't load in action " + class_name));
                e.printStackTrace();
                continue;
            }
            ac.setConfigParams(this.config_params);
            ac.setMessageRouter(this.mr);
            ac.configure();
            ac.getActionParameters(this.params);
            this.action_map.put(action_name, ac);
            String xslt = action.getAttribute("xslt");
            if (!xslt.equals("")) {
                this.xslt_map.put(action_name, xslt);
            }
            NodeList subactions = action.getElementsByTagName("subaction");
            for (int j = 0; j < subactions.getLength(); ++j) {
                Element subaction = (Element)subactions.item(j);
                String subname = subaction.getAttribute("name");
                String subxslt = subaction.getAttribute("xslt");
                String map_key = action_name + ":" + subname;
                logger.debug((Object)("adding in to xslt map, " + map_key + "->" + subxslt));
                this.xslt_map.put(map_key, subxslt);
            }
        }
        Element lang_list = (Element)GSXML.getChildByTagName(config_elem, "languageList");
        if (lang_list == null) {
            logger.error((Object)" didn't find a language list in the config file!!");
        } else {
            this.language_list = (Element)this.doc.importNode(lang_list, true);
        }
        return true;
    }

    protected Node postProcessPage(Element page) {
        this.addExtraInfo(page);
        Node transformed_page = this.transformPage(page);
        return transformed_page;
    }

    protected void addExtraInfo(Element page) {
    }

    protected Node transformPage(Element page) {
        Element xsl_output;
        Document preprocessingXsl;
        String xslt_file;
        HashMap params;
        logger.debug((Object)"page before transfomring:");
        logger.debug((Object)XMLConverter.getPrettyString(page));
        Element request = (Element)GSXML.getChildByTagName(page, "pageRequest");
        String action = request.getAttribute("action");
        String subaction = request.getAttribute("subaction");
        String output = request.getAttribute("output");
        if (output.equals("xml")) {
            return page;
        }
        Element cgi_param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        String collection = "";
        if (cgi_param_list != null && (collection = (String)(params = GSXML.extractParams(cgi_param_list, false)).get("c")) == null) {
            collection = "";
        }
        if ((xslt_file = this.getXSLTFileName(action, subaction, collection)) == null) {
            return this.fileNotFoundErrorPage(xslt_file);
        }
        Document style_doc = this.converter.getDOM(new File(xslt_file), "UTF-8");
        String errorPage = this.converter.getParseErrorMessage();
        if (errorPage != null) {
            return XMLTransformer.constructErrorXHTMLPage("Cannot parse the xslt file: " + xslt_file + "\n" + errorPage);
        }
        if (style_doc == null) {
            logger.error((Object)" cant parse the xslt file needed, so returning the original page!");
            return page;
        }
        TransformingReceptionist transformingReceptionist = this;
        Document doc = transformingReceptionist.converter.newDOM();
        doc.appendChild(doc.importNode(page, true));
        Element page_response = (Element)GSXML.getChildByTagName(page, "pageResponse");
        Element format_elem = (Element)GSXML.getChildByTagName(page_response, "format");
        if (output.equals("formatelem")) {
            return format_elem;
        }
        if (format_elem != null) {
            logger.debug((Object)("format elem=" + XMLConverter.getPrettyString(format_elem)));
            String configStylesheet_file = GSFile.stylesheetFile(GlobalProperties.getGSDL3Home(), (String)this.config_params.get("site_name"), collection, (String)this.config_params.get("interface_name"), this.base_interfaces, "config_format.xsl");
            Document configStylesheet_doc = this.converter.getDOM(new File(configStylesheet_file));
            if (configStylesheet_doc != null) {
                TransformingReceptionist transformingReceptionist2 = this;
                Document format_doc = transformingReceptionist2.converter.newDOM();
                format_doc.appendChild(format_doc.importNode(format_elem, true));
                Node result = this.transformer.transform(configStylesheet_doc, format_doc);
                Element new_format = result.getNodeType() == 9 ? ((Document)result).getDocumentElement() : (Element)result;
                logger.debug((Object)("new format elem=" + XMLConverter.getPrettyString(new_format)));
                if (output.equals("newformat")) {
                    return new_format;
                }
                GSXSLT.mergeStylesheets(style_doc, new_format);
            } else {
                logger.error((Object)" couldn't parse the config_format stylesheet, adding the format info as is");
                GSXSLT.mergeStylesheets(style_doc, format_elem);
            }
            logger.debug((Object)"the converted stylesheet is:");
            logger.debug((Object)XMLConverter.getPrettyString(style_doc.getDocumentElement()));
        }
        Document oldStyle_doc = style_doc;
        try {
            preprocessingXsl = this.getPreprocessDoc();
            String errMsg = ((XMLConverter.ParseErrorHandler)this.parser.getErrorHandler()).getErrorMessage();
            if (errMsg != null) {
                return XMLTransformer.constructErrorXHTMLPage("error loading preprocess xslt file: " + preprocess_xsl_filename + "\n" + errMsg);
            }
        }
        catch (FileNotFoundException e) {
            return this.fileNotFoundErrorPage(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error loading preprocess xslt");
            return XMLTransformer.constructErrorXHTMLPage("error loading preprocess xslt\n" + e.getMessage());
        }
        Document libraryXsl = null;
        try {
            libraryXsl = this.getLibraryDoc();
            String errMsg = ((XMLConverter.ParseErrorHandler)this.parser.getErrorHandler()).getErrorMessage();
            if (errMsg != null) {
                return XMLTransformer.constructErrorXHTMLPage("Error loading xslt file: " + this.getLibraryXSLFilename() + "\n" + errMsg);
            }
        }
        catch (FileNotFoundException e) {
            return this.fileNotFoundErrorPage(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error loading library xslt");
            return XMLTransformer.constructErrorXHTMLPage("error loading library xslt\n" + e.getMessage());
        }
        Document skinAndLibraryXsl = null;
        TransformingReceptionist transformingReceptionist3 = this;
        Document skinAndLibraryDoc = transformingReceptionist3.converter.newDOM();
        try {
            TransformingReceptionist transformingReceptionist4 = this;
            skinAndLibraryXsl = transformingReceptionist4.converter.newDOM();
            Element root = skinAndLibraryXsl.createElement("skinAndLibraryXsl");
            skinAndLibraryXsl.appendChild(root);
            Element s = skinAndLibraryXsl.createElement("skinXsl");
            s.appendChild(skinAndLibraryXsl.importNode(style_doc.getDocumentElement(), true));
            root.appendChild(s);
            Element l = skinAndLibraryXsl.createElement("libraryXsl");
            Element libraryXsl_el = libraryXsl.getDocumentElement();
            l.appendChild(skinAndLibraryXsl.importNode(libraryXsl_el, true));
            root.appendChild(l);
            Transformer preProcessor = this.transformerFactory.newTransformer(new DOMSource(preprocessingXsl));
            preProcessor.setErrorListener(new XMLTransformer.TransformErrorListener());
            DOMResult result = new DOMResult();
            result.setNode(skinAndLibraryDoc);
            preProcessor.transform(new DOMSource(skinAndLibraryXsl), result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            System.out.println("TransformerException while preprocessing the skin xslt");
            return XMLTransformer.constructErrorXHTMLPage(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error while preprocessing the skin xslt");
            return XMLTransformer.constructErrorXHTMLPage(e.getMessage());
        }
        GSXSLT.absoluteIncludePaths(skinAndLibraryDoc, GlobalProperties.getGSDL3Home(), (String)this.config_params.get("site_name"), collection, (String)this.config_params.get("interface_name"), this.base_interfaces);
        GSXSLT.absoluteIncludePaths(oldStyle_doc, GlobalProperties.getGSDL3Home(), (String)this.config_params.get("site_name"), collection, (String)this.config_params.get("interface_name"), this.base_interfaces);
        if (output.equals("skindoc")) {
            return this.converter.getDOM(this.getStringFromDocument(style_doc));
        }
        if (output.equals("skinandlib")) {
            return this.converter.getDOM(this.getStringFromDocument(skinAndLibraryXsl));
        }
        if (output.equals("skinandlibdoc")) {
            return this.converter.getDOM(this.getStringFromDocument(skinAndLibraryDoc));
        }
        if (output.equals("oldskindoc")) {
            return this.converter.getDOM(this.getStringFromDocument(oldStyle_doc));
        }
        String qualifiedName = "html";
        String publicID = "-//W3C//DTD HTML 4.01 Transitional//EN";
        String systemID = "http://www.w3.org/TR/html4/loose.dtd";
        Element root = skinAndLibraryDoc.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("xsl:output");
        if (nodes.getLength() != 0 && (xsl_output = (Element)nodes.item(nodes.getLength() - 1)) != null) {
            String attrValue = xsl_output.getAttribute("doctype-system");
            systemID = attrValue.equals("") ? systemID : attrValue;
            attrValue = xsl_output.getAttribute("doctype-public");
            publicID = attrValue.equals("") ? publicID : attrValue;
        }
        Document docWithDoctype = XMLConverter.newDOM(qualifiedName, publicID, systemID);
        return this.transformer.transform(skinAndLibraryDoc, doc, this.config_params, docWithDoctype);
    }

    protected String getStringFromDocument(Document doc) {
        String content = "";
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            content = writer.toString();
            System.out.println("Change the & to &Amp; for proper debug dispay");
            content = content.replaceAll("&", "&amp;");
            writer.flush();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
        return content;
    }

    protected Document getPreprocessDoc() throws Exception {
        File xslt_file = new File(preprocess_xsl_filename);
        FileReader reader = new FileReader(xslt_file);
        InputSource xml_source = new InputSource(reader);
        this.parser.parse(xml_source);
        Document doc = this.parser.getDocument();
        return doc;
    }

    protected Document getLibraryDoc() throws Exception {
        Document doc = null;
        File xslt_file = new File(this.getLibraryXSLFilename());
        FileReader reader = new FileReader(xslt_file);
        InputSource xml_source = new InputSource(reader);
        this.parser.parse(xml_source);
        doc = this.parser.getDocument();
        return doc;
    }

    protected String getXSLTFileName(String action, String subaction, String collection) {
        String stylesheet;
        String name = null;
        if (!subaction.equals("")) {
            String key = action + ":" + subaction;
            name = (String)this.xslt_map.get(key);
        }
        if (name == null) {
            name = (String)this.xslt_map.get(action);
        }
        if ((stylesheet = GSFile.stylesheetFile(GlobalProperties.getGSDL3Home(), (String)this.config_params.get("site_name"), collection, (String)this.config_params.get("interface_name"), this.base_interfaces, name)) == null) {
            logger.info((Object)(" cant find stylesheet for " + name));
        }
        return stylesheet;
    }

    protected String getLibraryXSLFilename() {
        return GSFile.xmlTransformDir(GSFile.interfaceHome(GlobalProperties.getGSDL3Home(), (String)this.config_params.get("interface_name"))) + File.separatorChar + "library.xsl";
    }

    protected Document fileNotFoundErrorPage(String filenameMessage) {
        String errorMessage = "ERROR missing file: " + filenameMessage;
        Element errPage = XMLTransformer.constructErrorXHTMLPage(errorMessage);
        logger.error((Object)errorMessage);
        System.err.println("****" + errorMessage);
        return errPage.getOwnerDocument();
    }
}

