/*
 * Decompiled with CFR 0.152.
 */
package org.nzdl.gsdl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplyXSLT {
    public static final String DOC_START = new String("<?DocStart?>");
    public static final String DOC_END = new String("<?DocEnd?>");
    public static final String INPUT_END = new String("<?Done?>");
    private static final String RECORD_ELEMENT = "record";
    private static final String CONTROLFIELD_ELEMENT = "controlfield";
    private static final String SUBFIELD_ELEMENT = "subfield";
    private static final String LEADER_ELEMENT = "leader";
    private final int BEFORE_READING = 0;
    private final int IS_READING = 1;
    private String xsl_file;
    private String mapping_file;
    private String sourcelang;
    private String targetlang;
    private HashMap paramMap;

    public ApplyXSLT(String string, String string2, HashMap hashMap) {
        this.initParams(string, string2, hashMap);
    }

    public ApplyXSLT(String string, String string2, String string3, HashMap hashMap) {
        this.xsl_file = string;
        this.initParams(string2, string3, hashMap);
    }

    public ApplyXSLT(String string, String string2, String string3, String string4, HashMap hashMap) {
        this.xsl_file = string;
        this.mapping_file = string2;
        this.initParams(string3, string4, hashMap);
    }

    private void initParams(String string, String string2, HashMap hashMap) {
        this.sourcelang = string;
        this.targetlang = string2;
        if (string.equals("") && !string2.equals("")) {
            this.sourcelang = "en";
        }
        this.paramMap = hashMap;
    }

    private boolean process() {
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(System.in, "UTF8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = new String();
            while ((string = bufferedReader.readLine()) != null) {
                if (!bl) {
                    if (string.compareTo(DOC_START) == 0) {
                        string2 = bufferedReader.readLine();
                        if (string2 == null) {
                            return false;
                        }
                        bl = true;
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    if (string.compareTo(INPUT_END) == 0) {
                        return true;
                    }
                    bl = false;
                    continue;
                }
                if (bl) {
                    if (string.compareTo(DOC_END) == 0) {
                        boolean bl2 = false;
                        bl2 = this.mapping_file != null && !this.mapping_file.equals("") ? this.translateXMLWithMapping(stringBuffer.toString(), string2) : this.translateXML(stringBuffer.toString(), string2);
                        if (!bl2) {
                            return false;
                        }
                        bl = false;
                        continue;
                    }
                    stringBuffer.append(string + "\n");
                    continue;
                }
                System.err.println("Undefined system status in ApplyXSLT.java main().");
                System.exit(-1);
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Receiving piped data error!" + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    private boolean processPipedFromStdIn() {
        try {
            ReadStreamGobbler readStreamGobbler = new ReadStreamGobbler(System.in, true);
            readStreamGobbler.start();
            readStreamGobbler.join();
            String string = readStreamGobbler.getOutput();
            boolean bl = false;
            bl = this.mapping_file != null && !this.mapping_file.equals("") ? this.translateXMLWithMapping(string, null) : this.translateXML(string, null);
            if (!bl) {
                System.err.println("Translation Failed!!");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Receiving piped data error!" + exception.toString());
            exception.printStackTrace();
            return false;
        }
    }

    private boolean translateXML(String string, String string2) throws IOException, TransformerException, TransformerConfigurationException, FileNotFoundException {
        StringReader stringReader = new StringReader(string);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(this.xsl_file));
        this.setTransformerParams(transformer);
        if (string2 != null) {
            transformer.transform(new StreamSource(stringReader), new StreamResult(new FileOutputStream(string2)));
        } else {
            transformer.transform(new StreamSource(stringReader), new StreamResult(System.out));
        }
        return true;
    }

    private boolean translateXMLWithMapping(String string, String string2) throws IOException, TransformerException, TransformerConfigurationException, FileNotFoundException {
        StringReader stringReader = new StringReader(string);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(this.xsl_file));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.mapping_file);
            Element element = document.getDocumentElement();
            transformer.setParameter("mapping", element);
            this.setTransformerParams(transformer);
            Document document2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            transformer.transform(new StreamSource(stringReader), new DOMResult(document2));
            this.calculateRecordsLength(document2);
            transformer = transformerFactory.newTransformer();
            transformer.transform(new DOMSource(document2), new StreamResult(new FileOutputStream(string2)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void calculateRecordsLength(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(RECORD_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            this.calculateRecordLength(element);
        }
    }

    private void calculateRecordLength(Element element) {
        Object object;
        int n = 0;
        NodeList nodeList = element.getElementsByTagName(CONTROLFIELD_ELEMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            n += this.getElementTextValue(element2).length();
        }
        NodeList nodeList2 = element.getElementsByTagName(SUBFIELD_ELEMENT);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = (Element)nodeList2.item(i);
            n += this.getElementTextValue((Element)object).length();
        }
        String string = n + "";
        if (n < 10000) {
            string = "0" + string;
            if (n < 1000) {
                string = "0" + string;
            }
            if (n < 100) {
                string = "0" + string;
            }
            if (n < 10) {
                string = "0" + string;
            }
        }
        if ((object = element.getElementsByTagName(LEADER_ELEMENT)).getLength() > 0) {
            Element element3 = (Element)object.item(0);
            this.removeFirstTextNode(element3);
            element3.insertBefore(element3.getOwnerDocument().createTextNode(string), element3.getFirstChild());
        }
    }

    private void removeFirstTextNode(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            element.removeChild(node);
            return;
        }
    }

    private String getElementTextValue(Element element) {
        String string = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            string = string + node.getNodeValue();
        }
        return string;
    }

    private void setMappingVariable(Document document) {
        for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            String string = node.getNodeName();
            if (!string.equals("xsl:variable") || !(element = (Element)node).getAttribute("name").trim().equals("mapping")) continue;
            element.setAttribute("select", "document('" + this.mapping_file + "')/Mapping");
        }
    }

    private void setTransformerParams(Transformer transformer) {
        if (this.targetlang != "") {
            transformer.setParameter("sourcelang", this.sourcelang);
            transformer.setParameter("targetlang", this.targetlang);
        }
        for (Map.Entry entry : this.paramMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            transformer.setParameter(string, string2);
        }
    }

    private void translate(String string, String string2, String string3) throws IOException, TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(string2));
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = string3.equals("") ? new OutputStreamWriter((OutputStream)System.out, "UTF-8") : new OutputStreamWriter((OutputStream)new FileOutputStream(string3), "UTF-8");
        this.setTransformerParams(transformer);
        transformer.transform(new StreamSource(new File(string)), new StreamResult(outputStreamWriter));
    }

    private void translateWithMapping(String string, String string2, String string3, String string4) throws IOException, TransformerException, TransformerConfigurationException, FileNotFoundException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(string2));
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = string4.equals("") ? new OutputStreamWriter((OutputStream)System.out, "UTF-8") : new OutputStreamWriter((OutputStream)new FileOutputStream(string4), "UTF-8");
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(string3);
            Element element = document.getDocumentElement();
            transformer.setParameter("mapping", element);
        }
        catch (Exception exception) {
            System.err.println("Couldn't load in mapping file");
            exception.printStackTrace();
        }
        this.setTransformerParams(transformer);
        transformer.transform(new StreamSource(new File(string)), new StreamResult(outputStreamWriter));
    }

    public static String replaceAll(String string, String string2, String string3) {
        return string.replaceAll(string2, string3);
    }

    public static String getChunkString(String string) {
        int n = string.indexOf("[");
        if (n != 0) {
            return string;
        }
        n = string.indexOf("{");
        int n2 = string.lastIndexOf("}");
        if (n != -1 && n2 != -1) {
            return string.substring(n + 1, n2);
        }
        return string;
    }

    public static String getChunkAttr(String string) {
        int n = string.indexOf("[");
        if (n != 0) {
            return string;
        }
        n = string.indexOf("{");
        int n2 = string.lastIndexOf("}");
        if (n != -1 && n2 != -1 && (n2 = string.lastIndexOf("]", n)) > 1) {
            return string.substring(1, n2).trim();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        block21: {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            boolean bl = false;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = -1;
            if (stringArray.length < 1) {
                ApplyXSLT.printUsage();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-m") && i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    string3 = stringArray[++i];
                    ApplyXSLT.checkFile(string3.replaceAll("file:///", ""));
                    continue;
                }
                if (stringArray[i].equals("-x") && i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    string = stringArray[++i];
                    ApplyXSLT.checkFile(string.replaceAll("file:///", ""));
                    continue;
                }
                if (stringArray[i].equals("-t") && i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    string2 = stringArray[++i];
                    ApplyXSLT.checkFile(string2.replaceAll("file:///", ""));
                    continue;
                }
                if (stringArray[i].equals("-o") && i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-s") && i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-l") && i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-c")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-h")) {
                    ApplyXSLT.printUsage();
                    continue;
                }
                n = stringArray[i].indexOf("=");
                if (n != -1) {
                    String string7 = stringArray[i].substring(0, n);
                    String string8 = stringArray[i].substring(n + 1);
                    hashMap.put(string7, string8);
                    n = -1;
                    continue;
                }
                ApplyXSLT.printUsage();
            }
            ApplyXSLT applyXSLT = null;
            if (string.equals("") && !string2.equals("")) {
                applyXSLT = string3.equals("") ? new ApplyXSLT(string2, string5, string6, hashMap) : new ApplyXSLT(string2, string3, string5, string6, hashMap);
                if (applyXSLT != null) {
                    if (bl) {
                        applyXSLT.processPipedFromStdIn();
                    }
                    applyXSLT.process();
                } else {
                    ApplyXSLT.printUsage();
                }
            } else if (!string.equals("") && !string2.equals("")) {
                applyXSLT = new ApplyXSLT(string5, string6, hashMap);
                try {
                    if (string3.equals("")) {
                        applyXSLT.translate(string, string2, string4);
                        break block21;
                    }
                    applyXSLT.translateWithMapping(string, string2, string3, string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                ApplyXSLT.printUsage();
            }
        }
    }

    private static void checkFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Error: " + string + " doesn't exist!");
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: ApplyXSLT -x File -t File [-m File] [-o File] [-s sourcelang] [-l targetlang] [param-name=param-value]");
        System.out.println("\t-x specifies the xml file (Note: optional for piped xml data)");
        System.out.println("\t-c read xml file piped from stdin but without DocStart/DocEnd markers. Writes to stdout");
        System.out.println("\t-t specifies the xsl file");
        System.out.println("\t-m specifies the mapping file (for MARCXMLPlugout.pm only)");
        System.out.println("\t-o specifies the output file name (output to screen if this option is absent)");
        System.out.println("\t-s specifies the input language code for generating TMX file. Defaults to 'en' if none is provided");
        System.out.println("\t-l specifies the output language code. Required if generating a TMX file.");
        System.out.println("\tFor general transformations of an XML by an XSLT, you can pass in parameter name=value pairs if any need to passed on into the XSLT as xsl params.");
        System.exit(-1);
    }

    class ReadStreamGobbler
    extends Thread {
        InputStream is = null;
        StringBuffer outputstr = new StringBuffer();
        boolean split_newlines = false;

        public ReadStreamGobbler(InputStream inputStream) {
            this.is = inputStream;
            this.split_newlines = false;
        }

        public ReadStreamGobbler(InputStream inputStream, boolean bl) {
            this.is = inputStream;
            this.split_newlines = bl;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.outputstr.append(string);
                    if (!this.split_newlines) continue;
                    this.outputstr.append("\n");
                }
                System.err.println("ReadStreamGobbler:run() finished.  Closing resource");
                this.closeResource(bufferedReader);
            }
            catch (IOException iOException) {
                try {
                    iOException.printStackTrace();
                    System.err.println("ReadStreamGobbler:run() finished.  Closing resource");
                    this.closeResource(bufferedReader);
                }
                catch (Throwable throwable) {
                    System.err.println("ReadStreamGobbler:run() finished.  Closing resource");
                    this.closeResource(bufferedReader);
                    throw throwable;
                }
            }
        }

        public String getOutput() {
            return this.outputstr.toString();
        }

        public void closeResource(Closeable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                    closeable = null;
                }
            }
            catch (Exception exception) {
                System.err.println("Exception closing resource: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

