extdesc="the ImageMagick extension"

full_setup=`pwd`/${BASH_SOURCE}
fulldir=${full_setup%/*}
fulldir=${fulldir%/.}

if [ "x$GSDLHOME" = "x" ] ; then
  if [ -e ../../setup.bash ] ; then
    export gsopt_noexts=1 && pushd ../.. && source setup.bash && popd 
    export gsopt_noexts=
  else
    # backstop
    GSDLOS=`uname -s | tr '[A-Z]' '[a-z]'`
    # check for running bash under cygwin
    if test "`echo $GSDLOS | sed 's/cygwin//'`" != "$GSDLOS" ; then
      GSDLOS=windows
    fi 

  fi
fi

if [ "x$GEXTIMAGEMAGICK" = "x" ] ; then
  export GEXTIMAGEMAGICK=$fulldir
  export GEXTIMAGEMAGICK_INSTALLED=$GEXTIMAGEMAGICK/$GSDLOS

  # Developer setting (for compilation: configure in ImageMagick)
  # better in devel.bash?
  export PKG_CONFIG_PATH="$GEXTIMAGEMAGICK_INSTALLED/lib/pkgconfig:$PKG_CONFIG_PATH"

  export MAGICK_HOME=$GEXTIMAGEMAGICK_INSTALLED
  export PATH=$GEXTIMAGEMAGICK_INSTALLED/bin:$GEXTIMAGEMAGICK_INSTALLED/script:$PATH

  if [ "x$LD_LIBRARY_PATH" = "x" ] ; then
    export LD_LIBRARY_PATH=$GEXTIMAGEMAGICK_INSTALLED/lib
  else
    export LD_LIBRARY_PATH=$GEXTIMAGEMAGICK_INSTALLED/lib:$LD_LIBRARY_PATH
  fi
  if [ "x$DYLD_FALLBACK_LIBRARY_PATH" = "x" ] ; then
    export DYLD_FALLBACK_LIBRARY_PATH=$GEXTIMAGEMAGICK_INSTALLED/lib
  else
    export DYLD_FALLBACK_LIBRARY_PATH=$GEXTIMAGEMAGICK_INSTALLED/lib:$DYLD_FALLBACK_LIBRARY_PATH
  fi

  if [ -e "devel-srcpack" ] ; then
    export LD_LIBRARY_PATH=$GEXTIMAGEMAGICK_INSTALLED/devel/lib:$LD_LIBRARY_PATH
    export DYLD_FALLBACK_LIBRARY_PATH=$GEXTIMAGEMAGICK_INSTALLED/devel/lib:$DYLD_FALLBACK_LIBRARY_PATH
  fi

  
  extdir=${GEXTIMAGEMAGICK##*/}

  if [ "x$GSDLEXTS" = "x" ] ; then
    export GSDLEXTS=$extdir
  else 
    export GSDLEXTS=$GSDLEXTS:$extdir
  fi


  echo "+Your environment is now setup for $extdesc"
else
  echo "+Your environment is already setup for $extdesc"
fi
