/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Scanner;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.util.Utility;

public class SafeProcess {
    public static int DEBUG = 0;
    public static final int STDERR = 0;
    public static final int STDOUT = 1;
    public static final int STDIN = 2;
    public static String WIN_KILL_CMD;
    public Boolean interruptible = Boolean.TRUE;
    private String command = null;
    private String[] command_args = null;
    private String[] envp = null;
    private File dir = null;
    private String inputStr = null;
    private Process process = null;
    private boolean forciblyTerminateProcess = false;
    private Thread theProcessThread = null;
    private String outputStr = "";
    private String errorStr = "";
    private int exitValue = -1;
    private ExceptionHandler exceptionHandler = null;
    private MainProcessHandler mainHandler = null;
    private boolean splitStdOutputNewLines = false;
    private boolean splitStdErrorNewLines = false;

    public SafeProcess(String[] stringArray) {
        this.command_args = stringArray;
    }

    public SafeProcess(String string) {
        this.command = string;
    }

    public SafeProcess(String[] stringArray, String[] stringArray2, File file) {
        this.command_args = stringArray;
        this.envp = stringArray2;
        this.dir = file;
    }

    public String getStdOutput() {
        return this.outputStr;
    }

    public String getStdError() {
        return this.errorStr;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public void setInputString(String string) {
        this.inputStr = string;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setMainHandler(MainProcessHandler mainProcessHandler) {
        this.mainHandler = mainProcessHandler;
    }

    public void setSplitStdOutputNewLines(boolean bl) {
        this.splitStdOutputNewLines = bl;
    }

    public void setSplitStdErrorNewLines(boolean bl) {
        this.splitStdErrorNewLines = bl;
    }

    public boolean cancelRunningProcess() {
        boolean bl = true;
        return this.cancelRunningProcess(!bl);
    }

    public synchronized boolean cancelRunningProcess(boolean bl) {
        if (this.process == null) {
            SafeProcess.log("@@@ No Java process to interrupt.");
            return false;
        }
        boolean bl2 = false;
        if (this.interruptible.booleanValue()) {
            if (this.theProcessThread != null) {
                this.theProcessThread.interrupt();
                SafeProcess.log("@@@ Successfully sent interrupt to process.");
                bl2 = true;
            }
        } else {
            if (!bl && SwingUtilities.isEventDispatchThread()) {
                SafeProcess.log("#### Event Dispatch thread, returning");
                return false;
            }
            while (!this.interruptible.booleanValue()) {
                SafeProcess.log("######### Waiting for process to become interruptible...");
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    SafeProcess.log("@@@ Interrupted exception while waiting for SafeProcess' worker threads to finish joining on cancelling process");
                }
            }
        }
        return bl2;
    }

    private Process doRuntimeExec() throws IOException {
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        if (this.command != null) {
            SafeProcess.log("SafeProcess running: " + this.command);
            DebugStream.println("  SafeProcess running: " + this.command);
            process = runtime.exec(this.command);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.command_args.length; ++i) {
                stringBuffer.append(" ").append(this.command_args[i]);
            }
            SafeProcess.log("SafeProcess running: [" + stringBuffer + "]");
            DebugStream.println("  SafeProcess running: [" + stringBuffer + "]");
            stringBuffer = null;
            process = this.envp == null && this.dir == null ? runtime.exec(this.command_args) : (this.dir == null ? runtime.exec(this.command_args, this.envp) : runtime.exec(this.command_args, this.envp, this.dir));
        }
        this.theProcessThread = Thread.currentThread();
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitForWithStreams(OutputStreamGobbler outputStreamGobbler, InputStreamGobbler inputStreamGobbler, InputStreamGobbler inputStreamGobbler2) throws IOException, InterruptedException {
        outputStreamGobbler.start();
        inputStreamGobbler2.start();
        inputStreamGobbler.start();
        try {
            this.exitValue = this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            SafeProcess.log("*** Process interrupted (InterruptedException). Expected to be a Cancel operation.");
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(interruptedException);
            }
            outputStreamGobbler.interrupt();
            inputStreamGobbler2.interrupt();
            inputStreamGobbler.interrupt();
            this.forciblyTerminateProcess = true;
        }
        finally {
            if (this.mainHandler != null) {
                this.forciblyTerminateProcess = this.mainHandler.beforeWaitingForStreamsToEnd(this.forciblyTerminateProcess);
            }
            Object object = this.interruptible;
            synchronized (object) {
                this.interruptible = Boolean.FALSE;
            }
            inputStreamGobbler.join();
            inputStreamGobbler2.join();
            outputStreamGobbler.join();
            object = this.interruptible;
            synchronized (object) {
                this.interruptible = Boolean.TRUE;
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
            this.outputStr = inputStreamGobbler.getOutput();
            this.errorStr = inputStreamGobbler2.getOutput();
            if (this.mainHandler != null) {
                this.forciblyTerminateProcess = this.mainHandler.afterStreamsEnded(this.forciblyTerminateProcess);
            }
        }
        return this.exitValue;
    }

    public synchronized boolean processRunning() {
        if (this.process == null) {
            return false;
        }
        return SafeProcess.processRunning(this.process);
    }

    public int runBasicProcess() {
        try {
            this.forciblyTerminateProcess = true;
            this.process = this.doRuntimeExec();
            this.exitValue = this.process.waitFor();
            this.forciblyTerminateProcess = false;
        }
        catch (IOException iOException) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(iOException);
            } else {
                SafeProcess.log("IOException: " + iOException.getMessage(), iOException);
            }
        }
        catch (InterruptedException interruptedException) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(interruptedException);
            } else {
                SafeProcess.log("Process InterruptedException: " + interruptedException.getMessage(), interruptedException);
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanUp("SafeProcess.runBasicProcess");
        }
        return this.exitValue;
    }

    public int runProcess() {
        return this.runProcess(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(CustomProcessHandler customProcessHandler, CustomProcessHandler customProcessHandler2, CustomProcessHandler customProcessHandler3) {
        OutputStreamGobbler outputStreamGobbler = null;
        InputStreamGobbler inputStreamGobbler = null;
        InputStreamGobbler inputStreamGobbler2 = null;
        try {
            this.forciblyTerminateProcess = false;
            this.process = this.doRuntimeExec();
            outputStreamGobbler = customProcessHandler == null ? new OutputStreamGobbler(this.process.getOutputStream(), this.inputStr) : new OutputStreamGobbler(this.process.getOutputStream(), customProcessHandler);
            inputStreamGobbler = customProcessHandler3 == null ? new InputStreamGobbler(this.process.getErrorStream(), this.splitStdErrorNewLines) : new InputStreamGobbler(this.process.getErrorStream(), customProcessHandler3);
            inputStreamGobbler2 = customProcessHandler2 == null ? new InputStreamGobbler(this.process.getInputStream(), this.splitStdOutputNewLines) : new InputStreamGobbler(this.process.getInputStream(), customProcessHandler2);
            this.exitValue = this.waitForWithStreams(outputStreamGobbler, inputStreamGobbler2, inputStreamGobbler);
        }
        catch (IOException iOException) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(iOException);
            } else {
                SafeProcess.log("IOexception: " + iOException.getMessage(), iOException);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(interruptedException);
                SafeProcess.log("@@@@ Unexpected InterruptedException when waiting for process stream gobblers to die");
            } else {
                SafeProcess.log("*** Unexpected InterruptException when waiting for process stream gobblers to die: " + interruptedException.getMessage(), interruptedException);
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanUp("SafeProcess.runProcess(3 params)");
        }
        return this.exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(LineByLineHandler lineByLineHandler, LineByLineHandler lineByLineHandler2) {
        OutputStreamGobbler outputStreamGobbler = null;
        InputStreamGobbler inputStreamGobbler = null;
        InputStreamGobbler inputStreamGobbler2 = null;
        try {
            this.forciblyTerminateProcess = false;
            this.process = this.doRuntimeExec();
            outputStreamGobbler = new OutputStreamGobbler(this.process.getOutputStream(), this.inputStr);
            inputStreamGobbler = new InputStreamGobbler(this.process.getErrorStream(), this.splitStdErrorNewLines);
            inputStreamGobbler2 = new InputStreamGobbler(this.process.getInputStream(), this.splitStdOutputNewLines);
            if (lineByLineHandler != null) {
                inputStreamGobbler2.setLineByLineHandler(lineByLineHandler);
            }
            if (lineByLineHandler2 != null) {
                inputStreamGobbler.setLineByLineHandler(lineByLineHandler2);
            }
            this.exitValue = this.waitForWithStreams(outputStreamGobbler, inputStreamGobbler2, inputStreamGobbler);
        }
        catch (IOException iOException) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(iOException);
            } else {
                SafeProcess.log("IOexception: " + iOException.getMessage(), iOException);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forciblyTerminateProcess = true;
            if (this.exceptionHandler != null) {
                this.exceptionHandler.gotException(interruptedException);
                SafeProcess.log("@@@@ Unexpected InterruptedException when waiting for process stream gobblers to die");
            } else {
                SafeProcess.log("*** Unexpected InterruptException when waiting for process stream gobblers to die: " + interruptedException.getMessage(), interruptedException);
            }
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanUp("SafeProcess.runProcess(2 params)");
        }
        return this.exitValue;
    }

    private void cleanUp(String string) {
        boolean bl;
        if (this.forciblyTerminateProcess) {
            SafeProcess.log("*** Going to call process.destroy from " + string);
            if (this.mainHandler != null) {
                this.mainHandler.beforeProcessDestroy();
            }
            bl = true;
            SafeProcess.destroyProcess(this.process, bl);
            if (this.mainHandler != null) {
                this.mainHandler.afterProcessDestroy();
            }
            SafeProcess.log("*** Have called process.destroy from " + string);
        }
        this.process = null;
        this.theProcessThread = null;
        bl = this.forciblyTerminateProcess;
        this.forciblyTerminateProcess = false;
        if (this.mainHandler != null) {
            this.mainHandler.doneCleanup(bl);
        }
    }

    public static long getProcessID(Process process) {
        long l = -1L;
        try {
            if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
                Field field = process.getClass().getDeclaredField("handle");
                field.setAccessible(true);
                long l2 = field.getLong(process);
                Kernel32 kernel32 = Kernel32.INSTANCE;
                WinNT.HANDLE hANDLE = new WinNT.HANDLE();
                hANDLE.setPointer(Pointer.createConstant(l2));
                l = kernel32.GetProcessId(hANDLE);
                field.setAccessible(false);
            } else if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field field = process.getClass().getDeclaredField("pid");
                field.setAccessible(true);
                l = field.getLong(process);
                field.setAccessible(false);
            }
        }
        catch (Exception exception) {
            SafeProcess.log("SafeProcess.getProcessID(): Exception when attempting to get process ID for process " + exception.getMessage(), exception);
            l = -1L;
        }
        return l;
    }

    static void killWinProcessWithID(long l) {
        String string = SafeProcess.getWinProcessKillCmd(l);
        if (string == null) {
            return;
        }
        try {
            SafeProcess.log("\tAttempting to terminate Win subprocess with pid: " + l);
            SafeProcess safeProcess = new SafeProcess(string);
            int n = safeProcess.runProcess();
        }
        catch (Exception exception) {
            SafeProcess.log("@@@ Exception attempting to stop perl " + exception.getMessage(), exception);
        }
    }

    static boolean killUnixProcessWithID(long l, boolean bl, boolean bl2) {
        String string;
        String string2 = string = bl ? "KILL" : "TERM";
        String string3 = bl2 ? (Utility.isMac() ? "pkill -" + string + " -P " + l : "kill -" + string + " -" + l) : "kill -" + string + " " + l;
        SafeProcess safeProcess = new SafeProcess(string3);
        int n = safeProcess.runProcess();
        if (n == 0) {
            if (bl) {
                SafeProcess.log("@@@ Successfully sent SIGKILL to unix process tree rooted at " + l);
            } else {
                SafeProcess.log("@@@ Successfully sent SIGTERM to unix process tree rooted at " + l);
            }
            return true;
        }
        if (n == 1 && safeProcess.getStdOutput().trim().equals("") && safeProcess.getStdError().trim().equals("")) {
            SafeProcess.log("@@@ Sending termination signal returned exit value 1. On unix this can happen when the process has already been terminated.");
            return true;
        }
        SafeProcess.log("@@@ Not able to successfully terminate process. Got exitvalue: " + n);
        SafeProcess.log("@@@ Got output: |" + safeProcess.getStdOutput() + "|");
        SafeProcess.log("@@@ Got err output: |" + safeProcess.getStdError() + "|");
        return false;
    }

    public static void destroyProcess(Process process) {
        boolean bl = true;
        SafeProcess.destroyProcess(process, !bl);
    }

    private static void destroyProcess(Process process, boolean bl) {
        SafeProcess.log("### in SafeProcess.destroyProcess(Process p)");
        if (Utility.isWindows()) {
            if (!SafeProcess.isAvailable("wmic")) {
                SafeProcess.log("wmic, used to kill subprocesses, is not available. Unable to terminate subprocesses...");
                SafeProcess.log("Kill them manually from the TaskManager or they will proceed to run to termination");
                process.destroy();
                return;
            }
            long l = SafeProcess.getProcessID(process);
            if (l == -1L) {
                process.destroy();
            } else {
                SafeProcess.log("Attempting to terminate sub processes of Windows process with pid " + l);
                SafeProcess.terminateSubProcessesRecursively(l, process);
            }
            return;
        }
        if (!Utility.isMac() && bl) {
            SafeProcess.log("@@@ Linux: Cancelling a SafeProcess instance does not require any complicated system destroy operation");
            process.destroy();
            return;
        }
        long l = SafeProcess.getProcessID(process);
        if (l == -1L) {
            process.destroy();
        } else {
            boolean bl2;
            boolean bl3 = true;
            if (!SafeProcess.killUnixProcessWithID(l, !bl3, bl2 = true)) {
                SafeProcess.killUnixProcessWithID(l, bl3, bl2);
            }
            process.destroy();
        }
    }

    private static void macTerminateSubProcessesRecursively(long l, Process process) {
        SafeProcess.log("@@@ Attempting to terminate mac process recursively");
        SafeProcess safeProcess = new SafeProcess("pgrep -P " + l);
        int n = safeProcess.runProcess();
        String string = safeProcess.getStdOutput();
        String string2 = safeProcess.getStdError();
        if (process != null) {
            process.destroy();
        } else {
            boolean bl;
            boolean bl2 = true;
            if (!SafeProcess.killUnixProcessWithID(l, !bl2, !(bl = true))) {
                SafeProcess.killUnixProcessWithID(l, bl2, !bl);
            }
        }
        if (string.trim().equals("") && string2.trim().equals("") && n == 1) {
            SafeProcess.log("No child processes");
            return;
        }
        SafeProcess.log("Got childpids on STDOUT: " + string);
        SafeProcess.log("Got childpids on STDERR: " + string2);
    }

    private static void terminateSubProcessesRecursively(long l, Process process) {
        long l2;
        SafeProcess safeProcess = new SafeProcess("wmic process where (parentprocessid=" + l + ") get processid");
        safeProcess.setSplitStdOutputNewLines(true);
        int n = safeProcess.runProcess();
        String string = safeProcess.getStdOutput();
        String string2 = safeProcess.getStdError();
        if (process != null) {
            process.destroy();
        } else {
            SafeProcess.killWinProcessWithID(l);
        }
        if (string2.indexOf("No Instance(s) Available.") != -1) {
            return;
        }
        Stack<Long> stack = new Stack<Long>();
        Scanner scanner = new Scanner(string);
        while (scanner.hasNext()) {
            if (!scanner.hasNextLong()) {
                scanner.next();
                continue;
            }
            l2 = scanner.nextLong();
            stack.push(l2);
        }
        scanner.close();
        if (!stack.empty()) {
            l2 = (Long)stack.pop();
            SafeProcess.terminateSubProcessesRecursively(l2, null);
        }
    }

    private static String getWinProcessKillCmd(Long l) {
        if (WIN_KILL_CMD == null) {
            WIN_KILL_CMD = SafeProcess.isAvailable("wmic") ? "wmic process _PROCID_ delete" : (SafeProcess.isAvailable("taskkill") ? "taskkill /f /t /PID _PROCID_" : "tskill _PROCID_");
        }
        if (WIN_KILL_CMD == null) {
            return null;
        }
        return WIN_KILL_CMD.replace("_PROCID_", Long.toString(l));
    }

    public static boolean isAvailable(String string) {
        try {
            SafeProcess safeProcess = new SafeProcess("which " + string);
            safeProcess.runProcess();
            String string2 = safeProcess.getStdOutput().trim();
            if (string2.equals("")) {
                return false;
            }
            if (string2.indexOf("no " + string) != -1) {
                SafeProcess.log("@@@ SafeProcess.isAvailable(): " + string + "is not available");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void log(String string) {
        if (DEBUG == 0) {
            return;
        }
        System.err.println(string);
    }

    public static void log(String string, Exception exception) {
        System.err.println(string);
        exception.printStackTrace();
    }

    public static void log(Exception exception) {
        exception.printStackTrace();
    }

    public static void log(String string, Exception exception, boolean bl) {
        if (bl) {
            SafeProcess.log(string, exception);
        } else {
            SafeProcess.log(string);
        }
    }

    public static String streamToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "stderr";
                break;
            }
            case 1: {
                string = "stdout";
                break;
            }
            default: {
                string = "stdin";
            }
        }
        return string;
    }

    public static boolean closeResource(Closeable closeable) {
        boolean bl = false;
        try {
            if (closeable != null) {
                closeable.close();
                closeable = null;
                bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            SafeProcess.log("Exception closing resource: " + exception.getMessage(), exception);
            closeable = null;
            bl = false;
            return bl;
        }
        finally {
            return bl;
        }
    }

    public static boolean closeSocket(Socket socket) {
        boolean bl = false;
        try {
            if (socket != null) {
                socket.close();
                socket = null;
                bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            SafeProcess.log("Exception closing resource: " + exception.getMessage(), exception);
            socket = null;
            bl = false;
            return bl;
        }
        finally {
            return bl;
        }
    }

    public static boolean closeProcess(Process process) {
        boolean bl = true;
        if (process != null) {
            bl = bl && SafeProcess.closeResource(process.getErrorStream());
            bl = bl && SafeProcess.closeResource(process.getOutputStream());
            bl = bl && SafeProcess.closeResource(process.getInputStream());
            process.destroy();
        }
        return bl;
    }

    public static boolean processRunning(Process process) {
        boolean bl = false;
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            bl = true;
        }
        catch (Exception exception) {
            SafeProcess.log(exception);
        }
        return bl;
    }

    public static class OutputStreamGobbler
    extends Thread {
        private OutputStream os = null;
        private String inputstr = "";
        private CustomProcessHandler customHandler = null;

        protected OutputStreamGobbler() {
            super("stdinOutputStreamGobbler");
        }

        public OutputStreamGobbler(OutputStream outputStream) {
            this();
            this.os = outputStream;
        }

        public OutputStreamGobbler(OutputStream outputStream, String string) {
            this();
            this.os = outputStream;
            this.inputstr = string;
        }

        public OutputStreamGobbler(OutputStream outputStream, CustomProcessHandler customProcessHandler) {
            this();
            this.os = outputStream;
            this.customHandler = customProcessHandler;
        }

        public void runDefault() {
            if (this.inputstr == null) {
                return;
            }
            if (this.isInterrupted()) {
                SafeProcess.log(this.getName() + " thread was interrupted.");
                return;
            }
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.os, "UTF-8"));
                bufferedWriter.write(this.inputstr, 0, this.inputstr.length());
                bufferedWriter.newLine();
                bufferedWriter.flush();
                SafeProcess.closeResource(bufferedWriter);
            }
            catch (IOException iOException) {
                SafeProcess.log("Exception writing to SafeProcess' inputstream: ", iOException);
            }
            finally {
                SafeProcess.closeResource(bufferedWriter);
            }
        }

        public void runCustom() {
            this.customHandler.run(this.os);
        }

        @Override
        public void run() {
            if (this.customHandler == null) {
                this.runDefault();
            } else {
                this.runCustom();
            }
        }
    }

    public static class InputStreamGobbler
    extends Thread {
        private InputStream is = null;
        private StringBuffer outputstr = new StringBuffer();
        private boolean split_newlines = false;
        private CustomProcessHandler customHandler = null;
        private LineByLineHandler lineByLineHandler = null;

        protected InputStreamGobbler() {
            super("InputStreamGobbler");
        }

        public InputStreamGobbler(InputStream inputStream) {
            this();
            this.is = inputStream;
            this.split_newlines = false;
        }

        public InputStreamGobbler(InputStream inputStream, boolean bl) {
            this();
            this.is = inputStream;
            this.split_newlines = bl;
        }

        public InputStreamGobbler(InputStream inputStream, CustomProcessHandler customProcessHandler) {
            this();
            this.is = inputStream;
            this.customHandler = customProcessHandler;
            this.adjustThreadName(customProcessHandler.getThreadNamePrefix());
        }

        private void adjustThreadName(String string) {
            this.setName(string + this.getName());
        }

        public void setLineByLineHandler(LineByLineHandler lineByLineHandler) {
            this.lineByLineHandler = lineByLineHandler;
            this.adjustThreadName(lineByLineHandler.getThreadNamePrefix());
        }

        public void runDefault() {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
                String string = null;
                while (!this.isInterrupted() && (string = bufferedReader.readLine()) != null) {
                    this.outputstr.append(string);
                    if (this.split_newlines) {
                        this.outputstr.append(Utility.NEWLINE);
                    }
                    if (this.lineByLineHandler == null) continue;
                    this.lineByLineHandler.gotLine(string);
                }
            }
            catch (IOException iOException) {
                block10: {
                    try {
                        if (this.lineByLineHandler != null) {
                            this.lineByLineHandler.gotException(iOException);
                            break block10;
                        }
                        SafeProcess.log("Exception when reading process stream with " + this.getName() + ": ", iOException);
                    }
                    catch (Throwable throwable) {
                        if (this.isInterrupted()) {
                            SafeProcess.log("@@@ Successfully interrupted " + this.getName() + ".");
                        }
                        SafeProcess.closeResource(bufferedReader);
                        throw throwable;
                    }
                }
                if (this.isInterrupted()) {
                    SafeProcess.log("@@@ Successfully interrupted " + this.getName() + ".");
                }
                SafeProcess.closeResource(bufferedReader);
            }
            if (this.isInterrupted()) {
                SafeProcess.log("@@@ Successfully interrupted " + this.getName() + ".");
            }
            SafeProcess.closeResource(bufferedReader);
        }

        public void runCustom() {
            this.customHandler.run(this.is);
        }

        @Override
        public void run() {
            if (this.customHandler == null) {
                this.runDefault();
            } else {
                this.runCustom();
            }
        }

        public String getOutput() {
            return this.outputstr.toString();
        }
    }

    public static abstract class LineByLineHandler {
        protected final int source;

        protected LineByLineHandler(int n) {
            this.source = n;
        }

        public String getThreadNamePrefix() {
            return SafeProcess.streamToString(this.source);
        }

        public abstract void gotLine(String var1);

        public abstract void gotException(Exception var1);
    }

    public static abstract class CustomProcessHandler {
        protected final int source;

        protected CustomProcessHandler(int n) {
            this.source = n;
        }

        public String getThreadNamePrefix() {
            return SafeProcess.streamToString(this.source);
        }

        public abstract void run(Closeable var1);
    }

    public static interface MainProcessHandler {
        public boolean beforeWaitingForStreamsToEnd(boolean var1);

        public boolean afterStreamsEnded(boolean var1);

        public void beforeProcessDestroy();

        public void afterProcessDestroy();

        public void doneCleanup(boolean var1);
    }

    public static interface ExceptionHandler {
        public void gotException(Exception var1);
    }
}

