/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.File;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.Utility;

public class GS3ServerThread
extends Thread {
    String _gsdl3_src_path = "";
    String _ant_command = "";
    private static final boolean isIndependentServer = GS3ServerThread.isServerRunning();

    public GS3ServerThread(String string, String string2) {
        this._gsdl3_src_path = string;
        this._ant_command = string2;
    }

    @Override
    public void run() {
        SafeProcess safeProcess = null;
        if (Utility.isWindows()) {
            if (this._ant_command.indexOf("start") != -1) {
                this._ant_command = "start";
            }
            safeProcess = new SafeProcess("cmd /C \"cd \"" + this._gsdl3_src_path + File.separator + "\" && ant " + this._ant_command + "\"");
        } else {
            if (this._ant_command.indexOf("start") != -1) {
                this._ant_command = "restart";
            }
            safeProcess = new SafeProcess(new String[]{"/bin/bash", "-c", "ant " + this._ant_command + " -f \"" + this._gsdl3_src_path + File.separator + "build.xml\""});
        }
        System.err.println("Issuing " + this._ant_command + " command to GS3 Server");
        safeProcess.setSplitStdErrorNewLines(true);
        int n = safeProcess.runProcess();
        if (n != 0) {
            System.err.println("Error: Failed to successfully " + this._ant_command + " the GS3 server.");
        }
    }

    public static boolean prepareXML() {
        SafeProcess safeProcess = null;
        safeProcess = Utility.isWindows() ? new SafeProcess("cmd /C \"cd \"" + Configuration.gsdl3_src_path + File.separator + "\" && ant configure-servlets-xml\"") : new SafeProcess(new String[]{"/bin/bash", "-c", "ant configure-servlets-xml -f \"" + Configuration.gsdl3_src_path + File.separator + "build.xml\""});
        int n = safeProcess.runProcess();
        return n == 0;
    }

    public static void stopServer() {
        SafeProcess safeProcess = null;
        safeProcess = Utility.isWindows() ? new SafeProcess("cmd /C \"cd \"" + Configuration.gsdl3_src_path + File.separator + "\" && ant stop\"") : new SafeProcess(new String[]{"/bin/bash", "-c", "ant stop -f \"" + Configuration.gsdl3_src_path + File.separator + "build.xml\""});
        System.err.println("Issuing stop command to GS3 Server. Waiting for GS3 server to stop...");
        int n = safeProcess.runProcess();
        if (n == 0) {
            System.err.println("Successfully stopped GS3 server.");
        } else {
            System.err.println("********** FAILED TO SUCCESSFULLY stop THE GS3 SERVER ON EXIT");
        }
    }

    public static boolean isServerRunning() {
        String string = "ant check-tomcat-running";
        SafeProcess safeProcess = null;
        safeProcess = Utility.isWindows() ? new SafeProcess("cmd /C \"cd \"" + Configuration.gsdl3_src_path + File.separator + "\" && " + string + "\"") : new SafeProcess(new String[]{"/bin/bash", "-c", string + " -f \"" + Configuration.gsdl3_src_path + File.separator + "build.xml\""});
        safeProcess.runProcess();
        String string2 = safeProcess.getStdOutput();
        return string2.contains("Tomcat is running: true");
    }

    public static boolean wasServerLaunchedOutsideGLI() {
        return isIndependentServer;
    }
}

