/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.tree.DragTree;

public class DragTreeSelectionModel
extends DefaultTreeSelectionModel
implements MouseListener {
    private boolean immediate = false;
    private boolean mixed_selection = false;
    private int type = -1;
    private TreePath temp_path = null;
    private TreePath[] temp_paths = null;
    private static final int NONE = -1;
    private static final int ADD = 0;
    private static final int SET = 1;

    public DragTreeSelectionModel(DragTree dragTree, boolean bl) {
        this.mixed_selection = bl;
        this.setSelectionMode(4);
        dragTree.addMouseListener(this);
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        if (!this.immediate) {
            this.temp_path = treePath;
            this.type = 0;
        } else if (this.isAppropriate(treePath)) {
            this.temp_path = null;
            super.addSelectionPath(treePath);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        if (!this.immediate) {
            this.temp_paths = treePathArray;
            this.type = 0;
        } else if (this.isAppropriate(treePathArray, true)) {
            this.temp_paths = null;
            super.setSelectionPaths(treePathArray);
        }
    }

    public String getDetails() {
        String string = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; this.selection != null && i < this.selection.length; ++i) {
            TreeNode treeNode = (TreeNode)this.selection[i].getLastPathComponent();
            if (treeNode.isLeaf()) {
                ++n;
                continue;
            }
            ++n2;
        }
        String[] stringArray = null;
        if (n > 0 && n2 > 0) {
            if (n > 1 && n2 > 1) {
                stringArray = new String[]{String.valueOf(n), String.valueOf(n2)};
                string = Dictionary.get("FileActions.Selected", stringArray);
            } else if (n > 1) {
                stringArray = new String[]{String.valueOf(n)};
                string = Dictionary.get("FileActions.Files_And_Directory_Selected", stringArray);
            } else if (n2 > 1) {
                stringArray = new String[]{String.valueOf(n2)};
                string = Dictionary.get("FileActions.File_And_Directories_Selected", stringArray);
            } else {
                string = Dictionary.get("FileActions.File_And_Directory_Selected");
            }
        } else if (n > 0) {
            if (n > 1) {
                stringArray = new String[]{String.valueOf(n)};
                string = Dictionary.get("FileActions.Files_Selected", stringArray);
            } else if (n == 1) {
                string = Dictionary.get("FileActions.File_Selected");
            }
        } else if (n2 > 0) {
            if (n2 > 1) {
                stringArray = new String[]{String.valueOf(n2)};
                string = Dictionary.get("FileActions.Directories_Selected", stringArray);
            } else {
                string = Dictionary.get("FileActions.Directory_Selected");
            }
        }
        stringArray = null;
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            switch (this.type) {
                case 0: {
                    if (this.temp_path != null && this.isAppropriate(this.temp_path)) {
                        super.addSelectionPath(this.temp_path);
                        this.temp_path = null;
                    }
                    if (this.temp_paths != null && this.isAppropriate(this.temp_paths, true)) {
                        super.addSelectionPaths(this.temp_paths);
                        this.temp_paths = null;
                    }
                    this.type = -1;
                    break;
                }
                case 1: {
                    if (this.temp_path != null) {
                        super.setSelectionPath(this.temp_path);
                        this.temp_path = null;
                    }
                    if (this.temp_paths != null && this.isAppropriate(this.temp_paths, false)) {
                        super.setSelectionPaths(this.temp_paths);
                        this.temp_paths = null;
                    }
                    this.type = -1;
                }
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public void setImmediate(boolean bl) {
        this.immediate = bl;
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        if (!this.immediate) {
            this.temp_path = treePath;
            this.type = 1;
        } else {
            this.temp_path = null;
            super.setSelectionPath(treePath);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        if (!this.immediate) {
            this.temp_paths = treePathArray;
            this.type = 1;
        } else if (this.isAppropriate(treePathArray, false)) {
            this.temp_paths = null;
            super.setSelectionPaths(treePathArray);
        }
    }

    private boolean isAppropriate(TreePath treePath) {
        boolean bl = true;
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (this.selection != null && this.selection.length > 0) {
            for (int i = 0; bl && i < this.selection.length; ++i) {
                TreeNode treeNode2 = (TreeNode)this.selection[i].getLastPathComponent();
                bl = bl && (this.mixed_selection || treeNode.isLeaf() == treeNode2.isLeaf());
                bl = bl && !treePath.isDescendant(this.selection[i]) && !this.selection[i].isDescendant(treePath);
            }
        }
        return bl;
    }

    private boolean isAppropriate(TreePath[] treePathArray, boolean bl) {
        boolean bl2 = true;
        if (bl && treePathArray != null && treePathArray.length > 0) {
            for (int i = 0; bl2 && i < treePathArray.length; ++i) {
                bl2 = bl2 && this.isAppropriate(treePathArray[i]);
            }
        }
        return bl2;
    }
}

