/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTree
extends JTree {
    public DOMTree(Document document) {
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        this.setModel(new DefaultTreeModel(new DOMTreeNode(document.getDocumentElement(), null)));
    }

    private class DOMTreeNode
    implements TreeNode {
        private Node node = null;
        private NodeList children = null;
        private String text = null;
        private TreeNode parent = null;
        private TreeNode self = null;

        DOMTreeNode(Node node, TreeNode treeNode) {
            this.node = node;
            this.parent = treeNode;
            this.self = this;
        }

        public Enumeration children() {
            if (this.children == null) {
                this.children = this.node.getChildNodes();
            }
            return new NodeListEnumeration();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int n) {
            if (this.children == null) {
                this.children = this.node.getChildNodes();
            }
            return new DOMTreeNode(this.children.item(n), this);
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                this.children = this.node.getChildNodes();
            }
            return this.children.getLength();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            if (this.children == null) {
                this.children = this.node.getChildNodes();
            }
            Node node = ((DOMTreeNode)treeNode).getNode();
            int n = this.children.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = this.children.item(i);
                if (node == node2) {
                    node2 = null;
                    node = null;
                    return i;
                }
                node2 = null;
            }
            node = null;
            return -1;
        }

        public Node getNode() {
            return this.node;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return !this.node.hasChildNodes();
        }

        public String toString() {
            if (this.text == null) {
                StringBuffer stringBuffer = new StringBuffer(this.node.getNodeName());
                String string = this.node.getNodeValue();
                if (string != null && string.length() != 0) {
                    stringBuffer.append("=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                string = null;
                if (this.node instanceof Element) {
                    Element element = (Element)this.node;
                    stringBuffer.append(": ");
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node node = namedNodeMap.item(i);
                        stringBuffer.append(node.getNodeName());
                        stringBuffer.append("=\"");
                        stringBuffer.append(node.getNodeValue());
                        if (i < n - 1) {
                            stringBuffer.append("\" ");
                            continue;
                        }
                        stringBuffer.append("\"");
                    }
                    namedNodeMap = null;
                    element = null;
                }
                this.text = stringBuffer.toString();
                stringBuffer = null;
            }
            return this.text;
        }

        private class NodeListEnumeration
        implements Enumeration {
            private int index = 0;

            private NodeListEnumeration() {
            }

            @Override
            public boolean hasMoreElements() {
                return this.index < DOMTreeNode.this.children.getLength();
            }

            public Object nextElement() {
                int n = this.index++;
                return new DOMTreeNode(DOMTreeNode.this.children.item(n), DOMTreeNode.this.self);
            }
        }
    }
}

