/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.greenstone.gatherer.util.CheckListEntry;

public class CheckList
extends JList {
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private boolean show_selected_row = true;

    public CheckList(boolean bl) {
        this.show_selected_row = bl;
        this.setCellRenderer(new CheckListCellRenderer());
        this.setModel(new DefaultListModel());
        this.setSelectionMode(0);
        this.addMouseListener(new CheckListMouseListener());
    }

    public void addEntry(CheckListEntry checkListEntry) {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        String string = checkListEntry.toString();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            Object e = defaultListModel.getElementAt(i);
            if (string.compareTo(e.toString()) > 0) continue;
            defaultListModel.add(i, checkListEntry);
            return;
        }
        defaultListModel.addElement(checkListEntry);
    }

    public void clearTicked() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            ((CheckListEntry)defaultListModel.get(i)).setSelected(false);
        }
        this.updateUI();
    }

    public ArrayList getAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            CheckListEntry checkListEntry = (CheckListEntry)defaultListModel.get(i);
            arrayList.add(checkListEntry.getObject());
        }
        return arrayList;
    }

    public ArrayList getTicked() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            CheckListEntry checkListEntry = (CheckListEntry)defaultListModel.get(i);
            if (!checkListEntry.isSelected()) continue;
            arrayList.add(checkListEntry.getObject());
        }
        return arrayList;
    }

    public int numTicked() {
        int n = 0;
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            CheckListEntry checkListEntry = (CheckListEntry)defaultListModel.get(i);
            if (!checkListEntry.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public boolean isNothingTicked() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            if (!((CheckListEntry)defaultListModel.get(i)).isSelected()) continue;
            return false;
        }
        return true;
    }

    public void setListData(ArrayList arrayList) {
        this.setModel(new DefaultListModel());
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof CheckListEntry) {
                this.addEntry((CheckListEntry)e);
                continue;
            }
            this.addEntry(new CheckListEntry(e));
        }
    }

    public void setTickedObjects(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        block0: for (int i = 0; i < defaultListModel.size(); ++i) {
            CheckListEntry checkListEntry = (CheckListEntry)defaultListModel.get(i);
            for (int j = 0; j < objectArray.length; ++j) {
                if (!checkListEntry.getObject().equals(objectArray[j])) continue;
                checkListEntry.setSelected(true);
                continue block0;
            }
        }
        this.updateUI();
    }

    public void setAllTicked() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            CheckListEntry checkListEntry = (CheckListEntry)defaultListModel.get(i);
            checkListEntry.setSelected(true);
        }
        this.updateUI();
    }

    private class CheckListMouseListener
    extends MouseAdapter {
        private CheckListMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!CheckList.this.isEnabled()) {
                return;
            }
            JList jList = (JList)mouseEvent.getSource();
            int n = jList.locationToIndex(mouseEvent.getPoint());
            CheckListEntry checkListEntry = (CheckListEntry)jList.getModel().getElementAt(n);
            if (!checkListEntry.isFixed()) {
                checkListEntry.setSelected(!checkListEntry.isSelected());
            }
            checkListEntry.grabFocus();
            jList.removeSelectionInterval(0, 0);
            jList.setSelectionInterval(n, n);
        }
    }

    protected class CheckListCellRenderer
    implements ListCellRenderer {
        protected CheckListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JCheckBox jCheckBox = (JCheckBox)object;
            if (CheckList.this.show_selected_row) {
                jCheckBox.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                jCheckBox.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                jCheckBox.setBorderPainted(true);
            } else {
                jCheckBox.setBackground(jList.getBackground());
                jCheckBox.setForeground(jList.getForeground());
                jCheckBox.setBorderPainted(false);
            }
            jCheckBox.setEnabled(jList.isEnabled());
            jCheckBox.setFont(jList.getFont());
            jCheckBox.setFocusPainted(false);
            jCheckBox.setBorder(bl ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return jCheckBox;
        }
    }
}

