/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.util.AppendLineOnlyFileDocumentOwner;

public class AppendLineOnlyFileDocument
implements Document {
    private static final String GLI_HEADER_STR = ".";
    private AppendLineOnlyFileDocumentElement root_element;
    private AppendLineOnlyFileDocumentOwner owner;
    private boolean build_log = false;
    private EventListenerList listeners_list;
    private HashMap properties;
    private long length;
    private RandomAccessFile file;
    private String filename;
    private WriterThread writer;

    public AppendLineOnlyFileDocument(String string) {
        this(string, true);
    }

    public AppendLineOnlyFileDocument(String string, boolean bl) {
        DebugStream.println("Creating log: " + string);
        this.build_log = bl;
        this.filename = string;
        this.listeners_list = new EventListenerList();
        this.properties = new HashMap();
        this.writer = new WriterThread();
        this.writer.start();
        try {
            this.file = new RandomAccessFile(string, "rw");
            this.length = this.file.length();
            this.root_element = new AppendLineOnlyFileDocumentElement();
            long l = 0L;
            this.file.seek(l);
            int n = -1;
            while ((n = this.file.read()) != -1) {
                if (n != 10) continue;
                long l2 = this.file.getFilePointer();
                AppendLineOnlyFileDocumentElement appendLineOnlyFileDocumentElement = new AppendLineOnlyFileDocumentElement(l, l2);
                this.root_element.add(appendLineOnlyFileDocumentElement);
                appendLineOnlyFileDocumentElement = null;
                l = l2;
            }
            if (bl && this.root_element.getElementCount() == 0) {
                this.appendLine(GLI_HEADER_STR);
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.listeners_list.add(DocumentListener.class, documentListener);
    }

    public void appendLine(String string) {
        try {
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
            int n = string.getBytes("UTF-8").length;
            long l = this.length;
            long l2 = l + (long)n;
            this.length += (long)n;
            AppendLineOnlyFileDocumentElement appendLineOnlyFileDocumentElement = new AppendLineOnlyFileDocumentElement(l, l2, string);
            this.root_element.add(appendLineOnlyFileDocumentElement);
            this.writer.queue(appendLineOnlyFileDocumentElement);
            AppendLineOnlyFileDocumentEvent appendLineOnlyFileDocumentEvent = new AppendLineOnlyFileDocumentEvent(appendLineOnlyFileDocumentElement, (int)l, n, DocumentEvent.EventType.INSERT);
            Object[] objectArray = this.listeners_list.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DocumentListener.class) continue;
                ((DocumentListener)objectArray[i + 1]).insertUpdate(appendLineOnlyFileDocumentEvent);
            }
            objectArray = null;
            appendLineOnlyFileDocumentEvent = null;
            appendLineOnlyFileDocumentElement = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    @Override
    public Position createPosition(int n) {
        return new AppendLineOnlyFileDocumentPosition(n);
    }

    public void close() {
        if (this.writer == null) {
            return;
        }
        this.setExit();
        this.writer = null;
        try {
            this.file.close();
        }
        catch (Exception exception) {
            DebugStream.println("Exception in AppendLineOnlyFileDocument.close() - Unable to close internal file");
            DebugStream.printStackTrace(exception);
        }
    }

    public void destroy() {
        try {
            if (this.writer != null) {
                this.writer.finish();
                this.writer = null;
                this.file.close();
            }
        }
        catch (Exception exception) {
            DebugStream.println("Exception in AppendLineOnlyFileDocument.destroy() - unexpected");
            DebugStream.printStackTrace(exception);
        }
    }

    @Override
    public Element getDefaultRootElement() {
        return this.root_element;
    }

    @Override
    public int getLength() {
        return (int)this.length;
    }

    public int getLengthToNearestLine() {
        AppendLineOnlyFileDocumentElement appendLineOnlyFileDocumentElement = (AppendLineOnlyFileDocumentElement)this.root_element.getElement(this.root_element.getElementCount() - 1);
        if (appendLineOnlyFileDocumentElement != null) {
            return appendLineOnlyFileDocumentElement.getStartOffset();
        }
        return (int)this.length;
    }

    @Override
    public Object getProperty(Object object) {
        return this.properties.get(object);
    }

    public boolean isStillWriting() {
        return this.writer.isStillWriting();
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        if (n2 == 0) {
            return "";
        }
        try {
            return this.read(n, n2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        String string = this.getText(n, n2);
        segment.array = string.toCharArray();
        segment.count = string.length();
        segment.offset = 0;
        string = null;
    }

    @Override
    public void putProperty(Object object, Object object2) {
        this.properties.put(object, object2);
    }

    public boolean ready() {
        return this.file != null;
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.listeners_list.remove(DocumentListener.class, documentListener);
    }

    public void setExit() {
        this.writer.exit();
        this.writer.finish();
    }

    public void setOwner(AppendLineOnlyFileDocumentOwner appendLineOnlyFileDocumentOwner) {
        this.owner = appendLineOnlyFileDocumentOwner;
    }

    public synchronized void setSpecialCharacter(char c) {
        if (this.build_log) {
            try {
                this.file.seek(0L);
                this.file.write(c);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
    }

    public String toString() {
        return this.filename;
    }

    private synchronized String read(long l, int n) throws IOException {
        byte[] byArray = new byte[n];
        this.file.seek(l);
        int n2 = this.file.read(byArray, 0, n);
        return new String(byArray, "UTF-8");
    }

    private synchronized void write(long l, long l2, String string, int n) throws IOException {
        this.file.setLength(l2);
        this.file.seek(l);
        this.file.write(string.getBytes("UTF-8"), 0, n);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public Position getEndPosition() {
        return null;
    }

    @Override
    public Element[] getRootElements() {
        return null;
    }

    @Override
    public Position getStartPosition() {
        return null;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) {
    }

    @Override
    public void remove(int n, int n2) {
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public void render(Runnable runnable) {
    }

    public static synchronized void print(String string) {
        if (string.endsWith("\n")) {
            DebugStream.print(string);
        } else {
            DebugStream.println(string);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("AppendLineOnlyFileDocument Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(640, 480);
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        AppendLineOnlyFileDocument appendLineOnlyFileDocument = new AppendLineOnlyFileDocument("temp.txt");
        JTextArea jTextArea = new JTextArea(appendLineOnlyFileDocument);
        GLIButton gLIButton = new GLIButton("Read Huge File");
        gLIButton.addActionListener(new ReadButtonListener(appendLineOnlyFileDocument));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel.add((Component)gLIButton, "South");
        jFrame.setVisible(true);
    }

    private static class ReadTask
    extends Thread {
        private AppendLineOnlyFileDocument document;

        public ReadTask(AppendLineOnlyFileDocument appendLineOnlyFileDocument) {
            super("LoadHugeFileThread");
            this.document = appendLineOnlyFileDocument;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(new File("big.txt")));
                while ((string = bufferedReader.readLine()) != null) {
                    this.document.appendLine(string);
                    try {
                        ReadTask readTask = this;
                        synchronized (readTask) {
                            this.wait(100L);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class ReadButtonListener
    implements ActionListener {
        private AppendLineOnlyFileDocument document;

        public ReadButtonListener(AppendLineOnlyFileDocument appendLineOnlyFileDocument) {
            this.document = appendLineOnlyFileDocument;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadTask readTask = new ReadTask(this.document);
            readTask.start();
        }
    }

    private class WriterThread
    extends Thread {
        private boolean empty_queue;
        private boolean exit;
        private boolean running;
        private Vector queue;

        public WriterThread() {
            super("WriterThread");
            this.empty_queue = false;
            this.exit = false;
            this.queue = new Vector();
        }

        public synchronized void exit() {
            this.exit = true;
            this.notify();
        }

        public void finish() {
            if (!this.queue.isEmpty() && this.running) {
                this.empty_queue = true;
                this.run();
            }
        }

        public boolean isStillWriting() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.exit = false;
            this.running = true;
            while (!this.exit) {
                Object object;
                if (!this.queue.isEmpty()) {
                    object = (AppendLineOnlyFileDocumentElement)this.queue.remove(0);
                    String string = ((AppendLineOnlyFileDocumentElement)object).getContent();
                    if (string == null) continue;
                    try {
                        AppendLineOnlyFileDocument.this.write(((AppendLineOnlyFileDocumentElement)object).getStartOffset(), ((AppendLineOnlyFileDocumentElement)object).getEndOffset(), string, string.getBytes("UTF-8").length);
                    }
                    catch (Exception exception) {
                        DebugStream.printStackTrace(exception);
                    }
                    ((AppendLineOnlyFileDocumentElement)object).clearContent();
                    continue;
                }
                if (this.empty_queue) {
                    this.exit = true;
                    continue;
                }
                object = this;
                synchronized (object) {
                    try {
                        AppendLineOnlyFileDocument.print("WriterThread.wait() start");
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    AppendLineOnlyFileDocument.print("WriterThread.wait() complete");
                }
            }
            AppendLineOnlyFileDocument.print("WriterThread completely finished. Exiting.");
            this.running = false;
            if (AppendLineOnlyFileDocument.this.owner != null) {
                AppendLineOnlyFileDocument.this.owner.remove(AppendLineOnlyFileDocument.this);
            }
        }

        public synchronized void queue(Element element) {
            AppendLineOnlyFileDocument.print("WriterThread.queue(): " + ((AppendLineOnlyFileDocumentElement)element).getContent());
            this.queue.add(element);
            this.notify();
        }
    }

    private class AppendLineOnlyFileDocumentPosition
    implements Position {
        private int offset;

        public AppendLineOnlyFileDocumentPosition(int n) {
            this.offset = n;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }

    private class AppendLineOnlyFileDocumentEvent
    implements DocumentEvent {
        private DocumentEvent.EventType type;
        private AppendLineOnlyFileDocumentElement element;
        private AppendLineOnlyFileDocumentElementChange element_change;
        private int len;
        private int offset;

        public AppendLineOnlyFileDocumentEvent(AppendLineOnlyFileDocumentElement appendLineOnlyFileDocumentElement, int n, int n2, DocumentEvent.EventType eventType) {
            this.element = appendLineOnlyFileDocumentElement;
            this.element_change = null;
            this.len = n2;
            this.offset = n;
            this.type = eventType;
        }

        @Override
        public Document getDocument() {
            return AppendLineOnlyFileDocument.this;
        }

        @Override
        public int getLength() {
            return this.len;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public DocumentEvent.EventType getType() {
            return this.type;
        }

        @Override
        public DocumentEvent.ElementChange getChange(Element element) {
            if (this.element_change == null) {
                this.element_change = new AppendLineOnlyFileDocumentElementChange();
            }
            return this.element_change;
        }

        private class AppendLineOnlyFileDocumentElementChange
        implements DocumentEvent.ElementChange {
            private Element[] children_added = new Element[1];
            private Element[] children_removed;
            private int index;

            public AppendLineOnlyFileDocumentElementChange() {
                this.children_added[0] = AppendLineOnlyFileDocumentEvent.this.element;
                this.children_removed = new Element[0];
                this.index = AppendLineOnlyFileDocument.this.root_element.indexOf(AppendLineOnlyFileDocumentEvent.this.element);
            }

            @Override
            public Element[] getChildrenAdded() {
                return this.children_added;
            }

            @Override
            public Element[] getChildrenRemoved() {
                return this.children_removed;
            }

            @Override
            public Element getElement() {
                return AppendLineOnlyFileDocument.this.root_element;
            }

            @Override
            public int getIndex() {
                return this.index;
            }
        }
    }

    private class AppendLineOnlyFileDocumentElement
    extends ArrayList
    implements Element {
        private Element parent;
        private long end;
        private long start;
        private String content;

        public AppendLineOnlyFileDocumentElement() {
            this.end = 0L;
            this.parent = null;
            this.start = 0L;
        }

        public AppendLineOnlyFileDocumentElement(long l, long l2) {
            this.end = l2;
            this.parent = null;
            this.start = l;
        }

        public AppendLineOnlyFileDocumentElement(long l, long l2, String string) {
            this.content = string;
            this.end = l2;
            this.parent = null;
            this.start = l;
        }

        public void add(Element element) {
            super.add(element);
            ((AppendLineOnlyFileDocumentElement)element).setParent(this);
        }

        public void clearContent() {
            this.content = null;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        public String getContent() {
            return this.content;
        }

        @Override
        public Document getDocument() {
            return AppendLineOnlyFileDocument.this;
        }

        @Override
        public Element getElement(int n) {
            if (0 > n || n >= this.size()) {
                throw new IndexOutOfBoundsException("AppendLineOnlyDocument.AppendLineOnlyFileDocumentElement.getElement(" + n + ")");
            }
            Element element = (Element)this.get(n);
            return element;
        }

        @Override
        public int getElementCount() {
            return this.size();
        }

        @Override
        public int getElementIndex(int n) {
            int n2 = -1;
            if (this.parent != null) {
                n2 = -1;
            } else if (n < 0) {
                n2 = 0;
            } else if ((long)n >= AppendLineOnlyFileDocument.this.length) {
                n2 = this.size() - 1;
            } else {
                int n3 = this.size();
                for (int i = 0; n2 == -1 && i < n3; ++i) {
                    Element element = (Element)this.get(i);
                    if (element.getStartOffset() <= n && n < element.getEndOffset()) {
                        n2 = i;
                    }
                    element = null;
                }
            }
            return n2;
        }

        @Override
        public int getEndOffset() {
            if (this.parent != null) {
                return (int)this.end;
            }
            return (int)AppendLineOnlyFileDocument.this.length;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public Element getParentElement() {
            return this.parent;
        }

        @Override
        public int getStartOffset() {
            if (this.parent != null) {
                return (int)this.start;
            }
            return 0;
        }

        @Override
        public boolean isLeaf() {
            return this.parent != null;
        }

        public void setParent(Element element) {
            this.parent = element;
        }
    }
}

