/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.shell;

import java.awt.Component;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GProgressBar;
import org.greenstone.gatherer.shell.GShellElement;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellProgressMonitor;

public class GImportProgressMonitor
implements GShellProgressMonitor {
    private boolean showing_string = false;
    private boolean stop = false;
    private int extracted_file_count;
    private int file_count;
    private int next_progress_value;
    private int num_expected_docs;
    private int num_docs;
    private int threshold = 2;
    private GProgressBar progress_bar = new GProgressBar();
    private GProgressBar shared_progress_bar;
    private static final String BLOCKED_ATTRIBUTE = "blocked";
    private static final String CONSIDERED_ATTRIBUTE = "considered";
    private static final String FAILED_ATTRIBUTE = "failed";
    private static final String IGNORED_ATTRIBUTE = "ignored";
    private static final String IMPORT_ELEMENT = "Import";
    private static final String PROCESSED_ATTRIBUTE = "processed";
    private static final String ARGUMENT_ATTRIBUTE = "a";
    private static final String NAME_ATTRIBUTE = "n";
    private static final String PLUGIN_ATTRIBUTE = "p";
    private static final String REASON_ATTRIBUTE = "r";
    private static final int CALCULATION = 50000;
    private static final int EXTRACTED = 200000;
    private static final int PROCESSED = 750000;
    private static final int MAXIMUM = 1000000;
    private static final int MINIMUM = 0;
    private static final String FILE_ELEMENT = "File";
    private static final String PROCESSING_ELEMENT = "Processing";
    private static final String PROCESSINGERROR_ELEMENT = "ProcessingError";
    private static final String IMPORTCOMPLETE_ELEMENT = "ImportComplete";
    private static final String NONPROCESSEDFILE_ELEMENT = "NonProcessedFile";
    private static final String NONRECOGNISEDFILE_ELEMENT = "NonRecognisedFile";
    private static final String WARNING_ELEMENT = "Warning";
    private static final String BADARGUMENT_ELEMENT = "BadArgument";
    private static final String BADARGUMENTVALUE_ELEMENT = "BadArgumentValue";
    private static final String BADPLUGIN_ELEMENT = "BadPlugin";
    int previous_value = -1;

    public GImportProgressMonitor() {
        this.progress_bar.setIndeterminate(false);
        this.progress_bar.setMaximum(1000000);
        this.progress_bar.setMinimum(0);
        this.progress_bar.setString(null);
        this.progress_bar.setStringPainted(true);
        this.next_progress_value = 50000;
        this.shared_progress_bar = new GProgressBar();
        this.shared_progress_bar.setIndeterminate(false);
        this.shared_progress_bar.setMaximum(2000000);
        this.shared_progress_bar.setMinimum(0);
        this.shared_progress_bar.setString(null);
        this.shared_progress_bar.setStringPainted(true);
        this.setValue(0);
    }

    @Override
    public void addProgressBar(GProgressBar gProgressBar) {
        this.progress_bar = gProgressBar;
        gProgressBar.setMaximum(1000000);
        gProgressBar.setMinimum(0);
        this.setValue(0);
        this.next_progress_value = 50000;
    }

    @Override
    public int exitValue() {
        if (this.num_docs > 0) {
            return 0;
        }
        return 1;
    }

    public int getNumberOfDocuments() {
        return this.num_docs;
    }

    @Override
    public Component getProgress() {
        return this.progress_bar;
    }

    @Override
    public GProgressBar getSharedProgress() {
        return this.shared_progress_bar;
    }

    @Override
    public void messageOnProgressBar(String string) {
        if (string != null && !string.equals("")) {
            this.progress_bar.setString(string);
            this.shared_progress_bar.setString(string);
            this.showing_string = true;
        } else {
            this.progress_bar.setString(null);
            this.shared_progress_bar.setString(null);
            this.showing_string = false;
        }
    }

    @Override
    public synchronized boolean hasSignalledStop() {
        return this.stop;
    }

    @Override
    public void increment() {
        ++this.extracted_file_count;
        this.setValue(800000 + 200000 * this.extracted_file_count / this.num_docs);
    }

    @Override
    public void process(ArrayList arrayList) {
        GShellEvent gShellEvent = (GShellEvent)arrayList.get(0);
        String string = gShellEvent.getMessage();
        string = string.substring(string.indexOf(">") + 1);
        if ((string = string.trim()).startsWith("<") && string.endsWith(">")) {
            gShellEvent.veto();
            GShellElement gShellElement = new GShellElement(string);
            String string2 = gShellElement.getElementName();
            if (string2.equals(IMPORT_ELEMENT)) {
                if (this.showing_string) {
                    this.progress_bar.setString(null);
                    this.showing_string = false;
                }
                if (Configuration.getMode() <= this.threshold) {
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.ImportBegun1"), gShellEvent.getStatus()));
                }
            } else if (string2.equals(FILE_ELEMENT)) {
                ++this.file_count;
                if (this.next_progress_value > 0) {
                    this.setValue(this.next_progress_value);
                }
                this.next_progress_value = 50000 + 750000 * this.file_count / this.num_expected_docs;
                gShellEvent.veto();
            } else if (string2.equals(PROCESSING_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(NAME_ATTRIBUTE), gShellElement.getAttribute(PLUGIN_ATTRIBUTE)};
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.FileProcessing", stringArray), gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(PROCESSINGERROR_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(NAME_ATTRIBUTE)};
                    String string3 = gShellElement.getAttribute(REASON_ATTRIBUTE);
                    if (string3 == null || string3.equals("")) {
                        arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.FileProcessingError", stringArray), gShellEvent.getStatus()));
                    } else {
                        arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.FileProcessingError", stringArray) + " (" + string3 + ")", gShellEvent.getStatus()));
                    }
                    stringArray = null;
                }
            } else if (string2.equals(NONRECOGNISEDFILE_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(NAME_ATTRIBUTE)};
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.FileNotRecognised", stringArray), gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(NONPROCESSEDFILE_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(NAME_ATTRIBUTE)};
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.FileNotProcessed", stringArray), gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(BADARGUMENT_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(ARGUMENT_ATTRIBUTE)};
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadArgument", stringArray), gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(BADARGUMENTVALUE_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(ARGUMENT_ATTRIBUTE)};
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadArgumentValue", stringArray), gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(BADPLUGIN_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(PLUGIN_ATTRIBUTE)};
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.BadPluginOptions", stringArray), gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(WARNING_ELEMENT)) {
                if (Configuration.getMode() <= this.threshold) {
                    String[] stringArray = new String[]{gShellElement.getAttribute(PLUGIN_ATTRIBUTE)};
                    String string4 = gShellElement.getAttribute(REASON_ATTRIBUTE);
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.Warning", stringArray) + " " + string4, gShellEvent.getStatus()));
                    stringArray = null;
                }
            } else if (string2.equals(IMPORTCOMPLETE_ELEMENT)) {
                this.setValue(this.next_progress_value);
                if (Configuration.getMode() <= this.threshold) {
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.ImportComplete1"), gShellEvent.getStatus()));
                    String string5 = gShellElement.getAttribute(CONSIDERED_ATTRIBUTE);
                    if (string5.equals("1")) {
                        arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.ImportComplete2.1"), gShellEvent.getStatus()));
                    } else {
                        arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.ImportComplete2", string5), gShellEvent.getStatus()));
                    }
                    string5 = null;
                    String string6 = gShellElement.getAttribute(PROCESSED_ATTRIBUTE);
                    if (!string6.equals("0")) {
                        if (string6.equals("1")) {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Processed.1"), gShellEvent.getStatus()));
                        } else {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Processed", string6), gShellEvent.getStatus()));
                        }
                    }
                    try {
                        this.num_docs = Integer.parseInt(string6);
                    }
                    catch (Exception exception) {
                        this.num_docs = 0;
                    }
                    string6 = null;
                    String string7 = gShellElement.getAttribute(BLOCKED_ATTRIBUTE);
                    if (!string7.equals("0")) {
                        if (string7.equals("1")) {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Blocked.1"), gShellEvent.getStatus()));
                        } else {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Blocked", string7), gShellEvent.getStatus()));
                        }
                    }
                    string7 = null;
                    String string8 = gShellElement.getAttribute(IGNORED_ATTRIBUTE);
                    if (!string8.equals("0")) {
                        if (string8.equals("1")) {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Ignored.1"), gShellEvent.getStatus()));
                        } else {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Ignored", string8), gShellEvent.getStatus()));
                        }
                    }
                    string8 = null;
                    String string9 = gShellElement.getAttribute(FAILED_ATTRIBUTE);
                    if (!string9.equals("0")) {
                        if (string9.equals("1")) {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Failed.1"), gShellEvent.getStatus()));
                        } else {
                            arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), "    " + Dictionary.get("GShell.Import.ImportComplete.Failed", string9), gShellEvent.getStatus()));
                        }
                    }
                    string9 = null;
                    arrayList.add(new GShellEvent(gShellEvent.getSource(), 0, gShellEvent.getType(), Dictionary.get("GShell.Import.ImportComplete3"), gShellEvent.getStatus()));
                } else {
                    String string10 = gShellElement.getAttribute(PROCESSED_ATTRIBUTE);
                    try {
                        this.num_docs = Integer.parseInt(string10);
                    }
                    catch (Exception exception) {
                        this.num_docs = 0;
                    }
                }
            } else {
                gShellEvent.veto();
            }
        } else if (Configuration.getMode() <= this.threshold) {
            gShellEvent.veto();
        }
    }

    @Override
    public void reset() {
        this.setValue(0);
        this.progress_bar.setString(null);
        this.progress_bar.updateUI();
    }

    @Override
    public void saving() {
        this.progress_bar.setString(Dictionary.get("SaveProgressDialog.Title"));
        this.showing_string = true;
    }

    @Override
    public synchronized void setStop(boolean bl) {
        this.stop = bl;
    }

    @Override
    public void start() {
        this.stop = false;
        this.setValue(0);
        this.progress_bar.setString(Dictionary.get("FileActions.Calculating_Size"));
        this.showing_string = true;
        this.extracted_file_count = 0;
        this.file_count = 0;
        this.next_progress_value = -1;
        this.num_docs = -1;
        this.num_expected_docs = Gatherer.c_man.getCollection().getCount() * 2;
    }

    @Override
    public void stop() {
        this.setValue(1000000);
    }

    private void setValue(int n) {
        if (n > 1000000) {
            DebugStream.println("Error: Tried to set progress bar higher than maximum!\n");
            return;
        }
        if (n != 0 && n < this.previous_value) {
            DebugStream.println("Error: Tried to set progress bar smaller than previous!\n");
            return;
        }
        this.progress_bar.setValue(n);
        this.shared_progress_bar.setValue(n);
        this.previous_value = n;
    }
}

