/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.feedback.Base64;
import org.greenstone.gatherer.remote.RemoteGreenstoneServer;
import org.greenstone.gatherer.remote.ZipTools;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.util.UnzipTools;
import org.greenstone.gatherer.util.Utility;

public abstract class RemoteGreenstoneServerAction {
    public String action_output = null;
    public boolean processed = false;
    public boolean processed_successfully;
    protected RemoteGreenstoneServer remote = Gatherer.remoteGreenstoneServer;
    protected RemoteGreenstoneServer.ProgressBar progress_bar = this.remote.getProgressBar();

    public abstract void perform() throws Exception;

    static class UploadFilesIntoCollectionAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File[] source_files;
        private File target_collection_directory;

        public UploadFilesIntoCollectionAction(String string, File[] fileArray, File file) {
            this.collection_name = string;
            this.source_files = fileArray;
            this.target_collection_directory = file;
        }

        @Override
        public void perform() throws Exception {
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String string2 = this.remote.getPathRelativeToDirectory(this.target_collection_directory, string);
            string2 = string2.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            this.progress_bar.setAction("Uploading files into collection...");
            String string3 = Gatherer.getCollectDirectoryPath() + this.collection_name + "-" + System.currentTimeMillis() + ".zip";
            String string4 = new File(string3).getName();
            DebugStream.println("Zip file path: " + string3);
            String string5 = this.source_files[0].getParentFile().getAbsolutePath();
            DebugStream.println("Base directory path: " + string5);
            String[] stringArray = new String[this.source_files.length];
            for (int i = 0; i < this.source_files.length; ++i) {
                DebugStream.println("Source file path: " + this.source_files[i]);
                stringArray[i] = this.remote.getPathRelativeToDirectory(this.source_files[i], string5);
            }
            ZipTools.zipFiles(string3, string5, stringArray);
            String string6 = "cmd=upload-collection-file";
            string6 = string6 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string6 = string6 + "&file=" + URLEncoder.encode(string4, "UTF-8");
            string6 = string6 + "&directory=" + URLEncoder.encode(string2, "UTF-8");
            string6 = string6 + "&zip=true";
            string6 = string6 + "&lr=" + this.remote.lang_region;
            this.action_output = this.remote.uploadFile(string6, string3);
        }
    }

    static class UploadCollectionFilesAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File[] collection_files;

        public UploadCollectionFilesAction(String string, File[] fileArray) {
            this.collection_name = string;
            this.collection_files = fileArray;
        }

        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Uploading collection files...");
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String[] stringArray = new String[this.collection_files.length];
            for (int i = 0; i < this.collection_files.length; ++i) {
                stringArray[i] = this.remote.getPathRelativeToDirectory(this.collection_files[i], string);
            }
            String string2 = string;
            String string3 = new File(string2).getName() + "-" + System.currentTimeMillis() + ".zip";
            string2 = string2 + string3;
            ZipTools.zipFiles(string2, string, stringArray);
            String string4 = "cmd=upload-collection-file";
            string4 = string4 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string4 = string4 + "&file=" + URLEncoder.encode(string3, "UTF-8");
            string4 = string4 + "&directory=";
            string4 = string4 + "&zip=true";
            string4 = string4 + "&lr=" + this.remote.lang_region;
            this.action_output = this.remote.uploadFile(string4, string2);
        }
    }

    static class RunScriptAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private String script_name;
        private String script_arguments;
        private GShell shell;

        public RunScriptAction(String string, String string2, String string3, GShell gShell) {
            this.collection_name = string;
            this.script_name = string2;
            this.script_arguments = string3;
            this.shell = gShell;
        }

        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Running " + this.script_name + "...");
            String string = "cmd=run-script";
            string = string + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string = string + "&script=" + this.script_name;
            string = string + "&language=" + Configuration.getLanguage();
            string = string + this.script_arguments;
            this.action_output = this.remote.sendCommandToServer(string, this.shell);
        }
    }

    static class NewCollectionDirectoryAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File new_collection_directory;

        public NewCollectionDirectoryAction(String string, File file) {
            this.collection_name = string;
            this.new_collection_directory = file;
        }

        @Override
        public void perform() throws Exception {
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String string2 = this.remote.getPathRelativeToDirectory(this.new_collection_directory, string);
            string2 = string2.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            this.progress_bar.setAction("Creating new directory " + string2 + "...");
            String string3 = "cmd=new-collection-directory";
            string3 = string3 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string3 = string3 + "&directory=" + URLEncoder.encode(string2, "UTF-8");
            this.action_output = this.remote.sendCommandToServer(string3, null);
        }
    }

    static class MoveCollectionFileAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File source_collection_file;
        private File target_collection_file;

        public MoveCollectionFileAction(String string, File file, File file2) {
            this.collection_name = string;
            this.source_collection_file = file;
            this.target_collection_file = file2;
        }

        @Override
        public void perform() throws Exception {
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String string2 = this.remote.getPathRelativeToDirectory(this.source_collection_file, string);
            string2 = string2.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            String string3 = this.remote.getPathRelativeToDirectory(this.target_collection_file, string);
            string3 = string3.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            this.progress_bar.setAction("Moving file " + string2 + " -> " + string3 + "...");
            String string4 = "cmd=move-collection-file";
            string4 = string4 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string4 = string4 + "&source=" + Base64.encodeBytesInSingleLine(string2.getBytes());
            string4 = string4 + "&target=" + Base64.encodeBytesInSingleLine(string3.getBytes());
            this.action_output = this.remote.sendCommandToServer(string4, null);
        }
    }

    static class GetDefaultServletPathAction
    extends RemoteGreenstoneServerAction {
        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Getting default servlet ...");
            String string = "cmd=get-default-servlet-path";
            this.action_output = this.remote.sendCommandToServer(string, null);
        }
    }

    static class GetSiteNamesAction
    extends RemoteGreenstoneServerAction {
        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Getting names of sites ...");
            String string = "cmd=get-site-names";
            this.action_output = this.remote.sendCommandToServer(string, null);
        }
    }

    static class GetScriptOptionsAction
    extends RemoteGreenstoneServerAction {
        private String script_name;
        private String script_arguments;

        public GetScriptOptionsAction(String string, String string2) {
            this.script_name = string;
            this.script_arguments = string2;
            this.script_arguments = string2.replace(File.separatorChar, '|');
        }

        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Getting options for " + this.script_name + "...");
            String string = "cmd=get-script-options";
            string = string + "&script=" + this.script_name;
            string = string + "&xml=";
            string = string + "&language=" + Configuration.getLanguage();
            string = string + this.script_arguments;
            this.action_output = this.remote.sendCommandToServer(string, null);
        }
    }

    static class DownloadWebXMLFileAction
    extends RemoteGreenstoneServerAction {
        @Override
        public void perform() throws Exception {
            String string = Configuration.gli_user_directory_path;
            String string2 = "cmd=download-web-xml-file";
            string2 = string2 + "&file=" + URLEncoder.encode("web.xml", "UTF-8");
            string2 = string2 + "&lr=" + this.remote.lang_region;
            String string3 = "web-xml.zip";
            String string4 = string + string3;
            this.action_output = this.remote.downloadFile(string2, string4);
            UnzipTools.unzipFile(string4, string);
        }
    }

    static class DownloadCollectionFileAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File collection_file;

        public DownloadCollectionFileAction(String string, File file) {
            this.collection_name = string;
            this.collection_file = file;
        }

        @Override
        public void perform() throws Exception {
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String string2 = this.remote.getPathRelativeToDirectory(this.collection_file, string);
            string2 = string2.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            this.progress_bar.setAction("Downloading collection file " + string2 + "...");
            String string3 = "cmd=download-collection-file";
            string3 = string3 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string3 = string3 + "&file=" + URLEncoder.encode(string2, "UTF-8");
            string3 = string3 + "&lr=" + this.remote.lang_region;
            String string4 = Gatherer.getCollectDirectoryPath() + this.collection_name + "-" + this.collection_file.getName() + ".zip";
            this.action_output = this.remote.downloadFile(string3, string4);
            UnzipTools.unzipFile(string4, string);
        }
    }

    static class ExistsAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File collection_file;

        public ExistsAction(String string, File file) {
            this.collection_name = string;
            this.collection_file = file;
        }

        @Override
        public void perform() throws Exception {
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String string2 = this.remote.getPathRelativeToDirectory(this.collection_file, string);
            string2 = string2.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            File file = new File(string, string2);
            String string3 = "cmd=file-exists";
            string3 = string3 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string3 = string3 + "&file=" + Base64.encodeBytesInSingleLine(string2.getBytes());
            this.action_output = this.remote.sendCommandToServer(string3, null);
        }
    }

    static class LibraryURLSuffixAction
    extends RemoteGreenstoneServerAction {
        LibraryURLSuffixAction() {
        }

        @Override
        public void perform() throws Exception {
            this.action_output = this.remote.sendCommandToServer("cmd=get-library-url-suffix", null);
        }
    }

    static class VersionAction
    extends RemoteGreenstoneServerAction {
        VersionAction() {
        }

        @Override
        public void perform() throws Exception {
            this.action_output = this.remote.sendCommandToServer("cmd=greenstone-server-version", null);
        }
    }

    static class DownloadCollectionConfigurationsAction
    extends RemoteGreenstoneServerAction {
        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Downloading collection configurations...");
            Utility.delete(new File(Gatherer.getCollectDirectoryPath()));
            new File(Gatherer.getCollectDirectoryPath()).mkdirs();
            String string = "cmd=download-collection-configurations";
            string = string + "&lr=" + this.remote.lang_region;
            String string2 = Gatherer.getCollectDirectoryPath() + "collections.zip";
            try {
                this.action_output = this.remote.downloadFile(string, string2);
            }
            catch (Exception exception) {
                if (!Gatherer.GS3) {
                    throw exception;
                }
                if (exception.getMessage().contains("Directory") && exception.getMessage().contains("does not exist")) {
                    System.err.println("*** Warning: The stored GS3 site '" + Configuration.site_name + "' from the previous session did not exist.");
                    System.err.println("    Swapping to known site and attempting to download its collection configurations.");
                    ArrayList arrayList = Gatherer.servlet_config.getSites();
                    if (arrayList.size() > 0) {
                        String string3 = (String)arrayList.get(0);
                        String string4 = (String)Gatherer.servlet_config.getServletsForSite(string3).get(0);
                        Configuration.setSiteAndServlet(string3, string4);
                        this.action_output = this.remote.downloadFile(string, string2);
                    }
                    throw exception;
                }
                throw exception;
            }
            UnzipTools.unzipFile(string2, Gatherer.getCollectDirectoryPath());
        }
    }

    static class DownloadCollectionArchivesAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;

        public DownloadCollectionArchivesAction(String string) {
            this.collection_name = string;
        }

        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Downloading collection archives for " + this.collection_name + "...");
            String string = "cmd=download-collection-archives";
            string = string + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string = string + "&lr=" + this.remote.lang_region;
            String string2 = Gatherer.getCollectDirectoryPath() + this.collection_name + "-archives.zip";
            this.action_output = this.remote.downloadFile(string, string2);
            Utility.delete(new File(CollectionManager.getLoadedCollectionArchivesDirectoryPath()));
            UnzipTools.unzipFile(string2, Gatherer.getCollectDirectoryPath());
        }
    }

    static class DownloadCollectionAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;

        public DownloadCollectionAction(String string) {
            this.collection_name = string;
        }

        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Downloading remote collection " + this.collection_name + "...");
            String string = "cmd=download-collection";
            string = string + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string = string + "&lr=" + this.remote.lang_region;
            String string2 = Gatherer.getCollectDirectoryPath() + this.collection_name + ".zip";
            this.action_output = this.remote.downloadFile(string, string2);
            Utility.delete(new File(CollectionManager.getCollectionDirectoryPath(this.collection_name)));
            UnzipTools.unzipFile(string2, Gatherer.getCollectDirectoryPath());
        }
    }

    static class DeleteCollectionFileAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;
        private File collection_file;

        public DeleteCollectionFileAction(String string, File file) {
            this.collection_name = string;
            this.collection_file = file;
        }

        @Override
        public void perform() throws Exception {
            String string = CollectionManager.getCollectionDirectoryPath(this.collection_name);
            String string2 = this.remote.getPathRelativeToDirectory(this.collection_file, string);
            string2 = string2.replaceAll(Utility.isWindows() ? "\\\\" : "\\/", "|");
            this.progress_bar.setAction("Deleting collection file " + string2 + "...");
            String string3 = "cmd=delete-collection-file";
            string3 = string3 + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            string3 = string3 + "&file=" + Base64.encodeBytesInSingleLine(string2.getBytes());
            this.action_output = this.remote.sendCommandToServer(string3, null);
        }
    }

    static class DeleteCollectionAction
    extends RemoteGreenstoneServerAction {
        private String collection_name;

        public DeleteCollectionAction(String string) {
            this.collection_name = string;
        }

        @Override
        public void perform() throws Exception {
            this.progress_bar.setAction("Deleting collection " + this.collection_name + "...");
            String string = "cmd=delete-collection";
            string = string + "&c=" + URLEncoder.encode(this.collection_name.replace(File.separatorChar, '|'), "UTF-8");
            this.action_output = this.remote.sendCommandToServer(string, null);
        }
    }

    static class ActionCancelledException
    extends Exception {
        ActionCancelledException() {
        }
    }
}

