/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.util.StringTokenizer;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;

public class MetadataTools {
    public static final String NAMESPACE_SEPARATOR = ".";
    public static final String SUBELEMENT_SEPARATOR = "^";
    public static boolean TO_DISPLAY_NAMES = true;
    public static boolean FROM_DISPLAY_NAMES = false;

    public static String getDisplayNameForMetadataElementWithName(String string) {
        MetadataElement metadataElement = MetadataTools.getMetadataElementWithName(string);
        if (metadataElement != null) {
            return metadataElement.getDisplayName();
        }
        return string;
    }

    public static String getMetadataElementAttribute(MetadataElement metadataElement, String string, String string2, String string3) {
        String string4 = metadataElement.getAttribute(string, string2);
        if (string4 == null && !string2.equals(string3)) {
            string4 = metadataElement.getAttribute(string, string3);
        }
        return string4;
    }

    public static String getMetadataElementName(String string) {
        if (string.indexOf(NAMESPACE_SEPARATOR) != -1) {
            return string.substring(string.indexOf(NAMESPACE_SEPARATOR) + 1);
        }
        return string;
    }

    public static MetadataElement getMetadataElementWithDisplayName(String string) {
        String string2 = MetadataTools.getMetadataSetNamespace(string);
        MetadataSet metadataSet = MetadataSetManager.getMetadataSet(string2);
        if (metadataSet == null) {
            return null;
        }
        return metadataSet.getMetadataElementWithDisplayName(string);
    }

    public static MetadataElement getMetadataElementWithName(String string) {
        String string2 = MetadataTools.getMetadataSetNamespace(string);
        MetadataSet metadataSet = MetadataSetManager.getMetadataSet(string2);
        if (metadataSet == null) {
            return null;
        }
        String string3 = MetadataTools.getMetadataElementName(string);
        return metadataSet.getMetadataElementWithName(string3);
    }

    public static String getMetadataSetAttribute(MetadataSet metadataSet, String string, String string2, String string3) {
        String string4 = metadataSet.getAttribute(string, string2);
        if (string4 == null && !string2.equals(string3)) {
            string4 = metadataSet.getAttribute(string, string3);
        }
        return string4;
    }

    public static String getMetadataSetNamespace(String string) {
        if (string.indexOf(NAMESPACE_SEPARATOR) != -1) {
            return string.substring(0, string.indexOf(NAMESPACE_SEPARATOR));
        }
        return "";
    }

    public static String getRegularExpressionThatMatchesFilePath(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\.", "\\\\.");
        string2 = string2.replaceAll("\\(", "\\\\(");
        string2 = string2.replaceAll("\\)", "\\\\)");
        string2 = string2.replaceAll("\\[", "\\\\[");
        string2 = string2.replaceAll("\\]", "\\\\]");
        string2 = string2.replaceAll("\\{", "\\\\{");
        string2 = string2.replaceAll("\\}", "\\\\}");
        string2 = string2.replaceAll("\\+", "\\\\+");
        return string2;
    }

    public static String convertMetadataElementListNames(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;/", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = string2.trim();
            boolean bl2 = false;
            if (!(string2.equals(",") || string2.equals(";") || string2.equals("/"))) {
                MetadataElement metadataElement = null;
                if (bl) {
                    metadataElement = MetadataTools.getMetadataElementWithName(string3);
                    if (metadataElement != null) {
                        string3 = metadataElement.getDisplayName();
                        bl2 = true;
                    }
                } else {
                    metadataElement = MetadataTools.getMetadataElementWithDisplayName(string3);
                    if (metadataElement != null) {
                        string3 = metadataElement.getFullName();
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }
}

