/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui.tree;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.gui.Filter;
import org.greenstone.gatherer.gui.tree.DragTreeCellRenderer;
import org.greenstone.gatherer.util.DragComponent;
import org.greenstone.gatherer.util.DragGroup;
import org.greenstone.gatherer.util.DragTreeSelectionModel;

public abstract class DragTree
extends JTree
implements Autoscroll,
DragGestureListener,
DragSourceListener,
DropTargetListener,
DragComponent,
TreeSelectionListener {
    private Color background_color;
    private Color foreground_color;
    private DragGroup group;
    protected Filter filter = null;
    private ImageIcon disabled_background;
    private ImageIcon normal_background;
    private ImageIcon multiple_icon = new ImageIcon("resource" + File.separator + "multiple.gif");
    private int drag_action = 2;
    private Point pt_last = null;
    private Rectangle lower_cue_line;
    private Rectangle ra_ghost = new Rectangle();
    private Rectangle upper_cue_line;
    private TreePath previous_path = null;
    private static Cursor NO_DRAG_CURSOR = null;
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final int AUTOSCROLL_MARGIN = 12;
    public static final int TREE_DISPLAY_CHANGED = 0;
    public static final int LOADED_COLLECTION_CHANGED = 1;
    public static final int COLLECTION_CONTENTS_CHANGED = 2;

    public DragTree(TreeModel treeModel, boolean bl) {
        if (UIManager.get("Tree.leftChildIndent") == null) {
            UIManager.put("Tree.leftChildIndent", 7);
        }
        if (UIManager.get("Tree.rightChildIndent") == null) {
            UIManager.put("Tree.rightChildIndent", 13);
        }
        this.init(bl);
        if (treeModel != null) {
            this.setModel(treeModel);
        }
    }

    public void init(boolean bl) {
        if (NO_DRAG_CURSOR == null) {
            NO_DRAG_CURSOR = DragSource.DefaultMoveNoDrop;
        }
        this.filter = new Filter(this, null);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setAutoscrolls(true);
        this.setEditable(false);
        this.setLargeModel(true);
        this.setOpaque(true);
        this.setRootVisible(false);
        this.setSelectionModel(new DragTreeSelectionModel(this, bl));
        this.setShowsRootHandles(true);
        this.setUI(new BasicTreeUI());
        this.addKeyListener(new DragTreeKeyListener());
        this.addMouseListener(Gatherer.g_man.foa_listener);
        this.addTreeExpansionListener(Gatherer.g_man.foa_listener);
        this.addTreeSelectionListener(this);
        DragTreeCellRenderer dragTreeCellRenderer = new DragTreeCellRenderer();
        this.setCellRenderer(dragTreeCellRenderer);
        Component component = dragTreeCellRenderer.getTreeCellRendererComponent(this, "Prototype", true, true, false, 0, true);
        this.setRowHeight(component.getSize().height);
        component = null;
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, this.drag_action, this);
        new DropTarget(this, this.drag_action, this, true);
    }

    @Override
    public void autoscroll(Point point) {
        int n = this.getRowForLocation(point.x, point.y);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        if (point.y + rectangle.y <= 12) {
            n = n <= 0 ? 0 : --n;
        } else if (n < this.getRowCount() - 1) {
            ++n;
        }
        this.scrollRowToVisible(n);
    }

    @Override
    public void clearGhost() {
        this.paintImmediately(this.ra_ghost.getBounds());
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.group.grabFocus(this);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        this.clearGhost();
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.clearGhost();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (!this.isDraggable()) {
            return;
        }
        this.setEditable(false);
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (!this.isPathSelected(treePath)) {
            ((DragTreeSelectionModel)this.selectionModel).setImmediate(true);
            this.setSelectionPath(treePath);
            ((DragTreeSelectionModel)this.selectionModel).setImmediate(false);
        }
        if (treePath == null) {
            return;
        }
        if (!this.isValidDrag()) {
            try {
                dragGestureEvent.startDrag(NO_DRAG_CURSOR, new StringSelection("dummy"), this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        this.group.setSelection(this.getSelectionPaths());
        this.group.setSource(this);
        this.group.grabFocus(this);
        Rectangle rectangle = this.getPathBounds(treePath);
        this.group.mouse_offset = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n = this.getSelectionCount();
        if (n > 0) {
            JLabel jLabel;
            Object object;
            Object object2;
            if (n == 1) {
                object2 = this.getSelectionPath();
                object = (FileNode)treePath.getLastPathComponent();
                jLabel = new JLabel(((FileNode)object).toString(), ((DefaultTreeCellRenderer)this.getCellRenderer()).getLeafIcon(), 0);
            } else {
                object2 = this.getSelectionCount() + " " + Dictionary.get("Tree.Files");
                jLabel = new JLabel((String)object2, ((DefaultTreeCellRenderer)this.getCellRenderer()).getClosedIcon(), 0);
                object2 = null;
            }
            object2 = jLabel.getPreferredSize();
            jLabel.setSize((Dimension)object2);
            jLabel.setBackground(TRANSPARENT_COLOR);
            jLabel.setOpaque(true);
            this.group.image_ghost = new BufferedImage(((Dimension)object2).width, ((Dimension)object2).height, 3);
            object2 = null;
            object = this.group.image_ghost.createGraphics();
            ((Graphics2D)object).setComposite(AlphaComposite.getInstance(2, 0.5f));
            jLabel.paint((Graphics)object);
            object = null;
            jLabel = null;
            try {
                dragGestureEvent.startDrag(new Cursor(0), this.group.image_ghost, this.group.mouse_offset, new StringSelection("dummy"), this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        TreePath treePath;
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        Point point = dropTargetDragEvent.getLocation();
        if (this.pt_last != null && point.equals(this.pt_last)) {
            return;
        }
        this.pt_last = point;
        if (!DragSource.isDragImageSupported() && this.group.image_ghost != null) {
            this.paintImmediately(this.ra_ghost.getBounds());
            this.ra_ghost.setRect(point.x - this.group.mouse_offset.x, point.y - this.group.mouse_offset.y, this.group.image_ghost.getWidth(), this.group.image_ghost.getHeight());
            graphics2D.drawImage(this.group.image_ghost, AffineTransform.getTranslateInstance(this.ra_ghost.getX(), this.ra_ghost.getY()), null);
        }
        if ((treePath = this.getPathForLocation(point.x, point.y)) == null) {
            if (this.upper_cue_line != null && this.lower_cue_line != null) {
                this.paintImmediately(this.upper_cue_line.getBounds());
                this.paintImmediately(this.lower_cue_line.getBounds());
                this.previous_path = null;
            }
            return;
        }
        if (this.previous_path == null || treePath != null && !treePath.equals(this.previous_path)) {
            if (this.upper_cue_line != null && this.lower_cue_line != null) {
                this.paintImmediately(this.upper_cue_line.getBounds());
                this.paintImmediately(this.lower_cue_line.getBounds());
            }
            if (this.isValidDrop(treePath)) {
                Rectangle rectangle = this.getPathBounds(treePath);
                this.upper_cue_line = new Rectangle(0, rectangle.y + (int)rectangle.getHeight(), this.getWidth(), 2);
                this.lower_cue_line = new Rectangle(0, rectangle.y, this.getWidth(), 2);
                graphics2D.setColor(((DefaultTreeCellRenderer)this.cellRenderer).getBackgroundSelectionColor());
                graphics2D.fill(this.upper_cue_line);
                graphics2D.fill(this.lower_cue_line);
            } else {
                this.upper_cue_line = null;
                this.lower_cue_line = null;
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        TreePath[] treePathArray;
        if (!this.isDroppable()) {
            return;
        }
        dropTargetDropEvent.acceptDrop(this.drag_action);
        Point point = dropTargetDropEvent.getLocation();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        FileNode fileNode = null;
        if (treePath != null) {
            if (this.isValidDrop(treePath)) {
                fileNode = (FileNode)treePath.getLastPathComponent();
            } else if (this.isValidDropOntoFile(treePath)) {
                fileNode = (FileNode)treePath.getParentPath().getLastPathComponent();
            }
        } else {
            treePathArray = this.getModel();
            if (treePathArray != null && treePathArray instanceof FileSystemModel) {
                fileNode = (FileNode)treePathArray.getRoot();
            }
        }
        treePath = null;
        point = null;
        if (fileNode != null) {
            treePathArray = this.group.getSelection();
            if (fileNode != null && treePathArray != null) {
                FileNode[] fileNodeArray = new FileNode[treePathArray.length];
                for (int i = 0; i < fileNodeArray.length; ++i) {
                    fileNodeArray[i] = (FileNode)treePathArray[i].getLastPathComponent();
                }
                Gatherer.f_man.action(this.group.getSource(), fileNodeArray, this, fileNode);
                fileNodeArray = null;
            }
            this.group.setSelection(null);
            this.group.setSource(null);
            treePathArray = null;
            fileNode = null;
        }
        this.paintImmediately(this.ra_ghost.getBounds());
        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
        this.group.image_ghost = null;
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void gainFocus() {
        ((DragTreeCellRenderer)this.cellRenderer).gainFocus();
        this.repaint();
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        return new Insets(rectangle2.y - rectangle.y + 12, rectangle2.x - rectangle.x + 12, rectangle.height - rectangle2.height - rectangle2.y + rectangle.y + 12, rectangle.width - rectangle2.width - rectangle2.x + rectangle.x + 12);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getSelectionDetails() {
        return ((DragTreeSelectionModel)this.selectionModel).getDetails();
    }

    @Override
    public FileSystemModel getTreeModel() {
        return (FileSystemModel)this.getModel();
    }

    protected abstract boolean isDraggable();

    protected abstract boolean isDroppable();

    @Override
    public void loseFocus() {
        ((DragTreeCellRenderer)this.cellRenderer).loseFocus();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.disabled_background != null) {
            int n = this.getSize().height;
            int n2 = 0;
            ImageIcon imageIcon = this.isEnabled() ? this.normal_background : this.disabled_background;
            while (n - n2 > 0) {
                graphics.drawImage(imageIcon.getImage(), 0, n2, null);
                n2 += imageIcon.getIconHeight();
            }
            imageIcon = null;
        }
        super.paint(graphics);
    }

    public void refresh(TreePath treePath) {
        if (this.treeModel instanceof FileSystemModel) {
            ((FileSystemModel)this.treeModel).refresh(treePath);
        }
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.background_color = color;
        if (this.isEnabled()) {
            this.setBackground(color);
            ((DefaultTreeCellRenderer)this.cellRenderer).setBackgroundNonSelectionColor(color);
        } else {
            this.setBackground(Color.lightGray);
            ((DefaultTreeCellRenderer)this.cellRenderer).setBackgroundNonSelectionColor(Color.lightGray);
        }
        this.repaint();
    }

    public void setBackgroundSelectionColor(Color color) {
        ((DefaultTreeCellRenderer)this.cellRenderer).setBackgroundSelectionColor(color);
        this.repaint();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.setBackground(this.background_color);
            ((DefaultTreeCellRenderer)this.cellRenderer).setBackgroundNonSelectionColor(this.background_color);
            ((DefaultTreeCellRenderer)this.cellRenderer).setTextNonSelectionColor(this.foreground_color);
        } else {
            this.setBackground(Color.lightGray);
            ((DefaultTreeCellRenderer)this.cellRenderer).setBackgroundNonSelectionColor(Color.lightGray);
            ((DefaultTreeCellRenderer)this.cellRenderer).setTextNonSelectionColor(Color.black);
        }
        this.repaint();
    }

    @Override
    public void setGroup(DragGroup dragGroup) {
        this.group = dragGroup;
    }

    public void setImmediate(boolean bl) {
        ((DragTreeSelectionModel)this.selectionModel).setImmediate(bl);
    }

    @Override
    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        if (treeModel instanceof FileSystemModel) {
            FileSystemModel fileSystemModel = (FileSystemModel)treeModel;
            fileSystemModel.setTree(this);
            this.removeTreeExpansionListener(fileSystemModel);
            this.addTreeExpansionListener(fileSystemModel);
            this.removeTreeWillExpandListener(fileSystemModel);
            this.addTreeWillExpandListener(fileSystemModel);
            fileSystemModel = null;
        }
    }

    public void setSelection(File file) {
        FileNode fileNode = (FileNode)this.getModel().getRoot();
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file != null && !fileNode.toString().equals(file.getName())) {
            arrayList.add(0, file);
            file = file.getParentFile();
        }
        if (file == null) {
            return;
        }
        while (arrayList.size() > 0) {
            file = (File)arrayList.remove(0);
            boolean bl = false;
            fileNode.map();
            for (int i = 0; !bl && i < fileNode.getChildCount(); ++i) {
                FileNode fileNode2 = (FileNode)fileNode.getChildAt(i);
                if (!fileNode2.toString().equals(file.getName())) continue;
                bl = true;
                fileNode = fileNode2;
            }
            if (bl) continue;
            return;
        }
        TreePath treePath = new TreePath(fileNode.getPath());
        this.setImmediate(true);
        this.setSelectionPath(treePath);
        this.setImmediate(false);
    }

    public void setTextNonSelectionColor(Color color) {
        this.foreground_color = color;
        if (this.isEnabled()) {
            ((DefaultTreeCellRenderer)this.cellRenderer).setTextNonSelectionColor(color);
        } else {
            ((DefaultTreeCellRenderer)this.cellRenderer).setTextNonSelectionColor(Color.black);
        }
        this.repaint();
    }

    public void setTextSelectionColor(Color color) {
        ((DefaultTreeCellRenderer)this.cellRenderer).setTextSelectionColor(color);
        this.repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.group != null) {
            this.group.grabFocus(this);
        }
    }

    private boolean isValidDrag() {
        TreePath treePath = this.getSelectionPath();
        FileNode fileNode = (FileNode)treePath.getLastPathComponent();
        if (fileNode.getFile() == null) {
            return false;
        }
        if (fileNode.isFileSystemRoot()) {
            return false;
        }
        TreePath[] treePathArray = this.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            FileNode fileNode2 = (FileNode)treePathArray[i].getLastPathComponent();
            if (!fileNode2.isInLoadedCollection()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDropOntoFile(TreePath treePath) {
        FileNode fileNode;
        boolean bl = false;
        if (treePath != null && (fileNode = (FileNode)treePath.getLastPathComponent()).isLeaf()) {
            return this.isValidDrop(treePath.getParentPath());
        }
        return false;
    }

    private boolean isValidDrop(TreePath treePath) {
        boolean bl = false;
        if (treePath == null) {
            this.previous_path = null;
        } else {
            FileNode fileNode = (FileNode)treePath.getLastPathComponent();
            if (!fileNode.isLeaf() && !fileNode.isReadOnly()) {
                TreePath[] treePathArray = this.group.getSelection();
                boolean bl2 = false;
                for (int i = 0; !bl2 && treePathArray != null && i < treePathArray.length; ++i) {
                    bl2 = treePathArray[i].isDescendant(treePath);
                }
                if (!bl2) {
                    bl = true;
                }
            }
            this.previous_path = treePath;
        }
        return bl;
    }

    private class DragTreeKeyListener
    extends KeyAdapter {
        private boolean vk_left_pressed = false;

        private DragTreeKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            File file;
            DragTree dragTree;
            TreePath treePath;
            if (keyEvent.getKeyCode() == 127) {
                DragTree dragTree2 = (DragTree)DragTree.this.group.getActive();
                DragTree.this.group.setSource(dragTree2);
                TreePath[] treePathArray = dragTree2.getSelectionPaths();
                if (treePathArray != null) {
                    FileNode[] fileNodeArray = new FileNode[treePathArray.length];
                    for (int i = 0; i < fileNodeArray.length; ++i) {
                        fileNodeArray[i] = (FileNode)treePathArray[i].getLastPathComponent();
                    }
                    Gatherer.f_man.action(dragTree2, fileNodeArray, Gatherer.recycle_bin, null);
                    fileNodeArray = null;
                }
            } else if (keyEvent.getKeyCode() == 10) {
                DragTree dragTree3 = (DragTree)keyEvent.getSource();
                TreePath treePath2 = dragTree3.getSelectionPath();
                if (treePath2 != null) {
                    File file2 = ((FileNode)treePath2.getLastPathComponent()).getFile();
                    if (file2 != null && file2.isFile()) {
                        Gatherer.f_man.openFileInExternalApplication(file2);
                    } else if (!dragTree3.isExpanded(treePath2)) {
                        dragTree3.expandPath(treePath2);
                    } else {
                        dragTree3.collapsePath(treePath2);
                    }
                }
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                DragTree dragTree4 = (DragTree)keyEvent.getSource();
                boolean bl = keyEvent.getKeyCode() == 38;
                int n = dragTree4.getLeadSelectionRow();
                dragTree4.setImmediate(true);
                if (bl) {
                    if (n > 0) {
                        dragTree4.clearSelection();
                        dragTree4.setSelectionRow(n - 1);
                    }
                } else if (n < dragTree4.getRowCount() - 1) {
                    dragTree4.clearSelection();
                    dragTree4.setSelectionRow(n + 1);
                }
                dragTree4.setImmediate(false);
            } else if (keyEvent.getKeyCode() == 37 && (treePath = (dragTree = (DragTree)keyEvent.getSource()).getLeadSelectionPath()) != null && (file = ((FileNode)treePath.getLastPathComponent()).getFile()) != null && (file.isFile() || this.vk_left_pressed)) {
                this.vk_left_pressed = false;
                TreePath treePath3 = treePath.getParentPath();
                if (treePath3 != null && treePath3.getParentPath() != null) {
                    dragTree.setImmediate(true);
                    dragTree.clearSelection();
                    dragTree.setSelectionPath(treePath3);
                    dragTree.setImmediate(false);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 37) {
                DragTree dragTree = (DragTree)keyEvent.getSource();
                TreePath treePath = dragTree.getLeadSelectionPath();
                if (treePath == null) {
                    return;
                }
                File file = ((FileNode)treePath.getLastPathComponent()).getFile();
                if (file == null) {
                    return;
                }
                if (file.isDirectory() && dragTree.isCollapsed(treePath)) {
                    this.vk_left_pressed = true;
                }
            }
        }
    }
}

