/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui.metaaudit;

import de.qfs.lib.gui.DefaultTableModelSorter;
import de.qfs.lib.gui.SortedTableHelper;
import de.qfs.lib.gui.TableModelSorter;
import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.gui.metaaudit.Filter;
import org.greenstone.gatherer.gui.metaaudit.HeaderListener;
import org.greenstone.gatherer.gui.metaaudit.HeaderRenderer;
import org.greenstone.gatherer.gui.metaaudit.MetaAuditFrame;
import org.greenstone.gatherer.gui.metaaudit.MetaAuditRenderer;
import org.greenstone.gatherer.metadata.MetadataAuditTableModel;

public class MetaAuditTable
extends JTable
implements TableModelSorterListener {
    private boolean initial_state;
    private Filter filter;
    private HeaderRenderer header_renderer;
    private MetaAuditFrame parent_frame;
    private MetaAuditRenderer cell_renderer;
    private MetadataAuditTableModel metadata_audit_table_model;
    private SortedTableHelper helper;
    private static final int MARGIN = 10;

    public MetaAuditTable(MetaAuditFrame metaAuditFrame) {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.cell_renderer = new MetaAuditRenderer();
        this.header_renderer = new HeaderRenderer();
        this.parent_frame = metaAuditFrame;
        this.getTableHeader().addMouseListener(new HeaderListener(metaAuditFrame, this));
        this.setAutoResizeMode(0);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public MetadataAuditTableModel getOriginalModel() {
        return this.metadata_audit_table_model;
    }

    public TableModelSorter getSorter() {
        return this.helper.getTableModelSorter();
    }

    public boolean isFiltered(int n) {
        if (this.filter == null) {
            return false;
        }
        return this.filter.isFiltered(n);
    }

    public void newModel(CollectionTreeNode[] collectionTreeNodeArray) {
        if (collectionTreeNodeArray == null || collectionTreeNodeArray.length == 0) {
            this.setModel(new DefaultTableModel());
            return;
        }
        this.wait(true);
        this.initial_state = true;
        this.metadata_audit_table_model = new MetadataAuditTableModel();
        this.metadata_audit_table_model.rebuild(collectionTreeNodeArray);
        this.setModel(this.metadata_audit_table_model);
        this.filter = new Filter(this.metadata_audit_table_model.getColumnCount());
        this.helper = new SortedTableHelper(this, this.filter, new DefaultTableModelSorter(), this.header_renderer, null);
        this.helper.prepareTable();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setCellRenderer(this.cell_renderer);
            tableColumnModel.getColumn(i).setHeaderRenderer(this.header_renderer);
        }
        this.wait(false);
        this.initial_state = false;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object;
        Object object2;
        int n;
        this.wait(true);
        super.tableChanged(tableModelEvent);
        ArrayList[] arrayListArray = new ArrayList[this.dataModel.getRowCount()];
        int[] nArray = new int[this.dataModel.getColumnCount()];
        ArrayList[] arrayListArray2 = new ArrayList[this.dataModel.getColumnCount()];
        for (n = 0; n < this.dataModel.getRowCount(); ++n) {
            for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
                object2 = this.dataModel.getValueAt(n, i);
                if (!(object2 instanceof ArrayList)) continue;
                ArrayList arrayList = (ArrayList)object2;
                if (arrayListArray[n] == null || arrayList.size() > arrayListArray[n].size()) {
                    arrayListArray[n] = arrayList;
                }
                object = "";
                for (int j = 0; j < arrayList.size(); ++j) {
                    String string = arrayList.get(j).toString();
                    if (string.length() <= ((String)object).length()) continue;
                    object = string;
                }
                if (arrayListArray2[i] != null && ((String)object).length() <= nArray[i]) continue;
                nArray[i] = ((String)object).length();
                arrayListArray2[i] = arrayList;
            }
        }
        for (n = 0; n < arrayListArray.length; ++n) {
            if (arrayListArray[n] == null) continue;
            Component component = this.cell_renderer.getTableCellRendererComponent(this, arrayListArray[n], false, false, 0, 0);
            object2 = component.getPreferredSize();
            this.setRowHeight(n, ((Dimension)object2).height);
        }
        for (n = 0; n < arrayListArray2.length; ++n) {
            if (arrayListArray2[n] == null) continue;
            Component component = this.cell_renderer.getTableCellRendererComponent(this, arrayListArray2[n], false, false, 0, 0);
            object2 = component.getPreferredSize();
            int n2 = ((Dimension)object2).width + 10;
            if (n2 > 2 * this.parent_frame.getSize().width / 3) {
                n2 = 2 * this.parent_frame.getSize().width / 3;
            }
            object = this.header_renderer.getTableCellRendererComponent(this, this.dataModel.getColumnName(n), false, false, 0, 0);
            if (((Component)object).getPreferredSize().width + 10 > n2) {
                n2 = ((Component)object).getPreferredSize().width + 10;
            }
            this.columnModel.getColumn(n).setPreferredWidth(n2);
        }
        this.wait(this.initial_state);
    }

    @Override
    public void sortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
    }

    private void wait(boolean bl) {
        if (this.parent_frame != null) {
            this.parent_frame.wait(bl);
        }
    }
}

