/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TextFileEditor;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;

public class XMLFileEditor
extends TextFileEditor
implements ActionListener,
DocumentListener {
    protected JTextArea editor_msgarea;
    protected boolean add_elements_enabled = false;
    protected String elements_xml_file;
    protected Document elements_available_for_insertion;
    protected JComboBox chooseElementComboBox;
    protected GLIButton addElementButton;
    protected JPanel add_elements_panel;
    protected String[] nonEscapingTagNames = new String[0];

    public XMLFileEditor(File file) {
        super(file, "text/xml");
        this.add_elements_enabled = this.addElementsEnabled();
        this.elements_xml_file = this.getElementsXMLFileString();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Dictionary.get("CDM.FormatManager.MessageBox"));
        jLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.editor_msgarea = new JTextArea();
        this.editor_msgarea.setCaretPosition(0);
        this.editor_msgarea.setLineWrap(true);
        this.editor_msgarea.setRows(3);
        this.editor_msgarea.setWrapStyleWord(false);
        this.editor_msgarea.setEditable(false);
        this.editor_msgarea.setToolTipText(Dictionary.get("CDM.FormatManager.MessageBox_Tooltip"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel.setLayout(new BorderLayout(5, 0));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)new JScrollPane(this.editor_msgarea), "Center");
        if (this.add_elements_enabled) {
            JLabel jLabel2 = new JLabel(Dictionary.get("XMLFileEditor.Add_Element_Label"));
            Enum[] enumArray = this.getElementOptions();
            if (enumArray != null) {
                this.chooseElementComboBox = new JComboBox<Enum>(enumArray);
                this.addElementButton = new GLIButton(Dictionary.get("XMLFileEditor.Add_Label"), Dictionary.get("XMLFileEditor.Add_Element_Tooltip"));
                this.elements_available_for_insertion = XMLTools.parseXMLFile(this.elements_xml_file, true);
                this.addElementButton.addActionListener(this);
                if (this.elements_available_for_insertion == null) {
                    this.add_elements_enabled = false;
                    this.addElementButton.setEnabled(false);
                }
            }
            this.add_elements_panel = new JPanel(new FlowLayout());
            this.add_elements_panel.setComponentOrientation(Dictionary.getOrientation());
            this.add_elements_panel.add(jLabel2);
            this.add_elements_panel.add(this.chooseElementComboBox);
            this.add_elements_panel.add(this.addElementButton);
            this.toolbars_panel.add((Component)this.add_elements_panel, "Center");
        }
        this.content_pane.add((Component)jPanel, "North");
        this.setFileXMLInEditor();
        this.editor.setCaretPosition(0);
    }

    @Override
    protected void setFileTextInEditor() {
    }

    protected void setFileXMLInEditor() {
        String string;
        String string2 = Utility.readUTF8File(this.config_file);
        if (!string2.equals("")) {
            string = this.getProcessingInstruction(string2);
            string2 = string2.replace(string, "").trim();
        }
        if (!string2.equals("")) {
            string = XMLTools.parse(string2);
            this.editor_msgarea.setBackground(Color.red);
            this.editor_msgarea.setText(string);
            this.save_button.setEnabled(false);
            if (this.add_elements_enabled) {
                // empty if block
            }
            this.editor.setText(string2);
        } else {
            this.editor.setText("");
            this.editor_msgarea.setText("");
        }
    }

    protected Enum[] getElementOptions() {
        return null;
    }

    @Override
    protected void saveFile() {
        Document document = XMLTools.getDOM(this.editor.getText());
        XMLTools.writeXMLFile(this.config_file, document, this.nonEscapingTagNames);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.addElementButton) {
            this.addElementToFile();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected boolean addElementsEnabled() {
        return false;
    }

    protected String getElementsXMLFileString() {
        return null;
    }

    protected void addElementToFile() {
    }

    @Override
    public String getProcessingInstruction(String string) {
        int n;
        String string2 = "";
        if ((string = string.trim()).startsWith("<?xml") && (n = string.indexOf("?>")) != -1) {
            string2 = string.substring(0, n += 2);
        }
        return string2;
    }

    @Override
    public void update() {
        String string = this.editor.getText();
        String string2 = XMLTools.parse(string);
        this.editor_msgarea.setText(string2);
        if (string2.startsWith("well-formed !")) {
            this.editor_msgarea.setBackground(Color.white);
            this.save_button.setEnabled(true);
        } else {
            this.editor_msgarea.setBackground(Color.red);
            this.save_button.setEnabled(false);
            if (this.add_elements_enabled) {
                this.addElementButton.setEnabled(false);
            }
        }
    }
}

