/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;

public class URLField {
    public static String getText(JComponent jComponent) {
        if (jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        if (jComponent instanceof DropDown) {
            return (String)((JComboBox)jComponent).getSelectedItem();
        }
        return "";
    }

    public static String setText(JComponent jComponent, String string) {
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(string);
        } else if (jComponent instanceof DropDown) {
            ((JComboBox)jComponent).setSelectedItem(string);
        }
        return "";
    }

    public static boolean validateURL(JComponent jComponent) {
        if (jComponent instanceof Text) {
            return ((Text)jComponent).validateURL();
        }
        if (jComponent instanceof JTextField) {
            return true;
        }
        return ((DropDown)jComponent).validateURL();
    }

    public static boolean validateURL(String string) {
        if (!string.equals("")) {
            try {
                new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    public static void store(JComponent jComponent, String string) {
        if (jComponent instanceof JTextField) {
            String string2 = ((JTextField)jComponent).getText();
            Configuration.setString(string, true, string2);
            Configuration.save();
        } else {
            ((DropDown)jComponent).saveProperties();
        }
    }

    public static class URLCollectionPair {
        String url;
        String collection;

        public static URLCollectionPair[] createDefaultsArray(String[] stringArray) {
            URLCollectionPair[] uRLCollectionPairArray = new URLCollectionPair[stringArray.length];
            for (int i = 0; i < uRLCollectionPairArray.length; ++i) {
                uRLCollectionPairArray[i] = new URLCollectionPair(stringArray[i]);
            }
            return uRLCollectionPairArray;
        }

        public URLCollectionPair(String string) {
            this.set(string, "");
        }

        public URLCollectionPair(String string, String string2) {
            this.set(string, string2);
        }

        public void set(String string, String string2) {
            this.url = string;
            this.collection = string2;
        }

        public void setURL(String string) {
            this.url = string;
        }

        public void setCollection(String string) {
            this.collection = string;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getURL() {
            return this.url;
        }

        public String toString() {
            return this.url;
        }

        public String getSuffixNumber() {
            String string = "";
            boolean bl = false;
            for (int i = this.url.length() - 1; i >= 0 && !bl; --i) {
                char c = this.url.charAt(i);
                if (Character.isDigit(c)) {
                    string = Character.toString(c) + string;
                    continue;
                }
                bl = true;
            }
            return string;
        }
    }

    public static class DropDown
    extends JComboBox
    implements URLFieldControl {
        private String checkString = null;
        private String affectedProperty = null;
        private String coaffectedProperty = null;
        private static final int MAX_URLS = 5;

        public DropDown(Color color, Color color2, String[] stringArray, String string, String string2) {
            super(URLCollectionPair.createDefaultsArray(stringArray));
            this.setEditable(true);
            this.getEditor().selectAll();
            this.setComponentOrientation(Dictionary.getOrientation());
            this.setBackground(color2);
            this.setForeground(color);
            this.affectedProperty = string;
            this.coaffectedProperty = string2;
            this.setComboBoxValues();
        }

        public DropDown(Color color, Color color2, String[] stringArray, String string, String string2, String string3) {
            this(color, color2, stringArray, string, string2);
            this.checkString = string3;
        }

        @Override
        public boolean validateURL() {
            String string = this.getSelectedItem().toString();
            if (this.checkString != null && !string.endsWith(this.checkString)) {
                return false;
            }
            return URLField.validateURL(string);
        }

        public void saveProperties() {
            URLCollectionPair uRLCollectionPair;
            Object object = this.getSelectedItem();
            URLCollectionPair uRLCollectionPair2 = uRLCollectionPair = object instanceof URLCollectionPair ? (URLCollectionPair)object : new URLCollectionPair(object.toString());
            if (uRLCollectionPair != null) {
                this.insertItemAt(uRLCollectionPair, 0);
            } else {
                uRLCollectionPair = (URLCollectionPair)this.getItemAt(0);
            }
            Configuration.setString(this.affectedProperty, true, uRLCollectionPair.getURL());
            String string = uRLCollectionPair.getCollection();
            if (string.equals("")) {
                Configuration.setString(this.coaffectedProperty, true, null);
            } else {
                Configuration.setString(this.coaffectedProperty, true, string);
            }
            int n = 1;
            for (int i = 0; n < 5 && i < this.getItemCount(); ++i, ++n) {
                URLCollectionPair uRLCollectionPair3 = (URLCollectionPair)this.getItemAt(i);
                String string2 = uRLCollectionPair3.getURL();
                if (uRLCollectionPair3 == null || string2.equals(uRLCollectionPair.getURL()) || string2.equals("")) {
                    --n;
                    continue;
                }
                Configuration.setString(this.affectedProperty + n, true, string2);
                if (uRLCollectionPair3.getCollection().equals("")) {
                    Configuration.setString(this.coaffectedProperty + n, true, null);
                    continue;
                }
                Configuration.setString(this.coaffectedProperty + n, true, uRLCollectionPair3.getCollection());
            }
            Configuration.save();
        }

        private void setComboBoxValues() {
            String string = Configuration.getString(this.affectedProperty, true);
            String string2 = Configuration.getString(this.coaffectedProperty, true);
            boolean bl = string.equals("");
            if (!bl) {
                this.removeAllItems();
                this.addItem(new URLCollectionPair(string, string2));
            }
            int n = 1;
            while (!bl) {
                string = Configuration.getString(this.affectedProperty + n, true);
                string2 = Configuration.getString(this.coaffectedProperty + n, true);
                if (string.equals("")) {
                    bl = true;
                } else {
                    this.addItem(new URLCollectionPair(string, string2));
                }
                ++n;
            }
            Dimension dimension = new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            this.setPreferredSize(dimension);
        }
    }

    public static class Text
    extends JTextField
    implements URLFieldControl {
        public Text(Color color, Color color2) {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.setBackground(color2);
            this.setForeground(color);
        }

        @Override
        public boolean validateURL() {
            String string = this.getText();
            return URLField.validateURL(string);
        }
    }

    public static interface URLFieldControl {
        public boolean validateURL();
    }
}

