/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentControl;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Plugin;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.collection.ScriptOptions;
import org.greenstone.gatherer.feedback.Base64;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.SimpleResultDialog;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;

public class ReplaceSrcDocWithHtmlPrompt
extends ModalDialog
implements GShellListener {
    private static Dimension SIZE = new Dimension(675, 250);
    private JDialog self = this;
    private File[] srcdoc_files = null;
    private Vector failedFiles = null;
    private Argument plugin_arg = null;
    private ScriptOptions options = null;
    private JPanel options_pane = null;
    private StringBuffer error_message = null;
    private boolean successful;
    private String successfulOutput;

    public ReplaceSrcDocWithHtmlPrompt(File[] fileArray) {
        super((Frame)Gatherer.g_man, true);
        this.srcdoc_files = fileArray;
        this.failedFiles = new Vector(fileArray.length);
        ArrayList arrayList = CollectionDesignManager.plugin_manager.getSrcReplacerPlugins(fileArray[0]);
        if (arrayList.size() == 0) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("ReplaceSrcWithHTMLPrompt.NotSrcReplaceable"), Dictionary.get("ReplaceSrcWithHTMLPrompt.Title"), 0);
            return;
        }
        this.plugin_arg = this.createPluginArgument(arrayList);
        this.setJMenuBar(new SimpleMenuBar("replacingSourceDoc"));
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("ReplaceSrcWithHTMLPrompt.Title"));
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Options/>";
        Document document = XMLTools.parseXML(new StringReader(string));
        this.options = new ScriptOptions(document.getDocumentElement(), "replace_srcdoc_with_html.pl");
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setOpaque(true);
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        this.options_pane = new JPanel();
        this.addScriptOptions(this.options_pane);
        JScrollPane jScrollPane = new JScrollPane(this.options_pane);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        JTextArea jTextArea = new JTextArea(Dictionary.get("ReplaceSrcWithHTMLPrompt.Instructions"));
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(5);
        jTextArea.setWrapStyleWord(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        GLIButton gLIButton = new GLIButton(Dictionary.get("ReplaceSrcWithHTMLPrompt.ReplaceSrc"), Dictionary.get("ReplaceSrcWithHTMLPrompt.ReplaceSrc_Tooltip"));
        GLIButton gLIButton2 = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        gLIButton2.addActionListener(new CancelListener());
        gLIButton.addActionListener(new SrcReplaceListener());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(gLIButton);
        jPanel2.add(gLIButton2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTextArea, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - ReplaceSrcDocWithHtmlPrompt.SIZE.width) / 2, (dimension.height - ReplaceSrcDocWithHtmlPrompt.SIZE.height) / 2);
        this.setVisible(true);
    }

    public void destroy() {
    }

    @Override
    public synchronized void message(GShellEvent gShellEvent) {
        String string = gShellEvent.getMessage();
        if (string.startsWith("replace_srcdoc_with_html.pl>")) {
            string = string.substring(28);
            this.error_message.append(string);
            this.error_message.append("\n");
        }
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        this.successful = false;
        if (gShellEvent.getStatus() == 1) {
            this.successful = true;
            GShell gShell = (GShell)gShellEvent.getSource();
            this.successfulOutput = gShell.getCommandOutput();
            gShell.resetCommandOutput();
        }
    }

    private Argument createPluginArgument(ArrayList arrayList) {
        Argument argument = new Argument();
        argument.setName("plugin");
        argument.setDescription(Dictionary.get("ReplaceSrcWithHTMLPrompt.Plugin"));
        argument.setRequired(true);
        argument.setType((byte)0);
        for (int i = 0; i < arrayList.size(); ++i) {
            Plugin plugin = (Plugin)arrayList.get(i);
            argument.addOption(plugin.getName(), plugin.getName());
        }
        return argument;
    }

    private void addScriptOptions(JPanel jPanel) {
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = Configuration.getMode();
        int n2 = this.options.getArgumentCount();
        ArgumentControl argumentControl = new ArgumentControl(this.plugin_arg, true, null);
        argumentControl.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jPanel.add(argumentControl);
        for (int i = 0; i < n2; ++i) {
            Argument argument = this.options.getArgument(i);
            if (argument.isHiddenGLI() || argument.getModeLevel() > n) continue;
            argumentControl = new ArgumentControl(argument, false, null);
            argumentControl.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
            jPanel.add(argumentControl);
        }
    }

    private void updateScriptOptions() {
        for (int i = 0; i < this.options_pane.getComponentCount(); ++i) {
            Component component = this.options_pane.getComponent(i);
            if (!(component instanceof ArgumentControl)) continue;
            ArgumentControl argumentControl = (ArgumentControl)component;
            String string = argumentControl.getArgumentName();
            String string2 = argumentControl.getValue();
            boolean bl = argumentControl.isEnabled();
            if (!bl && string2 == null) {
                this.options.removeValue(string);
                continue;
            }
            if (string2.equals("")) {
                this.options.setValue(string, false, string2);
                continue;
            }
            this.options.setValue(string, bl, string2);
        }
    }

    private int replaceSrcDoc(int n) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "replace_srcdoc_with_html.pl");
        String[] stringArray = this.options.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(this.srcdoc_files[n].getPath());
        } else {
            String string = CollectionManager.getLoadedCollectionName();
            object = CollectionManager.getCollectionDirectoryPath(string);
            String string2 = Gatherer.remoteGreenstoneServer.getPathRelativeToDirectory(this.srcdoc_files[n], (String)object);
            string2 = string2.replace(File.separatorChar, '|');
            arrayList.add("-file");
            arrayList.add(Base64.encodeBytes(string2.getBytes()));
            arrayList.add(string);
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        this.error_message = new StringBuffer();
        object = new GShell(stringArray2, 7, 3, this, null, GShell.GSHELL_SRCREPLACE);
        ((GShell)object).run();
        if (this.successful) {
            return 0;
        }
        return 1;
    }

    private void resultPrompt(boolean bl, String string) {
        if (bl) {
            JOptionPane.showMessageDialog(null, Dictionary.get("ReplaceSrcWithHTMLPrompt.Successful_ReplaceSrc"), Dictionary.get("ReplaceSrcWithHTMLPrompt.Successful_Title"), 1);
        } else {
            String string2 = Dictionary.get("ReplaceSrcWithHTMLPrompt.Failed_Title");
            String string3 = this.failedFiles.size() > 0 ? this.failedFiles.get(0).toString() : "";
            for (int i = 1; i < this.failedFiles.size(); ++i) {
                string3 = string3 + ", " + this.failedFiles.get(i);
            }
            String string4 = Dictionary.get("ReplaceSrcWithHTMLPrompt.Failed_ReplaceSrc", string3);
            SimpleResultDialog simpleResultDialog = new SimpleResultDialog(string2, string4, string);
            simpleResultDialog.setVisible(true);
            simpleResultDialog.dispose();
            simpleResultDialog = null;
        }
    }

    private class ReplaceSrcDocWithHtmlTask
    extends Thread {
        @Override
        public void run() {
            int n = 0;
            String string = "";
            for (int i = 0; i < ReplaceSrcDocWithHtmlPrompt.this.srcdoc_files.length; ++i) {
                int n2 = ReplaceSrcDocWithHtmlPrompt.this.replaceSrcDoc(i);
                n += n2;
                string = string + ReplaceSrcDocWithHtmlPrompt.this.error_message.toString();
                ReplaceSrcDocWithHtmlPrompt.this.error_message = null;
                if (n2 != 0) {
                    ReplaceSrcDocWithHtmlPrompt.this.failedFiles.add(ReplaceSrcDocWithHtmlPrompt.this.srcdoc_files[i].getName());
                    continue;
                }
                if (Gatherer.isGsdlRemote) {
                    String[] stringArray = ReplaceSrcDocWithHtmlPrompt.this.successfulOutput.split("\n");
                    String string2 = stringArray[stringArray.length - 1];
                    String string3 = string2 + ".html";
                    Utility.delete(ReplaceSrcDocWithHtmlPrompt.this.srcdoc_files[i]);
                    Gatherer.remoteGreenstoneServer.downloadCollectionFile(CollectionManager.getLoadedCollectionName(), new File(ReplaceSrcDocWithHtmlPrompt.this.srcdoc_files[i].getParentFile(), string3));
                    File file = new File(ReplaceSrcDocWithHtmlPrompt.this.srcdoc_files[i].getParentFile(), string2 + "_files");
                    if (Gatherer.remoteGreenstoneServer.exists(CollectionManager.getLoadedCollectionName(), file)) {
                        Gatherer.remoteGreenstoneServer.downloadCollectionFile(CollectionManager.getLoadedCollectionName(), file);
                    }
                }
                Gatherer.g_man.refreshCollectionTree(2);
                Gatherer.g_man.wait(false);
            }
            if (n != 0) {
                ReplaceSrcDocWithHtmlPrompt.this.resultPrompt(false, string);
            } else {
                ReplaceSrcDocWithHtmlPrompt.this.resultPrompt(true, string);
            }
        }
    }

    private class SrcReplaceListener
    implements ActionListener {
        private SrcReplaceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Gatherer.g_man.wait(true);
            ReplaceSrcDocWithHtmlPrompt.this.updateScriptOptions();
            ReplaceSrcDocWithHtmlPrompt.this.self.dispose();
            new ReplaceSrcDocWithHtmlTask().start();
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReplaceSrcDocWithHtmlPrompt.this.self.dispose();
        }
    }
}

