/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.TestingPreparation;

public class NewFolderOrFilePrompt
extends JDialog
implements ActionListener {
    private FileNode node;
    private JButton cancel_button;
    private JButton ok_button;
    private JTextField name_field;
    private String name;
    private int type;
    private String extension = "";
    private static final Dimension SIZE = new Dimension(350, 115);

    public NewFolderOrFilePrompt(FileNode fileNode, int n, String string) {
        super((Frame)Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
        if (n == 0) {
            this.setTitle(Dictionary.get("NewFolderOrFilePrompt.Title_Empty_File"));
        } else if (n == 1) {
            this.setTitle(Dictionary.get("NewFolderOrFilePrompt.Title_File"));
        } else {
            this.setTitle(Dictionary.get("NewFolderOrFilePrompt.Title_Folder"));
        }
        this.type = n;
        if (string != null) {
            this.extension = string;
        }
        this.node = fileNode;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok_button) {
            this.name = this.type == 1 ? this.name_field.getText() + this.extension : this.name_field.getText();
        } else if (actionEvent.getSource() == this.cancel_button) {
            this.name = null;
        }
        this.dispose();
    }

    public String getNameOfNewFolderOrFile() {
        return this.name;
    }

    public String display() {
        this.setSize(SIZE);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("NewFolderOrFilePrompt.Destination_Name"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JTextField jTextField = new JTextField(this.node.getFile().getName());
        jTextField.setComponentOrientation(Dictionary.getOrientation());
        jTextField.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        jTextField.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        this.name_field = new JTextField(this.getAutomaticName());
        this.name_field.setComponentOrientation(Dictionary.getOrientation());
        this.name_field.selectAll();
        if (this.type == 0 || this.type == 1) {
            jLabel2.setText(Dictionary.get("NewFolderOrFilePrompt.File_Name"));
            this.name_field.setToolTipText(Dictionary.get("NewFolderOrFilePrompt.File_Name_Tooltip"));
        } else {
            jLabel2.setText(Dictionary.get("NewFolderOrFilePrompt.Folder_Name"));
            this.name_field.setToolTipText(Dictionary.get("NewFolderOrFilePrompt.Folder_Name_Tooltip"));
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.cancel_button.addActionListener(this);
        this.ok_button.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok_button);
        jPanel2.setLayout(new GridLayout(2, 1, 5, 0));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel3.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel3.add(jTextField);
        jPanel3.add(this.name_field);
        jPanel4.setLayout(new BorderLayout(5, 0));
        jPanel4.add((Component)jPanel2, "Before");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel5.setLayout(new GridLayout(1, 2, 0, 5));
        jPanel5.add(this.ok_button);
        jPanel5.add(this.cancel_button);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel5, "South");
        Rectangle rectangle = Gatherer.g_man.getBounds();
        this.setLocation(rectangle.x + (rectangle.width - NewFolderOrFilePrompt.SIZE.width) / 2, rectangle.y + (rectangle.height - NewFolderOrFilePrompt.SIZE.height) / 2);
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
        return this.name;
    }

    private String getAutomaticName() {
        File file = this.node.getFile();
        String string = this.type == 0 || this.type == 1 ? Dictionary.get("NewFolderOrFilePrompt.Default_File_Name") : Dictionary.get("NewFolderOrFilePrompt.Default_Folder_Name");
        File file2 = new File(file, string + this.extension);
        int n = 1;
        while (file2.exists()) {
            file2 = new File(file, string + " " + n + this.extension);
            ++n;
        }
        if (this.extension.equals("") || this.type == 0) {
            return file2.getName();
        }
        String string2 = file2.getName();
        return string2.substring(0, string2.length() - this.extension.length());
    }
}

