/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.DynamicListModel;
import org.greenstone.gatherer.gems.GEMS;
import org.greenstone.gatherer.gems.GEMSListener;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.MetadataElementListCellRenderer;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;

public class MetadataSetDialog
extends ModalDialog {
    private static Dimension SIZE = new Dimension(600, 300);
    private static Dimension ADD_SIZE = new Dimension(600, 500);
    private ArrayList current_metadata_sets;
    private DynamicListModel current_metadata_model;
    private JButton add_button = null;
    private JButton edit_button = null;
    private JButton remove_button = null;
    private JButton close_button = null;
    private JList current_set_list = null;
    private MetadataSetDialog set_dialog = this;
    private boolean sets_changed = false;
    private GEMS gems = null;

    public MetadataSetDialog() {
        super((Frame)Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setJMenuBar(new SimpleMenuBar("selectingmetadatasets"));
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("MetadataSetDialog.Title"));
        this.current_metadata_sets = MetadataSetManager.getMetadataSets();
        this.current_metadata_model = new DynamicListModel();
        int n = this.current_metadata_sets.size();
        for (int i = 0; i < n; ++i) {
            this.current_metadata_model.addElement(this.current_metadata_sets.get(i));
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setOpaque(true);
        JLabel jLabel = new JLabel(Dictionary.get("MetadataSetDialog.Current_Sets"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jLabel.setOpaque(true);
        this.current_set_list = new JList(this.current_metadata_model);
        this.current_set_list.setComponentOrientation(Dictionary.getOrientation());
        this.current_set_list.setSelectionMode(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        this.add_button = new GLIButton(Dictionary.get("MetadataSetDialog.Add"), Dictionary.get("MetadataSetDialog.Add_Tooltip"));
        this.add_button.setEnabled(true);
        this.edit_button = new GLIButton(Dictionary.get("MetadataSetDialog.Edit"), Dictionary.get("MetadataSetDialog.Edit_Tooltip"));
        this.edit_button.setEnabled(false);
        this.remove_button = new GLIButton(Dictionary.get("MetadataSetDialog.Remove"), Dictionary.get("MetadataSetDialog.Remove_Tooltip"));
        this.remove_button.setEnabled(false);
        this.close_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
        this.close_button.setEnabled(true);
        this.add_button.addActionListener(new AddButtonListener());
        this.edit_button.addActionListener(new EditButtonListener());
        this.remove_button.addActionListener(new RemoveButtonListener());
        this.close_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MetadataSetDialog.this.set_dialog.dispose();
            }
        });
        this.current_set_list.addListSelectionListener(new MetadataSetListSelectionListener());
        jPanel2.setLayout(new GridLayout(2, 3));
        jPanel2.add(this.add_button);
        jPanel2.add(this.edit_button);
        jPanel2.add(this.remove_button);
        jPanel2.add(new JPanel());
        jPanel2.add(new JPanel());
        jPanel2.add(this.close_button);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.current_set_list);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - MetadataSetDialog.SIZE.width) / 2, (dimension.height - MetadataSetDialog.SIZE.height) / 2);
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
    }

    public boolean setsChanged() {
        return this.sets_changed;
    }

    private class AddMetadataSetPrompt
    extends ModalDialog
    implements GEMSListener {
        private JDialog add_set_dialog;
        private boolean cancelled;
        private JList elements_list;
        private JList available_sets_list;
        private JButton add_button;
        private JButton new_button;
        private GEMSListener self;

        public AddMetadataSetPrompt() {
            super((Frame)Gatherer.g_man, true);
            this.cancelled = false;
            this.setComponentOrientation(Dictionary.getOrientation());
            this.add_set_dialog = this;
            this.setModal(true);
            this.setJMenuBar(new SimpleMenuBar("choosingmetadatasets"));
            this.setSize(ADD_SIZE);
            this.setTitle(Dictionary.get("MetadataSetDialog.Add_Title"));
            this.self = this;
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("MetadataSetDialog.Available_Sets"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            jLabel.setOpaque(false);
            this.available_sets_list = new JList(this.getValidSetModel());
            this.available_sets_list.setComponentOrientation(Dictionary.getOrientation());
            this.available_sets_list.addListSelectionListener(new AvailableSetListSelectionListener());
            this.available_sets_list.setSelectionMode(0);
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel2 = new JLabel(Dictionary.get("MetadataSetDialog.Elements"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            this.elements_list = new JList();
            this.elements_list.setComponentOrientation(Dictionary.getOrientation());
            this.elements_list.setCellRenderer(new MetadataElementListCellRenderer());
            this.elements_list.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.elements_list.setForeground(Configuration.getColor("coloring.collection_tree_foreground", false));
            this.elements_list.setSelectionBackground(Configuration.getColor("coloring.collection_tree_background", false));
            this.elements_list.setSelectionForeground(Configuration.getColor("coloring.collection_tree_foreground", false));
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            this.add_button = new GLIButton(Dictionary.get("MetadataSetDialog.Add_Set"), Dictionary.get("MetadataSetDialog.Add_Set_Tooltip"));
            this.add_button.setEnabled(false);
            this.new_button = new GLIButton(Dictionary.get("MetadataSetDialog.New_Set"), Dictionary.get("MetadataSetDialog.New_Set_Tooltip"));
            GLIButton gLIButton = new GLIButton(Dictionary.get("MetadataSetDialog.Browse"), Dictionary.get("MetadataSetDialog.Browse_Tooltip"));
            gLIButton.setEnabled(true);
            GLIButton gLIButton2 = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
            this.add_button.addActionListener(new AddSetActionListener());
            gLIButton.addActionListener(new BrowseActionListener());
            gLIButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AddMetadataSetPrompt.this.cancelled = true;
                    if (MetadataSetDialog.this.gems != null) {
                        MetadataSetDialog.this.gems.removeGEMSListener(AddMetadataSetPrompt.this.self);
                    }
                    AddMetadataSetPrompt.this.add_set_dialog.dispose();
                }
            });
            this.new_button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MetadataSetDialog.this.gems == null) {
                        MetadataSetDialog.this.gems = new GEMS("", false);
                    }
                    MetadataSetDialog.this.gems.newMetadataSet();
                    MetadataSetDialog.this.gems.addGEMSListener(AddMetadataSetPrompt.this.self);
                }
            });
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jLabel, "North");
            jPanel2.add((Component)new JScrollPane(this.available_sets_list), "Center");
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jLabel2, "North");
            jPanel3.add((Component)new JScrollPane(this.elements_list), "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new GridLayout(2, 1, 0, 5));
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel4.setLayout(new GridLayout(1, 4, 5, 0));
            jPanel4.add(this.add_button);
            jPanel4.add(this.new_button);
            jPanel4.add(gLIButton);
            jPanel4.add(gLIButton2);
            JPanel jPanel5 = (JPanel)this.getContentPane();
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)jPanel, "Center");
            jPanel5.add((Component)jPanel4, "South");
            Dimension dimension = Configuration.screen_size;
            this.setLocation((dimension.width - ADD_SIZE.width) / 2, (dimension.height - ADD_SIZE.height) / 2);
            TestingPreparation.setNamesRecursively(this);
            this.setVisible(true);
        }

        public DynamicListModel getValidSetModel() {
            ArrayList arrayList = MetadataSetManager.listMetadataSets(new File(Gatherer.getGLIMetadataDirectoryPath()));
            ArrayList arrayList2 = MetadataSetManager.getMetadataSets();
            DynamicListModel dynamicListModel = new DynamicListModel();
            for (int i = 0; i < arrayList.size(); ++i) {
                MetadataSet metadataSet = (MetadataSet)arrayList.get(i);
                if (metadataSet.getNamespace().equals("ex") || metadataSet.getNamespace().equals("exp") || arrayList2.indexOf(metadataSet) != -1) continue;
                dynamicListModel.addElement(metadataSet);
            }
            return dynamicListModel;
        }

        @Override
        public void gemsIsClosed() {
            this.available_sets_list.setModel(this.getValidSetModel());
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        private class AvailableSetListSelectionListener
        implements ListSelectionListener {
            private AvailableSetListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!AddMetadataSetPrompt.this.available_sets_list.isSelectionEmpty()) {
                    MetadataSet metadataSet = (MetadataSet)AddMetadataSetPrompt.this.available_sets_list.getSelectedValue();
                    AddMetadataSetPrompt.this.elements_list.setListData(new Vector(metadataSet.getMetadataSetElements()));
                    AddMetadataSetPrompt.this.add_button.setEnabled(true);
                } else {
                    AddMetadataSetPrompt.this.elements_list.setListData(new String[0]);
                    AddMetadataSetPrompt.this.add_button.setEnabled(false);
                }
            }
        }

        private class BrowseActionListener
        implements ActionListener {
            private BrowseActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(new File(Gatherer.getGLIMetadataDirectoryPath()));
                jFileChooser.setComponentOrientation(Dictionary.getOrientation());
                jFileChooser.setFileFilter(new MetadataSet.MetadataSetFileFilter());
                jFileChooser.setDialogTitle(Dictionary.get("MetadataSetDialog.Add_Title"));
                int n = jFileChooser.showDialog(Gatherer.g_man, Dictionary.get("MetadataSetDialog.Add_Set"));
                if (n == 0) {
                    MetadataSet metadataSet = new MetadataSet(jFileChooser.getSelectedFile());
                    Gatherer.c_man.importMetadataSet(metadataSet);
                    MetadataSetDialog.this.current_metadata_model.addElement(metadataSet);
                    AddMetadataSetPrompt.this.cancelled = false;
                    AddMetadataSetPrompt.this.add_set_dialog.dispose();
                }
            }
        }

        private class AddSetActionListener
        implements ActionListener {
            private AddSetActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AddMetadataSetPrompt.this.available_sets_list.isSelectionEmpty()) {
                    return;
                }
                MetadataSet metadataSet = (MetadataSet)AddMetadataSetPrompt.this.available_sets_list.getSelectedValue();
                String string = metadataSet.getNamespace();
                MetadataSet metadataSet2 = null;
                metadataSet2 = MetadataSetManager.getMetadataSet(string);
                if (metadataSet2 != null) {
                    String[] stringArray = new String[]{metadataSet.toString(), metadataSet2.toString()};
                    WarningDialog warningDialog = new WarningDialog("warning.MetadataSetNamespaceClash", Dictionary.get("MetadataSetNamespaceClash.Title"), Dictionary.get("MetadataSetNamespaceClash.Message", stringArray), null, true);
                    if (warningDialog.display() == 2) {
                        warningDialog.dispose();
                        return;
                    }
                    MetadataSetDialog.this.current_metadata_model.removeElement(metadataSet2);
                    Gatherer.c_man.removeMetadataSet(metadataSet2);
                    MetadataSetDialog.this.sets_changed = true;
                    warningDialog.dispose();
                }
                Gatherer.c_man.importMetadataSet(metadataSet);
                metadataSet = MetadataSetManager.getMetadataSet(string);
                MetadataSetDialog.this.current_metadata_model.addElement(metadataSet);
                MetadataSetDialog.this.sets_changed = true;
                AddMetadataSetPrompt.this.cancelled = false;
                AddMetadataSetPrompt.this.add_set_dialog.dispose();
            }
        }
    }

    private class MetadataSetListSelectionListener
    implements ListSelectionListener {
        private MetadataSetListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (!MetadataSetDialog.this.current_set_list.isSelectionEmpty() && !((MetadataSet)MetadataSetDialog.this.current_set_list.getSelectedValue()).getNamespace().equals("ex")) {
                MetadataSetDialog.this.remove_button.setEnabled(true);
                MetadataSetDialog.this.edit_button.setEnabled(true);
            } else {
                MetadataSetDialog.this.remove_button.setEnabled(false);
                MetadataSetDialog.this.edit_button.setEnabled(false);
            }
        }
    }

    private class RemoveButtonListener
    implements ActionListener {
        private RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetadataSet metadataSet = (MetadataSet)MetadataSetDialog.this.current_set_list.getSelectedValue();
            MetadataSetDialog.this.current_metadata_model.removeElement(metadataSet);
            Gatherer.c_man.removeMetadataSet(metadataSet);
            MetadataSetDialog.this.sets_changed = true;
        }
    }

    private class EditButtonListener
    implements ActionListener,
    GEMSListener {
        private EditButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetadataSet metadataSet = (MetadataSet)MetadataSetDialog.this.current_set_list.getSelectedValue();
            String string = metadataSet.getMetadataSetFile().toString();
            if (MetadataSetDialog.this.gems == null) {
                MetadataSetDialog.this.gems = new GEMS("", false);
                MetadataSetDialog.this.gems.addGEMSListener(this);
            }
            MetadataSetDialog.this.gems.displayMetadataSet(string);
        }

        @Override
        public void gemsIsClosed() {
            MetadataSet metadataSet = (MetadataSet)MetadataSetDialog.this.current_set_list.getSelectedValue();
            MetadataSetManager.unloadMetadataSet(metadataSet);
            Gatherer.c_man.updateMetadataSet(metadataSet);
            MetadataSetManager.loadMetadataSet(metadataSet.getMetadataSetFile());
            MetadataSetDialog.this.sets_changed = true;
        }
    }

    private class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddMetadataSetPrompt addMetadataSetPrompt = new AddMetadataSetPrompt();
            if (!addMetadataSetPrompt.isCancelled()) {
                MetadataSetDialog.this.sets_changed = true;
            }
        }
    }
}

