/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

public class MenuBar
extends JMenuBar {
    public static ImageIcon BLANK_ICON = JarTools.getImage("blank.gif");
    public static ImageIcon HELP_ICON = JarTools.getImage("help.png");
    private int current_tab = -1;
    private int current_mode;
    public JMenu file = null;
    public JMenu edit = null;
    public JMenu help = null;
    public JMenuItem file_associations;
    public JMenuItem file_cdimage = null;
    public JMenuItem file_close = null;
    public JMenuItem file_delete = null;
    public JMenuItem file_exit = null;
    public JMenuItem file_exportas = null;
    public JMenuItem file_exportmeta = null;
    public JMenuItem file_convertmeta = null;
    public JMenuItem file_new = null;
    public JMenuItem file_open = null;
    public JMenuItem file_options = null;
    public JMenuItem file_save = null;
    public JMenuItem edit_copy;
    public JMenuItem edit_cut;
    public JMenuItem edit_paste;
    public JMenuItem edit_config;
    public JMenuItem edit_group_config;
    public JMenuItem help_general;
    public JMenuItem help_download;
    public JMenuItem help_gather;
    public JMenuItem help_enrich;
    public JMenuItem help_design;
    public JMenuItem help_create;
    public JMenuItem help_format;
    public JMenuItem help_files;
    public JMenuItem help_about;

    public MenuBar(MenuListener menuListener) {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.current_mode = Configuration.getMode();
        this.file = new JMenu();
        this.file.setEnabled(false);
        this.file.setText(Dictionary.get("Menu.File"));
        this.file.setComponentOrientation(Dictionary.getOrientation());
        this.file_associations = new JMenuItem(Dictionary.get("Menu.File_Associations"));
        this.file_associations.addActionListener(Gatherer.g_man);
        this.file_associations.setComponentOrientation(Dictionary.getOrientation());
        this.file_cdimage = new JMenuItem(Dictionary.get("Menu.File_CDimage"));
        this.file_cdimage.addActionListener(Gatherer.g_man);
        this.file_cdimage.setEnabled(!Gatherer.isGsdlRemote);
        this.file_cdimage.setComponentOrientation(Dictionary.getOrientation());
        this.file_close = new JMenuItem(Dictionary.get("Menu.File_Close"));
        this.file_close.addActionListener(Gatherer.g_man);
        this.file_close.setEnabled(false);
        this.file_close.setComponentOrientation(Dictionary.getOrientation());
        this.file_delete = new JMenuItem(Dictionary.get("Menu.File_Delete"));
        this.file_delete.addActionListener(Gatherer.g_man);
        this.file_delete.setComponentOrientation(Dictionary.getOrientation());
        this.file_exit = new JMenuItem(Dictionary.get("Menu.File_Exit"));
        this.file_exit.addActionListener(Gatherer.g_man);
        this.file_exit.setComponentOrientation(Dictionary.getOrientation());
        this.file_exportas = new JMenuItem(Dictionary.get("Menu.File_ExportAs"));
        this.file_exportas.addActionListener(Gatherer.g_man);
        this.file_exportas.setEnabled(!Gatherer.isGsdlRemote && !Gatherer.isWebswing);
        this.file_exportas.setComponentOrientation(Dictionary.getOrientation());
        this.file_exportmeta = new JMenuItem(Dictionary.get("Menu.File_ExportMeta"));
        this.file_exportmeta.addActionListener(Gatherer.g_man);
        this.file_exportmeta.setEnabled(false);
        this.file_exportmeta.setComponentOrientation(Dictionary.getOrientation());
        this.file_convertmeta = new JMenuItem(Dictionary.get("Menu.File_ConvertMetaToCSV"));
        this.file_convertmeta.addActionListener(Gatherer.g_man);
        this.file_convertmeta.setEnabled(false);
        this.file_convertmeta.setComponentOrientation(Dictionary.getOrientation());
        this.file_new = new JMenuItem(Dictionary.get("Menu.File_New"));
        this.file_new.addActionListener(Gatherer.g_man);
        this.file_new.setComponentOrientation(Dictionary.getOrientation());
        this.file_open = new JMenuItem(Dictionary.get("Menu.File_Open"));
        this.file_open.addActionListener(Gatherer.g_man);
        this.file_open.setComponentOrientation(Dictionary.getOrientation());
        this.file_options = new JMenuItem(Dictionary.get("Menu.File_Options"));
        this.file_options.addActionListener(Gatherer.g_man);
        this.file_options.setComponentOrientation(Dictionary.getOrientation());
        this.file_save = new JMenuItem(Dictionary.get("Menu.File_Save"));
        this.file_save.addActionListener(Gatherer.g_man);
        this.file_save.setEnabled(false);
        this.file_save.setComponentOrientation(Dictionary.getOrientation());
        this.file.add(this.file_new);
        this.file.add(this.file_open);
        this.file.add(this.file_save);
        this.file.add(this.file_close);
        this.file.add(new JSeparator());
        this.file.add(this.file_delete);
        this.file.add(this.file_exportas);
        this.file.add(this.file_exportmeta);
        this.file.add(this.file_convertmeta);
        if (!Gatherer.GS3) {
            this.file.add(this.file_cdimage);
        }
        this.file.add(new JSeparator());
        this.file.add(this.file_associations);
        this.file.add(this.file_options);
        this.file.add(new JSeparator());
        this.file.add(this.file_exit);
        if (Gatherer.isWebswing && !Gatherer.webswingAuthenticator.canCreateNewCollections()) {
            this.file_new.setEnabled(false);
        }
        this.edit = new JMenu();
        this.edit.setEnabled(false);
        this.edit.setText(Dictionary.get("Menu.Edit"));
        this.edit.setComponentOrientation(Dictionary.getOrientation());
        String string = "ctrl";
        if (Utility.isMac()) {
            String string2;
            char c = '\u2318';
            string = string2 = String.valueOf(c);
        }
        this.edit_cut = new JMenuItem(Dictionary.get("Menu.Edit_Cut", string));
        this.edit_cut.addActionListener(Gatherer.g_man);
        this.edit_cut.setComponentOrientation(Dictionary.getOrientation());
        this.edit_copy = new JMenuItem(Dictionary.get("Menu.Edit_Copy", string));
        this.edit_copy.addActionListener(Gatherer.g_man);
        this.edit_copy.setComponentOrientation(Dictionary.getOrientation());
        this.edit_paste = new JMenuItem(Dictionary.get("Menu.Edit_Paste", string));
        this.edit_paste.addActionListener(Gatherer.g_man);
        this.edit_paste.setComponentOrientation(Dictionary.getOrientation());
        this.edit.add(this.edit_cut);
        this.edit.add(this.edit_copy);
        this.edit.add(this.edit_paste);
        if (Gatherer.GS3) {
            this.edit_config = new JMenuItem(Dictionary.get("Menu.Edit_Config"));
            this.edit_config.addActionListener(Gatherer.g_man);
            this.edit_config.setComponentOrientation(Dictionary.getOrientation());
            this.edit.addMenuListener(menuListener);
            this.edit_group_config = new JMenuItem(Dictionary.get("Menu.Edit_Group_Config"));
            this.edit_group_config.addActionListener(Gatherer.g_man);
            this.edit_group_config.setComponentOrientation(Dictionary.getOrientation());
            if (this.current_mode == 3) {
                this.edit.add(this.edit_config);
                if (Gatherer.isWebswing) {
                    if (Gatherer.webswingAuthenticator.canEditSharedCollections()) {
                        this.edit.add(this.edit_group_config);
                    }
                } else {
                    this.edit.add(this.edit_group_config);
                }
            }
        }
        this.help = new JMenu();
        this.help.setIcon(HELP_ICON);
        this.help.setText(Dictionary.get("Menu.Help"));
        this.help.setComponentOrientation(Dictionary.getOrientation());
        this.help_general = new JMenuItem(Dictionary.get("Source.General"));
        this.help_general.addActionListener(Gatherer.g_man);
        this.help_general.setComponentOrientation(Dictionary.getOrientation());
        this.help_download = new JMenuItem(Dictionary.get("GUI.Download"), BLANK_ICON);
        this.help_download.addActionListener(Gatherer.g_man);
        this.help_download.setComponentOrientation(Dictionary.getOrientation());
        this.help_gather = new JMenuItem(Dictionary.get("GUI.Gather"), BLANK_ICON);
        this.help_gather.addActionListener(Gatherer.g_man);
        this.help_gather.setComponentOrientation(Dictionary.getOrientation());
        this.help_enrich = new JMenuItem(Dictionary.get("GUI.Enrich"), BLANK_ICON);
        this.help_enrich.addActionListener(Gatherer.g_man);
        this.help_enrich.setComponentOrientation(Dictionary.getOrientation());
        this.help_design = new JMenuItem(Dictionary.get("GUI.Design"), BLANK_ICON);
        this.help_design.addActionListener(Gatherer.g_man);
        this.help_design.setComponentOrientation(Dictionary.getOrientation());
        this.help_create = new JMenuItem(Dictionary.get("GUI.Create"), BLANK_ICON);
        this.help_create.addActionListener(Gatherer.g_man);
        this.help_create.setComponentOrientation(Dictionary.getOrientation());
        this.help_format = new JMenuItem(Dictionary.get("GUI.Format"), BLANK_ICON);
        this.help_format.addActionListener(Gatherer.g_man);
        this.help_format.setComponentOrientation(Dictionary.getOrientation());
        this.help_files = new JMenuItem(Dictionary.get("GUI.Files"), BLANK_ICON);
        this.help_files.addActionListener(Gatherer.g_man);
        this.help_files.setComponentOrientation(Dictionary.getOrientation());
        this.help_about = new JMenuItem(Dictionary.get("Menu.Help_About"));
        this.help_about.addActionListener(Gatherer.g_man);
        this.help_about.setComponentOrientation(Dictionary.getOrientation());
        this.help.add(this.help_general);
        this.help.add(new JSeparator());
        if (Configuration.get("workflow.download", true) && Gatherer.isDownloadEnabled) {
            this.help.add(this.help_download);
        }
        if (Configuration.get("workflow.gather", true)) {
            this.help.add(this.help_gather);
        }
        if (Configuration.get("workflow.enrich", true)) {
            this.help.add(this.help_enrich);
        }
        if (Configuration.get("workflow.design", true)) {
            this.help.add(this.help_design);
        }
        if (Configuration.get("workflow.create", true)) {
            this.help.add(this.help_create);
        }
        if (Configuration.get("workflow.format", true)) {
            this.help.add(this.help_format);
        }
        if (Configuration.get("workflow.files", true)) {
            this.help.add(this.help_files);
        }
        this.help.add(new JSeparator());
        this.help.add(this.help_about);
        this.add(this.file);
        this.add(Box.createHorizontalStrut(15));
        this.add(this.edit);
        this.add(Box.createHorizontalGlue());
        this.add(this.help);
    }

    public void exit() {
        this.file.setEnabled(false);
        this.edit.setEnabled(false);
        this.help.setEnabled(false);
    }

    public void refresh(int n, boolean bl) {
        this.file_close.setEnabled(bl);
        this.file_save.setEnabled(bl);
        this.file_exportmeta.setEnabled(bl);
        this.file_convertmeta.setEnabled(bl);
    }

    public void tabSelected(int n) {
        JMenuItem jMenuItem;
        if (this.current_tab != -1 && (jMenuItem = this.help.getItem(this.current_tab)) != null) {
            jMenuItem.setIcon(BLANK_ICON);
        }
        this.current_tab = n + 2;
        jMenuItem = this.help.getItem(this.current_tab);
        if (jMenuItem != null) {
            jMenuItem.setIcon(HELP_ICON);
        }
        jMenuItem = null;
    }

    public void modeChanged(int n) {
        if (n == 3) {
            this.edit.add(this.edit_config);
            if (Gatherer.isWebswing) {
                if (Gatherer.webswingAuthenticator.canEditSharedCollections()) {
                    this.edit.add(this.edit_group_config);
                }
            } else {
                this.edit.add(this.edit_group_config);
            }
        } else {
            this.edit.remove(this.edit_config);
            this.edit.remove(this.edit_group_config);
        }
    }
}

