/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HelpFrame
extends JFrame {
    private static final Dimension SIZE = new Dimension(800, 560);
    private static HelpFrame self = null;
    private static JEditorPane help_pane = null;
    private static JTree help_contents_tree = null;
    private static HelpContentsTreeModel help_contents_tree_model = null;
    private static JSplitPane split_pane = null;

    public HelpFrame() {
        this.setDefaultCloseOperation(1);
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("Help.Title"));
        this.setComponentOrientation(Dictionary.getOrientation());
        help_pane = new JEditorPane();
        help_pane.setComponentOrientation(Dictionary.getOrientation());
        help_pane.setEditable(false);
        help_pane.addHyperlinkListener(new HelpPaneHyperlinkListener());
        HelpContentsTreeNode helpContentsTreeNode = new HelpContentsTreeNode(null, Dictionary.get("Help.Contents"));
        help_contents_tree_model = new HelpContentsTreeModel(helpContentsTreeNode);
        help_contents_tree = new JTree(help_contents_tree_model);
        help_contents_tree.setComponentOrientation(Dictionary.getOrientation());
        help_contents_tree.addTreeSelectionListener(new HelpContentsTreeSelectionListener());
        help_contents_tree.setExpandsSelectedPaths(true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        split_pane = new JSplitPane(1);
        JScrollPane jScrollPane = new JScrollPane(help_contents_tree);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        JScrollPane jScrollPane2 = new JScrollPane(help_pane);
        jScrollPane2.setComponentOrientation(Dictionary.getOrientation());
        if (Dictionary.getOrientation().isLeftToRight()) {
            split_pane.add((Component)jScrollPane, "left");
            split_pane.add((Component)jScrollPane2, "right");
        } else {
            split_pane.add((Component)jScrollPane, "right");
            split_pane.add((Component)jScrollPane2, "left");
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)split_pane, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - HelpFrame.SIZE.width) / 2, (dimension.height - HelpFrame.SIZE.height) / 2);
        String string = "gatherer.png";
        if (Configuration.fedora_info.isActive()) {
            string = "fli-" + string;
        }
        this.setIconImage(JarTools.getImage(string).getImage());
        self = this;
    }

    public void destroy() {
        help_contents_tree = null;
        help_pane = null;
    }

    private String getHelpFolder() {
        String string = "help/" + Configuration.getLanguage() + "/";
        if (Gatherer.isApplet && JarTools.getResource("/" + string) != null) {
            return string;
        }
        if (new File(string).exists()) {
            return string;
        }
        return "help/en/";
    }

    private URL getURLForSection(String string) {
        if (string != null) {
            String string2 = this.getHelpFolder() + string + ".htm";
            try {
                if (Gatherer.isApplet) {
                    return JarTools.getResource("/" + string2);
                }
                return new File(string2).toURI().toURL();
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
        return null;
    }

    private static void selectHelpContentsTreeNode(String string) {
        HelpFrame.selectHelpContentsTreeNode(HelpFrame.help_contents_tree_model.getHelpContentsTreeNodeNamed(string));
    }

    private static void selectHelpContentsTreeNode(HelpContentsTreeNode helpContentsTreeNode) {
        TreePath treePath = new TreePath(helpContentsTreeNode.getPath());
        help_contents_tree.setSelectionPath(treePath);
        help_contents_tree.scrollPathToVisible(treePath);
    }

    public static void setView(String string) {
        HelpFrame.selectHelpContentsTreeNode(string);
        self.showHelpPage(string);
    }

    private void showHelpPage(String string) {
        this.showHelpPage(this.getURLForSection(string));
    }

    private void showHelpPage(URL uRL) {
        if (uRL != null) {
            try {
                help_pane.setPage(uRL);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
        this.setVisible(true);
        split_pane.setDividerLocation(0.4);
    }

    private class HelpPaneHyperlinkListener
    implements HyperlinkListener {
        private HelpPaneHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getURL().getFile();
                if (string.endsWith(".htm")) {
                    string = string.substring(string.lastIndexOf("/") + 1);
                    string = string.substring(0, string.length() - ".htm".length());
                    HelpFrame.selectHelpContentsTreeNode(string);
                }
                HelpFrame.this.showHelpPage(hyperlinkEvent.getURL());
            }
        }
    }

    private class HelpContentsTreeNode
    extends DefaultMutableTreeNode {
        public String section_name = null;
        public String section_title = null;

        public HelpContentsTreeNode(String string, String string2) {
            this.section_name = string;
            this.section_title = string2;
        }

        @Override
        public String toString() {
            return this.section_title;
        }
    }

    private class HelpContentsTreeSelectionListener
    implements TreeSelectionListener {
        private HelpContentsTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            HelpContentsTreeNode helpContentsTreeNode = (HelpContentsTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            HelpFrame.selectHelpContentsTreeNode(helpContentsTreeNode);
            HelpFrame.this.showHelpPage(helpContentsTreeNode.section_name);
        }
    }

    private class HelpContentsTreeModel
    extends DefaultTreeModel {
        public HelpContentsTreeModel(MutableTreeNode mutableTreeNode) {
            super(mutableTreeNode);
            try {
                String string = HelpFrame.this.getHelpFolder() + "help_index.xml";
                Document document = null;
                if (Gatherer.isApplet && JarTools.getResource(string) != null) {
                    document = XMLTools.parseXMLFile(string, true);
                }
                if (new File(string).exists()) {
                    document = XMLTools.parseXMLFile(string, false);
                }
                if (document == null) {
                    String string2 = "HelpFrame.HelpContentsTreeModel constructor(): There's no help document after parsing";
                    System.err.println(string2);
                    DebugStream.println(string2);
                    return;
                }
                Node node = document.getFirstChild();
                int n = 0;
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (!node2.getNodeName().equals("Section")) continue;
                    this.buildHelpContentsTree(mutableTreeNode, ++n + "", node2);
                }
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }

        private void buildHelpContentsTree(MutableTreeNode mutableTreeNode, String string, Node node) {
            String string2 = ((Element)node).getAttribute("name");
            String string3 = "";
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("Title")) continue;
                string3 = string + ": ";
                if (node2.getFirstChild() == null) continue;
                string3 = string3 + node2.getFirstChild().getNodeValue();
            }
            HelpContentsTreeNode helpContentsTreeNode = new HelpContentsTreeNode(string2, string3);
            this.insertNodeInto(helpContentsTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
            int n = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (!node3.getNodeName().equals("Section")) continue;
                this.buildHelpContentsTree(helpContentsTreeNode, string + "." + ++n, node3);
            }
        }

        private HelpContentsTreeNode getHelpContentsTreeNodeNamed(String string) {
            if (string != null) {
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.root).preorderEnumeration();
                while (enumeration.hasMoreElements()) {
                    HelpContentsTreeNode helpContentsTreeNode = (HelpContentsTreeNode)enumeration.nextElement();
                    if (!string.equals(helpContentsTreeNode.section_name)) continue;
                    return helpContentsTreeNode;
                }
            }
            return (HelpContentsTreeNode)this.root;
        }
    }
}

