/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.Collection;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.file.FileOpenActionListener;
import org.greenstone.gatherer.gui.AboutDialog;
import org.greenstone.gatherer.gui.CollectionConfigFileEditor;
import org.greenstone.gatherer.gui.CreatePane;
import org.greenstone.gatherer.gui.DeleteCollectionPrompt;
import org.greenstone.gatherer.gui.DesignPane;
import org.greenstone.gatherer.gui.DownloadPane;
import org.greenstone.gatherer.gui.EnrichPane;
import org.greenstone.gatherer.gui.ExportAsPrompt;
import org.greenstone.gatherer.gui.FormatPane;
import org.greenstone.gatherer.gui.GatherPane;
import org.greenstone.gatherer.gui.HelpFrame;
import org.greenstone.gatherer.gui.MenuBar;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.NewCollectionDetailsPrompt;
import org.greenstone.gatherer.gui.OpenCollectionDialog;
import org.greenstone.gatherer.gui.Preferences;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.gui.WriteCDImagePrompt;
import org.greenstone.gatherer.gui.XMLFileEditor;
import org.greenstone.gatherer.gui.metaaudit.MetaAuditFrame;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.metadata.MetadataToCSV;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;
import org.webswing.toolkit.api.WebswingUtil;

public class GUIManager
extends JFrame
implements ActionListener,
ChangeListener,
WindowFocusListener {
    public DownloadPane download_pane = null;
    public GatherPane gather_pane = null;
    public EnrichPane enrich_pane = null;
    public DesignPane design_pane = null;
    public CreatePane create_pane = null;
    public FormatPane format_pane = null;
    public GatherPane files_pane = null;
    public FileOpenActionListener foa_listener = new FileOpenActionListener();
    private HelpFrame help = null;
    public MenuBar menu_bar = null;
    public MetaAuditFrame meta_audit;
    private boolean locked = false;
    private Dimension size = null;
    private JPanel content_pane = null;
    private JPanel previous_pane;
    private JTabbedPane tab_pane = null;
    private TabUpdater tab_updater = null;
    static final String newline = "\n";
    static final String space = "    ";
    private MouseListener mouse_blocker_listener = new MouseAdapter(){};

    public GUIManager(Dimension dimension) {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.help = new HelpFrame();
        this.size = dimension;
        if (TestingPreparation.TEST_MODE) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(0);
        }
        this.addFocusListener(new GLIGUIFocusListener());
        this.addWindowFocusListener(this);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        UIManager.put("FileChooser.lookInLabelText", Dictionary.get("SaveCollectionBox.Look_In"));
        UIManager.put("FileChooser.filesOfTypeLabelText", Dictionary.get("SaveCollectionBox.Files_Of_Type"));
        UIManager.put("FileChooser.fileNameLabelText", Dictionary.get("SaveCollectionBox.File_Name"));
        UIManager.put("OptionPane.cancelButtonText", Dictionary.get("General.Cancel"));
        UIManager.put("OptionPane.noButtonText", Dictionary.get("General.No"));
        UIManager.put("OptionPane.okButtonText", Dictionary.get("General.OK"));
        UIManager.put("OptionPane.yesButtonText", Dictionary.get("General.Yes"));
    }

    @Override
    public void setSize(Dimension dimension) {
        this.size = dimension;
        super.setSize(dimension);
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (Gatherer.c_man != null) {
            if (Gatherer.c_man.ready() && Gatherer.c_man.getCollection().cdm != null) {
                Gatherer.c_man.saveCollection();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menu_bar.file_associations) {
            Gatherer.assoc_man.edit();
        } else if (object == this.menu_bar.file_close) {
            this.saveThenCloseCurrentCollection();
        } else if (object == this.menu_bar.file_delete) {
            SwingUtilities.invokeLater(new DeleteCollectionTask());
        } else if (object == this.menu_bar.file_cdimage) {
            WriteCDImagePrompt writeCDImagePrompt = new WriteCDImagePrompt();
            writeCDImagePrompt.display();
            writeCDImagePrompt.destroy();
            writeCDImagePrompt = null;
        } else if (object == this.menu_bar.file_exportas) {
            ExportAsPrompt exportAsPrompt = new ExportAsPrompt();
            TestingPreparation.setNamesRecursively(exportAsPrompt);
            exportAsPrompt.display();
            exportAsPrompt.destroy();
            exportAsPrompt = null;
        } else if (object == this.menu_bar.file_exportmeta || object == this.menu_bar.file_convertmeta) {
            File file;
            String string = Gatherer.c_man.getCollection().getName();
            String string2 = CollectionManager.getCollectionDirectoryPath(string);
            String string3 = string2 + "import";
            boolean bl = false;
            String string4 = string2;
            if (object == this.menu_bar.file_convertmeta) {
                string4 = string3;
                bl = true;
            }
            if ((file = MetadataToCSV.chooseMetaCSVFile(string4, bl, this)) != null) {
                MetadataToCSV metadataToCSV = new MetadataToCSV(string2, file);
                boolean bl2 = false;
                bl2 = object == this.menu_bar.file_convertmeta ? metadataToCSV.convertMetaXMLToCSV(file, this) : metadataToCSV.exportMetaXMLToCSV(file);
                if (bl2 && file.exists() && file.getAbsolutePath().startsWith(string2)) {
                    if (Gatherer.isGsdlRemote) {
                        Gatherer.remoteGreenstoneServer.uploadFilesIntoCollection(string, new File[]{file}, file.getParentFile());
                    }
                    if (file.getAbsolutePath().startsWith(string3)) {
                        Gatherer.g_man.refreshCollectionTree(2);
                    }
                    if (Gatherer.isWebswing && object == this.menu_bar.file_exportmeta) {
                        String string5 = Configuration.library_url.toString() + "/sites/" + Configuration.site_name + "/collect/" + string + "/" + file.getName();
                        WebswingUtil.getWebswingApi().sendActionEvent("downloadURL", string5, null);
                    }
                }
            }
        } else if (object == this.menu_bar.file_exit) {
            this.exit();
        } else if (object == this.menu_bar.file_new) {
            SwingUtilities.invokeLater(new NewCollectionTask());
        } else if (object == this.menu_bar.file_open) {
            SwingUtilities.invokeLater(new OpenCollectionTask());
        } else if (object == this.menu_bar.file_options) {
            new Preferences();
        } else if (object == this.menu_bar.file_save) {
            this.enrich_pane.stopEditingAndRebuild();
            MetadataXMLFileManager.saveMetadataXMLFiles();
            Gatherer.c_man.saveCollection();
        } else if (object == this.menu_bar.edit_copy) {
            try {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                JTextComponent jTextComponent = (JTextComponent)keyboardFocusManager.getPermanentFocusOwner();
                jTextComponent.copy();
            }
            catch (Exception exception) {
                DebugStream.println(exception.toString());
            }
        } else if (object == this.menu_bar.edit_cut) {
            try {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                JTextComponent jTextComponent = (JTextComponent)keyboardFocusManager.getPermanentFocusOwner();
                jTextComponent.cut();
            }
            catch (ClassCastException classCastException) {
                DebugStream.println(classCastException.toString());
            }
        } else if (object == this.menu_bar.edit_paste) {
            try {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                JTextComponent jTextComponent = (JTextComponent)keyboardFocusManager.getPermanentFocusOwner();
                jTextComponent.paste();
            }
            catch (ClassCastException classCastException) {
                DebugStream.println(classCastException.toString());
            }
        } else if (object == this.menu_bar.edit_config) {
            if (Gatherer.c_man.getCollection() != null) {
                if (this.previous_pane != null) {
                    this.doLoseFocus();
                }
                File file = new File(Gatherer.getCurrentCollectionDirectoryPath(), Utility.CONFIG_GS3_FILE);
                CollectionConfigFileEditor collectionConfigFileEditor = new CollectionConfigFileEditor(file);
                collectionConfigFileEditor.setVisible(true);
                collectionConfigFileEditor.setSize(900, 700);
            }
        } else if (object == this.menu_bar.edit_group_config) {
            if (this.previous_pane != null) {
                this.doLoseFocus();
            }
            String string = Gatherer.getCurrentSiteDirectoryPath() + "groupConfig.xml";
            File file = new File(string);
            XMLFileEditor xMLFileEditor = new XMLFileEditor(file);
            xMLFileEditor.setVisible(true);
            xMLFileEditor.setSize(900, 700);
        } else if (object == this.menu_bar.help_general) {
            HelpFrame.setView("introduction");
        } else if (object == this.menu_bar.help_download) {
            HelpFrame.setView("themirrorview");
        } else if (object == this.menu_bar.help_gather) {
            HelpFrame.setView("collectingfiles");
        } else if (object == this.menu_bar.help_enrich) {
            HelpFrame.setView("enrichingacollection");
        } else if (object == this.menu_bar.help_design) {
            HelpFrame.setView("designingacollection");
        } else if (object == this.menu_bar.help_create) {
            HelpFrame.setView("producingthecollection");
        } else if (object == this.menu_bar.help_format) {
            HelpFrame.setView("formattingacollection");
        } else if (object == this.menu_bar.help_about) {
            new AboutDialog(this);
        }
    }

    public void afterDisplay() {
        if (this.download_pane != null) {
            this.download_pane.afterDisplay();
        }
        this.enrich_pane.afterDisplay();
    }

    public void closeCurrentCollection() {
        this.tab_pane.setSelectedComponent(this.gather_pane);
        Gatherer.c_man.closeCollection();
        FilenameEncoding.closeCollection();
    }

    public void saveThenCloseCurrentCollection() {
        Gatherer.c_man.saveCollection();
        this.closeCurrentCollection();
    }

    public void destroy() {
        if (this.create_pane != null) {
            this.create_pane.destroy();
        }
        if (this.help != null) {
            this.help.destroy();
            this.help = null;
        }
    }

    public void display() {
        this.content_pane = (JPanel)this.getContentPane();
        this.content_pane.setComponentOrientation(Dictionary.getOrientation());
        this.enableEvents(64L);
        try {
            Object object;
            this.setSize(this.size);
            String string = null;
            String string2 = null;
            if (Gatherer.c_man.ready()) {
                object = Gatherer.c_man.getCollection();
                string = ((Collection)object).getTitle();
                string2 = ((Collection)object).getGroupQualifiedName(true);
                object = null;
            }
            this.setTitle(string, string2);
            string = null;
            string2 = null;
            object = "gatherer.png";
            if (Configuration.fedora_info.isActive()) {
                object = "fli-" + (String)object;
            }
            if (Gatherer.isGsdlRemote) {
                object = "client-" + (String)object;
            }
            this.setIconImage(JarTools.getImage((String)object).getImage());
            this.content_pane.setLayout(new BorderLayout());
            this.menu_bar = new MenuBar(new MenuListenerImpl());
            this.menu_bar.setComponentOrientation(Dictionary.getOrientation());
            this.setJMenuBar(this.menu_bar);
            this.tab_pane = new JTabbedPane();
            this.tab_pane.setComponentOrientation(Dictionary.getOrientation());
            this.tab_pane.addChangeListener(this);
            this.tab_pane.setFont(Configuration.getFont("general.font", false));
            if (Configuration.get("workflow.download", true) && Gatherer.isDownloadEnabled) {
                this.download_pane = new DownloadPane();
                this.tab_pane.addTab(Dictionary.get("GUI.Download"), JarTools.getImage("download.gif"), this.download_pane, Dictionary.get("GUI.Download_Tooltip"));
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.download_pane), Configuration.get("workflow.download", false));
            }
            this.gather_pane = new GatherPane(Utility.IMPORT_MODE);
            this.gather_pane.display();
            if (Configuration.get("workflow.gather", true)) {
                this.tab_pane.addTab(Dictionary.get("GUI.Gather"), JarTools.getImage("gather.gif"), this.gather_pane, Dictionary.get("GUI.Gather_Tooltip"));
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.gather_pane), Configuration.get("workflow.gather", false));
            }
            this.enrich_pane = new EnrichPane();
            this.enrich_pane.display();
            if (Configuration.get("workflow.enrich", true)) {
                this.tab_pane.addTab(Dictionary.get("GUI.Enrich"), JarTools.getImage("enrich.gif"), this.enrich_pane, Dictionary.get("GUI.Enrich_Tooltip"));
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.enrich_pane), false);
            }
            this.design_pane = new DesignPane();
            this.design_pane.display();
            if (Configuration.get("workflow.design", true)) {
                if (Configuration.fedora_info.isActive()) {
                    this.tab_pane.addTab("Plugins", JarTools.getImage("design.gif"), this.design_pane, Dictionary.get("GUI.Design_Tooltip"));
                } else {
                    this.tab_pane.addTab(Dictionary.get("GUI.Design"), JarTools.getImage("design.gif"), this.design_pane, Dictionary.get("GUI.Design_Tooltip"));
                }
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.design_pane), false);
            }
            this.create_pane = new CreatePane();
            this.create_pane.setComponentOrientation(Dictionary.getOrientation());
            this.create_pane.display();
            if (Configuration.get("workflow.create", true)) {
                this.tab_pane.addTab(Dictionary.get("GUI.Create"), JarTools.getImage("create.gif"), this.create_pane, Dictionary.get("GUI.Create_Tooltip"));
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.create_pane), false);
            }
            this.format_pane = new FormatPane();
            this.format_pane.setComponentOrientation(Dictionary.getOrientation());
            this.format_pane.display();
            if (Configuration.get("workflow.format", true)) {
                this.tab_pane.addTab(Dictionary.get("GUI.Format"), JarTools.getImage("format.gif"), this.format_pane, Dictionary.get("GUI.Format_Tooltip"));
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.format_pane), false);
            }
            this.files_pane = new GatherPane(Utility.FILES_MODE);
            this.files_pane.display();
            if (Configuration.get("workflow.files", true)) {
                this.tab_pane.addTab(Dictionary.get("GUI.Files"), JarTools.getImage("gather.gif"), this.files_pane, Dictionary.get("GUI.Files_Tooltip"));
                this.tab_pane.setEnabledAt(this.tab_pane.indexOfComponent(this.files_pane), false);
            }
            this.meta_audit = new MetaAuditFrame();
            this.meta_audit.setComponentOrientation(Dictionary.getOrientation());
            if (this.tab_pane.indexOfComponent(this.gather_pane) != -1) {
                this.tab_pane.setSelectedComponent(this.gather_pane);
            } else {
                for (int i = 0; i < this.tab_pane.getTabCount(); ++i) {
                    if (!this.tab_pane.isEnabledAt(i)) continue;
                    this.tab_pane.setSelectedIndex(i);
                    break;
                }
            }
            this.content_pane.add((Component)this.tab_pane, "Center");
            if (Gatherer.isGsdlRemote) {
                JPanel jPanel = new JPanel();
                JLabel jLabel = new JLabel(Dictionary.get("RemoteGreenstoneServer.Progress"));
                jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jLabel, "Before");
                jPanel.add((Component)Gatherer.remoteGreenstoneServer.getProgressBar(), "Center");
                this.content_pane.add((Component)jPanel, "South");
            }
            this.refresh(-1, Gatherer.c_man.ready());
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void exit() {
        this.exit(0);
    }

    public void exitNoCollectionSave(int n) {
        Configuration.setBounds("general.bounds", true, this.getBounds());
        Configuration.save();
        this.setVisible(false);
        if (!Gatherer.isApplet) {
            Gatherer.exit(n);
        }
    }

    public void exit(int n) {
        boolean bl = false;
        if (Gatherer.c_man.ready()) {
            if (Gatherer.isGsdlRemote) {
                Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, "");
            } else {
                Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, CollectionManager.getLoadedCollectionColFilePath());
            }
            this.saveThenCloseCurrentCollection();
            bl = true;
        } else if (Gatherer.isGsdlRemote || Gatherer.getCollectDirectoryPath().equals(Gatherer.getDefaultGSCollectDirectoryPath(true))) {
            Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, "");
        } else {
            Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, Gatherer.getCollectDirectoryPath());
        }
        if (!Gatherer.isGsdlRemote && !Gatherer.isPersistentServer()) {
            String string = Gatherer.getDefaultGSCollectDirectoryPath(false);
            String string2 = Gatherer.getCollectDirectoryPath();
            String string3 = Gatherer.gsdlsite_collecthome;
            boolean bl2 = true;
            String string4 = Gatherer.gsdlsite_collecthome.replace("\"", "");
            if (string2.equals(string4 + File.separator)) {
                bl2 = false;
            } else if (string4.equals("") && string2.equals(string + File.separator)) {
                bl2 = false;
            }
            if (bl2) {
                if (string2.endsWith(File.separator)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string3.equals("")) {
                    string3 = string;
                }
                this.collectDirSettingsDialog(string, string3, string2, bl);
            }
        }
        Configuration.setBounds("general.bounds", true, this.getBounds());
        Configuration.save();
        this.setVisible(false);
        if (!Gatherer.isApplet) {
            Gatherer.exit(n);
        }
    }

    public void collectDirSettingsDialog(final String string, final String string2, final String string3, final boolean bl) {
        final JDialog jDialog = new JDialog(this, Dictionary.get("GUI.CollectHome.title"), true);
        jDialog.setDefaultCloseOperation(0);
        JRadioButton jRadioButton = new JRadioButton(Dictionary.get("General.Yes"), true);
        JRadioButton jRadioButton2 = new JRadioButton(Dictionary.get("General.Yes"));
        JRadioButton jRadioButton3 = null;
        JRadioButton jRadioButton4 = null;
        JRadioButton jRadioButton5 = null;
        JRadioButton jRadioButton6 = null;
        if (string2.equals(string)) {
            jRadioButton3 = new JRadioButton(Dictionary.get("GUI.CollectHome.resetToDefault"));
            jRadioButton5 = new JRadioButton(Dictionary.get("GUI.CollectHome.leaveAtDefault"), true);
        } else {
            jRadioButton3 = new JRadioButton(Dictionary.get("General.No"));
            jRadioButton5 = new JRadioButton(Dictionary.get("General.No"), true);
            if (!string3.equals(string)) {
                jRadioButton4 = new JRadioButton(Dictionary.get("GUI.CollectHome.reset"));
                jRadioButton6 = new JRadioButton(Dictionary.get("GUI.CollectHome.reset"));
            }
        }
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        buttonGroup2.add(jRadioButton2);
        jPanel2.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jPanel.add(jRadioButton3);
        buttonGroup2.add(jRadioButton5);
        jPanel2.add(jRadioButton5);
        if (jRadioButton4 != null) {
            jRadioButton4 = new JRadioButton("Reset to default");
            jRadioButton6 = new JRadioButton("Reset to default");
            buttonGroup.add(jRadioButton4);
            jPanel.add(jRadioButton4);
            buttonGroup2.add(jRadioButton6);
            jPanel2.add(jRadioButton6);
        }
        final JRadioButton jRadioButton7 = jRadioButton;
        final JRadioButton jRadioButton8 = jRadioButton3;
        final JRadioButton jRadioButton9 = jRadioButton4;
        final JRadioButton jRadioButton10 = jRadioButton2;
        final JRadioButton jRadioButton11 = jRadioButton5;
        final JRadioButton jRadioButton12 = jRadioButton6;
        JButton jButton = new JButton(Dictionary.get("General.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string4 = string3;
                if (jRadioButton9 != null && jRadioButton9.isSelected()) {
                    string4 = "";
                } else if (jRadioButton7.isSelected()) {
                    string4 = string3;
                } else if (jRadioButton8.isSelected()) {
                    string4 = string2;
                }
                if (string.equals(string4)) {
                    string4 = "";
                }
                if (!bl || !jRadioButton7.isSelected()) {
                    Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, string4);
                }
                String string22 = string2;
                if (jRadioButton12 != null && jRadioButton12.isSelected()) {
                    string22 = null;
                } else if (jRadioButton10.isSelected()) {
                    string22 = string3;
                } else if (jRadioButton11.isSelected()) {
                    string22 = string2;
                }
                if (string22 != null && string.equals(string22)) {
                    string22 = null;
                }
                if (string22 != null) {
                    string22 = string22.replace("\"", "");
                    string22 = "\"" + string22 + "\"";
                }
                Gatherer.gsdlsite_collecthome = Utility.updatePropertyConfigFile(Gatherer.getGsdlSiteConfigFile(), "collecthome", string22);
                jDialog.dispose();
            }
        });
        JLabel jLabel = new JLabel(Dictionary.get("GUI.CollectHome.message"));
        JLabel jLabel2 = new JLabel(Dictionary.get("GUI.CollectHome.dir", string2));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
        JLabel jLabel3 = new JLabel(Dictionary.get("GUI.CollectHome.to"));
        JLabel jLabel4 = new JLabel(Dictionary.get("GUI.CollectHome.dir", string3));
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0));
        JLabel jLabel5 = new JLabel(Dictionary.get("GUI.CollectHome.gli"));
        JLabel jLabel6 = new JLabel(Dictionary.get("GUI.CollectHome.server"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(9, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.add(jLabel);
        jPanel3.add(jLabel2);
        jPanel3.add(jLabel3);
        jPanel3.add(jLabel4);
        jPanel3.add(jLabel5);
        jPanel3.add(jPanel);
        jPanel3.add(jLabel6);
        jPanel3.add(jPanel2);
        jPanel3.add(jButton);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel3, "Center");
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public void lockCollection(final boolean bl, final boolean bl2) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("GUIManager.lockCollection()", true, new Runnable(){

            @Override
            public void run() {
                int n;
                int n2;
                GUIManager.this.locked = bl2;
                if (bl) {
                    n2 = GUIManager.this.tab_pane.indexOfComponent(GUIManager.this.gather_pane);
                    if (n2 != -1) {
                        GUIManager.this.tab_pane.setEnabledAt(n2, !bl2);
                    }
                    if ((n = GUIManager.this.tab_pane.indexOfComponent(GUIManager.this.enrich_pane)) != -1) {
                        GUIManager.this.tab_pane.setEnabledAt(n, !bl2);
                    }
                }
                if ((n2 = GUIManager.this.tab_pane.indexOfComponent(GUIManager.this.design_pane)) != -1) {
                    GUIManager.this.tab_pane.setEnabledAt(n2, !bl2);
                }
                if ((n = GUIManager.this.tab_pane.indexOfComponent(GUIManager.this.files_pane)) != -1) {
                    GUIManager.this.tab_pane.setEnabledAt(n, !bl2);
                }
            }
        });
    }

    public void modeChanged(int n) {
        String string = null;
        String string2 = null;
        if (Gatherer.c_man.ready()) {
            Collection collection = Gatherer.c_man.getCollection();
            string = collection.getTitle();
            string2 = collection.getGroupQualifiedName(true);
            collection = null;
        }
        this.setTitle(string, string2);
        string = null;
        string2 = null;
        if (this.download_pane != null) {
            this.download_pane.modeChanged(n);
        }
        if (this.gather_pane != null) {
            this.gather_pane.modeChanged(n);
        }
        if (this.enrich_pane != null) {
            this.enrich_pane.modeChanged(n);
        }
        if (this.design_pane != null) {
            this.design_pane.modeChanged(n);
        }
        if (this.create_pane != null) {
            this.create_pane.modeChanged(n);
        }
        if (this.format_pane != null) {
            this.format_pane.modeChanged(n);
        }
        if (this.files_pane != null) {
            this.files_pane.modeChanged(n);
        }
        if (this.menu_bar != null) {
            this.menu_bar.modeChanged(n);
        }
    }

    public void refresh(final int n, final boolean bl) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("GUIManager.refresh()", false, new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    Collection collection = Gatherer.c_man.getCollection();
                    GUIManager.this.setTitle(collection.getTitle(), collection.getGroupQualifiedName(true));
                } else {
                    GUIManager.this.setTitle(null, null);
                }
                GUIManager.this.menu_bar.refresh(n, bl);
                if (GUIManager.this.download_pane != null) {
                    GUIManager.this.download_pane.refresh(n, bl);
                }
                if (GUIManager.this.gather_pane != null) {
                    GUIManager.this.gather_pane.refresh(n, bl);
                }
                if (GUIManager.this.enrich_pane != null) {
                    GUIManager.this.enrich_pane.refresh(n, bl);
                }
                if (GUIManager.this.design_pane != null) {
                    GUIManager.this.design_pane.refresh(n, bl);
                }
                if (GUIManager.this.create_pane != null) {
                    GUIManager.this.create_pane.refresh(n, bl);
                }
                if (GUIManager.this.format_pane != null) {
                    GUIManager.this.format_pane.refresh(n, bl);
                }
                if (GUIManager.this.files_pane != null) {
                    GUIManager.this.files_pane.refresh(n, bl);
                }
            }
        });
        if (!this.locked) {
            if (this.tab_updater == null) {
                this.tab_updater = new TabUpdater(this.tab_pane, bl);
            } else {
                this.tab_updater.setReady(bl);
            }
            SwingUtilities.invokeLater(this.tab_updater);
        }
    }

    public void refreshCollectionTree(int n) {
        if (this.gather_pane != null) {
            this.gather_pane.refreshCollectionTree(n);
        }
        if (this.files_pane != null) {
            this.files_pane.refreshCollectionTree(n);
        }
    }

    public void refreshWorkspaceTree(int n) {
        if (this.gather_pane != null) {
            this.gather_pane.refreshWorkspaceTree(n);
        }
        if (this.files_pane != null) {
            this.files_pane.refreshWorkspaceTree(n);
        }
    }

    public void refreshWorkspaceTreeGreenstoneCollections() {
        this.refreshWorkspaceTree(10);
    }

    public boolean isGatherPaneSelected() {
        int n;
        int n2 = this.tab_pane.getSelectedIndex();
        return n2 == (n = this.tab_pane.indexOfTab(Dictionary.get("GUI.Gather")));
    }

    /*
     * Unable to fully structure code
     */
    private void setTabEnabled(String var1_1, boolean var2_2) {
        block5: {
            block7: {
                block6: {
                    var3_3 = Dictionary.get("GUI." + var1_1);
                    var4_4 = this.tab_pane.indexOfTab(var3_3);
                    if (var4_4 == -1) break block5;
                    var5_5 = this.tab_pane.getComponentAt(var4_4);
                    if (var5_5 != this.enrich_pane && var5_5 != this.design_pane && var5_5 != this.create_pane && var5_5 != this.format_pane && var5_5 != this.files_pane) break block6;
                    if (!var2_2 || Gatherer.c_man == null) ** GOTO lbl-1000
                    if (Gatherer.c_man.ready()) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    this.tab_pane.setEnabledAt(var4_4, v0);
                    break block7;
                }
                this.tab_pane.setEnabledAt(var4_4, var2_2);
            }
            if (this.tab_pane.getSelectedIndex() == var4_4 && !var2_2) {
                var6_6 = false;
                for (var7_7 = 0; !var6_6 && var7_7 < this.tab_pane.getTabCount(); ++var7_7) {
                    if (!this.tab_pane.isEnabledAt(var7_7)) continue;
                    this.tab_pane.setSelectedIndex(var7_7);
                    var6_6 = true;
                }
                if (!var6_6) {
                    this.tab_pane.setSelectedIndex(0);
                }
            }
        }
    }

    public void setTitle(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(Configuration.getApplicationTitle());
        stringBuffer.append(" ");
        stringBuffer.append("2.88");
        stringBuffer.append(" ");
        stringBuffer.append(" ");
        stringBuffer.append(Gatherer.getServerVersionAsString());
        stringBuffer.append(" ");
        stringBuffer.append(" ");
        stringBuffer.append("Mode: ");
        stringBuffer.append(Configuration.getModeAsString());
        stringBuffer.append(" ");
        stringBuffer.append(" ");
        stringBuffer.append("Collection: ");
        if (string != null && string2 != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append("[");
            stringBuffer.append(string2);
            stringBuffer.append("]");
        } else {
            stringBuffer.append(Dictionary.get("Collection.No_Collection"));
        }
        this.setTitle(stringBuffer.toString());
        stringBuffer = null;
    }

    private String showOpenCollectionDialog() {
        OpenCollectionDialog openCollectionDialog = new OpenCollectionDialog();
        TestingPreparation.setNamesRecursively(openCollectionDialog);
        openCollectionDialog.setComponentOrientation(Dictionary.getOrientation());
        if (openCollectionDialog.display() == 0) {
            return openCollectionDialog.getFileName();
        }
        return null;
    }

    public void showMetaAuditBox() {
        this.wait(true);
        this.meta_audit.display();
        this.wait(false);
    }

    public void doLoseFocus() {
        if (this.previous_pane != null) {
            if (this.previous_pane == this.gather_pane) {
                this.gather_pane.loseFocus();
            } else if (this.previous_pane == this.enrich_pane) {
                this.enrich_pane.loseFocus();
            } else if (this.previous_pane == this.design_pane) {
                this.design_pane.loseFocus();
            } else if (this.previous_pane == this.create_pane) {
                this.create_pane.loseFocus();
            } else if (this.previous_pane == this.format_pane) {
                this.format_pane.loseFocus();
            } else if (this.previous_pane == this.files_pane) {
                this.files_pane.loseFocus();
            }
        }
    }

    public void doRegainFocus() {
        if (this.previous_pane != null) {
            if (this.previous_pane == this.gather_pane) {
                this.gather_pane.gainFocus();
            } else if (this.previous_pane == this.enrich_pane) {
                this.enrich_pane.gainFocus();
            } else if (this.previous_pane == this.design_pane) {
                this.design_pane.gainFocus();
            } else if (this.previous_pane == this.create_pane) {
                this.create_pane.gainFocus();
            } else if (this.previous_pane == this.format_pane) {
                this.format_pane.gainFocus();
            } else if (this.previous_pane == this.files_pane) {
                this.files_pane.gainFocus();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.previous_pane != null) {
            if (this.previous_pane == this.gather_pane) {
                this.gather_pane.loseFocus();
            } else if (this.previous_pane == this.enrich_pane) {
                this.enrich_pane.loseFocus();
            } else if (this.previous_pane == this.design_pane) {
                this.design_pane.loseFocus();
            } else if (this.previous_pane == this.create_pane) {
                this.create_pane.loseFocus();
            } else if (this.previous_pane == this.format_pane) {
                this.format_pane.loseFocus();
            } else if (this.previous_pane == this.files_pane) {
                this.files_pane.loseFocus();
            }
        }
        this.menu_bar.tabSelected(this.tab_pane.getSelectedIndex());
        int n = this.tab_pane.getSelectedIndex();
        if (n == this.tab_pane.indexOfComponent(this.download_pane)) {
            this.download_pane.gainFocus();
        } else if (n == this.tab_pane.indexOfComponent(this.gather_pane)) {
            this.gather_pane.gainFocus();
        } else if (n == this.tab_pane.indexOfComponent(this.enrich_pane)) {
            this.enrich_pane.gainFocus();
        } else if (n == this.tab_pane.indexOfComponent(this.design_pane)) {
            this.design_pane.gainFocus();
        } else if (n == this.tab_pane.indexOfComponent(this.create_pane)) {
            this.create_pane.gainFocus();
        } else if (n == this.tab_pane.indexOfComponent(this.format_pane)) {
            this.format_pane.gainFocus();
        } else if (n == this.tab_pane.indexOfComponent(this.files_pane)) {
            this.files_pane.gainFocus();
        }
        this.previous_pane = (JPanel)this.tab_pane.getSelectedComponent();
    }

    public void updateUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel jPanel = (JPanel)GUIManager.this.getContentPane();
                jPanel.updateUI();
                GUIManager.this.workflowUpdate("Download", Configuration.get("workflow.download", false));
                GUIManager.this.workflowUpdate("Gather", Configuration.get("workflow.gather", false));
                GUIManager.this.workflowUpdate("Enrich", Configuration.get("workflow.enrich", false));
                GUIManager.this.workflowUpdate("Design", Configuration.get("workflow.design", false));
                GUIManager.this.workflowUpdate("Create", Configuration.get("workflow.create", false));
                GUIManager.this.workflowUpdate("Format", Configuration.get("workflow.format", false));
                GUIManager.this.workflowUpdate("Files", Configuration.get("workflow.files", false));
            }
        });
    }

    public void wait(final boolean bl) {
        Gatherer.invokeInEDT_replacesProceedInCurrThread("GUIManager.wait()", true, new Runnable(){

            @Override
            public void run() {
                Component component = GUIManager.this.getGlassPane();
                if (bl) {
                    component.addMouseListener(GUIManager.this.mouse_blocker_listener);
                    component.setCursor(Cursor.getPredefinedCursor(3));
                    component.setVisible(true);
                } else {
                    component.setVisible(false);
                    component.setCursor(Cursor.getPredefinedCursor(0));
                    component.removeMouseListener(GUIManager.this.mouse_blocker_listener);
                }
                component = null;
            }
        });
    }

    public void workflowUpdate(String string, boolean bl) {
        WorkflowUpdater workflowUpdater = new WorkflowUpdater(string, bl);
        SwingUtilities.invokeLater(workflowUpdater);
        workflowUpdater = null;
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exit();
        }
    }

    private class WorkflowUpdater
    implements Runnable {
        private boolean state;
        private String raw;

        public WorkflowUpdater(String string, boolean bl) {
            this.raw = string;
            this.state = bl;
        }

        @Override
        public void run() {
            GUIManager.this.setTabEnabled(this.raw, this.state);
        }
    }

    private class TabUpdater
    implements Runnable {
        private boolean ready = false;
        private int download_pos = -1;
        private int enrich_pos = -1;
        private int design_pos = -1;
        private int create_pos = -1;
        private int format_pos = -1;
        private int files_pos = -1;
        private int export_pos = -1;
        private JTabbedPane tab_pane = null;

        public TabUpdater(JTabbedPane jTabbedPane, boolean bl) {
            this.ready = bl;
            this.tab_pane = jTabbedPane;
            this.download_pos = jTabbedPane.indexOfComponent(GUIManager.this.download_pane);
            this.enrich_pos = jTabbedPane.indexOfComponent(GUIManager.this.enrich_pane);
            this.design_pos = jTabbedPane.indexOfComponent(GUIManager.this.design_pane);
            this.create_pos = jTabbedPane.indexOfComponent(GUIManager.this.create_pane);
            this.format_pos = jTabbedPane.indexOfComponent(GUIManager.this.format_pane);
            this.files_pos = jTabbedPane.indexOfComponent(GUIManager.this.files_pane);
        }

        @Override
        public void run() {
            if (this.download_pos != -1) {
                if (this.ready) {
                    this.tab_pane.setEnabledAt(this.download_pos, Configuration.get("workflow.download", false));
                } else {
                    this.tab_pane.setEnabledAt(this.download_pos, Configuration.get("workflow.download", true));
                }
            }
            if (this.enrich_pos != -1) {
                this.tab_pane.setEnabledAt(this.enrich_pos, this.ready && Configuration.get("workflow.enrich", false));
            }
            if (this.design_pos != -1) {
                this.tab_pane.setEnabledAt(this.design_pos, this.ready && Configuration.get("workflow.design", false) && Configuration.getMode() > 1);
            }
            if (this.create_pos != -1) {
                this.tab_pane.setEnabledAt(this.create_pos, this.ready && Configuration.get("workflow.create", false));
            }
            if (this.format_pos != -1) {
                this.tab_pane.setEnabledAt(this.format_pos, this.ready && Configuration.get("workflow.format", false) && Configuration.getMode() > 1);
            }
            if (this.files_pos != -1) {
                this.tab_pane.setEnabledAt(this.files_pos, this.ready && Configuration.get("workflow.files", false) && Configuration.getMode() > 2);
            }
        }

        public void setReady(boolean bl) {
            this.ready = bl;
        }
    }

    private class MenuListenerImpl
    implements MenuListener {
        private MenuListenerImpl() {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (menuEvent.getSource() == GUIManager.this.menu_bar.help) {
                if (GUIManager.this.menu_bar.help.isSelected()) {
                    GUIManager.this.menu_bar.help.doClick(10);
                }
            } else if (menuEvent.getSource() == GUIManager.this.menu_bar.edit) {
                if (Gatherer.c_man.getCollection() == null) {
                    GUIManager.this.menu_bar.edit_config.setEnabled(false);
                } else {
                    GUIManager.this.menu_bar.edit_config.setEnabled(true);
                }
            }
        }
    }

    private class DeleteCollectionTask
    implements Runnable {
        private DeleteCollectionTask() {
        }

        @Override
        public void run() {
            DeleteCollectionPrompt deleteCollectionPrompt = new DeleteCollectionPrompt();
            TestingPreparation.setNamesRecursively(deleteCollectionPrompt);
            if (deleteCollectionPrompt.display()) {
                // empty if block
            }
            deleteCollectionPrompt.destroy();
            deleteCollectionPrompt = null;
        }
    }

    private class NewCollectionTask
    implements Runnable {
        private NewCollectionTask() {
        }

        @Override
        public void run() {
            NewCollectionDetailsPrompt newCollectionDetailsPrompt = new NewCollectionDetailsPrompt();
            if (!newCollectionDetailsPrompt.isCancelled()) {
                if (Gatherer.c_man.ready()) {
                    GUIManager.this.saveThenCloseCurrentCollection();
                }
                Gatherer.c_man.createCollection(newCollectionDetailsPrompt.getDescription(), Configuration.getEmail(), newCollectionDetailsPrompt.getName(), newCollectionDetailsPrompt.getTitle(), newCollectionDetailsPrompt.getBase(), new ArrayList());
                newCollectionDetailsPrompt.dispose();
            }
            newCollectionDetailsPrompt = null;
        }
    }

    private class OpenCollectionTask
    implements Runnable {
        private OpenCollectionTask() {
        }

        @Override
        public void run() {
            String string = GUIManager.this.showOpenCollectionDialog();
            if (string != null) {
                if (Gatherer.c_man.ready()) {
                    GUIManager.this.saveThenCloseCurrentCollection();
                }
                Gatherer.c_man.loadCollection(string);
            }
        }
    }

    private class GLIGUIFocusListener
    extends FocusAdapter {
        private GLIGUIFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (ModalDialog.current_modal != null) {
                ModalDialog.current_modal.makeVisible();
                ModalDialog.current_modal.toFront();
            }
        }
    }
}

