/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.Format;
import org.greenstone.gatherer.cdm.Format4gs3;
import org.greenstone.gatherer.cdm.Format4gs3Manager;
import org.greenstone.gatherer.cdm.FormatManager;
import org.greenstone.gatherer.gui.BaseConfigPane;
import org.greenstone.gatherer.gui.PreviewButton;
import org.greenstone.gatherer.gui.PreviewButtonOwner;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;

public class FormatPane
extends BaseConfigPane
implements PreviewButtonOwner,
GShellListener {
    private static PreviewButton preview_button = null;
    private boolean buildCanceled = false;
    private int page_type = 1;
    private String page_params = "";

    public FormatPane() {
        this.contents = Gatherer.GS3 ? new String[]{"CDM.GUI.General", "CDM.GUI.SearchMetadata", "CDM.GUI.Formats", "CDM.GUI.Translation"} : new String[]{"CDM.GUI.General", "CDM.GUI.SearchMetadata", "CDM.GUI.Formats", "CDM.GUI.Translation", "CDM.GUI.SuperCollection", "CDM.GUI.Macros", "CDM.GUI.DepositorMetadata"};
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setLayout(new BorderLayout());
        this.remove(this.tree_pane);
        jPanel.add((Component)this.tree_pane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        preview_button = new PreviewButton(Dictionary.get("CreatePane.Preview_Collection"), Dictionary.get("CreatePane.Preview_Collection_Tooltip"));
        preview_button.setEnabled(true);
        preview_button.setVariablePreview(true);
        preview_button.setOwner(this);
        jPanel2.add((Component)preview_button, "Center");
        preview_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FormatPane.this.view != null) {
                    FormatPane.this.view.loseFocus();
                }
                if (FormatPane.this.buildCanceled) {
                    WarningDialog warningDialog = new WarningDialog("warning.ShowPreviousCollection", Dictionary.get("ShowPreviousCollection.Title"), Dictionary.get("ShowPreviousCollection.Message"), null, false);
                    warningDialog.display();
                    warningDialog.dispose();
                }
            }
        });
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "Before");
    }

    @Override
    public void gainFocus() {
        super.gainFocus();
        if (Gatherer.c_man.built() && Configuration.library_url != null) {
            preview_button.setEnabled(true);
        } else {
            preview_button.setEnabled(false);
        }
    }

    public static void setPreviewButton(boolean bl) {
        if (bl && Gatherer.c_man.previewAvailable()) {
            bl = false;
        }
        preview_button.setEnabled(bl);
    }

    @Override
    public synchronized void message(GShellEvent gShellEvent) {
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
        this.buildCanceled = false;
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        if (gShellEvent.getStatus() == 1) {
            if (gShellEvent.getType() == 0) {
                this.buildCanceled = false;
            }
        } else {
            this.buildCanceled = true;
        }
    }

    @Override
    protected Control getSubControls(String string) {
        if (string.equals("CDM.GUI.General")) {
            return CollectionDesignManager.general_manager.getControls();
        }
        if (string.equals("CDM.GUI.SearchMetadata")) {
            return CollectionDesignManager.searchmeta_manager.getControls();
        }
        if (string.equals("CDM.GUI.Formats")) {
            return CollectionDesignManager.format_manager.getControls();
        }
        if (string.equals("CDM.GUI.Translation")) {
            return CollectionDesignManager.translation_manager.getControls();
        }
        if (string.equals("CDM.GUI.Macros")) {
            return CollectionDesignManager.macros_manager.getControls();
        }
        if (string.equals("CDM.GUI.SuperCollection")) {
            return CollectionDesignManager.supercollection_manager.getControls();
        }
        if (string.equals("CDM.GUI.DepositorMetadata")) {
            return CollectionDesignManager.depositormetadata_manager.getControls();
        }
        return null;
    }

    @Override
    public int getPageType() {
        System.err.println("view type = " + this.view_type);
        if (this.view_type.equals("CDM.GUI.General") || this.view_type.equals("CDM.GUI.Translation")) {
            this.page_type = 1;
        } else if (Gatherer.GS3) {
            Format4gs3 format4gs3 = ((Format4gs3Manager.FormatControl)this.view).getCurrentFormat();
            String string = format4gs3.getFeatureName();
            if (string.equals("browse")) {
                this.page_type = 3;
                this.page_params = "CL1";
            } else if (string.startsWith("CL")) {
                this.page_type = 3;
                this.page_params = format4gs3.getFeatureName();
            } else if (string.startsWith("display")) {
                this.page_type = 4;
                this.page_params = "HASH01e4da6100fdbb11b7ef244b";
            } else if (string.equals("search")) {
                this.page_type = 2;
                this.page_params = "the";
            }
        } else {
            Format format = ((FormatManager.FormatControl)this.view).getCurrentFormat();
            String string = format.getFeatureName();
            System.err.println("current format = " + string);
            if (string.equals("")) {
                this.page_type = 3;
                this.page_params = "CL1";
            }
            if (string.startsWith("CL")) {
                this.page_type = 3;
                this.page_params = format.getFeatureName();
            } else if (string.startsWith("Document")) {
                this.page_type = 4;
                this.page_params = "HASH01e4da6100fdbb11b7ef244b";
            } else if (string.equals("Search")) {
                this.page_type = 2;
                this.page_params = "the";
            }
        }
        return this.page_type;
    }

    @Override
    public String getPageParams() {
        return this.page_params;
    }
}

